/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.timerservice.task;

import java.util.Date;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.ejb3.timerservice.TimerImpl;
import org.jboss.as.ejb3.timerservice.TimerServiceImpl;
import org.jboss.as.ejb3.timerservice.TimerState;
import org.jboss.as.ejb3.timerservice.spi.BeanRemovedException;

public class TimerTask<T extends TimerImpl>
implements Runnable {
    protected final String timedObjectId;
    protected final String timerId;
    protected final TimerServiceImpl timerService;
    private volatile boolean cancelled = false;

    public TimerTask(T timer) {
        if (timer == null) {
            throw EjbLogger.ROOT_LOGGER.timerIsNull();
        }
        this.timedObjectId = ((TimerImpl)timer).getTimedObjectId();
        this.timerId = ((TimerImpl)timer).getId();
        this.timerService = ((TimerImpl)timer).getTimerService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        TimerImpl timer = this.timerService.getTimer(this.timerId);
        try {
            if (this.cancelled) {
                EjbLogger.ROOT_LOGGER.debugf("Timer task was cancelled for %s", timer);
                return;
            }
            Date now = new Date();
            if (EjbLogger.ROOT_LOGGER.isDebugEnabled()) {
                EjbLogger.ROOT_LOGGER.debug("Timer task invoked at: " + now + " for timer " + timer);
            }
            if (timer.isInRetry()) {
                EjbLogger.ROOT_LOGGER.skipInvokeTimeoutDuringRetry(timer, now);
                timer.setNextTimeout(this.calculateNextTimeout(timer));
                this.timerService.persistTimer(timer, false);
                this.scheduleTimeoutIfRequired(timer);
                return;
            }
            if (timer.getState() == TimerState.IN_TIMEOUT || timer.getState() == TimerState.RETRY_TIMEOUT) {
                EjbLogger.ROOT_LOGGER.skipOverlappingInvokeTimeout(timer, now);
                timer.setNextTimeout(this.calculateNextTimeout(timer));
                this.timerService.persistTimer(timer, false);
                this.scheduleTimeoutIfRequired(timer);
                return;
            }
            if (!this.timerService.shouldRun(timer)) {
                EjbLogger.ROOT_LOGGER.debugf("Skipping execution of timer for %s as it is being run on another node or the execution is suppressed by configuration", timer.getTimedObjectId());
                timer.setNextTimeout(this.calculateNextTimeout(timer));
                this.scheduleTimeoutIfRequired(timer);
                return;
            }
            timer.lock();
            try {
                if (!timer.isActive()) {
                    EjbLogger.ROOT_LOGGER.debug("Timer is not active, skipping this scheduled execution at: " + now + "for " + timer);
                    return;
                }
                timer.setPreviousRun(new Date());
                Date nextTimeout = this.calculateNextTimeout(timer);
                timer.setNextTimeout(nextTimeout);
                timer.setTimerState(TimerState.IN_TIMEOUT);
                this.timerService.persistTimer(timer, false);
            }
            finally {
                timer.unlock();
            }
            try {
                this.callTimeout(timer);
            }
            catch (BeanRemovedException e) {
                EjbLogger.ROOT_LOGGER.debugf("Removing timer %s as EJB has been removed ", timer);
                timer.cancel();
            }
            catch (Exception e) {
                EjbLogger.ROOT_LOGGER.errorInvokeTimeout(timer, e);
                try {
                    EjbLogger.ROOT_LOGGER.timerRetried(timer);
                    this.retryTimeout(timer);
                }
                catch (Exception retryException) {
                    EjbLogger.ROOT_LOGGER.errorDuringRetryTimeout(timer, retryException);
                }
            }
            finally {
                this.postTimeoutProcessing(timer);
            }
        }
        catch (Exception e) {
            EjbLogger.ROOT_LOGGER.exceptionRunningTimerTask(timer, this.timedObjectId, e);
        }
    }

    protected void scheduleTimeoutIfRequired(TimerImpl timer) {
    }

    protected void callTimeout(TimerImpl timer) throws Exception {
        this.timerService.getInvoker().callTimeout(timer);
    }

    protected Date calculateNextTimeout(TimerImpl timer) {
        long intervalDuration = timer.getInterval();
        if (intervalDuration > 0L) {
            long now = new Date().getTime();
            long nextExpiration = timer.getNextExpiration().getTime();
            int periods = (int)((now - nextExpiration) / intervalDuration);
            return new Date(nextExpiration + (long)periods * intervalDuration + intervalDuration);
        }
        return null;
    }

    protected void retryTimeout(TimerImpl timer) throws Exception {
        if (timer.isActive()) {
            EjbLogger.ROOT_LOGGER.retryingTimeout(timer);
            timer.setTimerState(TimerState.RETRY_TIMEOUT);
            this.timerService.persistTimer(timer, false);
            this.callTimeout(timer);
        } else {
            EjbLogger.ROOT_LOGGER.timerNotActive(timer);
        }
    }

    protected void postTimeoutProcessing(TimerImpl timer) {
        timer.lock();
        try {
            TimerState timerState = timer.getState();
            if (timerState != TimerState.CANCELED && timerState != TimerState.EXPIRED) {
                if (timer.getInterval() == 0L) {
                    this.timerService.expireTimer(timer);
                } else {
                    timer.setTimerState(TimerState.ACTIVE);
                }
                this.timerService.persistTimer(timer, false);
            }
        }
        finally {
            timer.unlock();
        }
    }

    public void cancel() {
        this.cancelled = true;
    }
}

