/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.iiop.openjdk.security;

import com.sun.corba.se.pept.transport.Acceptor;
import com.sun.corba.se.spi.orb.ORB;
import com.sun.corba.se.spi.transport.ORBSocketFactory;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.jboss.security.JSSESecurityDomain;
import org.wildfly.iiop.openjdk.logging.IIOPLogger;
import org.wildfly.iiop.openjdk.security.Util;

public class SocketFactory
implements ORBSocketFactory {
    private static String securityDomain = null;
    private ORB orb;
    private SSLContext sslContext = null;
    private JSSESecurityDomain jsseSecurityDomain = null;
    private boolean request_mutual_auth = false;
    private boolean require_mutual_auth = false;

    public static void setSecurityDomain(String securityDomain) {
        SocketFactory.securityDomain = securityDomain;
    }

    public void setORB(ORB orb) {
        this.orb = orb;
        try {
            InitialContext context = new InitialContext();
            this.jsseSecurityDomain = (JSSESecurityDomain)context.lookup("java:jboss/jaas/" + securityDomain + "/jsse");
            IIOPLogger.ROOT_LOGGER.debugf("Obtained JSSE security domain with name %s", securityDomain);
        }
        catch (NamingException ne) {
            IIOPLogger.ROOT_LOGGER.failedToObtainJSSEDomain(securityDomain);
        }
        if (this.jsseSecurityDomain == null) {
            throw new RuntimeException(IIOPLogger.ROOT_LOGGER.failedToLookupJSSEDomain());
        }
    }

    public ServerSocket createServerSocket(String type, InetSocketAddress inetSocketAddress) throws IOException {
        ServerSocketChannel serverSocketChannel = null;
        ServerSocket serverSocket = null;
        if (type.equals("SSL")) {
            serverSocket = this.createSSLServerSocket(inetSocketAddress.getPort(), 1000, InetAddress.getByName(inetSocketAddress.getHostName()));
        } else if (this.orb.getORBData().acceptorSocketType().equals("SocketChannel")) {
            serverSocketChannel = ServerSocketChannel.open();
            serverSocket = serverSocketChannel.socket();
        } else {
            serverSocket = new ServerSocket();
        }
        if (!type.equals("SSL")) {
            serverSocket.bind(inetSocketAddress);
        }
        return serverSocket;
    }

    public Socket createSocket(String type, InetSocketAddress inetSocketAddress) throws IOException {
        SocketChannel socketChannel = null;
        Socket socket = null;
        if (type.contains("SSL")) {
            socket = this.createSSLSocket(inetSocketAddress.getHostName(), inetSocketAddress.getPort());
        } else if (this.orb.getORBData().connectionSocketType().equals("SocketChannel")) {
            socketChannel = SocketChannel.open(inetSocketAddress);
            socket = socketChannel.socket();
        } else {
            socket = new Socket(inetSocketAddress.getHostName(), inetSocketAddress.getPort());
        }
        socket.setTcpNoDelay(true);
        return socket;
    }

    public void setAcceptedSocketOptions(Acceptor acceptor, ServerSocket serverSocket, Socket socket) throws SocketException {
        socket.setTcpNoDelay(true);
    }

    public Socket createSSLSocket(String host, int port) throws IOException {
        this.initSSLContext();
        InetAddress address = InetAddress.getByName(host);
        SSLSocketFactory socketFactory = this.sslContext.getSocketFactory();
        SSLSocket socket = (SSLSocket)socketFactory.createSocket(address, port);
        if (this.jsseSecurityDomain.getProtocols() != null) {
            socket.setEnabledProtocols(this.jsseSecurityDomain.getProtocols());
        }
        if (this.jsseSecurityDomain.getCipherSuites() != null) {
            socket.setEnabledCipherSuites(this.jsseSecurityDomain.getCipherSuites());
        }
        socket.setNeedClientAuth(this.jsseSecurityDomain.isClientAuth());
        return socket;
    }

    public ServerSocket createSSLServerSocket(int port, int backlog, InetAddress inetAddress) throws IOException {
        this.initSSLContext();
        SSLServerSocketFactory serverSocketFactory = this.sslContext.getServerSocketFactory();
        SSLServerSocket serverSocket = (SSLServerSocket)serverSocketFactory.createServerSocket(port, backlog, inetAddress);
        if (this.jsseSecurityDomain.getProtocols() != null) {
            serverSocket.setEnabledProtocols(this.jsseSecurityDomain.getProtocols());
        }
        if (this.jsseSecurityDomain.getCipherSuites() != null) {
            serverSocket.setEnabledCipherSuites(this.jsseSecurityDomain.getCipherSuites());
        }
        if (this.jsseSecurityDomain.isClientAuth() || this.require_mutual_auth) {
            serverSocket.setNeedClientAuth(true);
        } else {
            serverSocket.setWantClientAuth(this.request_mutual_auth);
        }
        return serverSocket;
    }

    private void initSSLContext() throws IOException {
        if (this.sslContext != null) {
            return;
        }
        this.sslContext = Util.forDomain(this.jsseSecurityDomain);
    }
}

