/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations.coordination;

import java.util.Map;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ProxyController;
import org.jboss.as.controller.extension.ExtensionRegistry;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.controller.LocalHostControllerInfo;
import org.jboss.as.domain.controller.operations.ApplyMissingDomainModelResourcesHandler;
import org.jboss.as.domain.controller.operations.coordination.DomainControllerLockIdUtils;
import org.jboss.as.domain.controller.operations.coordination.HostControllerExecutionSupport;
import org.jboss.as.domain.controller.operations.coordination.ServerOperationResolver;
import org.jboss.as.domain.controller.operations.coordination.ServerOperationsResolverHandler;
import org.jboss.as.host.controller.ignored.IgnoredDomainResourceRegistry;
import org.jboss.dmr.ModelNode;

public class OperationSlaveStepHandler {
    private final LocalHostControllerInfo localHostControllerInfo;
    private final Map<String, ProxyController> serverProxies;
    private final IgnoredDomainResourceRegistry ignoredDomainResourceRegistry;
    private final ExtensionRegistry extensionRegistry;
    private volatile ApplyMissingDomainModelResourcesHandler applyMissingDomainModelResourcesHandler;

    OperationSlaveStepHandler(LocalHostControllerInfo localHostControllerInfo, Map<String, ProxyController> serverProxies, IgnoredDomainResourceRegistry ignoredDomainResourceRegistry, ExtensionRegistry extensionRegistry) {
        this.localHostControllerInfo = localHostControllerInfo;
        this.serverProxies = serverProxies;
        this.ignoredDomainResourceRegistry = ignoredDomainResourceRegistry;
        this.extensionRegistry = extensionRegistry;
    }

    void intialize(ApplyMissingDomainModelResourcesHandler applyMissingDomainModelResourcesHandler) {
        this.applyMissingDomainModelResourcesHandler = applyMissingDomainModelResourcesHandler;
    }

    void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        ModelNode headers = operation.get("operation-headers");
        headers.remove("execute-for-coordinator");
        ModelNode missingResources = operation.get("operation-headers").remove("missing-domain-resources");
        if (headers.hasDefined("domain-controller-lock-id")) {
            int id = headers.remove("domain-controller-lock-id").asInt();
            context.attach(DomainControllerLockIdUtils.DOMAIN_CONTROLLER_LOCK_ID_ATTACHMENT, (Object)id);
        }
        final HostControllerExecutionSupport hostControllerExecutionSupport = this.addSteps(context, operation, null, true);
        if (missingResources != null) {
            ModelNode applyMissingResourcesOp = ApplyMissingDomainModelResourcesHandler.createPiggyBackedMissingDataOperation(missingResources);
            context.addStep(applyMissingResourcesOp, (OperationStepHandler)this.applyMissingDomainModelResourcesHandler, OperationContext.Stage.MODEL, true);
        }
        context.completeStep(new OperationContext.RollbackHandler(){

            public void handleRollback(OperationContext context, ModelNode operation) {
                if (hostControllerExecutionSupport.getDomainOperation() != null) {
                    ModelNode domainResult = hostControllerExecutionSupport.getFormattedDomainResult(context.getResult());
                    context.getResult().set(domainResult);
                }
            }
        });
    }

    HostControllerExecutionSupport addSteps(OperationContext context, ModelNode operation, ModelNode response, boolean recordResponse) throws OperationFailedException {
        PathAddress originalAddress = PathAddress.pathAddress((ModelNode)operation.get("address"));
        ImmutableManagementResourceRegistration originalRegistration = context.getResourceRegistration();
        HostControllerExecutionSupport hostControllerExecutionSupport = HostControllerExecutionSupport.Factory.create(operation, this.localHostControllerInfo.getLocalHostName(), new LazyDomainModelProvider(context), this.ignoredDomainResourceRegistry, !this.localHostControllerInfo.isMasterDomainController() && this.localHostControllerInfo.isRemoteDomainControllerIgnoreUnaffectedConfiguration(), this.extensionRegistry);
        ModelNode domainOp = hostControllerExecutionSupport.getDomainOperation();
        if (domainOp != null) {
            if (originalRegistration == null) {
                throw new OperationFailedException(ControllerLogger.ROOT_LOGGER.noSuchResourceType(originalAddress));
            }
            this.addBasicStep(context, domainOp);
        }
        ServerOperationResolver resolver = new ServerOperationResolver(this.localHostControllerInfo.getLocalHostName(), this.serverProxies);
        ServerOperationsResolverHandler sorh = new ServerOperationsResolverHandler(resolver, hostControllerExecutionSupport, originalAddress, originalRegistration, response);
        context.addStep((OperationStepHandler)sorh, OperationContext.Stage.DOMAIN);
        return hostControllerExecutionSupport;
    }

    private void addBasicStep(OperationContext context, ModelNode operation) throws OperationFailedException {
        String operationName = operation.require("operation").asString();
        OperationStepHandler stepHandler = context.getResourceRegistration().getOperationHandler(PathAddress.EMPTY_ADDRESS, operationName);
        if (stepHandler == null) {
            throw new OperationFailedException(ControllerLogger.ROOT_LOGGER.noHandlerForOperation(operationName, PathAddress.pathAddress((ModelNode)operation.get("address"))));
        }
        context.addStep(operation, stepHandler, OperationContext.Stage.MODEL);
    }

    private static class LazyDomainModelProvider
    implements HostControllerExecutionSupport.DomainModelProvider {
        private final OperationContext context;
        private Resource domainModelResource;

        private LazyDomainModelProvider(OperationContext context) {
            this.context = context;
        }

        @Override
        public Resource getDomainModel() {
            if (this.domainModelResource == null) {
                this.domainModelResource = this.context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS, true);
            }
            return this.domainModelResource;
        }
    }
}

