/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.mod_cluster;

import java.util.List;
import java.util.Map;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.as.controller.transform.description.DefaultCheckersAndConverter;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.wildfly.extension.mod_cluster.ModClusterLogger;

class PropertyCheckerAndConverter
extends DefaultCheckersAndConverter {
    static final PropertyCheckerAndConverter INSTANCE = new PropertyCheckerAndConverter();

    PropertyCheckerAndConverter() {
    }

    public String getRejectionLogMessage(Map<String, ModelNode> attributes) {
        return ModClusterLogger.ROOT_LOGGER.propertyCanOnlyHaveOneEntry();
    }

    protected boolean rejectAttribute(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
        return attributeValue.isDefined() && attributeValue.asPropertyList().size() > 1;
    }

    protected void convertAttribute(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
        List list;
        if (attributeValue.isDefined() && (list = attributeValue.asPropertyList()).size() == 1) {
            attributeValue.set(((Property)list.get(0)).getName(), ((Property)list.get(0)).getValue().asString());
        }
    }

    protected boolean isValueDiscardable(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
        return false;
    }
}

