/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.tracer;

public class TraceEvent {
    public static final int GET_CONNECTION_LISTENER = 0;
    public static final int GET_CONNECTION_LISTENER_NEW = 1;
    public static final int GET_INTERLEAVING_CONNECTION_LISTENER = 2;
    public static final int GET_INTERLEAVING_CONNECTION_LISTENER_NEW = 3;
    public static final int RETURN_CONNECTION_LISTENER = 10;
    public static final int RETURN_CONNECTION_LISTENER_WITH_KILL = 11;
    public static final int RETURN_INTERLEAVING_CONNECTION_LISTENER = 12;
    public static final int RETURN_INTERLEAVING_CONNECTION_LISTENER_WITH_KILL = 13;
    public static final int CLEAR_CONNECTION_LISTENER = 14;
    public static final int ENLIST_CONNECTION_LISTENER = 20;
    public static final int ENLIST_CONNECTION_LISTENER_FAILED = 21;
    public static final int ENLIST_INTERLEAVING_CONNECTION_LISTENER = 22;
    public static final int ENLIST_INTERLEAVING_CONNECTION_LISTENER_FAILED = 23;
    public static final int DELIST_CONNECTION_LISTENER = 30;
    public static final int DELIST_CONNECTION_LISTENER_FAILED = 31;
    public static final int DELIST_INTERLEAVING_CONNECTION_LISTENER = 32;
    public static final int DELIST_INTERLEAVING_CONNECTION_LISTENER_FAILED = 33;
    public static final int DELIST_ROLLEDBACK_CONNECTION_LISTENER = 34;
    public static final int GET_CONNECTION = 40;
    public static final int RETURN_CONNECTION = 41;
    public static final int CLEAR_CONNECTION = 42;
    public static final int EXCEPTION = 50;
    private String pool;
    private long threadId;
    private int type;
    private long timestamp;
    private String cl;
    private String payload;

    TraceEvent(String pool, int type, String cl) {
        this(pool, Thread.currentThread().getId(), type, System.currentTimeMillis(), cl, "");
    }

    TraceEvent(String pool, int type, String cl, String payload) {
        this(pool, Thread.currentThread().getId(), type, System.currentTimeMillis(), cl, payload);
    }

    private TraceEvent(String pool, long threadId, int type, long timestamp, String cl, String payload) {
        this.pool = pool != null ? pool.replace('-', '_') : "Empty";
        this.threadId = threadId;
        this.type = type;
        this.timestamp = timestamp;
        this.cl = cl;
        this.payload = payload;
    }

    public String getPool() {
        return this.pool;
    }

    public long getThreadId() {
        return this.threadId;
    }

    public int getType() {
        return this.type;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getConnectionListener() {
        return this.cl;
    }

    public String getPayload() {
        return this.payload;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("IJTRACER");
        sb.append("-");
        sb.append(this.pool);
        sb.append("-");
        sb.append(Long.toString(this.threadId));
        sb.append("-");
        sb.append(Integer.toString(this.type));
        sb.append("-");
        sb.append(Long.toString(this.timestamp));
        sb.append("-");
        sb.append(this.cl);
        sb.append("-");
        sb.append(this.payload);
        return sb.toString();
    }

    public static String asText(TraceEvent event) {
        switch (event.getType()) {
            case 0: {
                return "getConnectionListener()";
            }
            case 1: {
                return "getConnectionListener(true)";
            }
            case 2: {
                return "getConnectionListener() (I)";
            }
            case 3: {
                return "getConnectionListener(true) (I)";
            }
            case 10: {
                return "returnConnectionListener()";
            }
            case 11: {
                return "returnConnectionListener(true)";
            }
            case 12: {
                return "returnConnectionListener() (I)";
            }
            case 13: {
                return "returnConnectionListener(true) (I)";
            }
            case 14: {
                return "clearConnectionListener()";
            }
            case 20: {
                return "enlistResource()";
            }
            case 21: {
                return "enlistResource(false)";
            }
            case 22: {
                return "enlistResource() (I)";
            }
            case 23: {
                return "enlistResource(false) (I)";
            }
            case 30: {
                return "delistResource()";
            }
            case 31: {
                return "delistResource(false)";
            }
            case 32: {
                return "delistResource() (I)";
            }
            case 33: {
                return "delistResource(false) (I)";
            }
            case 34: {
                return "delistResource() (R)";
            }
            case 40: {
                return "getConnection(" + event.getPayload() + ")";
            }
            case 41: {
                return "returnConnection(" + event.getPayload() + ")";
            }
            case 42: {
                return "clearConnection(" + event.getPayload() + ")";
            }
            case 50: {
                return "exception";
            }
        }
        return "";
    }

    public static TraceEvent parse(String data) {
        String[] raw = data.split("-");
        String header = raw[0];
        String p = raw[1];
        long tid = Long.parseLong(raw[2]);
        int t = Integer.parseInt(raw[3]);
        long ts = Long.parseLong(raw[4]);
        String c = raw[5];
        String pyl = "";
        if (raw.length == 7) {
            pyl = raw[6];
        }
        return new TraceEvent(p, tid, t, ts, c, pyl);
    }
}

