/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.entity.interceptors;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.transaction.Synchronization;
import javax.transaction.TransactionSynchronizationRegistry;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ee.component.ComponentClientInstance;
import org.jboss.as.ee.component.interceptors.InvocationType;
import org.jboss.as.ejb3.component.entity.EntityBeanComponent;
import org.jboss.as.ejb3.component.entity.EntityBeanComponentInstance;
import org.jboss.as.ejb3.component.entity.interceptors.EntityBeanHomeCreateInterceptorFactory;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.invocation.ImmediateInterceptorFactory;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.Interceptors;

public class EntityBeanEjbCreateMethodInterceptor
implements Interceptor {
    public static final InterceptorFactory INSTANCE = new ImmediateInterceptorFactory((Interceptor)new EntityBeanEjbCreateMethodInterceptor());

    protected EntityBeanEjbCreateMethodInterceptor() {
    }

    public Object processInvocation(InterceptorContext context) throws Exception {
        Object existing = context.getPrivateData(EntityBeanComponent.PRIMARY_KEY_CONTEXT_KEY);
        Method ejbCreate = (Method)context.getPrivateData(EntityBeanHomeCreateInterceptorFactory.EJB_CREATE_METHOD_KEY);
        Method ejbPostCreate = (Method)context.getPrivateData(EntityBeanHomeCreateInterceptorFactory.EJB_POST_CREATE_METHOD_KEY);
        Object[] params = (Object[])context.getPrivateData(EntityBeanHomeCreateInterceptorFactory.PARAMETERS_KEY);
        ComponentClientInstance clientInstance = (ComponentClientInstance)context.getPrivateData(ComponentClientInstance.class);
        if (existing != null) {
            clientInstance.setViewInstanceData(EntityBeanComponent.PRIMARY_KEY_CONTEXT_KEY, existing);
            return existing;
        }
        Component component = (Component)context.getPrivateData(Component.class);
        if (!(component instanceof EntityBeanComponent)) {
            throw EjbLogger.ROOT_LOGGER.unexpectedComponent(component, EntityBeanComponent.class);
        }
        final EntityBeanComponent entityBeanComponent = (EntityBeanComponent)component;
        final EntityBeanComponentInstance instance = entityBeanComponent.acquireUnAssociatedInstance();
        Object primaryKey = this.invokeEjbCreate(context, ejbCreate, instance, params);
        instance.associate(primaryKey);
        clientInstance.setViewInstanceData(EntityBeanComponent.PRIMARY_KEY_CONTEXT_KEY, primaryKey);
        boolean synchronizationRegistered = false;
        boolean exception = false;
        boolean instanceCachedBefore = entityBeanComponent.getCache().contains(primaryKey);
        entityBeanComponent.getCache().create(instance);
        try {
            this.invokeEjbPostCreate(context, ejbPostCreate, instance, params);
            TransactionSynchronizationRegistry transactionSynchronizationRegistry = entityBeanComponent.getTransactionSynchronizationRegistry();
            if (transactionSynchronizationRegistry.getTransactionKey() != null) {
                if (!instanceCachedBefore) {
                    transactionSynchronizationRegistry.registerInterposedSynchronization(new Synchronization(){

                        public void beforeCompletion() {
                        }

                        public void afterCompletion(int status) {
                            entityBeanComponent.getCache().release(instance, status == 3);
                        }
                    });
                }
                synchronizationRegistered = true;
            }
            Object object = context.proceed();
            return object;
        }
        catch (Exception e) {
            entityBeanComponent.getCache().release(instance, false);
            exception = true;
            throw e;
        }
        finally {
            if (!synchronizationRegistered && !exception) {
                entityBeanComponent.getCache().release(instance, true);
            }
        }
    }

    protected void invokeEjbPostCreate(InterceptorContext context, Method ejbPostCreate, EntityBeanComponentInstance instance, Object[] params) throws Exception {
        try {
            ejbPostCreate.invoke((Object)instance.getInstance(), params);
        }
        catch (InvocationTargetException e) {
            throw Interceptors.rethrow((Throwable)e.getCause());
        }
    }

    protected Object invokeEjbCreate(InterceptorContext context, Method ejbCreate, EntityBeanComponentInstance instance, Object[] params) throws Exception {
        InvocationType invocationType = (InvocationType)context.getPrivateData(InvocationType.class);
        try {
            context.putPrivateData(InvocationType.class, (Object)InvocationType.ENTITY_EJB_CREATE);
            Object object = ejbCreate.invoke((Object)instance.getInstance(), params);
            return object;
        }
        catch (InvocationTargetException e) {
            throw Interceptors.rethrow((Throwable)e.getCause());
        }
        finally {
            context.putPrivateData(InvocationType.class, (Object)invocationType);
        }
    }
}

