/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors;

import java.util.Properties;
import org.jboss.as.ee.metadata.EJBClientDescriptorMetaData;
import org.jboss.as.ejb3.deployment.EjbDeploymentAttachmentKeys;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.ejb3.remote.DescriptorBasedEJBClientContextService;
import org.jboss.as.ejb3.remote.EJBClientClusterConfig;
import org.jboss.as.ejb3.remote.EJBClientClusterNodeConfig;
import org.jboss.as.ejb3.remote.JBossEJBClientXmlConfiguration;
import org.jboss.as.ejb3.remote.LocalEjbReceiver;
import org.jboss.as.ejb3.remote.RemotingProfileService;
import org.jboss.as.ejb3.remote.TCCLEJBClientContextSelectorService;
import org.jboss.as.remoting.AbstractOutboundConnectionService;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.ejb.client.DeploymentNodeSelector;
import org.jboss.ejb.client.EJBClientConfiguration;
import org.jboss.logging.Logger;
import org.jboss.modules.Module;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;
import org.xnio.Option;
import org.xnio.OptionMap;

public class EJBClientDescriptorMetaDataProcessor
implements DeploymentUnitProcessor {
    private static final Logger logger = Logger.getLogger(EJBClientDescriptorMetaDataProcessor.class);
    private static final String INTERNAL_REMOTING_PROFILE = "internal-remoting-profile";

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (deploymentUnit.getParent() != null) {
            return;
        }
        EJBClientDescriptorMetaData ejbClientDescriptorMetaData = (EJBClientDescriptorMetaData)deploymentUnit.getAttachment(org.jboss.as.ee.structure.Attachments.EJB_CLIENT_METADATA);
        if (ejbClientDescriptorMetaData == null) {
            return;
        }
        this.checkDescriptorConfiguration(ejbClientDescriptorMetaData);
        Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
        if (module == null) {
            return;
        }
        ServiceName ejbClientContextServiceName = DescriptorBasedEJBClientContextService.BASE_SERVICE_NAME.append(new String[]{deploymentUnit.getName()});
        ServiceTarget serviceTarget = phaseContext.getServiceTarget();
        EJBClientConfiguration ejbClientConfiguration = this.createClientConfiguration(phaseContext.getServiceRegistry(), (ClassLoader)module.getClassLoader(), ejbClientDescriptorMetaData);
        DescriptorBasedEJBClientContextService service = new DescriptorBasedEJBClientContextService(ejbClientConfiguration, (ClassLoader)module.getClassLoader());
        ServiceBuilder serviceBuilder = serviceTarget.addService(ejbClientContextServiceName, (Service)service);
        String profile = ejbClientDescriptorMetaData.getProfile();
        if (profile != null) {
            ServiceName profileServiceDependency = RemotingProfileService.BASE_SERVICE_NAME.append(new String[]{profile});
            serviceBuilder.addDependency(profileServiceDependency, RemotingProfileService.class, service.getProfileServiceInjector());
        } else {
            ServiceName profileServiceName = ejbClientContextServiceName.append(new String[]{INTERNAL_REMOTING_PROFILE});
            this.createInternalRemotingProfileService(profileServiceName, serviceTarget, ejbClientDescriptorMetaData);
            serviceBuilder.addDependency(profileServiceName, RemotingProfileService.class, service.getProfileServiceInjector());
        }
        serviceBuilder.addDependency(TCCLEJBClientContextSelectorService.TCCL_BASED_EJB_CLIENT_CONTEXT_SELECTOR_SERVICE_NAME);
        serviceBuilder.install();
        logger.debugf("Deployment unit %s will use %s as the EJB client context service", (Object)deploymentUnit, (Object)ejbClientContextServiceName);
        phaseContext.addDeploymentDependency(ejbClientContextServiceName, EjbDeploymentAttachmentKeys.EJB_CLIENT_CONTEXT);
        deploymentUnit.putAttachment(EjbDeploymentAttachmentKeys.EJB_CLIENT_CONTEXT_SERVICE_NAME, (Object)ejbClientContextServiceName);
    }

    public void undeploy(DeploymentUnit context) {
    }

    private void checkDescriptorConfiguration(EJBClientDescriptorMetaData ejbClientDescriptorMetaData) throws DeploymentUnitProcessingException {
        boolean receiversDefined;
        boolean profileDefinied = ejbClientDescriptorMetaData.getProfile() != null;
        boolean bl = receiversDefined = !ejbClientDescriptorMetaData.getRemotingReceiverConfigurations().isEmpty() || ejbClientDescriptorMetaData.isLocalReceiverExcluded() != null || ejbClientDescriptorMetaData.isLocalReceiverPassByValue() != null;
        if (profileDefinied && receiversDefined) {
            throw EjbLogger.ROOT_LOGGER.profileAndRemotingEjbReceiversUsedTogether();
        }
    }

    private RemotingProfileService createInternalRemotingProfileService(ServiceName profileServiceName, ServiceTarget serviceTarget, EJBClientDescriptorMetaData ejbClientDescriptorMetaData) {
        boolean localReceiverExcluded;
        RemotingProfileService profileService = new RemotingProfileService();
        ServiceBuilder profileServiceBuilder = serviceTarget.addService(profileServiceName, (Service)profileService);
        for (EJBClientDescriptorMetaData.RemotingReceiverConfiguration remotingReceiverConfiguration : ejbClientDescriptorMetaData.getRemotingReceiverConfigurations()) {
            String connectionRef = remotingReceiverConfiguration.getOutboundConnectionRef();
            ServiceName connectionDependencyService = AbstractOutboundConnectionService.OUTBOUND_CONNECTION_BASE_SERVICE_NAME.append(new String[]{connectionRef});
            InjectedValue connectionInjector = new InjectedValue();
            profileServiceBuilder.addDependency(connectionDependencyService, AbstractOutboundConnectionService.class, (Injector)connectionInjector);
            profileService.addRemotingConnectionInjector(connectionDependencyService, (InjectedValue<AbstractOutboundConnectionService>)connectionInjector);
            profileService.addConnectionTimeout(connectionRef, remotingReceiverConfiguration.getConnectionTimeout());
            Properties channelCreationProps = remotingReceiverConfiguration.getChannelCreationOptions();
            OptionMap channelCreationOpts = channelCreationProps == null ? OptionMap.EMPTY : this.getOptionMapFromProperties(channelCreationProps, this.getClass().getClassLoader());
            profileService.addChannelCreationOption(connectionRef, channelCreationOpts);
            logger.debugf("Channel creation options for connection %s are %s", (Object)channelCreationOpts, (Object)connectionRef, (Object)channelCreationOpts);
        }
        boolean bl = localReceiverExcluded = ejbClientDescriptorMetaData.isLocalReceiverExcluded() != null ? ejbClientDescriptorMetaData.isLocalReceiverExcluded() : false;
        if (!localReceiverExcluded) {
            Boolean passByValue = ejbClientDescriptorMetaData.isLocalReceiverPassByValue();
            if (passByValue != null) {
                ServiceName localEjbReceiverServiceName = passByValue == true ? LocalEjbReceiver.BY_VALUE_SERVICE_NAME : LocalEjbReceiver.BY_REFERENCE_SERVICE_NAME;
                profileServiceBuilder.addDependency(localEjbReceiverServiceName, LocalEjbReceiver.class, profileService.getLocalEjbReceiverInjector());
            } else {
                profileServiceBuilder.addDependency(LocalEjbReceiver.DEFAULT_LOCAL_EJB_RECEIVER_SERVICE_NAME, LocalEjbReceiver.class, profileService.getLocalEjbReceiverInjector());
            }
        }
        profileServiceBuilder.install();
        return profileService;
    }

    private OptionMap getOptionMapFromProperties(Properties properties, ClassLoader classLoader) {
        OptionMap.Builder optionMapBuilder = OptionMap.builder();
        for (String propertyName : properties.stringPropertyNames()) {
            try {
                Option option = Option.fromString((String)propertyName, (ClassLoader)classLoader);
                optionMapBuilder.parse(option, properties.getProperty(propertyName), classLoader);
            }
            catch (IllegalArgumentException e) {
                EjbLogger.ROOT_LOGGER.failedToCreateOptionForProperty(propertyName, e.getMessage());
            }
        }
        return optionMapBuilder.getMap();
    }

    private EJBClientConfiguration createClientConfiguration(ServiceRegistry serviceRegistry, ClassLoader classLoader, EJBClientDescriptorMetaData ejbClientDescriptorMetaData) throws DeploymentUnitProcessingException {
        JBossEJBClientXmlConfiguration ejbClientConfig = new JBossEJBClientXmlConfiguration();
        ejbClientConfig.setInvocationTimeout(ejbClientDescriptorMetaData.getInvocationTimeout());
        String deploymentNodeSelectorClassName = ejbClientDescriptorMetaData.getDeploymentNodeSelector();
        if (deploymentNodeSelectorClassName != null && !deploymentNodeSelectorClassName.trim().isEmpty()) {
            try {
                Class<?> deploymentNodeSelectorClass = classLoader.loadClass(deploymentNodeSelectorClassName);
                ejbClientConfig.setDeploymentNodeSelector((DeploymentNodeSelector)deploymentNodeSelectorClass.newInstance());
            }
            catch (Exception e) {
                throw EjbLogger.ROOT_LOGGER.failedToCreateDeploymentNodeSelector(e, deploymentNodeSelectorClassName);
            }
        }
        for (EJBClientDescriptorMetaData.ClusterConfig clusterMetadata : ejbClientDescriptorMetaData.getClusterConfigs()) {
            EJBClientClusterConfig clusterConfig = new EJBClientClusterConfig(clusterMetadata, classLoader, serviceRegistry);
            ejbClientConfig.addClusterConfiguration(clusterConfig);
            for (EJBClientDescriptorMetaData.ClusterNodeConfig nodeMetadata : clusterMetadata.getClusterNodeConfigs()) {
                EJBClientClusterNodeConfig clusterNodeConfig = new EJBClientClusterNodeConfig(nodeMetadata, classLoader, serviceRegistry);
                clusterConfig.addClusterNode(clusterNodeConfig);
            }
        }
        return ejbClientConfig;
    }
}

