/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors;

import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.commons.CacheException;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.InvocationContextContainer;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.transaction.impl.TransactionTable;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class InvocationContextInterceptor
extends CommandInterceptor {
    private TransactionManager tm;
    private ComponentRegistry componentRegistry;
    private TransactionTable txTable;
    private InvocationContextContainer invocationContextContainer;
    private static final Log log = LogFactory.getLog(InvocationContextInterceptor.class);
    private static final boolean trace = log.isTraceEnabled();
    private volatile boolean shuttingDown = false;

    @Override
    protected Log getLog() {
        return log;
    }

    @Start(priority=1)
    private void setStartStatus() {
        this.shuttingDown = false;
    }

    @Stop(priority=1)
    private void setStopStatus() {
        this.shuttingDown = true;
    }

    @Inject
    public void init(TransactionManager tm, ComponentRegistry componentRegistry, TransactionTable txTable, InvocationContextContainer invocationContextContainer) {
        this.tm = tm;
        this.componentRegistry = componentRegistry;
        this.txTable = txTable;
        this.invocationContextContainer = invocationContextContainer;
    }

    @Override
    public Object handleDefault(InvocationContext ctx, VisitableCommand command) throws Throwable {
        return this.handleAll(ctx, command);
    }

    @Override
    public Object visitLockControlCommand(TxInvocationContext ctx, LockControlCommand lcc) throws Throwable {
        Object retval = this.handleAll(ctx, lcc);
        return retval == null ? Boolean.valueOf(false) : retval;
    }

    /*
     * Exception decompiling
     */
    private Object handleAll(InvocationContext ctx, VisitableCommand command) throws Throwable {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[CATCHBLOCK]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String getCacheNamePrefix() {
        String cacheName = this.componentRegistry.getCacheName();
        String prefix = "Cache '" + cacheName + "'";
        if (cacheName.equals("___defaultcache")) {
            prefix = "Default cache";
        }
        return prefix;
    }

    private boolean stoppingAndNotAllowed(ComponentStatus status, InvocationContext ctx) throws Exception {
        return status.isStopping() && (!ctx.isInTxScope() || !this.isOngoingTransaction(ctx));
    }

    private Object markTxForRollbackAndRethrow(InvocationContext ctx, Throwable te) throws Throwable {
        Transaction transaction;
        if (ctx.isOriginLocal() && ctx.isInTxScope() && (transaction = this.tm.getTransaction()) != null && this.isValidRunningTx(transaction)) {
            transaction.setRollbackOnly();
        }
        throw te;
    }

    private boolean isValidRunningTx(Transaction tx) throws Exception {
        int status;
        try {
            status = tx.getStatus();
        }
        catch (SystemException e) {
            throw new CacheException("Unexpected!", (Throwable)e);
        }
        return status == 0 || status == 7;
    }

    private boolean isOngoingTransaction(InvocationContext ctx) throws SystemException {
        if (!ctx.isInTxScope()) {
            return false;
        }
        if (ctx.isOriginLocal()) {
            return this.txTable.containsLocalTx(this.tm.getTransaction());
        }
        return this.txTable.containRemoteTx(((TxInvocationContext)ctx).getGlobalTransaction());
    }
}

