/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.notifications.impl;

import java.lang.annotation.Annotation;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import javax.security.auth.Subject;
import javax.transaction.Transaction;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.util.ReflectionUtil;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.notifications.IncorrectListenerException;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.impl.ListenerInvocation;
import org.infinispan.notifications.impl.SecurityActions;
import org.infinispan.security.Security;
import org.infinispan.util.concurrent.WithinThreadExecutor;
import org.infinispan.util.logging.Log;

public abstract class AbstractListenerImpl<T, L extends ListenerInvocation<T>> {
    protected final Map<Class<? extends Annotation>, List<L>> listenersMap = new HashMap<Class<? extends Annotation>, List<L>>(16, 0.99f);
    protected ExecutorService syncProcessor;
    protected ExecutorService asyncProcessor;

    @Inject
    void injectExecutor(@ComponentName(value="org.infinispan.executors.notification") ExecutorService executor) {
        this.asyncProcessor = executor;
    }

    @Start(priority=9)
    public void start() {
        this.syncProcessor = new WithinThreadExecutor();
    }

    @Stop(priority=99)
    void stop() {
        for (List<L> list : this.listenersMap.values()) {
            if (list == null) continue;
            list.clear();
        }
        if (this.syncProcessor != null) {
            this.syncProcessor.shutdownNow();
        }
    }

    protected abstract Log getLog();

    protected abstract Map<Class<? extends Annotation>, Class<?>> getAllowedMethodAnnotations(Listener var1);

    protected List<L> getListenerCollectionForAnnotation(Class<? extends Annotation> annotation) {
        List<L> list = this.listenersMap.get(annotation);
        if (list == null) {
            throw new CacheException("Unknown listener annotation: " + annotation);
        }
        return list;
    }

    public void removeListener(Object listener) {
        for (Class<Annotation> annotation : this.getAllowedMethodAnnotations(AbstractListenerImpl.testListenerClassValidity(listener.getClass())).keySet()) {
            this.removeListenerInvocation(annotation, listener);
        }
    }

    private void removeListenerInvocation(Class<? extends Annotation> annotation, Object listener) {
        if (listener == null) {
            return;
        }
        List<L> l = this.getListenerCollectionForAnnotation(annotation);
        HashSet<ListenerInvocation> markedForRemoval = new HashSet<ListenerInvocation>(4);
        for (ListenerInvocation li : l) {
            if (!listener.equals(li.getTarget())) continue;
            markedForRemoval.add(li);
        }
        l.removeAll(markedForRemoval);
    }

    public Set<Object> getListeners() {
        HashSet<Object> result = new HashSet<Object>(this.listenersMap.size());
        for (List<L> list : this.listenersMap.values()) {
            for (ListenerInvocation li : list) {
                result.add(li.getTarget());
            }
        }
        return Collections.unmodifiableSet(result);
    }

    protected boolean validateAndAddListenerInvocation(Object listener, AbstractInvocationBuilder builder) {
        Listener l = AbstractListenerImpl.testListenerClassValidity(listener.getClass());
        boolean foundMethods = false;
        builder.setTarget(listener);
        builder.setSubject(Security.getSubject());
        builder.setSync(l.sync());
        Map<Class<Annotation>, Class<?>> allowedListeners = this.getAllowedMethodAnnotations(l);
        for (Method m : listener.getClass().getMethods()) {
            if (m.isSynthetic() && m.isBridge()) continue;
            for (Map.Entry<Class<Annotation>, Class<?>> annotationEntry : allowedListeners.entrySet()) {
                Class<Annotation> key = annotationEntry.getKey();
                Class<?> value = annotationEntry.getValue();
                if (!m.isAnnotationPresent(key)) continue;
                AbstractListenerImpl.testListenerMethodValidity(m, value, key.getName());
                m.setAccessible(true);
                builder.setMethod(m);
                this.addListenerInvocation(key, builder.build());
                foundMethods = true;
            }
        }
        if (!foundMethods) {
            this.getLog().noAnnotateMethodsFoundInListener(listener.getClass());
        }
        return foundMethods;
    }

    private void addListenerInvocation(Class<? extends Annotation> annotation, L li) {
        List<L> result = this.getListenerCollectionForAnnotation(annotation);
        result.add(li);
    }

    protected static Listener testListenerClassValidity(Class<?> listenerClass) {
        Listener l = (Listener)ReflectionUtil.getAnnotation(listenerClass, Listener.class);
        if (l == null) {
            throw new IncorrectListenerException(String.format("Cache listener class %s must be annotated with org.infinispan.notifications.annotation.Listener", listenerClass.getName()));
        }
        return l;
    }

    protected static void testListenerMethodValidity(Method m, Class<?> allowedParameter, String annotationName) {
        if (m.getParameterTypes().length != 1 || !m.getParameterTypes()[0].isAssignableFrom(allowedParameter)) {
            throw new IncorrectListenerException("Methods annotated with " + annotationName + " must accept exactly one parameter, of assignable from type " + allowedParameter.getName());
        }
        if (!m.getReturnType().equals(Void.TYPE)) {
            throw new IncorrectListenerException("Methods annotated with " + annotationName + " should have a return type of void.");
        }
    }

    protected abstract Transaction suspendIfNeeded();

    protected abstract void resumeIfNeeded(Transaction var1);

    private Throwable getRealException(Throwable re) {
        if (re.getCause() == null) {
            return re;
        }
        Throwable cause = re.getCause();
        if (cause instanceof RuntimeException || cause instanceof Error) {
            return this.getRealException(cause);
        }
        return re;
    }

    protected class ListenerInvocationImpl<A>
    implements ListenerInvocation<A> {
        public final Object target;
        public final Method method;
        public final boolean sync;
        public final WeakReference<ClassLoader> classLoader;
        public final Subject subject;

        public ListenerInvocationImpl(Object target, Method method, boolean sync, ClassLoader classLoader, Subject subject) {
            this.target = target;
            this.method = method;
            this.sync = sync;
            this.classLoader = new WeakReference<ClassLoader>(classLoader);
            this.subject = subject;
        }

        @Override
        public void invoke(final A event) {
            Runnable r = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    block15: {
                        ClassLoader contextClassLoader = null;
                        Transaction transaction = AbstractListenerImpl.this.suspendIfNeeded();
                        if (ListenerInvocationImpl.this.classLoader != null && ListenerInvocationImpl.this.classLoader.get() != null) {
                            contextClassLoader = SecurityActions.setContextClassLoader((ClassLoader)ListenerInvocationImpl.this.classLoader.get());
                        }
                        try {
                            if (ListenerInvocationImpl.this.subject != null) {
                                try {
                                    Security.doAs(ListenerInvocationImpl.this.subject, new PrivilegedExceptionAction<Void>(){

                                        @Override
                                        public Void run() throws Exception {
                                            ListenerInvocationImpl.this.method.invoke(ListenerInvocationImpl.this.target, event);
                                            return null;
                                        }
                                    });
                                    break block15;
                                }
                                catch (PrivilegedActionException e) {
                                    Throwable cause = e.getCause();
                                    if (cause instanceof InvocationTargetException) {
                                        throw (InvocationTargetException)cause;
                                    }
                                    if (cause instanceof IllegalAccessException) {
                                        throw (IllegalAccessException)cause;
                                    }
                                    throw new InvocationTargetException(cause);
                                }
                            }
                            ListenerInvocationImpl.this.method.invoke(ListenerInvocationImpl.this.target, event);
                        }
                        catch (InvocationTargetException exception) {
                            Throwable cause = AbstractListenerImpl.this.getRealException(exception);
                            if (ListenerInvocationImpl.this.sync) {
                                throw AbstractListenerImpl.this.getLog().exceptionInvokingListener(cause.getClass().getName(), ListenerInvocationImpl.this.method, ListenerInvocationImpl.this.target, cause);
                            }
                            AbstractListenerImpl.this.getLog().unableToInvokeListenerMethod(ListenerInvocationImpl.this.method, ListenerInvocationImpl.this.target, cause);
                        }
                        catch (IllegalAccessException exception) {
                            AbstractListenerImpl.this.getLog().unableToInvokeListenerMethodAndRemoveListener(ListenerInvocationImpl.this.method, ListenerInvocationImpl.this.target, exception);
                            AbstractListenerImpl.this.removeListener(ListenerInvocationImpl.this.target);
                        }
                        finally {
                            if (ListenerInvocationImpl.this.classLoader != null && ListenerInvocationImpl.this.classLoader.get() != null) {
                                SecurityActions.setContextClassLoader(contextClassLoader);
                            }
                            AbstractListenerImpl.this.resumeIfNeeded(transaction);
                        }
                    }
                }
            };
            if (this.sync) {
                AbstractListenerImpl.this.syncProcessor.execute(r);
            } else {
                AbstractListenerImpl.this.asyncProcessor.execute(r);
            }
        }

        @Override
        public Object getTarget() {
            return this.target;
        }
    }

    protected abstract class AbstractInvocationBuilder {
        protected Object target;
        protected Method method;
        protected boolean sync;
        protected ClassLoader classLoader;
        protected Subject subject;

        protected AbstractInvocationBuilder() {
        }

        public Object getTarget() {
            return this.target;
        }

        public Method getMethod() {
            return this.method;
        }

        public boolean isSync() {
            return this.sync;
        }

        public ClassLoader getClassLoader() {
            return this.classLoader;
        }

        public Subject getSubject() {
            return this.subject;
        }

        public AbstractInvocationBuilder setTarget(Object target) {
            this.target = target;
            return this;
        }

        public AbstractInvocationBuilder setMethod(Method method) {
            this.method = method;
            return this;
        }

        public AbstractInvocationBuilder setSync(boolean sync) {
            this.sync = sync;
            return this;
        }

        public AbstractInvocationBuilder setClassLoader(ClassLoader classLoader) {
            this.classLoader = classLoader;
            return this;
        }

        public AbstractInvocationBuilder setSubject(Subject subject) {
            this.subject = subject;
            return this;
        }

        public abstract L build();
    }
}

