/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.client;

import io.undertow.websockets.client.WebSocketClientHandshake;
import io.undertow.websockets.client.WebSocketClientNegotiation;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.WebSocketVersion;
import io.undertow.websockets.extensions.ExtensionHandshake;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.xnio.Cancellable;
import org.xnio.ChannelListener;
import org.xnio.FutureResult;
import org.xnio.IoFuture;
import org.xnio.OptionMap;
import org.xnio.Pool;
import org.xnio.StreamConnection;
import org.xnio.XnioWorker;
import org.xnio.http.ExtendedHandshakeChecker;
import org.xnio.http.HttpUpgrade;
import org.xnio.ssl.XnioSsl;

public class WebSocketClient {
    public static final String BIND_PROPERTY = "io.undertow.websockets.BIND_ADDRESS";

    @Deprecated
    public static IoFuture<WebSocketChannel> connect(XnioWorker worker, Pool<ByteBuffer> bufferPool, OptionMap optionMap, URI uri, WebSocketVersion version) {
        return WebSocketClient.connect(worker, bufferPool, optionMap, uri, version, null);
    }

    @Deprecated
    public static IoFuture<WebSocketChannel> connect(XnioWorker worker, XnioSsl ssl, Pool<ByteBuffer> bufferPool, OptionMap optionMap, URI uri, WebSocketVersion version) {
        return WebSocketClient.connect(worker, ssl, bufferPool, optionMap, uri, version, null);
    }

    @Deprecated
    public static IoFuture<WebSocketChannel> connect(XnioWorker worker, Pool<ByteBuffer> bufferPool, OptionMap optionMap, URI uri, WebSocketVersion version, WebSocketClientNegotiation clientNegotiation) {
        return WebSocketClient.connect(worker, null, bufferPool, optionMap, uri, version, clientNegotiation);
    }

    @Deprecated
    public static IoFuture<WebSocketChannel> connect(XnioWorker worker, XnioSsl ssl, Pool<ByteBuffer> bufferPool, OptionMap optionMap, URI uri, WebSocketVersion version, WebSocketClientNegotiation clientNegotiation) {
        return WebSocketClient.connect(worker, ssl, bufferPool, optionMap, uri, version, clientNegotiation, null);
    }

    @Deprecated
    public static IoFuture<WebSocketChannel> connect(XnioWorker worker, XnioSsl ssl, Pool<ByteBuffer> bufferPool, OptionMap optionMap, URI uri, WebSocketVersion version, WebSocketClientNegotiation clientNegotiation, Set<ExtensionHandshake> clientExtensions) {
        return WebSocketClient.connect(worker, ssl, bufferPool, optionMap, null, uri, version, clientNegotiation, clientExtensions);
    }

    @Deprecated
    public static IoFuture<WebSocketChannel> connect(XnioWorker worker, XnioSsl ssl, Pool<ByteBuffer> bufferPool, OptionMap optionMap, InetSocketAddress bindAddress, URI uri, WebSocketVersion version, WebSocketClientNegotiation clientNegotiation, Set<ExtensionHandshake> clientExtensions) {
        return WebSocketClient.connectionBuilder(worker, bufferPool, uri).setSsl(ssl).setOptionMap(optionMap).setBindAddress(bindAddress).setVersion(version).setClientNegotiation(clientNegotiation).setClientExtensions(clientExtensions).connect();
    }

    public static ConnectionBuilder connectionBuilder(XnioWorker worker, Pool<ByteBuffer> bufferPool, URI uri) {
        return new ConnectionBuilder(worker, bufferPool, uri);
    }

    private WebSocketClient() {
    }

    public static class ConnectionBuilder {
        private final XnioWorker worker;
        private final Pool<ByteBuffer> bufferPool;
        private final URI uri;
        private XnioSsl ssl;
        private OptionMap optionMap = OptionMap.EMPTY;
        private InetSocketAddress bindAddress;
        private WebSocketVersion version = WebSocketVersion.V13;
        private WebSocketClientNegotiation clientNegotiation;
        private Set<ExtensionHandshake> clientExtensions;

        public ConnectionBuilder(XnioWorker worker, Pool<ByteBuffer> bufferPool, URI uri) {
            this.worker = worker;
            this.bufferPool = bufferPool;
            this.uri = uri;
        }

        public XnioWorker getWorker() {
            return this.worker;
        }

        public URI getUri() {
            return this.uri;
        }

        public XnioSsl getSsl() {
            return this.ssl;
        }

        public ConnectionBuilder setSsl(XnioSsl ssl) {
            this.ssl = ssl;
            return this;
        }

        public Pool<ByteBuffer> getBufferPool() {
            return this.bufferPool;
        }

        public OptionMap getOptionMap() {
            return this.optionMap;
        }

        public ConnectionBuilder setOptionMap(OptionMap optionMap) {
            this.optionMap = optionMap;
            return this;
        }

        public InetSocketAddress getBindAddress() {
            return this.bindAddress;
        }

        public ConnectionBuilder setBindAddress(InetSocketAddress bindAddress) {
            this.bindAddress = bindAddress;
            return this;
        }

        public WebSocketVersion getVersion() {
            return this.version;
        }

        public ConnectionBuilder setVersion(WebSocketVersion version) {
            this.version = version;
            return this;
        }

        public WebSocketClientNegotiation getClientNegotiation() {
            return this.clientNegotiation;
        }

        public ConnectionBuilder setClientNegotiation(WebSocketClientNegotiation clientNegotiation) {
            this.clientNegotiation = clientNegotiation;
            return this;
        }

        public Set<ExtensionHandshake> getClientExtensions() {
            return this.clientExtensions;
        }

        public ConnectionBuilder setClientExtensions(Set<ExtensionHandshake> clientExtensions) {
            this.clientExtensions = clientExtensions;
            return this;
        }

        public IoFuture<WebSocketChannel> connect() {
            URI newUri;
            final FutureResult ioFuture = new FutureResult();
            String scheme = this.uri.getScheme().equals("wss") ? "https" : "http";
            try {
                newUri = new URI(scheme, this.uri.getUserInfo(), this.uri.getHost(), this.uri.getPort() == -1 ? (this.uri.getScheme().equals("wss") ? 443 : 80) : this.uri.getPort(), this.uri.getPath().isEmpty() ? "/" : this.uri.getPath(), this.uri.getQuery(), this.uri.getFragment());
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
            final WebSocketClientHandshake handshake = WebSocketClientHandshake.create(this.version, newUri, this.clientNegotiation, this.clientExtensions);
            Map<String, String> originalHeaders = handshake.createHeaders();
            originalHeaders.put("Origin", scheme + "://" + this.uri.getHost());
            HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
            for (Map.Entry<String, String> entry : originalHeaders.entrySet()) {
                ArrayList<String> list = new ArrayList<String>();
                list.add(entry.getValue());
                headers.put(entry.getKey(), list);
            }
            if (this.clientNegotiation != null) {
                this.clientNegotiation.beforeRequest(headers);
            }
            InetSocketAddress toBind = this.bindAddress;
            String sysBind = System.getProperty(WebSocketClient.BIND_PROPERTY);
            if (toBind == null && sysBind != null) {
                toBind = new InetSocketAddress(sysBind, 0);
            }
            final IoFuture result = this.ssl != null ? HttpUpgrade.performUpgrade((XnioWorker)this.worker, (XnioSsl)this.ssl, (InetSocketAddress)toBind, (URI)newUri, headers, (ChannelListener)new ChannelListener<StreamConnection>(){

                public void handleEvent(StreamConnection channel) {
                    WebSocketChannel result = handshake.createChannel(channel, newUri.toString(), (Pool<ByteBuffer>)ConnectionBuilder.this.bufferPool);
                    ioFuture.setResult((Object)result);
                }
            }, null, (OptionMap)this.optionMap, (ExtendedHandshakeChecker)handshake.handshakeChecker(newUri, headers)) : HttpUpgrade.performUpgrade((XnioWorker)this.worker, (InetSocketAddress)toBind, (URI)newUri, headers, (ChannelListener)new ChannelListener<StreamConnection>(){

                public void handleEvent(StreamConnection channel) {
                    WebSocketChannel result = handshake.createChannel(channel, newUri.toString(), (Pool<ByteBuffer>)ConnectionBuilder.this.bufferPool);
                    ioFuture.setResult((Object)result);
                }
            }, null, (OptionMap)this.optionMap, (ExtendedHandshakeChecker)handshake.handshakeChecker(newUri, headers));
            result.addNotifier((IoFuture.Notifier)new IoFuture.Notifier<StreamConnection, Object>(){

                public void notify(IoFuture<? extends StreamConnection> res, Object attachment) {
                    if (res.getStatus() == IoFuture.Status.FAILED) {
                        ioFuture.setException(res.getException());
                    }
                }
            }, null);
            ioFuture.addCancelHandler(new Cancellable(){

                public Cancellable cancel() {
                    result.cancel();
                    return null;
                }
            });
            return ioFuture.getIoFuture();
        }
    }
}

