/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.near;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.infinispan.client.hotrod.VersionedValue;
import org.infinispan.client.hotrod.configuration.NearCacheConfiguration;
import org.infinispan.client.hotrod.near.NearCache;

public class LinkedMapNearCache<K, V>
implements NearCache<K, V> {
    private final LinkedHashMap<K, VersionedValue<V>> cache;
    private final ReadWriteLock rwlock = new ReentrantReadWriteLock();

    protected LinkedMapNearCache(LinkedHashMap<K, VersionedValue<V>> cache) {
        this.cache = cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(K key, VersionedValue<V> value) {
        Lock lock = this.rwlock.writeLock();
        try {
            lock.lock();
            this.cache.put(key, value);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putIfAbsent(K key, VersionedValue<V> value) {
        Lock lock = this.rwlock.writeLock();
        try {
            lock.lock();
            VersionedValue<V> current = this.cache.get(key);
            if (current == null) {
                this.cache.put(key, value);
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(K key) {
        Lock lock = this.rwlock.writeLock();
        try {
            lock.lock();
            this.cache.remove(key);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VersionedValue<V> get(K key) {
        Lock lock = this.rwlock.readLock();
        try {
            lock.lock();
            VersionedValue<V> versionedValue = this.cache.get(key);
            return versionedValue;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Lock lock = this.rwlock.writeLock();
        try {
            lock.lock();
            this.cache.clear();
        }
        finally {
            lock.unlock();
        }
    }

    public static <K, V> NearCache<K, V> create(final NearCacheConfiguration config) {
        return new LinkedMapNearCache<K, V>(new LinkedHashMap<K, VersionedValue<V>>(16, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry eldest) {
                return this.size() > config.maxEntries();
            }
        });
    }
}

