/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import java.util.Map;
import org.hornetq.api.core.management.ClusterConnectionControl;
import org.hornetq.core.server.HornetQServer;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.messaging.AbstractHornetQComponentControlHandler;
import org.jboss.as.messaging.ClusterConnectionDefinition;
import org.jboss.dmr.ModelNode;

public class ClusterConnectionControlHandler
extends AbstractHornetQComponentControlHandler<ClusterConnectionControl> {
    public static final ClusterConnectionControlHandler INSTANCE = new ClusterConnectionControlHandler();

    private ClusterConnectionControlHandler() {
    }

    @Override
    protected ClusterConnectionControl getHornetQComponentControl(HornetQServer hqServer, PathAddress address) {
        String resourceName = address.getLastElement().getValue();
        return (ClusterConnectionControl)ClusterConnectionControl.class.cast(hqServer.getManagementService().getResource("core.clusterconnection." + resourceName));
    }

    @Override
    protected String getDescriptionPrefix() {
        return "cluster-connection";
    }

    @Override
    protected void handleReadAttribute(String attributeName, OperationContext context, ModelNode operation) throws OperationFailedException {
        if (ClusterConnectionDefinition.NODE_ID.getName().equals(attributeName)) {
            ClusterConnectionControl control = (ClusterConnectionControl)this.getHornetQComponentControl(context, operation, false);
            context.getResult().set(control.getNodeID());
        } else if (ClusterConnectionDefinition.TOPOLOGY.getName().equals(attributeName)) {
            ClusterConnectionControl control = (ClusterConnectionControl)this.getHornetQComponentControl(context, operation, false);
            context.getResult().set(control.getTopology());
        } else {
            this.unsupportedAttribute(attributeName);
        }
    }

    @Override
    protected Object handleOperation(String operationName, OperationContext context, ModelNode operation) throws OperationFailedException {
        if ("get-static-connectors-as-json".equals(operationName)) {
            ClusterConnectionControl control = (ClusterConnectionControl)this.getHornetQComponentControl(context, operation, false);
            try {
                context.getResult().set(control.getStaticConnectorsAsJSON());
            }
            catch (Exception e) {
                context.getFailureDescription().set(e.getLocalizedMessage());
            }
        } else if ("get-nodes".equals(operationName)) {
            ClusterConnectionControl control = (ClusterConnectionControl)this.getHornetQComponentControl(context, operation, false);
            try {
                Map nodes = control.getNodes();
                ModelNode result = context.getResult();
                result.setEmptyObject();
                for (Map.Entry entry : nodes.entrySet()) {
                    result.get((String)entry.getKey()).set((String)entry.getValue());
                }
            }
            catch (Exception e) {
                context.getFailureDescription().set(e.getLocalizedMessage());
            }
        } else {
            this.unsupportedOperation(operationName);
        }
        return null;
    }
}

