/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.connectionmanager.ccm;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionRequestInfo;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import org.jboss.jca.core.CoreBundle;
import org.jboss.jca.core.CoreLogger;
import org.jboss.jca.core.api.connectionmanager.ccm.CachedConnectionManager;
import org.jboss.jca.core.api.connectionmanager.listener.ConnectionListener;
import org.jboss.jca.core.connectionmanager.ConnectionRecord;
import org.jboss.jca.core.connectionmanager.ccm.KeyConnectionAssociation;
import org.jboss.jca.core.connectionmanager.ccm.SecurityActions;
import org.jboss.jca.core.connectionmanager.listener.ConnectionCacheListener;
import org.jboss.jca.core.connectionmanager.transaction.TransactionSynchronizer;
import org.jboss.jca.core.spi.transaction.TransactionIntegration;
import org.jboss.jca.core.spi.transaction.TxUtils;
import org.jboss.jca.core.spi.transaction.usertx.UserTransactionListener;
import org.jboss.logging.Logger;
import org.jboss.logging.Messages;

public class CachedConnectionManagerImpl
implements CachedConnectionManager {
    private static CoreLogger log = (CoreLogger)Logger.getMessageLogger(CoreLogger.class, (String)CachedConnectionManager.class.getName());
    private static boolean trace = log.isTraceEnabled();
    private static CoreBundle bundle = (CoreBundle)Messages.getBundle(CoreBundle.class);
    private boolean debug = false;
    private boolean error = false;
    private boolean ignoreConnections = false;
    private TransactionIntegration transactionIntegration;
    private final ThreadLocal<LinkedList<Object>> currentObjects = new ThreadLocal();
    private final ConcurrentMap<KeyConnectionAssociation, ConcurrentMap<ConnectionCacheListener, CopyOnWriteArrayList<ConnectionRecord>>> objectToConnectionManagerMap = new ConcurrentHashMap<KeyConnectionAssociation, ConcurrentMap<ConnectionCacheListener, CopyOnWriteArrayList<ConnectionRecord>>>();
    private final Map<Object, Throwable> connectionStackTraces = new WeakHashMap<Object, Throwable>();

    public CachedConnectionManagerImpl(TransactionIntegration transactionIntegration) {
        if (transactionIntegration == null) {
            throw new IllegalArgumentException("TransactionIntegration is null");
        }
        this.transactionIntegration = transactionIntegration;
    }

    public TransactionManager getTransactionManager() {
        return this.transactionIntegration.getTransactionManager();
    }

    public TransactionSynchronizationRegistry getTransactionSynchronizationRegistry() {
        return this.transactionIntegration.getTransactionSynchronizationRegistry();
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean v) {
        this.debug = v;
    }

    public boolean isError() {
        return this.error;
    }

    public void setError(boolean v) {
        this.error = v;
    }

    public boolean isIgnoreUnknownConnections() {
        return this.ignoreConnections;
    }

    public void setIgnoreUnknownConnections(boolean v) {
        this.ignoreConnections = v;
    }

    public void start() {
        if (this.transactionIntegration.getUserTransactionRegistry() != null) {
            this.transactionIntegration.getUserTransactionRegistry().addListener((UserTransactionListener)this);
        }
        log.debugf("start: %s", this.toString());
    }

    public void stop() {
        log.debugf("stop: %s", this.toString());
        if (this.transactionIntegration.getUserTransactionRegistry() != null) {
            this.transactionIntegration.getUserTransactionRegistry().removeListener((UserTransactionListener)this);
        }
    }

    public void userTransactionStarted() throws SystemException {
        KeyConnectionAssociation key = this.peekMetaAwareObject();
        if (trace) {
            log.tracef("user tx started, key: %s", key);
        }
        if (key != null) {
            ConcurrentMap<ConnectionCacheListener, CopyOnWriteArrayList<ConnectionRecord>> cmToConnectionsMap = key.getCMToConnectionsMap();
            for (Map.Entry entry : cmToConnectionsMap.entrySet()) {
                ConnectionCacheListener cm = (ConnectionCacheListener)entry.getKey();
                CopyOnWriteArrayList conns = (CopyOnWriteArrayList)entry.getValue();
                cm.transactionStarted(conns);
            }
        }
    }

    private KeyConnectionAssociation peekMetaAwareObject() {
        LinkedList<Object> stack = this.currentObjects.get();
        if (stack != null && !stack.isEmpty()) {
            return (KeyConnectionAssociation)stack.getLast();
        }
        return null;
    }

    public void popMetaAwareObject(Set unsharableResources) throws ResourceException {
        LinkedList<Object> stack = this.currentObjects.get();
        KeyConnectionAssociation oldKey = (KeyConnectionAssociation)stack.removeLast();
        if (trace) {
            log.tracef("popped object: %s", oldKey);
        }
        if (this.debug && this.closeAll(oldKey.getCMToConnectionsMap()) && this.error) {
            throw new ResourceException(bundle.someConnectionsWereNotClosed());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerConnection(org.jboss.jca.core.api.connectionmanager.listener.ConnectionCacheListener cm, ConnectionListener cl, Object connection, ConnectionRequestInfo cri) {
        if (this.debug) {
            Map<Object, Throwable> map = this.connectionStackTraces;
            synchronized (map) {
                this.connectionStackTraces.put(connection, new Throwable("STACKTRACE"));
            }
        }
        KeyConnectionAssociation key = this.peekMetaAwareObject();
        if (trace) {
            log.tracef("registering connection from connection manager: %s, connection : %s, key: %s", cm, connection, key);
        }
        if (key != null) {
            ConnectionRecord cr = new ConnectionRecord(cl, connection, cri);
            ConcurrentMap<ConnectionCacheListener, CopyOnWriteArrayList<ConnectionRecord>> cmToConnectionsMap = key.getCMToConnectionsMap();
            CopyOnWriteArrayList<ConnectionRecord> conns = (CopyOnWriteArrayList<ConnectionRecord>)cmToConnectionsMap.get(cm);
            if (conns == null) {
                conns = new CopyOnWriteArrayList<ConnectionRecord>();
                cmToConnectionsMap.put((ConnectionCacheListener)cm, conns);
            }
            conns.add(cr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterConnection(org.jboss.jca.core.api.connectionmanager.listener.ConnectionCacheListener cm, Object connection) {
        if (this.debug) {
            CloseConnectionSynchronization cas = this.getCloseConnectionSynchronization(false);
            if (cas != null) {
                cas.remove(connection);
            }
            Map<Object, Throwable> map = this.connectionStackTraces;
            synchronized (map) {
                this.connectionStackTraces.remove(connection);
            }
        }
        KeyConnectionAssociation key = this.peekMetaAwareObject();
        if (trace) {
            log.tracef("unregistering connection from connection manager: %s, connection: %s, key: %s", cm, connection, key);
        }
        if (key == null) {
            return;
        }
        ConcurrentMap<ConnectionCacheListener, CopyOnWriteArrayList<ConnectionRecord>> cmToConnectionsMap = key.getCMToConnectionsMap();
        CopyOnWriteArrayList conns = (CopyOnWriteArrayList)cmToConnectionsMap.get(cm);
        if (conns == null) {
            return;
        }
        for (ConnectionRecord connectionRecord : conns) {
            if (connectionRecord.getConnection() != connection) continue;
            conns.remove(connectionRecord);
            return;
        }
        if (!this.ignoreConnections) {
            throw new IllegalStateException(bundle.tryingToReturnUnknownConnection(connection.toString()));
        }
    }

    public void pushMetaAwareObject(Object rawKey, Set unsharableResources) throws ResourceException {
        LinkedList<Object> stack = this.currentObjects.get();
        if (stack == null) {
            if (trace) {
                log.tracef("new stack for key: %s", rawKey);
            }
            stack = new LinkedList();
            this.currentObjects.set(stack);
        } else if (trace) {
            log.tracef("old stack for key: %s", stack.getLast());
        }
        KeyConnectionAssociation key = new KeyConnectionAssociation(rawKey);
        stack.addLast(key);
    }

    public void unregisterConnectionCacheListener(ConnectionCacheListener cm) {
        if (trace) {
            log.tracef("unregisterConnectionCacheListener: %s", cm);
        }
        for (ConcurrentMap cmToConnectionsMap : this.objectToConnectionManagerMap.values()) {
            if (cmToConnectionsMap == null) continue;
            cmToConnectionsMap.remove(cm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfConnections() {
        if (!this.debug) {
            return 0;
        }
        Map<Object, Throwable> map = this.connectionStackTraces;
        synchronized (map) {
            return this.connectionStackTraces.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> listConnections() {
        if (!this.debug) {
            return Collections.unmodifiableMap(Collections.EMPTY_MAP);
        }
        Map<Object, Throwable> map = this.connectionStackTraces;
        synchronized (map) {
            HashMap<String, String> result = new HashMap<String, String>();
            for (Map.Entry<Object, Throwable> entry : this.connectionStackTraces.entrySet()) {
                Object key = entry.getKey();
                Throwable stackTrace = entry.getValue();
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                PrintStream ps = new PrintStream(baos, true);
                stackTrace.printStackTrace(ps);
                result.put(key.toString(), baos.toString());
            }
            return Collections.unmodifiableMap(result);
        }
    }

    private boolean closeAll(ConcurrentMap<ConnectionCacheListener, CopyOnWriteArrayList<ConnectionRecord>> cmToConnectionsMap) {
        boolean unclosed = false;
        Collection connections = cmToConnectionsMap.values();
        if (connections.size() != 0) {
            for (CopyOnWriteArrayList conns : connections) {
                Iterator j = conns.iterator();
                while (j.hasNext()) {
                    Object c = ((ConnectionRecord)j.next()).getConnection();
                    CloseConnectionSynchronization cas = this.getCloseConnectionSynchronization(true);
                    if (cas == null) {
                        unclosed = true;
                        this.closeConnection(c);
                        continue;
                    }
                    cas.add(c);
                }
            }
        }
        return unclosed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CloseConnectionSynchronization getCloseConnectionSynchronization(boolean createIfNotFound) {
        block9: {
            CloseConnectionSynchronization closeConnectionSynchronization;
            block10: {
                Transaction tx = null;
                if (this.getTransactionManager() != null) {
                    tx = this.getTransactionManager().getTransaction();
                }
                if (tx == null) break block9;
                if (createIfNotFound) {
                    TransactionSynchronizer.lock(tx, this.transactionIntegration);
                }
                try {
                    CloseConnectionSynchronization cas = (CloseConnectionSynchronization)TransactionSynchronizer.getCCMSynchronization(tx, this.transactionIntegration);
                    if (cas == null && createIfNotFound && TxUtils.isActive((Transaction)tx)) {
                        cas = new CloseConnectionSynchronization();
                        TransactionSynchronizer.registerCCMSynchronization(tx, cas, this.transactionIntegration);
                    }
                    closeConnectionSynchronization = cas;
                    if (!createIfNotFound) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (createIfNotFound) {
                            TransactionSynchronizer.unlock(tx, this.transactionIntegration);
                        }
                        throw throwable;
                    }
                    catch (Throwable t) {
                        log.debug("Unable to synchronize with transaction", t);
                    }
                }
                TransactionSynchronizer.unlock(tx, this.transactionIntegration);
            }
            return closeConnectionSynchronization;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeConnection(Object connectionHandle) {
        try {
            Throwable exception;
            Map<Object, Throwable> map = this.connectionStackTraces;
            synchronized (map) {
                exception = this.connectionStackTraces.remove(connectionHandle);
            }
            Method m = SecurityActions.getMethod(connectionHandle.getClass(), "close", new Class[0]);
            try {
                if (exception != null) {
                    log.closingConnection(connectionHandle, exception);
                } else {
                    log.closingConnection(connectionHandle);
                }
                m.invoke(connectionHandle, new Object[0]);
            }
            catch (Throwable t) {
                log.closingConnectionThrowable(t);
            }
        }
        catch (NoSuchMethodException nsme) {
            log.closingConnectionNoClose(connectionHandle.getClass().getName());
        }
    }

    final ThreadLocal<LinkedList<Object>> getCurrentObjects() {
        return this.currentObjects;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CachedConnectionManagerImpl@").append(Integer.toHexString(System.identityHashCode(this)));
        sb.append("[debug=").append(this.debug);
        sb.append(" error=").append(this.error);
        sb.append(" ignoreConnections=").append(this.ignoreConnections);
        sb.append(" transactionIntegration=").append(this.transactionIntegration);
        sb.append(" currentObjects=").append(this.currentObjects.get());
        sb.append(" objectToConnectionManagerMap=").append(this.objectToConnectionManagerMap);
        sb.append(" connectionStackTraces=").append(this.connectionStackTraces);
        sb.append("]");
        return sb.toString();
    }

    private class CloseConnectionSynchronization
    implements Synchronization {
        CopyOnWriteArraySet<Object> connections = new CopyOnWriteArraySet();
        AtomicBoolean closing = new AtomicBoolean(false);

        public void add(Object c) {
            if (!this.closing.get()) {
                this.connections.add(c);
            }
        }

        public void remove(Object c) {
            if (!this.closing.get()) {
                this.connections.remove(c);
            }
        }

        public void beforeCompletion() {
            this.closing.set(true);
            Iterator<Object> i = this.connections.iterator();
            while (i.hasNext()) {
                CachedConnectionManagerImpl.this.closeConnection(i.next());
            }
            this.connections.clear();
        }

        public void afterCompletion(int status) {
        }
    }
}

