/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.connectionmanager.listener;

import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.ManagedConnection;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import org.jboss.jca.common.api.metadata.common.FlushStrategy;
import org.jboss.jca.core.CoreBundle;
import org.jboss.jca.core.CoreLogger;
import org.jboss.jca.core.api.connectionmanager.listener.ConnectionCacheListener;
import org.jboss.jca.core.api.connectionmanager.listener.ConnectionListener;
import org.jboss.jca.core.connectionmanager.ConnectionManager;
import org.jboss.jca.core.connectionmanager.TxConnectionManager;
import org.jboss.jca.core.connectionmanager.listener.AbstractConnectionListener;
import org.jboss.jca.core.connectionmanager.listener.ConnectionState;
import org.jboss.jca.core.connectionmanager.listener.SecurityActions;
import org.jboss.jca.core.connectionmanager.pool.api.Pool;
import org.jboss.jca.core.connectionmanager.pool.mcp.ManagedConnectionPool;
import org.jboss.jca.core.connectionmanager.transaction.LockKey;
import org.jboss.jca.core.connectionmanager.transaction.TransactionSynchronizer;
import org.jboss.jca.core.connectionmanager.tx.TxConnectionManagerImpl;
import org.jboss.jca.core.spi.transaction.ConnectableResource;
import org.jboss.jca.core.spi.transaction.ConnectableResourceListener;
import org.jboss.jca.core.spi.transaction.TxUtils;
import org.jboss.jca.core.spi.transaction.local.LocalXAResource;
import org.jboss.jca.core.tracer.Tracer;
import org.jboss.logging.Logger;
import org.jboss.logging.Messages;

public class TxConnectionListener
extends AbstractConnectionListener {
    private static CoreLogger log = (CoreLogger)Logger.getMessageLogger(CoreLogger.class, (String)TxConnectionListener.class.getName());
    private static CoreBundle bundle = (CoreBundle)Messages.getBundle(CoreBundle.class);
    private static boolean disableFailedtoEnlist = false;
    private TransactionSynchronization transactionSynchronization;
    private final XAResource xaResource;
    private final int xaResourceTimeout;
    private final AtomicBoolean localTransaction = new AtomicBoolean(false);
    private boolean doDelistResource;

    public TxConnectionListener(ConnectionManager cm, ManagedConnection mc, Pool pool, ManagedConnectionPool mcp, FlushStrategy flushStrategy, Boolean tracking, XAResource xaResource, int xaResourceTimeout) throws ResourceException {
        super(cm, mc, pool, mcp, flushStrategy, tracking);
        String value;
        this.xaResource = xaResource;
        this.xaResourceTimeout = xaResourceTimeout;
        this.doDelistResource = true;
        if (xaResource instanceof LocalXAResource) {
            ((LocalXAResource)xaResource).setConnectionListener((ConnectionListener)this);
        }
        if (xaResource instanceof ConnectableResource) {
            ((ConnectableResource)xaResource).setConnectableResourceListener((ConnectableResourceListener)this);
        }
        if ((value = SecurityActions.getSystemProperty("ironjacamar.no_delist_resource")) != null && !value.trim().equals("")) {
            StringTokenizer st = new StringTokenizer(value, ",");
            while (this.doDelistResource && st.hasMoreTokens()) {
                if (!this.getPool().getName().equals(st.nextToken())) continue;
                this.doDelistResource = false;
            }
        }
        if ((value = SecurityActions.getSystemProperty("ironjacamar.no_delist_resource_all")) != null && !value.trim().equals("")) {
            this.doDelistResource = false;
        }
    }

    @Override
    protected CoreLogger getLogger() {
        return log;
    }

    @Override
    public void toPool() {
        super.toPool();
        if (!(this.xaResource instanceof LocalXAResource) && this.xaResourceTimeout > 0) {
            try {
                this.xaResource.setTransactionTimeout(this.xaResourceTimeout);
            }
            catch (XAException e) {
                log.debugf(e, "XAException happend during return for: %s", this.getPool() != null ? this.getPool().getName() : "Unknown");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enlist() throws SystemException {
        TxConnectionManager txConnectionManager;
        if (this.isEnlisted()) {
            return;
        }
        TransactionManager tm = this.getConnectionManager().getTransactionIntegration().getTransactionManager();
        int status = tm.getStatus();
        if (status == 6) {
            if (this.transactionSynchronization != null && this.transactionSynchronization.currentTx != null) {
                String error = "Attempt to use connection outside a transaction when already a tx!";
                if (this.trace) {
                    log.trace(error + " " + this);
                }
                throw new IllegalStateException(error);
            }
            if (this.trace) {
                log.trace("No transaction, no need to enlist: " + this);
            }
            return;
        }
        Transaction threadTx = tm.getTransaction();
        if (!(threadTx != null && status == 0 || (txConnectionManager = (TxConnectionManager)this.getConnectionManager()).isAllowMarkedForRollback())) {
            String error = "Transaction " + threadTx + " is not active " + TxUtils.getStatusAsString((int)status);
            if (this.trace) {
                log.trace(error + " cl=" + this);
            }
            throw new IllegalStateException(error);
        }
        if (this.trace) {
            log.trace("Pre-enlist: " + this + " threadTx=" + threadTx);
        }
        TransactionSynchronization ourSynchronization = null;
        TransactionSynchronizer synchronizer = null;
        try {
            TransactionSynchronizer.lock(threadTx, this.getConnectionManager().getTransactionIntegration());
        }
        catch (Exception e) {
            this.setTrackByTx(false);
            TxConnectionManagerImpl.rethrowAsSystemException("Exception during lock", threadTx, e);
        }
        try {
            if (!this.isTrackByTx() && this.transactionSynchronization != null) {
                String error = "Can't enlist - already a tx!";
                if (this.trace) {
                    log.trace(error + " " + this);
                }
                throw new IllegalStateException(error);
            }
            if (this.transactionSynchronization != null && !this.transactionSynchronization.currentTx.equals(threadTx)) {
                String error = "Trying to change transaction " + threadTx + " in enlist!";
                if (this.trace) {
                    log.trace(error + " " + this);
                }
                throw new IllegalStateException(error);
            }
            try {
                if (this.trace) {
                    log.trace("Get synchronizer " + this + " threadTx=" + threadTx);
                }
                synchronizer = TransactionSynchronizer.getRegisteredSynchronizer(threadTx, this.getConnectionManager().getTransactionIntegration());
            }
            catch (Throwable t) {
                this.setTrackByTx(false);
                TxConnectionManagerImpl.rethrowAsSystemException("Cannot register synchronization", threadTx, t);
            }
            if (this.transactionSynchronization == null) {
                TransactionSynchronization synchronization = new TransactionSynchronization(threadTx, this.isTrackByTx());
                synchronizer.addUnenlisted(synchronization);
                this.transactionSynchronization = synchronization;
            }
            ourSynchronization = this.transactionSynchronization;
        }
        finally {
            TransactionSynchronizer.unlock(threadTx, this.getConnectionManager().getTransactionIntegration());
        }
        List<Synchronization> unenlisted = synchronizer.getUnenlisted();
        if (unenlisted != null) {
            try {
                int size = unenlisted.size();
                for (int i = 0; i < size; ++i) {
                    TransactionSynchronization sync = (TransactionSynchronization)unenlisted.get(i);
                    if (!sync.enlist()) continue;
                    synchronizer.addEnlisted(sync);
                }
            }
            finally {
                synchronizer.enlisted();
            }
        }
        if (this.trace) {
            log.trace("Check enlisted " + this + " threadTx=" + threadTx);
        }
        ourSynchronization.checkEnlisted();
        this.setEnlisted(true);
    }

    @Override
    public boolean delist() throws ResourceException {
        if (this.trace) {
            log.trace("delisting " + this);
        }
        boolean success = true;
        try {
            if (!this.isTrackByTx()) {
                Transaction tx;
                if (this.transactionSynchronization != null) {
                    Transaction tx2 = this.transactionSynchronization.currentTx;
                    TransactionSynchronization synchronization = this.transactionSynchronization;
                    this.transactionSynchronization = null;
                    if (TxUtils.isUncommitted((Transaction)tx2)) {
                        TransactionSynchronizer synchronizer;
                        if (synchronization.enlisted && !(synchronizer = TransactionSynchronizer.getRegisteredSynchronizer(tx2, this.getConnectionManager().getTransactionIntegration())).removeEnlisted(synchronization) && this.trace) {
                            log.tracef("%s not found in %s", synchronization, synchronizer);
                        }
                        if (!this.getState().equals((Object)ConnectionState.DESTROYED)) {
                            if (this.trace) {
                                log.tracef("delistResource(%s, TMSUSPEND)", this.getXAResource());
                            }
                            boolean suspendResult = tx2.delistResource(this.getXAResource(), 0x2000000);
                            if (Tracer.isEnabled()) {
                                Tracer.delistConnectionListener(this.getPool() != null ? this.getPool().getName() : null, this.getManagedConnectionPool(), this, suspendResult, false, true);
                            }
                            if (!suspendResult) {
                                throw new ResourceException(bundle.failureDelistResource(this));
                            }
                            if (this.trace) {
                                log.trace("delist-suspend: " + this);
                            }
                        }
                    }
                } else if (!this.getState().equals((Object)ConnectionState.DESTROYED) && this.isManagedConnectionFree() && this.isEnlisted() && this.doDelistResource && this.getConnectionManager().getTransactionIntegration() != null && this.getConnectionManager().getTransactionIntegration().getTransactionManager() != null && TxUtils.isUncommitted((Transaction)(tx = this.getConnectionManager().getTransactionIntegration().getTransactionManager().getTransaction()))) {
                    if (TxUtils.isActive((Transaction)tx)) {
                        if (this.trace) {
                            log.tracef("delistResource(%s, TMSUCCESS)", this.getXAResource());
                        }
                        boolean successResult = tx.delistResource(this.getXAResource(), 0x4000000);
                        if (Tracer.isEnabled()) {
                            Tracer.delistConnectionListener(this.getPool() != null ? this.getPool().getName() : null, this.getManagedConnectionPool(), this, true, false, true);
                        }
                        if (successResult) {
                            if (this.trace) {
                                log.trace("delist-success: " + this);
                            }
                        } else {
                            log.debugf("delist-success failed: %s", this);
                            success = false;
                        }
                    } else {
                        if (this.trace) {
                            log.tracef("delistResource(%s, TMFAIL)", this.getXAResource());
                        }
                        boolean failResult = tx.delistResource(this.getXAResource(), 0x20000000);
                        if (Tracer.isEnabled()) {
                            Tracer.delistConnectionListener(this.getPool() != null ? this.getPool().getName() : null, this.getManagedConnectionPool(), this, false, false, true);
                        }
                        if (failResult) {
                            if (this.trace) {
                                log.trace("delist-fail: " + this);
                            }
                        } else {
                            log.debugf("delist-fail failed: %s", this);
                            success = false;
                        }
                    }
                }
                this.setEnlisted(false);
            }
            if (this.trace) {
                log.trace("delisted " + this);
            }
            return success;
        }
        catch (ResourceException re) {
            throw re;
        }
        catch (Throwable t) {
            throw new ResourceException(bundle.errorInDelist(), t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dissociate() throws ResourceException {
        if (this.trace) {
            log.tracef("dissociate: %s", this);
        }
        try {
            TransactionManager tm = this.getConnectionManager().getTransactionIntegration().getTransactionManager();
            int status = tm.getStatus();
            if (this.trace) {
                log.tracef("dissociate: status=%s", TxUtils.getStatusAsString((int)status));
            }
            if (status != 6) {
                if (this.isEnlisted()) {
                    if (this.doDelistResource) {
                        Transaction tx = tm.getTransaction();
                        boolean delistResult = tx.delistResource(this.getXAResource(), 0x4000000);
                        if (this.trace) {
                            log.tracef("dissociate: delistResult=%s", delistResult);
                        }
                    }
                } else if (this.trace) {
                    log.tracef("dissociate: not enlisted (%s)", this);
                }
                if (this.isTrackByTx()) {
                    ManagedConnectionPool mcp = this.getManagedConnectionPool();
                    TransactionSynchronizationRegistry tsr = this.getConnectionManager().getTransactionIntegration().getTransactionSynchronizationRegistry();
                    Lock lock = (Lock)tsr.getResource((Object)LockKey.INSTANCE);
                    if (lock != null) {
                        try {
                            lock.lockInterruptibly();
                        }
                        catch (InterruptedException ie) {
                            Thread.interrupted();
                            throw new ResourceException(bundle.unableObtainLock(), (Throwable)ie);
                        }
                        try {
                            tsr.putResource((Object)mcp, null);
                        }
                        finally {
                            lock.unlock();
                        }
                    }
                }
            }
            this.localTransaction.set(false);
            this.setTrackByTx(false);
            if (this.transactionSynchronization != null) {
                this.transactionSynchronization.cancel();
                this.transactionSynchronization = null;
            }
            this.setEnlisted(false);
        }
        catch (Throwable t) {
            throw new ResourceException(bundle.errorInDissociate(), t);
        }
    }

    protected XAResource getXAResource() {
        return this.xaResource;
    }

    @Override
    public void connectionClosed(ConnectionEvent ce) {
        if (this.trace) {
            log.trace("connectionClosed called mc=" + this.getManagedConnection());
        }
        if (this.getManagedConnection() != (ManagedConnection)ce.getSource()) {
            throw new IllegalArgumentException("ConnectionClosed event received from wrong ManagedConnection! Expected: " + this.getManagedConnection() + ", actual: " + ce.getSource());
        }
        if (this.getCachedConnectionManager() != null) {
            try {
                this.getCachedConnectionManager().unregisterConnection((ConnectionCacheListener)this.getConnectionManager(), ce.getConnectionHandle());
            }
            catch (Throwable t) {
                log.throwableFromUnregisterConnection(t);
            }
        }
        try {
            if (this.wasFreed(ce.getConnectionHandle())) {
                boolean success = this.delist();
                if (this.trace) {
                    log.trace("isManagedConnectionFree=true mc=" + this.getManagedConnection());
                }
                if (success || this.tracking != null && !this.tracking.booleanValue()) {
                    this.getConnectionManager().returnManagedConnection(this, false);
                } else {
                    log.delistingFailed(this.getPool() != null ? this.getPool().getName() : "Unknown", new Exception());
                    this.getConnectionManager().returnManagedConnection(this, true);
                }
            } else if (this.trace) {
                log.trace("isManagedConnectionFree=false mc=" + this.getManagedConnection());
            }
        }
        catch (Throwable t) {
            log.errorWhileClosingConnectionHandle(t);
            this.getConnectionManager().returnManagedConnection(this, true);
        }
    }

    @Override
    public void localTransactionStarted(ConnectionEvent ce) {
        this.localTransaction.set(true);
    }

    @Override
    public void localTransactionCommitted(ConnectionEvent ce) {
        this.localTransaction.set(false);
    }

    @Override
    public void localTransactionRolledback(ConnectionEvent ce) {
        this.localTransaction.set(false);
    }

    @Override
    public void tidyup() throws ResourceException {
        if (this.localTransaction.get()) {
            LocalTransaction local = null;
            ManagedConnection mc = this.getManagedConnection();
            try {
                local = mc.getLocalTransaction();
            }
            catch (Throwable t) {
                throw new ResourceException(bundle.unfinishedLocalTransaction(this), t);
            }
            if (local == null) {
                throw new ResourceException(bundle.unfinishedLocalTransactionNotProvideLocalTransaction(this));
            }
            local.rollback();
            log.debugf("Unfinished local transaction was rolled back.%s", this);
        }
    }

    @Override
    public void connectionErrorOccurred(ConnectionEvent ce) {
        this.transactionSynchronization = null;
        super.connectionErrorOccurred(ce);
    }

    @Override
    public boolean isManagedConnectionFree() {
        if (this.isTrackByTx() && this.transactionSynchronization != null) {
            return false;
        }
        return super.isManagedConnectionFree();
    }

    boolean wasFreed(Object handle) {
        if (handle != null) {
            this.unregisterConnection(handle);
        } else {
            if (!this.isTrackByTx()) {
                return false;
            }
            this.setTrackByTx(false);
        }
        return this.isManagedConnectionFree();
    }

    @Override
    protected void toString(StringBuffer buffer) {
        buffer.append(" xaResource=").append(this.xaResource);
        buffer.append(" txSync=").append(this.transactionSynchronization);
    }

    final TransactionSynchronization getTransactionSynchronization() {
        return this.transactionSynchronization;
    }

    final void setTransactionSynchronization(TransactionSynchronization transactionSynchronization) {
        this.transactionSynchronization = transactionSynchronization;
    }

    static {
        String value = SecurityActions.getSystemProperty("ironjacamar.disable_enlistment_trace");
        if (value != null && !value.trim().equals("")) {
            try {
                int equal = value.indexOf("=");
                if (equal != -1) {
                    String setting = value.substring(equal + 1);
                    disableFailedtoEnlist = Boolean.valueOf(setting);
                } else {
                    disableFailedtoEnlist = true;
                }
            }
            catch (Throwable t) {
                throw new RuntimeException("Unable to parse ironjacamar.disable_enlistment_trace: " + value);
            }
        }
    }

    public class TransactionSynchronization
    implements Synchronization {
        private final Throwable failedToEnlist;
        protected final Transaction currentTx;
        private final boolean wasTrackByTx;
        private boolean enlisted;
        private Throwable enlistError;
        private boolean cancel;

        public TransactionSynchronization(Transaction tx, boolean trackByTx) {
            this.currentTx = tx;
            this.wasTrackByTx = trackByTx;
            this.enlisted = false;
            this.enlistError = null;
            this.cancel = false;
            this.failedToEnlist = !disableFailedtoEnlist ? new Throwable("Unabled to enlist resource, see the previous warnings.") : null;
            if (TxConnectionListener.this.trace) {
                log.tracef("%s: Constructor", this.toString());
            }
        }

        public void cancel() {
            this.cancel = true;
        }

        public void checkEnlisted() throws SystemException {
            if (this.enlistError != null) {
                String error = "Error enlisting resource in transaction=" + this.currentTx;
                if (TxConnectionListener.this.trace) {
                    log.trace(error + " " + TxConnectionListener.this);
                }
                if (!disableFailedtoEnlist && this.enlistError == this.failedToEnlist) {
                    SystemException se = new SystemException(bundle.systemExceptionWhenFailedToEnlistEqualsCurrentTx(this.failedToEnlist, this.currentTx));
                    if (Tracer.isEnabled()) {
                        Tracer.exception(TxConnectionListener.this.getPool() != null ? TxConnectionListener.this.getPool().getName() : null, TxConnectionListener.this.getManagedConnectionPool(), TxConnectionListener.this, (Throwable)se);
                    }
                    throw se;
                }
                SystemException e = new SystemException(error);
                e.initCause(this.enlistError);
                if (Tracer.isEnabled()) {
                    Tracer.exception(TxConnectionListener.this.getPool() != null ? TxConnectionListener.this.getPool().getName() : null, TxConnectionListener.this.getManagedConnectionPool(), TxConnectionListener.this, (Throwable)e);
                }
                throw e;
            }
            if (!this.enlisted) {
                String error = "Resource is not enlisted in transaction=" + this.currentTx;
                if (TxConnectionListener.this.trace) {
                    log.trace(error + " " + TxConnectionListener.this);
                }
                throw new IllegalStateException("Resource was not enlisted.");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean enlist() {
            block13: {
                if (TxConnectionListener.this.trace) {
                    log.trace("Enlisting resource " + TxConnectionListener.this);
                }
                try {
                    XAResource resource = TxConnectionListener.this.getXAResource();
                    if (!this.currentTx.enlistResource(resource)) {
                        if (Tracer.isEnabled()) {
                            Tracer.enlistConnectionListener(TxConnectionListener.this.getPool() != null ? TxConnectionListener.this.getPool().getName() : null, TxConnectionListener.this.getManagedConnectionPool(), TxConnectionListener.this, false, !TxConnectionListener.this.isTrackByTx());
                        }
                        this.enlistError = !disableFailedtoEnlist ? this.failedToEnlist : new Throwable("Failed to enlist");
                    } else if (Tracer.isEnabled()) {
                        Tracer.enlistConnectionListener(TxConnectionListener.this.getPool() != null ? TxConnectionListener.this.getPool().getName() : null, TxConnectionListener.this.getManagedConnectionPool(), TxConnectionListener.this, true, !TxConnectionListener.this.isTrackByTx());
                    }
                }
                catch (Throwable t) {
                    this.enlistError = t;
                    if (!Tracer.isEnabled()) break block13;
                    Tracer.enlistConnectionListener(TxConnectionListener.this.getPool() != null ? TxConnectionListener.this.getPool().getName() : null, TxConnectionListener.this.getManagedConnectionPool(), TxConnectionListener.this, false, !TxConnectionListener.this.isTrackByTx());
                }
            }
            TransactionSynchronization transactionSynchronization = this;
            synchronized (transactionSynchronization) {
                if (this.enlistError != null) {
                    if (TxConnectionListener.this.trace) {
                        log.trace("Failed to enlist resource " + TxConnectionListener.this, this.enlistError);
                    }
                    TxConnectionListener.this.setTrackByTx(false);
                    TxConnectionListener.this.transactionSynchronization = null;
                    return false;
                }
                this.enlisted = true;
                if (TxConnectionListener.this.trace) {
                    log.trace("Enlisted resource " + TxConnectionListener.this);
                }
                return true;
            }
        }

        public void beforeCompletion() {
            if (this.enlisted && !this.cancel) {
                try {
                    if (this.equals(TxConnectionListener.this.transactionSynchronization) && this.wasTrackByTx && TxConnectionListener.this.doDelistResource) {
                        if (TxUtils.isUncommitted((Transaction)this.currentTx)) {
                            if (TxUtils.isActive((Transaction)this.currentTx)) {
                                if (TxConnectionListener.this.trace) {
                                    log.tracef("delistResource(%s, TMSUCCESS)", TxConnectionListener.this.getXAResource());
                                }
                                this.currentTx.delistResource(TxConnectionListener.this.getXAResource(), 0x4000000);
                                if (Tracer.isEnabled()) {
                                    Tracer.delistConnectionListener(TxConnectionListener.this.getPool() != null ? TxConnectionListener.this.getPool().getName() : null, TxConnectionListener.this.getManagedConnectionPool(), TxConnectionListener.this, true, false, false);
                                }
                            } else {
                                if (TxConnectionListener.this.trace) {
                                    log.tracef("delistResource(%s, TMFAIL)", TxConnectionListener.this.getXAResource());
                                }
                                this.currentTx.delistResource(TxConnectionListener.this.getXAResource(), 0x20000000);
                                if (Tracer.isEnabled()) {
                                    Tracer.delistConnectionListener(TxConnectionListener.this.getPool() != null ? TxConnectionListener.this.getPool().getName() : null, TxConnectionListener.this.getManagedConnectionPool(), TxConnectionListener.this, false, false, false);
                                }
                            }
                        } else if (TxConnectionListener.this.trace) {
                            log.tracef("Non-uncommitted transaction for %s (%s)", TxConnectionListener.this, this.currentTx != null ? TxUtils.getStatusAsString((int)this.currentTx.getStatus()) : "None");
                        }
                    } else if (TxConnectionListener.this.trace && this.wasTrackByTx) {
                        log.tracef("No delistResource for: %s", TxConnectionListener.this);
                    }
                }
                catch (Throwable t) {
                    log.beforeCompletionErrorOccured(TxConnectionListener.this, t);
                }
            } else if (TxConnectionListener.this.trace) {
                log.tracef("Unenlisted resource: %s", TxConnectionListener.this);
            }
        }

        public void afterCompletion(int status) {
            if (TxConnectionListener.this.getState().equals((Object)ConnectionState.DESTROYED)) {
                return;
            }
            if (!this.cancel) {
                if (!this.equals(TxConnectionListener.this.transactionSynchronization)) {
                    if (!this.wasTrackByTx) {
                        TxConnectionListener.this.setEnlisted(false);
                        return;
                    }
                    String message = "afterCompletion called with wrong tx! Expected: " + this + ", actual: " + TxConnectionListener.this.transactionSynchronization;
                    IllegalStateException e = new IllegalStateException(message);
                    log.somethingWrongWithPooling(e);
                }
                TxConnectionListener.this.setEnlisted(false);
                TxConnectionListener.this.transactionSynchronization = null;
                if (this.wasTrackByTx) {
                    if (TxConnectionListener.this.trace) {
                        log.trace("afterCompletion(" + status + ") isTrackByTx=" + TxConnectionListener.this.isTrackByTx() + " for " + TxConnectionListener.this);
                    }
                    if (TxConnectionListener.this.wasFreed(null)) {
                        if (Tracer.isEnabled() && status == 4) {
                            Tracer.delistConnectionListener(TxConnectionListener.this.getPool() != null ? TxConnectionListener.this.getPool().getName() : null, TxConnectionListener.this.getManagedConnectionPool(), TxConnectionListener.this, true, true, false);
                        }
                        TxConnectionListener.this.getConnectionManager().returnManagedConnection(TxConnectionListener.this, false);
                    } else if (TxConnectionListener.this.tracking == null || TxConnectionListener.this.tracking.booleanValue()) {
                        log.activeHandles(TxConnectionListener.this.getPool() != null ? TxConnectionListener.this.getPool().getName() : "Unknown", TxConnectionListener.this.connectionHandles.size());
                        if (TxConnectionListener.this.tracking != null && TxConnectionListener.this.tracking.booleanValue()) {
                            for (Map.Entry entry : TxConnectionListener.this.connectionTraces.entrySet()) {
                                log.activeHandle(entry.getKey(), (Exception)entry.getValue());
                            }
                            log.txConnectionListenerBoundary(new Exception());
                        }
                        if (Tracer.isEnabled()) {
                            for (Object c : TxConnectionListener.this.connectionHandles) {
                                Tracer.clearConnection(TxConnectionListener.this.getPool() != null ? TxConnectionListener.this.getPool().getName() : null, TxConnectionListener.this.getManagedConnectionPool(), TxConnectionListener.this, c);
                            }
                        }
                        TxConnectionListener.this.getConnectionManager().returnManagedConnection(TxConnectionListener.this, true);
                    } else if (TxConnectionListener.this.trace) {
                        log.tracef(new Exception("Connection across boundary"), "ConnectionListener=%s", TxConnectionListener.this);
                    }
                }
            }
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("TransactionSynchronization@").append(System.identityHashCode(this));
            buffer.append("{tx=").append(this.currentTx);
            buffer.append(" wasTrackByTx=").append(this.wasTrackByTx);
            buffer.append(" enlisted=").append(this.enlisted);
            buffer.append(" cancel=").append(this.cancel);
            buffer.append("}");
            return buffer.toString();
        }
    }
}

