/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.connectionmanager.pool.capacity;

import java.util.Map;
import org.jboss.jca.common.api.metadata.common.Capacity;
import org.jboss.jca.core.CoreLogger;
import org.jboss.jca.core.connectionmanager.pool.api.CapacityDecrementer;
import org.jboss.jca.core.connectionmanager.pool.api.CapacityIncrementer;
import org.jboss.jca.core.connectionmanager.pool.capacity.DefaultCapacity;
import org.jboss.jca.core.connectionmanager.pool.capacity.ExplicitCapacity;
import org.jboss.jca.core.connectionmanager.pool.capacity.MinPoolSizeDecrementer;
import org.jboss.jca.core.connectionmanager.pool.capacity.SecurityActions;
import org.jboss.jca.core.connectionmanager.pool.capacity.SizeDecrementer;
import org.jboss.jca.core.connectionmanager.pool.capacity.TimedOutDecrementer;
import org.jboss.jca.core.util.Injection;
import org.jboss.logging.Logger;

public class CapacityFactory {
    private static CoreLogger log = (CoreLogger)Logger.getMessageLogger(CoreLogger.class, (String)CapacityFactory.class.getName());

    private CapacityFactory() {
    }

    public static org.jboss.jca.core.connectionmanager.pool.api.Capacity create(Capacity metadata, boolean isCRI) {
        Map properties;
        Injection injector;
        if (metadata == null) {
            return DefaultCapacity.INSTANCE;
        }
        CapacityIncrementer incrementer = null;
        CapacityDecrementer decrementer = null;
        if (metadata.getIncrementer() != null && metadata.getIncrementer().getClassName() != null) {
            incrementer = CapacityFactory.loadIncrementer(metadata.getIncrementer().getClassName());
            if (incrementer != null) {
                if (metadata.getIncrementer().getConfigPropertiesMap().size() > 0) {
                    injector = new Injection();
                    properties = metadata.getIncrementer().getConfigPropertiesMap();
                    for (Map.Entry property : properties.entrySet()) {
                        try {
                            injector.inject(incrementer, (String)property.getKey(), property.getValue());
                        }
                        catch (Throwable t) {
                            log.invalidCapacityOption((String)property.getKey(), (String)property.getValue(), incrementer.getClass().getName());
                        }
                    }
                }
            } else {
                log.invalidCapacityIncrementer(metadata.getIncrementer().getClassName());
            }
        }
        if (incrementer == null) {
            incrementer = DefaultCapacity.DEFAULT_INCREMENTER;
        }
        if (metadata.getDecrementer() != null && metadata.getDecrementer().getClassName() != null) {
            if (!isCRI) {
                decrementer = CapacityFactory.loadDecrementer(metadata.getDecrementer().getClassName());
                if (decrementer != null) {
                    if (metadata.getDecrementer().getConfigPropertiesMap().size() > 0) {
                        injector = new Injection();
                        properties = metadata.getDecrementer().getConfigPropertiesMap();
                        for (Map.Entry property : properties.entrySet()) {
                            try {
                                injector.inject(decrementer, (String)property.getKey(), property.getValue());
                            }
                            catch (Throwable t) {
                                log.invalidCapacityOption((String)property.getKey(), (String)property.getValue(), decrementer.getClass().getName());
                            }
                        }
                    }
                } else {
                    log.invalidCapacityDecrementer(metadata.getDecrementer().getClassName());
                }
            } else if (TimedOutDecrementer.class.getName().equals(metadata.getDecrementer().getClassName()) || MinPoolSizeDecrementer.class.getName().equals(metadata.getDecrementer().getClassName()) || SizeDecrementer.class.getName().equals(metadata.getDecrementer().getClassName())) {
                decrementer = CapacityFactory.loadDecrementer(metadata.getDecrementer().getClassName());
            } else {
                log.invalidCapacityDecrementer(metadata.getDecrementer().getClassName());
            }
        }
        if (decrementer == null) {
            decrementer = DefaultCapacity.DEFAULT_DECREMENTER;
        }
        return new ExplicitCapacity(incrementer, decrementer);
    }

    private static CapacityIncrementer loadIncrementer(String clz) {
        Object result = CapacityFactory.loadClass(clz);
        if (result != null && result instanceof CapacityIncrementer) {
            return (CapacityIncrementer)result;
        }
        log.debugf("%s wasn't a CapacityIncrementer", clz);
        return null;
    }

    private static CapacityDecrementer loadDecrementer(String clz) {
        Object result = CapacityFactory.loadClass(clz);
        if (result != null && result instanceof CapacityDecrementer) {
            return (CapacityDecrementer)result;
        }
        log.debugf("%s wasn't a CapacityDecrementer", clz);
        return null;
    }

    private static Object loadClass(String clz) {
        try {
            Class<?> c = Class.forName(clz, true, SecurityActions.getClassLoader(CapacityFactory.class));
            return c.newInstance();
        }
        catch (Throwable t) {
            log.tracef("Throwable while loading %s using own classloader: %s", clz, t.getMessage());
            try {
                Class<?> c = Class.forName(clz, true, SecurityActions.getThreadContextClassLoader());
                return c.newInstance();
            }
            catch (Throwable t2) {
                log.tracef("Throwable while loading %s using TCCL: %s", clz, t2.getMessage());
                return null;
            }
        }
    }
}

