/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld;

import com.google.common.collect.ImmutableSet;
import java.lang.annotation.Annotation;
import java.util.Iterator;
import java.util.Set;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.CDI;
import javax.enterprise.inject.spi.Unmanaged;
import javax.enterprise.util.TypeLiteral;
import org.jboss.weld.bean.builtin.BeanManagerProxy;
import org.jboss.weld.logging.BeanManagerLogger;
import org.jboss.weld.util.reflection.Reflections;

public abstract class AbstractCDI<T>
extends CDI<T> {
    protected final Set<String> knownClassNames;

    public AbstractCDI() {
        ImmutableSet.Builder names = ImmutableSet.builder();
        for (Class<?> clazz = ((Object)((Object)this)).getClass(); clazz != CDI.class; clazz = clazz.getSuperclass()) {
            names.add((Object)clazz.getName());
        }
        names.add((Object)Unmanaged.class.getName());
        this.knownClassNames = names.build();
    }

    public Iterator<T> iterator() {
        return this.getInstance().iterator();
    }

    public T get() {
        return (T)this.getInstance().get();
    }

    public Instance<T> select(Annotation ... qualifiers) {
        return this.getInstance().select(qualifiers);
    }

    public <U extends T> Instance<U> select(Class<U> subtype, Annotation ... qualifiers) {
        return this.getInstance().select(subtype, qualifiers);
    }

    public <U extends T> Instance<U> select(TypeLiteral<U> subtype, Annotation ... qualifiers) {
        return this.getInstance().select(subtype, qualifiers);
    }

    public boolean isUnsatisfied() {
        return this.getInstance().isUnsatisfied();
    }

    public boolean isAmbiguous() {
        return this.getInstance().isAmbiguous();
    }

    public void destroy(T instance) {
        this.getInstance().destroy(instance);
    }

    protected String getCallingClassName() {
        boolean outerSubclassReached = false;
        for (StackTraceElement element : Thread.currentThread().getStackTrace()) {
            if (!this.knownClassNames.contains(element.getClassName())) {
                if (!outerSubclassReached) continue;
                return element.getClassName();
            }
            outerSubclassReached = true;
        }
        throw BeanManagerLogger.LOG.unableToIdentifyBeanManager();
    }

    private Instance<T> getInstance() {
        return (Instance)Reflections.cast(BeanManagerProxy.unwrap(this.getBeanManager()).instance());
    }
}

