/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.iiop.openjdk;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.operations.validation.EnumValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.metadata.ejb.jboss.IORTransportConfigMetaData;
import org.wildfly.iiop.openjdk.AttributeConstants;
import org.wildfly.iiop.openjdk.IIOPExtension;

class IORTransportConfigDefinition
extends PersistentResourceDefinition {
    static final ParameterValidator VALIDATOR = new EnumValidator(IORTransportConfigValues.class, true, true);
    static final ModelNode DEFAULT_VALUE = new ModelNode(IORTransportConfigValues.NONE.toString());
    static final AttributeDefinition INTEGRITY = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("integrity", ModelType.STRING, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setDefaultValue(DEFAULT_VALUE)).setValidator(VALIDATOR)).setAllowExpression(true)).build();
    static final AttributeDefinition CONFIDENTIALITY = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("confidentiality", ModelType.STRING, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setDefaultValue(DEFAULT_VALUE)).setValidator(VALIDATOR)).setAllowExpression(true)).build();
    static final AttributeDefinition TRUST_IN_TARGET = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("trust-in-target", ModelType.STRING, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setDefaultValue(DEFAULT_VALUE)).setValidator((ParameterValidator)new EnumValidator(IORTransportConfigValues.class, true, true, (Enum[])new IORTransportConfigValues[]{IORTransportConfigValues.NONE, IORTransportConfigValues.SUPPORTED}))).setAllowExpression(true)).build();
    static final AttributeDefinition TRUST_IN_CLIENT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("trust-in-client", ModelType.STRING, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setDefaultValue(DEFAULT_VALUE)).setValidator(VALIDATOR)).setAllowExpression(true)).build();
    static final AttributeDefinition DETECT_REPLAY = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("detect-replay", ModelType.STRING, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setDefaultValue(DEFAULT_VALUE)).setValidator(VALIDATOR)).setAllowExpression(true)).build();
    static final AttributeDefinition DETECT_MISORDERING = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("detect-misordering", ModelType.STRING, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setDefaultValue(DEFAULT_VALUE)).setValidator(VALIDATOR)).setAllowExpression(true)).build();
    static final Collection<AttributeDefinition> ATTRIBUTES = Arrays.asList(INTEGRITY, CONFIDENTIALITY, TRUST_IN_TARGET, TRUST_IN_CLIENT, DETECT_REPLAY, DETECT_MISORDERING);
    static final IORTransportConfigDefinition INSTANCE = new IORTransportConfigDefinition();

    private IORTransportConfigDefinition() {
        super(IIOPExtension.PATH_IOR_TRANSPORT, IIOPExtension.getResourceDescriptionResolver("ior-settings", "transport-config"), (OperationStepHandler)new AbstractAddStepHandler(ATTRIBUTES), (OperationStepHandler)ReloadRequiredRemoveStepHandler.INSTANCE);
    }

    public List<AccessConstraintDefinition> getAccessConstraints() {
        return Collections.singletonList(AttributeConstants.IIOP_SECURITY_DEF);
    }

    public Collection<AttributeDefinition> getAttributes() {
        return ATTRIBUTES;
    }

    protected IORTransportConfigMetaData getTransportConfigMetaData(OperationContext context, ModelNode model) throws OperationFailedException {
        if (!model.isDefined()) {
            return null;
        }
        IORTransportConfigMetaData metaData = new IORTransportConfigMetaData();
        metaData.setIntegrity(INTEGRITY.resolveModelAttribute(context, model).asString());
        metaData.setConfidentiality(CONFIDENTIALITY.resolveModelAttribute(context, model).asString());
        metaData.setEstablishTrustInTarget(TRUST_IN_TARGET.resolveModelAttribute(context, model).asString());
        metaData.setEstablishTrustInClient(TRUST_IN_CLIENT.resolveModelAttribute(context, model).asString());
        metaData.setDetectMisordering(DETECT_MISORDERING.resolveModelAttribute(context, model).asString());
        metaData.setDetectReplay(DETECT_REPLAY.resolveModelAttribute(context, model).asString());
        return metaData;
    }

    private static enum IORTransportConfigValues {
        NONE("none"),
        SUPPORTED("supported"),
        REQUIRED("required");

        private String name;

        private IORTransportConfigValues(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

