/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.deployment;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.configuration.Configurer;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.interceptor.InterceptorProvider;
import org.apache.cxf.jaxws.support.JaxWsImplementorInfo;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.jboss.ws.common.configuration.ConfigHelper;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.metadata.config.CommonConfig;
import org.jboss.wsf.spi.metadata.config.SOAPAddressRewriteMetadata;
import org.jboss.wsf.stack.cxf.Loggers;
import org.jboss.wsf.stack.cxf.addressRewrite.SoapAddressRewriteHelper;
import org.jboss.wsf.stack.cxf.client.configuration.InterceptorUtils;
import org.jboss.wsf.stack.cxf.deployment.WSDLFilePublisher;

public class EndpointImpl
extends org.apache.cxf.jaxws22.EndpointImpl {
    private WSDLFilePublisher wsdlPublisher;
    private CommonConfig config;
    private SOAPAddressRewriteMetadata sarm;

    public EndpointImpl(Object implementor) {
        super(implementor);
    }

    public EndpointImpl(Bus bus, Object implementor) {
        super(bus, implementor);
    }

    protected void doPublish(String addr) {
        super.getServerFactory().setBlockPostConstruct(true);
        super.doPublish(addr);
        this.configureObject((Object)this);
        this.setupConfigHandlers();
        this.publishContractToFilesystem();
    }

    public void setEndpointConfig(CommonConfig config) {
        if (this.config == null) {
            this.config = config;
            Map epConfProps = config.getProperties();
            if (!epConfProps.isEmpty()) {
                Map propMap = this.getProperties();
                if (propMap == null) {
                    this.setProperties(new HashMap(epConfProps));
                } else {
                    propMap.putAll(epConfProps);
                }
                InterceptorUtils.addInterceptors((InterceptorProvider)this, (Map)epConfProps);
            }
        }
    }

    protected void setupConfigHandlers() {
        if (this.config != null) {
            ConfigHelper helper = new ConfigHelper();
            helper.setupConfigHandlers(this.getBinding(), this.config);
        }
    }

    protected void publishContractToFilesystem() {
        if (this.wsdlPublisher != null) {
            Endpoint endpoint = this.getServer().getEndpoint();
            Service service = endpoint.getService();
            try {
                String wsdlLocation = this.getWsdlLocation();
                if (wsdlLocation == null) {
                    JaxWsImplementorInfo info = new JaxWsImplementorInfo(this.getImplementorClass());
                    wsdlLocation = info.getWsdlLocation();
                }
                this.updateSoapAddress();
                this.wsdlPublisher.publishWsdlFiles(service.getName(), wsdlLocation, this.getBus(), service.getServiceInfos());
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        } else {
            Loggers.DEPLOYMENT_LOGGER.unableToPublishContractDueToMissingPublisher(this.getImplementorClass());
        }
    }

    private void configureObject(Object instance) {
        Configurer configurer = (Configurer)this.getBus().getExtension(Configurer.class);
        if (null != configurer) {
            configurer.configureBean(instance);
        }
    }

    public String getBeanName() {
        QName endpointName = this.getEndpointName();
        if (endpointName == null) {
            JaxWsImplementorInfo implInfo = new JaxWsImplementorInfo(this.getImplementorClass());
            endpointName = implInfo.getEndpointName();
        }
        return endpointName.toString() + ".jaxws-endpoint";
    }

    public WSDLFilePublisher getWsdlPublisher() {
        return this.wsdlPublisher;
    }

    public void setWsdlPublisher(WSDLFilePublisher wsdlPublisher) {
        this.wsdlPublisher = wsdlPublisher;
    }

    public void setSOAPAddressRewriteMetadata(SOAPAddressRewriteMetadata sarm) {
        this.sarm = sarm;
    }

    private SOAPAddressRewriteMetadata getSOAPAddressRewriteMetadata() {
        if (this.sarm == null) {
            Deployment dep = (Deployment)this.getBus().getProperty(Deployment.class.getName());
            this.sarm = (SOAPAddressRewriteMetadata)dep.getAttachment(SOAPAddressRewriteMetadata.class);
        }
        return this.sarm;
    }

    private void updateSoapAddress() {
        SOAPAddressRewriteMetadata metadata = this.getSOAPAddressRewriteMetadata();
        if (metadata.isModifySOAPAddress()) {
            List sevInfos = this.getServer().getEndpoint().getService().getServiceInfos();
            for (ServiceInfo si : sevInfos) {
                Collection epInfos = si.getEndpoints();
                for (EndpointInfo ei : epInfos) {
                    String publishedEndpointUrl = (String)ei.getProperty("publishedEndpointUrl");
                    if (publishedEndpointUrl != null) {
                        ei.setAddress(publishedEndpointUrl);
                        continue;
                    }
                    if (!ei.getAddress().contains("jbossws.undefined.host")) continue;
                    String epurl = SoapAddressRewriteHelper.getRewrittenPublishedEndpointUrl(ei.getAddress(), metadata);
                    ei.setAddress(epurl);
                }
            }
        }
    }
}

