/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.discovery;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public class DiscoveryOptionsResource
implements Resource {
    private final Resource delegate;

    public DiscoveryOptionsResource() {
        this(Resource.Factory.create());
    }

    DiscoveryOptionsResource(Resource delegate) {
        assert (delegate != null) : "delegate is null";
        this.delegate = delegate;
    }

    public ModelNode getModel() {
        return this.delegate.getModel();
    }

    public void writeModel(ModelNode newModel) {
        this.delegate.writeModel(newModel);
    }

    public boolean isModelDefined() {
        return this.delegate.isModelDefined();
    }

    public boolean hasChild(PathElement element) {
        return this.hasOption(element.getKey(), element.getValue());
    }

    public Resource getChild(PathElement element) {
        return this.getOption(element.getKey(), element.getValue());
    }

    public Resource requireChild(PathElement element) {
        Resource option = this.getOption(element.getKey(), element.getValue());
        if (option == null) {
            throw new Resource.NoSuchResourceException(element);
        }
        return option;
    }

    public boolean hasChildren(String childType) {
        return this.hasOption(childType);
    }

    public Resource navigate(PathAddress address) {
        return Resource.Tools.navigate((Resource)this, (PathAddress)address);
    }

    public Set<String> getChildTypes() {
        return this.getOptionTypes();
    }

    public Set<String> getChildrenNames(String childType) {
        return this.getOptionTypeNames(childType);
    }

    public Set<Resource.ResourceEntry> getChildren(String childType) {
        return this.getOptions(childType);
    }

    public void registerChild(PathElement address, Resource resource) {
    }

    public Resource removeChild(PathElement address) {
        return this.removeOption(address.getKey(), address.getValue());
    }

    public boolean isRuntime() {
        return this.delegate.isRuntime();
    }

    public boolean isProxy() {
        return this.delegate.isProxy();
    }

    public Resource clone() {
        return new DiscoveryOptionsResource(this.delegate.clone());
    }

    protected Set<String> getOptionTypes() {
        ModelNode options = this.delegate.getModel().get("options");
        if (!options.isDefined()) {
            return Collections.emptySet();
        }
        List list = options.asPropertyList();
        if (list.isEmpty()) {
            return Collections.emptySet();
        }
        LinkedHashSet<String> types = new LinkedHashSet<String>(2);
        for (Property prop : list) {
            if ("custom-discovery".equals(prop.getName())) {
                types.add("discovery-option");
                continue;
            }
            types.add(prop.getName());
        }
        return types;
    }

    protected Set<String> getOptionTypeNames(String type) {
        ModelNode options = this.delegate.getModel().get("options");
        if (!options.isDefined()) {
            return Collections.emptySet();
        }
        List list = options.asPropertyList();
        if (list.isEmpty()) {
            return Collections.emptySet();
        }
        boolean staticOption = "static-discovery".equals(type);
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        for (Property prop : list) {
            if (staticOption) {
                if (!prop.getName().equals("static-discovery")) continue;
                names.add(prop.getValue().get("name").asString());
                continue;
            }
            if (!prop.getName().equals("custom-discovery")) continue;
            names.add(prop.getValue().get("name").asString());
        }
        return names;
    }

    protected Set<Resource.ResourceEntry> getOptions(String type) {
        ModelNode options = this.delegate.getModel().get("options");
        if (!options.isDefined()) {
            return Collections.emptySet();
        }
        List list = options.asPropertyList();
        if (list.isEmpty()) {
            return Collections.emptySet();
        }
        boolean staticOption = "static-discovery".equals(type);
        LinkedHashSet<Resource.ResourceEntry> names = new LinkedHashSet<Resource.ResourceEntry>();
        for (Property prop : list) {
            String name;
            Resource res;
            if (staticOption) {
                if (!prop.getName().equals("static-discovery")) continue;
                res = this.getResource(prop);
                name = prop.getValue().get("name").asString();
                names.add(DiscoveryOptionsResource.entryFor(name, PathElement.pathElement((String)type, (String)name), res));
                continue;
            }
            if (!prop.getName().equals("custom-discovery")) continue;
            res = this.getResource(prop);
            name = prop.getValue().get("name").asString();
            names.add(DiscoveryOptionsResource.entryFor(name, PathElement.pathElement((String)"discovery-option", (String)name), res));
        }
        return names;
    }

    protected boolean hasOption(String type) {
        ModelNode options = this.delegate.getModel().get("options");
        if (!options.isDefined()) {
            return false;
        }
        boolean staticOption = "static-discovery".equals(type);
        for (Property prop : options.asPropertyList()) {
            if (!(staticOption ? prop.getName().equals("static-discovery") : prop.getName().equals("custom-discovery"))) continue;
            return true;
        }
        return false;
    }

    protected boolean hasOption(String type, String name) {
        ModelNode options = this.delegate.getModel().get("options");
        if (!options.isDefined()) {
            return false;
        }
        boolean staticOption = "static-discovery".equals(type);
        for (Property prop : options.asPropertyList()) {
            if (!(staticOption ? prop.getName().equals("static-discovery") && prop.getValue().has("name") && prop.getValue().get("name").asString().equals(name) : prop.getName().equals("custom-discovery") && prop.getValue().has("name") && prop.getValue().get("name").asString().equals(name))) continue;
            return true;
        }
        return false;
    }

    protected Resource getOption(String type, String name) {
        ModelNode options = this.delegate.getModel().get("options");
        if (!options.isDefined()) {
            return null;
        }
        boolean staticOption = "static-discovery".equals(type);
        for (Property prop : options.asPropertyList()) {
            if (!(staticOption ? prop.getName().equals("static-discovery") && prop.getValue().has("name") && prop.getValue().get("name").asString().equals(name) : prop.getName().equals("custom-discovery") && prop.getValue().has("name") && prop.getValue().get("name").asString().equals(name))) continue;
            return this.getResource(prop);
        }
        return null;
    }

    protected Resource removeOption(String type, String name) {
        ModelNode options = this.delegate.getModel().get("options");
        if (!options.isDefined()) {
            return null;
        }
        List list = options.asPropertyList();
        if (list.isEmpty()) {
            return null;
        }
        boolean staticOption = "static-discovery".equals(type);
        Resource res = null;
        int i = 0;
        while (i < list.size() && res == null) {
            Property prop = (Property)list.get(i++);
            if (staticOption) {
                if (!prop.getName().equals("static-discovery") || !prop.getValue().has("name") || !prop.getValue().get("name").asString().equals(name)) continue;
                res = this.getResource(prop);
                continue;
            }
            if (!prop.getName().equals("custom-discovery") || !prop.getValue().has("name") || !prop.getValue().get("name").asString().equals(name)) continue;
            res = this.getResource(prop);
        }
        if (res != null) {
            options.remove(i - 1);
        }
        return res;
    }

    private Resource getResource(Property prop) {
        Resource res = Resource.Factory.create((boolean)true);
        for (Property attr : prop.getValue().asPropertyList()) {
            if (attr.getName().equals("name")) continue;
            res.getModel().get(attr.getName()).set(attr.getValue());
        }
        return res;
    }

    static Resource.ResourceEntry entryFor(final String name, final PathElement pathElement, final Resource resource) {
        return new Resource.ResourceEntry(){

            public ModelNode getModel() {
                return resource.getModel();
            }

            public void writeModel(ModelNode newModel) {
                resource.writeModel(newModel);
            }

            public boolean isModelDefined() {
                return resource.isModelDefined();
            }

            public boolean hasChild(PathElement element) {
                return resource.hasChild(element);
            }

            public Resource getChild(PathElement element) {
                return resource.getChild(element);
            }

            public Resource requireChild(PathElement element) {
                return resource.requireChild(element);
            }

            public boolean hasChildren(String childType) {
                return resource.hasChildren(childType);
            }

            public Resource navigate(PathAddress address) {
                return resource.navigate(address);
            }

            public Set<String> getChildTypes() {
                return resource.getChildTypes();
            }

            public Set<String> getChildrenNames(String childType) {
                return resource.getChildrenNames(childType);
            }

            public Set<Resource.ResourceEntry> getChildren(String childType) {
                return resource.getChildren(childType);
            }

            public void registerChild(PathElement address, Resource resource2) {
                resource2.registerChild(address, resource2);
            }

            public Resource removeChild(PathElement address) {
                return resource.removeChild(address);
            }

            public boolean isRuntime() {
                return resource.isRuntime();
            }

            public boolean isProxy() {
                return resource.isProxy();
            }

            public Resource clone() {
                return DiscoveryOptionsResource.entryFor(name, pathElement, resource.clone());
            }

            public String getName() {
                return name;
            }

            public PathElement getPathElement() {
                return pathElement;
            }
        };
    }
}

