/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.repository;

import java.util.Collection;
import java.util.Date;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.batch.runtime.BatchStatus;
import javax.batch.runtime.JobExecution;
import javax.batch.runtime.context.JobContext;
import javax.batch.runtime.context.StepContext;
import org.jberet.repository.JobExecutionSelector;

public final class DefaultJobExecutionSelector
implements JobExecutionSelector {
    private JobContext jobContext;
    private StepContext stepContext;
    Boolean excludeRunningJobExecutions = Boolean.TRUE;
    Set<Long> jobExecutionIds;
    Integer numberOfRecentJobExecutionsToExclude;
    Long jobExecutionIdFrom;
    Long jobExecutionIdTo;
    Integer withinPastMinutes;
    Date jobExecutionEndTimeFrom;
    Date jobExecutionEndTimeTo;
    Set<String> batchStatuses;
    Set<String> exitStatuses;
    Set<String> jobExecutionsByJobNames;

    public DefaultJobExecutionSelector(Boolean excludeRunningJobExecutions) {
        if (excludeRunningJobExecutions == Boolean.FALSE) {
            this.excludeRunningJobExecutions = Boolean.FALSE;
        }
    }

    @Override
    public boolean select(JobExecution jobExecution, Collection<JobExecution> allJobExecutions) {
        BatchStatus batchStatus;
        if (this.excludeRunningJobExecutions.booleanValue() && (batchStatus = jobExecution.getBatchStatus()) != BatchStatus.COMPLETED && batchStatus != BatchStatus.FAILED && batchStatus != BatchStatus.STOPPED && batchStatus != BatchStatus.ABANDONED) {
            return false;
        }
        long id = jobExecution.getExecutionId();
        if (this.jobExecutionIds != null && !this.jobExecutionIds.isEmpty()) {
            return this.jobExecutionIds.contains(id);
        }
        if (this.numberOfRecentJobExecutionsToExclude != null) {
            int numOfLargerIds = 0;
            for (JobExecution je : allJobExecutions) {
                if (je.getExecutionId() <= id || ++numOfLargerIds < this.numberOfRecentJobExecutionsToExclude) continue;
                return true;
            }
            if (numOfLargerIds < this.numberOfRecentJobExecutionsToExclude) {
                return false;
            }
        }
        if (this.jobExecutionIdFrom != null) {
            if (this.jobExecutionIdTo != null) {
                return id >= this.jobExecutionIdFrom && id <= this.jobExecutionIdTo;
            }
            return id >= this.jobExecutionIdFrom;
        }
        if (this.jobExecutionIdTo != null) {
            return id <= this.jobExecutionIdTo;
        }
        Date endTime = jobExecution.getEndTime();
        if (this.withinPastMinutes != null) {
            long diffMillis = System.currentTimeMillis() - endTime.getTime();
            long diffMinutes = TimeUnit.MILLISECONDS.toMinutes(diffMillis);
            return diffMinutes <= (long)this.withinPastMinutes.intValue();
        }
        if (this.jobExecutionEndTimeFrom != null) {
            if (this.jobExecutionEndTimeTo != null) {
                return !(!endTime.after(this.jobExecutionEndTimeFrom) && !endTime.equals(this.jobExecutionEndTimeFrom) || !endTime.before(this.jobExecutionEndTimeTo) && !endTime.equals(this.jobExecutionEndTimeTo));
            }
            return endTime.after(this.jobExecutionEndTimeFrom) || endTime.equals(this.jobExecutionEndTimeFrom);
        }
        if (this.jobExecutionEndTimeTo != null) {
            return endTime.before(this.jobExecutionEndTimeTo) || endTime.equals(this.jobExecutionEndTimeTo);
        }
        if (this.batchStatuses != null) {
            return this.batchStatuses.contains(jobExecution.getBatchStatus().name());
        }
        if (this.exitStatuses != null) {
            return this.exitStatuses.contains(jobExecution.getExitStatus());
        }
        if (this.jobExecutionsByJobNames != null) {
            return this.jobExecutionsByJobNames.contains(jobExecution.getJobName());
        }
        return false;
    }

    @Override
    public JobContext getJobContext() {
        return this.jobContext;
    }

    @Override
    public void setJobContext(JobContext jobContext) {
        this.jobContext = jobContext;
    }

    @Override
    public StepContext getStepContext() {
        return this.stepContext;
    }

    @Override
    public void setStepContext(StepContext stepContext) {
        this.stepContext = stepContext;
    }
}

