/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.clustering.infinispan.subsystem.Attribute;
import org.jboss.as.clustering.infinispan.subsystem.BackupForResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.BackupSiteResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.BinaryKeyedJDBCStoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.CacheResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.CacheType;
import org.jboss.as.clustering.infinispan.subsystem.ClusteredCacheResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.CustomStoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.DistributedCacheResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.Element;
import org.jboss.as.clustering.infinispan.subsystem.EvictionResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.ExpirationResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.FileStoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanSchema;
import org.jboss.as.clustering.infinispan.subsystem.JDBCStoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.LockingResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.MixedKeyedJDBCStoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.RemoteStoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.StateTransferResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.StorePropertyResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.StoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.StoreWriteBehindResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.StringKeyedJDBCStoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.TransactionResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.TransportResourceDefinition;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class InfinispanSubsystemXMLWriter
implements XMLElementWriter<SubsystemMarshallingContext> {
    public static final XMLElementWriter<SubsystemMarshallingContext> INSTANCE = new InfinispanSubsystemXMLWriter();

    public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
        context.startSubsystemElement(InfinispanSchema.CURRENT.getNamespaceUri(), false);
        ModelNode model = context.getModelNode();
        if (model.isDefined() && model.hasDefined(CacheContainerResourceDefinition.WILDCARD_PATH.getKey())) {
            for (Property entry : model.get(CacheContainerResourceDefinition.WILDCARD_PATH.getKey()).asPropertyList()) {
                ModelNode cache;
                String containerName = entry.getName();
                ModelNode container = entry.getValue();
                writer.writeStartElement(Element.CACHE_CONTAINER.getLocalName());
                writer.writeAttribute(Attribute.NAME.getLocalName(), containerName);
                InfinispanSubsystemXMLWriter.writeAttribute(writer, container, (AttributeDefinition)CacheContainerResourceDefinition.DEFAULT_CACHE);
                InfinispanSubsystemXMLWriter.writeAttribute(writer, container, (AttributeDefinition)CacheContainerResourceDefinition.EVICTION_EXECUTOR);
                InfinispanSubsystemXMLWriter.writeAttribute(writer, container, (AttributeDefinition)CacheContainerResourceDefinition.JNDI_NAME);
                InfinispanSubsystemXMLWriter.writeAttribute(writer, container, (AttributeDefinition)CacheContainerResourceDefinition.LISTENER_EXECUTOR);
                InfinispanSubsystemXMLWriter.writeAttribute(writer, container, (AttributeDefinition)CacheContainerResourceDefinition.REPLICATION_QUEUE_EXECUTOR);
                InfinispanSubsystemXMLWriter.writeAttribute(writer, container, (AttributeDefinition)CacheContainerResourceDefinition.START);
                InfinispanSubsystemXMLWriter.writeAttribute(writer, container, (AttributeDefinition)CacheContainerResourceDefinition.MODULE);
                InfinispanSubsystemXMLWriter.writeAttribute(writer, container, (AttributeDefinition)CacheContainerResourceDefinition.STATISTICS_ENABLED);
                InfinispanSubsystemXMLWriter.writeAttribute(writer, container, (AttributeDefinition)CacheContainerResourceDefinition.ALIASES);
                if (container.hasDefined(TransportResourceDefinition.PATH.getKey())) {
                    writer.writeStartElement(Element.TRANSPORT.getLocalName());
                    ModelNode transport = container.get(TransportResourceDefinition.PATH.getKeyValuePair());
                    InfinispanSubsystemXMLWriter.writeAttribute(writer, transport, (AttributeDefinition)TransportResourceDefinition.CHANNEL);
                    InfinispanSubsystemXMLWriter.writeAttribute(writer, transport, (AttributeDefinition)TransportResourceDefinition.EXECUTOR);
                    InfinispanSubsystemXMLWriter.writeAttribute(writer, transport, (AttributeDefinition)TransportResourceDefinition.LOCK_TIMEOUT);
                    writer.writeEndElement();
                }
                if (container.hasDefined(CacheType.LOCAL.pathElement().getKey())) {
                    for (Property property : container.get(CacheType.LOCAL.pathElement().getKey()).asPropertyList()) {
                        cache = property.getValue();
                        writer.writeStartElement(Element.LOCAL_CACHE.getLocalName());
                        InfinispanSubsystemXMLWriter.writeCacheAttributes(writer, property.getName(), cache);
                        InfinispanSubsystemXMLWriter.writeCacheElements(writer, cache);
                        writer.writeEndElement();
                    }
                }
                if (container.hasDefined(CacheType.INVALIDATION.pathElement().getKey())) {
                    for (Property property : container.get(CacheType.INVALIDATION.pathElement().getKey()).asPropertyList()) {
                        cache = property.getValue();
                        writer.writeStartElement(Element.INVALIDATION_CACHE.getLocalName());
                        InfinispanSubsystemXMLWriter.writeClusteredCacheAttributes(writer, property.getName(), cache);
                        InfinispanSubsystemXMLWriter.writeCacheElements(writer, cache);
                        writer.writeEndElement();
                    }
                }
                if (container.hasDefined(CacheType.REPLICATED.pathElement().getKey())) {
                    for (Property property : container.get(CacheType.REPLICATED.pathElement().getKey()).asPropertyList()) {
                        cache = property.getValue();
                        writer.writeStartElement(Element.REPLICATED_CACHE.getLocalName());
                        InfinispanSubsystemXMLWriter.writeClusteredCacheAttributes(writer, property.getName(), cache);
                        InfinispanSubsystemXMLWriter.writeCacheElements(writer, cache);
                        writer.writeEndElement();
                    }
                }
                if (container.hasDefined(CacheType.DISTRIBUTED.pathElement().getKey())) {
                    for (Property property : container.get(CacheType.DISTRIBUTED.pathElement().getKey()).asPropertyList()) {
                        cache = property.getValue();
                        writer.writeStartElement(Element.DISTRIBUTED_CACHE.getLocalName());
                        InfinispanSubsystemXMLWriter.writeClusteredCacheAttributes(writer, property.getName(), cache);
                        InfinispanSubsystemXMLWriter.writeAttribute(writer, cache, (AttributeDefinition)DistributedCacheResourceDefinition.OWNERS);
                        InfinispanSubsystemXMLWriter.writeAttribute(writer, cache, (AttributeDefinition)DistributedCacheResourceDefinition.SEGMENTS);
                        InfinispanSubsystemXMLWriter.writeAttribute(writer, cache, (AttributeDefinition)DistributedCacheResourceDefinition.L1_LIFESPAN);
                        InfinispanSubsystemXMLWriter.writeAttribute(writer, cache, (AttributeDefinition)DistributedCacheResourceDefinition.CAPACITY_FACTOR);
                        InfinispanSubsystemXMLWriter.writeAttribute(writer, cache, (AttributeDefinition)DistributedCacheResourceDefinition.CONSISTENT_HASH_STRATEGY);
                        InfinispanSubsystemXMLWriter.writeCacheElements(writer, cache);
                        writer.writeEndElement();
                    }
                }
                writer.writeEndElement();
            }
        }
        writer.writeEndElement();
    }

    private static void writeCacheAttributes(XMLExtendedStreamWriter writer, String name, ModelNode cache) throws XMLStreamException {
        writer.writeAttribute(Attribute.NAME.getLocalName(), name);
        InfinispanSubsystemXMLWriter.writeAttribute(writer, cache, (AttributeDefinition)CacheResourceDefinition.START);
        InfinispanSubsystemXMLWriter.writeAttribute(writer, cache, (AttributeDefinition)CacheResourceDefinition.JNDI_NAME);
        InfinispanSubsystemXMLWriter.writeAttribute(writer, cache, (AttributeDefinition)CacheResourceDefinition.MODULE);
        InfinispanSubsystemXMLWriter.writeAttribute(writer, cache, (AttributeDefinition)CacheResourceDefinition.STATISTICS_ENABLED);
    }

    private static void writeClusteredCacheAttributes(XMLExtendedStreamWriter writer, String name, ModelNode cache) throws XMLStreamException {
        InfinispanSubsystemXMLWriter.writeCacheAttributes(writer, name, cache);
        InfinispanSubsystemXMLWriter.writeAttribute(writer, cache, (AttributeDefinition)ClusteredCacheResourceDefinition.ASYNC_MARSHALLING);
        InfinispanSubsystemXMLWriter.writeAttribute(writer, cache, (AttributeDefinition)ClusteredCacheResourceDefinition.MODE);
        InfinispanSubsystemXMLWriter.writeAttribute(writer, cache, (AttributeDefinition)ClusteredCacheResourceDefinition.QUEUE_SIZE);
        InfinispanSubsystemXMLWriter.writeAttribute(writer, cache, (AttributeDefinition)ClusteredCacheResourceDefinition.QUEUE_FLUSH_INTERVAL);
        InfinispanSubsystemXMLWriter.writeAttribute(writer, cache, (AttributeDefinition)ClusteredCacheResourceDefinition.REMOTE_TIMEOUT);
    }

    private static void writeCacheElements(XMLExtendedStreamWriter writer, ModelNode cache) throws XMLStreamException {
        ModelNode store;
        if (cache.hasDefined(LockingResourceDefinition.PATH.getKey())) {
            writer.writeStartElement(Element.LOCKING.getLocalName());
            ModelNode locking = cache.get(LockingResourceDefinition.PATH.getKeyValuePair());
            InfinispanSubsystemXMLWriter.writeAttribute(writer, locking, (AttributeDefinition)LockingResourceDefinition.ISOLATION);
            InfinispanSubsystemXMLWriter.writeAttribute(writer, locking, (AttributeDefinition)LockingResourceDefinition.STRIPING);
            InfinispanSubsystemXMLWriter.writeAttribute(writer, locking, (AttributeDefinition)LockingResourceDefinition.ACQUIRE_TIMEOUT);
            InfinispanSubsystemXMLWriter.writeAttribute(writer, locking, (AttributeDefinition)LockingResourceDefinition.CONCURRENCY_LEVEL);
            writer.writeEndElement();
        }
        if (cache.hasDefined(TransactionResourceDefinition.PATH.getKey())) {
            writer.writeStartElement(Element.TRANSACTION.getLocalName());
            ModelNode transaction = cache.get(TransactionResourceDefinition.PATH.getKeyValuePair());
            InfinispanSubsystemXMLWriter.writeAttribute(writer, transaction, (AttributeDefinition)TransactionResourceDefinition.STOP_TIMEOUT);
            InfinispanSubsystemXMLWriter.writeAttribute(writer, transaction, (AttributeDefinition)TransactionResourceDefinition.MODE);
            InfinispanSubsystemXMLWriter.writeAttribute(writer, transaction, (AttributeDefinition)TransactionResourceDefinition.LOCKING);
            writer.writeEndElement();
        }
        if (cache.hasDefined(EvictionResourceDefinition.PATH.getKey())) {
            writer.writeStartElement(Element.EVICTION.getLocalName());
            ModelNode eviction = cache.get(EvictionResourceDefinition.PATH.getKeyValuePair());
            InfinispanSubsystemXMLWriter.writeAttribute(writer, eviction, (AttributeDefinition)EvictionResourceDefinition.STRATEGY);
            InfinispanSubsystemXMLWriter.writeAttribute(writer, eviction, (AttributeDefinition)EvictionResourceDefinition.MAX_ENTRIES);
            writer.writeEndElement();
        }
        if (cache.hasDefined(ExpirationResourceDefinition.PATH.getKey())) {
            writer.writeStartElement(Element.EXPIRATION.getLocalName());
            ModelNode expiration = cache.get(ExpirationResourceDefinition.PATH.getKeyValuePair());
            InfinispanSubsystemXMLWriter.writeAttribute(writer, expiration, (AttributeDefinition)ExpirationResourceDefinition.MAX_IDLE);
            InfinispanSubsystemXMLWriter.writeAttribute(writer, expiration, (AttributeDefinition)ExpirationResourceDefinition.LIFESPAN);
            InfinispanSubsystemXMLWriter.writeAttribute(writer, expiration, (AttributeDefinition)ExpirationResourceDefinition.INTERVAL);
            writer.writeEndElement();
        }
        if (cache.hasDefined(CustomStoreResourceDefinition.PATH.getKey())) {
            store = cache.get(CustomStoreResourceDefinition.PATH.getKeyValuePair());
            writer.writeStartElement(Element.STORE.getLocalName());
            InfinispanSubsystemXMLWriter.writeAttribute(writer, store, (AttributeDefinition)CustomStoreResourceDefinition.CLASS);
            InfinispanSubsystemXMLWriter.writeStoreAttributes(writer, store);
            InfinispanSubsystemXMLWriter.writeStoreElements(writer, store);
            writer.writeEndElement();
        }
        if (cache.hasDefined(FileStoreResourceDefinition.PATH.getKey())) {
            store = cache.get(FileStoreResourceDefinition.PATH.getKeyValuePair());
            writer.writeStartElement(Element.FILE_STORE.getLocalName());
            InfinispanSubsystemXMLWriter.writeStoreAttributes(writer, store);
            InfinispanSubsystemXMLWriter.writeAttribute(writer, store, (AttributeDefinition)FileStoreResourceDefinition.RELATIVE_TO);
            InfinispanSubsystemXMLWriter.writeAttribute(writer, store, (AttributeDefinition)FileStoreResourceDefinition.RELATIVE_PATH);
            InfinispanSubsystemXMLWriter.writeStoreElements(writer, store);
            writer.writeEndElement();
        }
        if (cache.hasDefined(StringKeyedJDBCStoreResourceDefinition.PATH.getKey())) {
            store = cache.get(StringKeyedJDBCStoreResourceDefinition.PATH.getKeyValuePair());
            writer.writeStartElement(Element.STRING_KEYED_JDBC_STORE.getLocalName());
            InfinispanSubsystemXMLWriter.writeJDBCStoreAttributes(writer, store);
            InfinispanSubsystemXMLWriter.writeStoreElements(writer, store);
            InfinispanSubsystemXMLWriter.writeJDBCStoreTable(writer, Element.STRING_KEYED_TABLE, store, "string-keyed-table");
            writer.writeEndElement();
        }
        if (cache.hasDefined(BinaryKeyedJDBCStoreResourceDefinition.PATH.getKey())) {
            store = cache.get(BinaryKeyedJDBCStoreResourceDefinition.PATH.getKeyValuePair());
            writer.writeStartElement(Element.BINARY_KEYED_JDBC_STORE.getLocalName());
            InfinispanSubsystemXMLWriter.writeJDBCStoreAttributes(writer, store);
            InfinispanSubsystemXMLWriter.writeStoreElements(writer, store);
            InfinispanSubsystemXMLWriter.writeJDBCStoreTable(writer, Element.BINARY_KEYED_TABLE, store, "binary-keyed-table");
            writer.writeEndElement();
        }
        if (cache.hasDefined(MixedKeyedJDBCStoreResourceDefinition.PATH.getKey())) {
            store = cache.get(MixedKeyedJDBCStoreResourceDefinition.PATH.getKeyValuePair());
            writer.writeStartElement(Element.MIXED_KEYED_JDBC_STORE.getLocalName());
            InfinispanSubsystemXMLWriter.writeJDBCStoreAttributes(writer, store);
            InfinispanSubsystemXMLWriter.writeStoreElements(writer, store);
            InfinispanSubsystemXMLWriter.writeJDBCStoreTable(writer, Element.BINARY_KEYED_TABLE, store, "binary-keyed-table");
            InfinispanSubsystemXMLWriter.writeJDBCStoreTable(writer, Element.STRING_KEYED_TABLE, store, "string-keyed-table");
            writer.writeEndElement();
        }
        if (cache.hasDefined(RemoteStoreResourceDefinition.PATH.getKey())) {
            store = cache.get(RemoteStoreResourceDefinition.PATH.getKeyValuePair());
            writer.writeStartElement(Element.REMOTE_STORE.getLocalName());
            InfinispanSubsystemXMLWriter.writeStoreAttributes(writer, store);
            InfinispanSubsystemXMLWriter.writeAttribute(writer, store, (AttributeDefinition)RemoteStoreResourceDefinition.CACHE);
            InfinispanSubsystemXMLWriter.writeAttribute(writer, store, (AttributeDefinition)RemoteStoreResourceDefinition.SOCKET_TIMEOUT);
            InfinispanSubsystemXMLWriter.writeAttribute(writer, store, (AttributeDefinition)RemoteStoreResourceDefinition.TCP_NO_DELAY);
            InfinispanSubsystemXMLWriter.writeStoreElements(writer, store);
            for (ModelNode remoteServer : store.get("remote-servers").asList()) {
                writer.writeStartElement(Element.REMOTE_SERVER.getLocalName());
                InfinispanSubsystemXMLWriter.writeAttribute(writer, remoteServer, (AttributeDefinition)RemoteStoreResourceDefinition.OUTBOUND_SOCKET_BINDING);
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        if (cache.get("indexing").isDefined() || cache.get("indexing-properties").isDefined()) {
            writer.writeStartElement(Element.INDEXING.getLocalName());
            InfinispanSubsystemXMLWriter.writeAttribute(writer, cache, (AttributeDefinition)CacheResourceDefinition.INDEXING);
            InfinispanSubsystemXMLWriter.writeElement(writer, cache, (AttributeDefinition)CacheResourceDefinition.INDEXING_PROPERTIES);
            writer.writeEndElement();
        }
        if (cache.hasDefined(StateTransferResourceDefinition.PATH.getKey())) {
            ModelNode stateTransfer = cache.get(StateTransferResourceDefinition.PATH.getKeyValuePair());
            writer.writeStartElement(Element.STATE_TRANSFER.getLocalName());
            InfinispanSubsystemXMLWriter.writeAttribute(writer, stateTransfer, (AttributeDefinition)StateTransferResourceDefinition.ENABLED);
            InfinispanSubsystemXMLWriter.writeAttribute(writer, stateTransfer, (AttributeDefinition)StateTransferResourceDefinition.TIMEOUT);
            InfinispanSubsystemXMLWriter.writeAttribute(writer, stateTransfer, (AttributeDefinition)StateTransferResourceDefinition.CHUNK_SIZE);
            writer.writeEndElement();
        }
        if (cache.hasDefined(BackupSiteResourceDefinition.WILDCARD_PATH.getKey())) {
            writer.writeStartElement(Element.BACKUPS.getLocalName());
            for (Property property : cache.get(BackupSiteResourceDefinition.WILDCARD_PATH.getKey()).asPropertyList()) {
                writer.writeStartElement(Element.BACKUP.getLocalName());
                writer.writeAttribute(Attribute.SITE.getLocalName(), property.getName());
                ModelNode backup = property.getValue();
                InfinispanSubsystemXMLWriter.writeAttribute(writer, backup, (AttributeDefinition)BackupSiteResourceDefinition.FAILURE_POLICY);
                InfinispanSubsystemXMLWriter.writeAttribute(writer, backup, (AttributeDefinition)BackupSiteResourceDefinition.STRATEGY);
                InfinispanSubsystemXMLWriter.writeAttribute(writer, backup, (AttributeDefinition)BackupSiteResourceDefinition.REPLICATION_TIMEOUT);
                InfinispanSubsystemXMLWriter.writeAttribute(writer, backup, (AttributeDefinition)BackupSiteResourceDefinition.ENABLED);
                if (backup.hasDefined("after-failures") || backup.hasDefined("min-wait")) {
                    writer.writeStartElement(Element.TAKE_OFFLINE.getLocalName());
                    InfinispanSubsystemXMLWriter.writeAttribute(writer, backup, (AttributeDefinition)BackupSiteResourceDefinition.TAKE_OFFLINE_AFTER_FAILURES);
                    InfinispanSubsystemXMLWriter.writeAttribute(writer, backup, (AttributeDefinition)BackupSiteResourceDefinition.TAKE_OFFLINE_MIN_WAIT);
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        if (cache.hasDefined(BackupForResourceDefinition.PATH.getKey())) {
            ModelNode backupFor = cache.get(BackupForResourceDefinition.PATH.getKeyValuePair());
            writer.writeStartElement(Element.BACKUP_FOR.getLocalName());
            InfinispanSubsystemXMLWriter.writeAttribute(writer, backupFor, (AttributeDefinition)BackupForResourceDefinition.REMOTE_CACHE);
            InfinispanSubsystemXMLWriter.writeAttribute(writer, backupFor, (AttributeDefinition)BackupForResourceDefinition.REMOTE_SITE);
            writer.writeEndElement();
        }
    }

    private static void writeJDBCStoreTable(XMLExtendedStreamWriter writer, Element element, ModelNode store, String key) throws XMLStreamException {
        if (store.hasDefined(key)) {
            ModelNode table = store.get(key);
            writer.writeStartElement(element.getLocalName());
            InfinispanSubsystemXMLWriter.writeAttribute(writer, table, (AttributeDefinition)JDBCStoreResourceDefinition.PREFIX);
            InfinispanSubsystemXMLWriter.writeAttribute(writer, table, (AttributeDefinition)JDBCStoreResourceDefinition.BATCH_SIZE);
            InfinispanSubsystemXMLWriter.writeAttribute(writer, table, (AttributeDefinition)JDBCStoreResourceDefinition.FETCH_SIZE);
            InfinispanSubsystemXMLWriter.writeJDBCStoreColumn(writer, Element.ID_COLUMN, table, "id-column");
            InfinispanSubsystemXMLWriter.writeJDBCStoreColumn(writer, Element.DATA_COLUMN, table, "data-column");
            InfinispanSubsystemXMLWriter.writeJDBCStoreColumn(writer, Element.TIMESTAMP_COLUMN, table, "timestamp-column");
            writer.writeEndElement();
        }
    }

    private static void writeJDBCStoreColumn(XMLExtendedStreamWriter writer, Element element, ModelNode table, String key) throws XMLStreamException {
        if (table.hasDefined(key)) {
            ModelNode column = table.get(key);
            writer.writeStartElement(element.getLocalName());
            InfinispanSubsystemXMLWriter.writeAttribute(writer, column, (AttributeDefinition)JDBCStoreResourceDefinition.COLUMN_NAME);
            InfinispanSubsystemXMLWriter.writeAttribute(writer, column, (AttributeDefinition)JDBCStoreResourceDefinition.COLUMN_TYPE);
            writer.writeEndElement();
        }
    }

    private static void writeStoreAttributes(XMLExtendedStreamWriter writer, ModelNode store) throws XMLStreamException {
        InfinispanSubsystemXMLWriter.writeAttribute(writer, store, (AttributeDefinition)StoreResourceDefinition.SHARED);
        InfinispanSubsystemXMLWriter.writeAttribute(writer, store, (AttributeDefinition)StoreResourceDefinition.PRELOAD);
        InfinispanSubsystemXMLWriter.writeAttribute(writer, store, (AttributeDefinition)StoreResourceDefinition.PASSIVATION);
        InfinispanSubsystemXMLWriter.writeAttribute(writer, store, (AttributeDefinition)StoreResourceDefinition.FETCH_STATE);
        InfinispanSubsystemXMLWriter.writeAttribute(writer, store, (AttributeDefinition)StoreResourceDefinition.PURGE);
        InfinispanSubsystemXMLWriter.writeAttribute(writer, store, (AttributeDefinition)StoreResourceDefinition.SINGLETON);
    }

    private static void writeJDBCStoreAttributes(XMLExtendedStreamWriter writer, ModelNode store) throws XMLStreamException {
        InfinispanSubsystemXMLWriter.writeStoreAttributes(writer, store);
        InfinispanSubsystemXMLWriter.writeAttribute(writer, store, (AttributeDefinition)JDBCStoreResourceDefinition.DATA_SOURCE);
        InfinispanSubsystemXMLWriter.writeAttribute(writer, store, (AttributeDefinition)JDBCStoreResourceDefinition.DIALECT);
    }

    private static void writeStoreElements(XMLExtendedStreamWriter writer, ModelNode store) throws XMLStreamException {
        if (store.hasDefined(StoreWriteBehindResourceDefinition.PATH.getKey())) {
            ModelNode writeBehind = store.get(StoreWriteBehindResourceDefinition.PATH.getKeyValuePair());
            writer.writeStartElement(Element.WRITE_BEHIND.getLocalName());
            InfinispanSubsystemXMLWriter.writeAttribute(writer, writeBehind, (AttributeDefinition)StoreWriteBehindResourceDefinition.FLUSH_LOCK_TIMEOUT);
            InfinispanSubsystemXMLWriter.writeAttribute(writer, writeBehind, (AttributeDefinition)StoreWriteBehindResourceDefinition.MODIFICATION_QUEUE_SIZE);
            InfinispanSubsystemXMLWriter.writeAttribute(writer, writeBehind, (AttributeDefinition)StoreWriteBehindResourceDefinition.SHUTDOWN_TIMEOUT);
            InfinispanSubsystemXMLWriter.writeAttribute(writer, writeBehind, (AttributeDefinition)StoreWriteBehindResourceDefinition.THREAD_POOL_SIZE);
            writer.writeEndElement();
        }
        if (store.hasDefined(StorePropertyResourceDefinition.WILDCARD_PATH.getKey())) {
            for (Property property : store.get(StorePropertyResourceDefinition.WILDCARD_PATH.getKey()).asPropertyList()) {
                writer.writeStartElement(Element.PROPERTY.getLocalName());
                writer.writeAttribute(Attribute.NAME.getLocalName(), property.getName());
                Property complexValue = property.getValue().asProperty();
                writer.writeCharacters(complexValue.getValue().asString());
                writer.writeEndElement();
            }
        }
    }

    private static void writeAttribute(XMLExtendedStreamWriter writer, ModelNode model, AttributeDefinition attribute) throws XMLStreamException {
        attribute.getAttributeMarshaller().marshallAsAttribute(attribute, model, true, (XMLStreamWriter)writer);
    }

    private static void writeElement(XMLExtendedStreamWriter writer, ModelNode model, AttributeDefinition attribute) throws XMLStreamException {
        attribute.getAttributeMarshaller().marshallAsElement(attribute, model, true, (XMLStreamWriter)writer);
    }
}

