/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import org.jboss.as.clustering.infinispan.InfinispanLogger;
import org.jboss.as.clustering.infinispan.subsystem.StorePropertyResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.StoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.StoreType;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public class StoreAddHandler
extends AbstractAddStepHandler {
    protected void populateModel(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        PathAddress address = context.getCurrentAddress();
        PathAddress cacheAddress = address.subAddress(0, address.size() - 1);
        ModelNode cache = Resource.Tools.readModel((Resource)context.readResourceFromRoot(cacheAddress));
        for (StoreType type : StoreType.values()) {
            if (!cache.hasDefined(type.pathElement().getKey()) || !cache.get(type.pathElement().getKeyValuePair()).isDefined()) continue;
            throw InfinispanLogger.ROOT_LOGGER.cacheStoreAlreadyDefined(type.pathElement().getKey());
        }
        ModelNode model = resource.getModel();
        for (AttributeDefinition attribute : StoreResourceDefinition.PARAMETERS) {
            if (attribute.getName().equals(StoreResourceDefinition.PROPERTIES.getName())) continue;
            attribute.validateAndSet(operation, model);
        }
        if (operation.hasDefined("properties")) {
            for (Property property : operation.get("properties").asPropertyList()) {
                Resource param = context.createResource(PathAddress.pathAddress((PathElement[])new PathElement[]{StorePropertyResourceDefinition.pathElement(property.getName())}));
                ModelNode value = property.getValue();
                if (!value.isDefined()) {
                    throw InfinispanLogger.ROOT_LOGGER.propertyValueNotDefined(property.getName());
                }
                StorePropertyResourceDefinition.VALUE.validateAndSet(value, param.getModel());
            }
        }
    }
}

