/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.HashMap;
import java.util.Map;
import org.infinispan.interceptors.TxInterceptor;
import org.jboss.as.clustering.controller.Metric;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public enum TransactionMetric implements Metric<TxInterceptor>
{
    COMMITS("commits", ModelType.LONG){

        public ModelNode getValue(TxInterceptor interceptor) {
            return new ModelNode(interceptor.getCommits());
        }
    }
    ,
    PREPARES("prepares", ModelType.LONG){

        public ModelNode getValue(TxInterceptor interceptor) {
            return new ModelNode(interceptor.getPrepares());
        }
    }
    ,
    ROLLBACKS("rollbacks", ModelType.LONG){

        public ModelNode getValue(TxInterceptor interceptor) {
            return new ModelNode(interceptor.getRollbacks());
        }
    };

    private final AttributeDefinition definition;
    private static final Map<String, TransactionMetric> metrics;

    private TransactionMetric(String name, ModelType type) {
        this.definition = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(name, type, true).setStorageRuntime()).build();
    }

    public AttributeDefinition getDefinition() {
        return this.definition;
    }

    public static TransactionMetric forName(String name) {
        return metrics.get(name);
    }

    static {
        metrics = new HashMap<String, TransactionMetric>();
        for (TransactionMetric metric : TransactionMetric.values()) {
            metrics.put(metric.definition.getName(), metric);
        }
    }
}

