/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.lucene.works;

import java.io.Serializable;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.hibernate.search.backend.IndexingMonitor;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.impl.lucene.works.AddWorkDelegate;
import org.hibernate.search.backend.impl.lucene.works.DeleteWorkDelegate;
import org.hibernate.search.backend.impl.lucene.works.UpdateWorkDelegate;
import org.hibernate.search.bridge.util.impl.NumericFieldUtils;
import org.hibernate.search.engine.spi.DocumentBuilderIndexedEntity;
import org.hibernate.search.exception.AssertionFailure;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.store.Workspace;
import org.hibernate.search.util.impl.ScopedAnalyzer;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public final class UpdateExtWorkDelegate
extends UpdateWorkDelegate {
    private static final Log log = LoggerFactory.make();
    private final AddWorkDelegate addDelegate;
    private final Class<?> managedType;
    private final DocumentBuilderIndexedEntity builder;
    private final boolean idIsNumeric;
    private final Workspace workspace;

    UpdateExtWorkDelegate(Workspace workspace, AddWorkDelegate addDelegate) {
        super(null, null);
        this.workspace = workspace;
        this.addDelegate = addDelegate;
        this.managedType = workspace.getEntitiesInIndexManager().iterator().next();
        this.builder = workspace.getDocumentBuilder(this.managedType);
        this.idIsNumeric = DeleteWorkDelegate.isIdNumeric(this.builder);
    }

    @Override
    public void performWork(LuceneWork work, IndexWriter writer, IndexingMonitor monitor) {
        this.checkType(work);
        Serializable id = work.getId();
        try {
            if (this.idIsNumeric) {
                log.tracef("Deleting %s#%s by query using an IndexWriter#updateDocument as id is Numeric", this.managedType, id);
                writer.deleteDocuments(new Query[]{NumericFieldUtils.createExactMatchQuery(this.builder.getIdKeywordName(), id)});
                this.addDelegate.performWork(work, writer, monitor);
            } else {
                log.tracef("Updating %s#%s by id using an IndexWriter#updateDocument.", this.managedType, id);
                Term idTerm = new Term(this.builder.getIdKeywordName(), work.getIdInString());
                Map<String, String> fieldToAnalyzerMap = work.getFieldToAnalyzerMap();
                ScopedAnalyzer analyzer = this.builder.getAnalyzer();
                analyzer = AddWorkDelegate.updateAnalyzerMappings(this.workspace, analyzer, fieldToAnalyzerMap);
                writer.updateDocument(idTerm, (Iterable)work.getDocument(), (Analyzer)analyzer);
            }
            this.workspace.notifyWorkApplied(work);
        }
        catch (Exception e) {
            String message = "Unable to update " + this.managedType + "#" + id + " in index.";
            throw new SearchException(message, e);
        }
        if (monitor != null) {
            monitor.documentsAdded(1L);
        }
    }

    private void checkType(LuceneWork work) {
        if (work.getEntityClass() != this.managedType) {
            throw new AssertionFailure("Unexpected type: " + work.getEntityClass() + " This workspace expects: " + this.managedType);
        }
    }
}

