/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.spi;

import java.io.Serializable;
import org.hibernate.search.backend.spi.WorkType;

public class Work {
    private final Object entity;
    private final Class<?> entityClass;
    private final Serializable id;
    private final WorkType type;
    private final boolean identifierWasRolledBack;

    public Work(Object entity, Serializable id, WorkType type) {
        this(entity, null, id, type, false);
    }

    public Work(Object entity, Serializable id, WorkType type, boolean identifierRollbackEnabled) {
        this(entity, null, id, type, identifierRollbackEnabled);
    }

    public Work(Class<?> entityType, Serializable id, WorkType type) {
        this(null, entityType, id, type, false);
    }

    public Work(Object entity, WorkType type) {
        this(entity, null, null, type, false);
    }

    private Work(Object entity, Class<?> entityClass, Serializable id, WorkType type, boolean identifierWasRolledBack) {
        this.entity = entity;
        this.entityClass = entityClass;
        this.id = id;
        this.type = type;
        this.identifierWasRolledBack = identifierWasRolledBack;
    }

    public Class<?> getEntityClass() {
        return this.entityClass;
    }

    public Object getEntity() {
        return this.entity;
    }

    public Serializable getId() {
        return this.id;
    }

    public WorkType getType() {
        return this.type;
    }

    public boolean isIdentifierWasRolledBack() {
        return this.identifierWasRolledBack;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Work{");
        sb.append("entityClass=").append(this.entityClass);
        sb.append(", id=").append(this.id);
        sb.append(", type=").append((Object)this.type);
        sb.append('}');
        return sb.toString();
    }
}

