/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.ast.spi.predicate;

import org.hibernate.hql.ast.spi.predicate.AbstractPredicate;
import org.hibernate.hql.ast.spi.predicate.ParentPredicate;
import org.hibernate.hql.ast.spi.predicate.Predicate;
import org.hibernate.hql.internal.logging.Log;
import org.hibernate.hql.internal.logging.LoggerFactory;

public abstract class NegationPredicate<Q>
extends AbstractPredicate<Q>
implements ParentPredicate<Q> {
    private static final Log log = LoggerFactory.make();
    private Predicate<Q> child;

    public NegationPredicate() {
        super(Predicate.Type.NEGATION);
    }

    @Override
    public void add(Predicate<Q> predicate) {
        if (this.child != null) {
            throw log.getNotMoreThanOnePredicateInNegationAllowedException(predicate);
        }
        this.child = predicate;
    }

    public Predicate<Q> getChild() {
        return this.child;
    }

    public String toString() {
        return "( NOT " + this.getChild() + " )";
    }
}

