/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component;

import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jboss.as.ee.component.AbstractComponentConfigurator;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.BasicComponentInstance;
import org.jboss.as.ee.component.ClassDescriptionTraversal;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.ComponentConfigurator;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.EEApplicationClasses;
import org.jboss.as.ee.component.EEModuleClassDescription;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.component.ManagedReferenceLifecycleMethodInterceptor;
import org.jboss.as.ee.component.ManagedReferenceMethodInterceptor;
import org.jboss.as.ee.component.ManagedReferenceReleaseInterceptor;
import org.jboss.as.ee.component.interceptors.InterceptorClassDescription;
import org.jboss.as.ee.component.interceptors.UserInterceptorFactory;
import org.jboss.as.ee.metadata.MetadataCompleteMarker;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.reflect.ClassReflectionIndexUtil;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.invocation.ContextClassLoaderInterceptor;
import org.jboss.invocation.ImmediateInterceptorFactory;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.Interceptors;
import org.jboss.invocation.PrivilegedWithCombinerInterceptor;
import org.jboss.invocation.proxy.MethodIdentifier;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;

class DefaultComponentConfigurator
extends AbstractComponentConfigurator
implements ComponentConfigurator {
    DefaultComponentConfigurator() {
    }

    @Override
    public void configure(final DeploymentPhaseContext context, final ComponentDescription description, final ComponentConfiguration configuration) throws DeploymentUnitProcessingException {
        ArrayList<InterceptorFactory> componentUserPostActivate;
        ArrayList<InterceptorFactory> componentUserPrePassivate;
        DeploymentUnit deploymentUnit = context.getDeploymentUnit();
        final DeploymentReflectionIndex deploymentReflectionIndex = (DeploymentReflectionIndex)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.REFLECTION_INDEX);
        Module module = (Module)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.MODULE);
        EEApplicationClasses applicationClasses = (EEApplicationClasses)deploymentUnit.getAttachment(Attachments.EE_APPLICATION_CLASSES_DESCRIPTION);
        final EEModuleDescription moduleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        final boolean metadataComplete = MetadataCompleteMarker.isMetadataComplete(deploymentUnit);
        final ArrayDeque injectors = new ArrayDeque();
        final ArrayDeque uninjectors = new ArrayDeque();
        ArrayDeque<ImmediateInterceptorFactory> destructors = new ArrayDeque<ImmediateInterceptorFactory>();
        final ArrayList<InterceptorFactory> componentUserAroundInvoke = new ArrayList<InterceptorFactory>();
        final ArrayList<InterceptorFactory> userPostConstruct = new ArrayList<InterceptorFactory>();
        final ArrayList<InterceptorFactory> userPreDestroy = new ArrayList<InterceptorFactory>();
        Set<MethodIdentifier> timeoutMethods = description.getTimerMethods();
        final ArrayList<InterceptorFactory> componentUserAroundTimeout = description.isTimerServiceRequired() ? new ArrayList<InterceptorFactory>() : null;
        if (description.isPassivationApplicable()) {
            componentUserPrePassivate = new ArrayList<InterceptorFactory>();
            componentUserPostActivate = new ArrayList<InterceptorFactory>();
        } else {
            componentUserPrePassivate = null;
            componentUserPostActivate = null;
        }
        destructors.add(new ImmediateInterceptorFactory((Interceptor)new ManagedReferenceReleaseInterceptor(BasicComponentInstance.INSTANCE_KEY)));
        new ClassDescriptionTraversal(configuration.getComponentClass(), applicationClasses){

            @Override
            public void handle(Class<?> clazz, EEModuleClassDescription classDescription) throws DeploymentUnitProcessingException {
                DefaultComponentConfigurator.this.mergeInjectionsForClass(clazz, configuration.getComponentClass(), classDescription, moduleDescription, deploymentReflectionIndex, description, configuration, context, injectors, BasicComponentInstance.INSTANCE_KEY, uninjectors, metadataComplete);
            }
        }.run();
        new ClassDescriptionTraversal(configuration.getComponentClass(), applicationClasses){

            @Override
            public void handle(Class<?> clazz, EEModuleClassDescription classDescription) throws DeploymentUnitProcessingException {
                InterceptorClassDescription interceptorConfig = InterceptorClassDescription.merge(ComponentDescription.mergeInterceptorConfig(clazz, classDescription, description, metadataComplete), moduleDescription.getInterceptorClassOverride(clazz.getName()));
                this.handleClassMethod(clazz, interceptorConfig.getAroundInvoke(), componentUserAroundInvoke, false, false, configuration);
                if (description.isTimerServiceRequired()) {
                    this.handleClassMethod(clazz, interceptorConfig.getAroundTimeout(), componentUserAroundTimeout, false, false, configuration);
                }
                if (!description.isIgnoreLifecycleInterceptors()) {
                    this.handleClassMethod(clazz, interceptorConfig.getPostConstruct(), userPostConstruct, true, true, configuration);
                    this.handleClassMethod(clazz, interceptorConfig.getPreDestroy(), userPreDestroy, true, true, configuration);
                    if (description.isPassivationApplicable()) {
                        this.handleClassMethod(clazz, interceptorConfig.getPrePassivate(), componentUserPrePassivate, false, false, configuration);
                        this.handleClassMethod(clazz, interceptorConfig.getPostActivate(), componentUserPostActivate, false, false, configuration);
                    }
                }
            }

            private void handleClassMethod(Class<?> clazz, MethodIdentifier methodIdentifier, List<InterceptorFactory> interceptors, boolean changeMethod, boolean lifecycleMethod, ComponentConfiguration configuration2) throws DeploymentUnitProcessingException {
                Method method;
                if (methodIdentifier != null && DefaultComponentConfigurator.this.isNotOverriden(clazz, method = ClassReflectionIndexUtil.findRequiredMethod((DeploymentReflectionIndex)deploymentReflectionIndex, clazz, (MethodIdentifier)methodIdentifier), configuration2.getComponentClass(), deploymentReflectionIndex)) {
                    ImmediateInterceptorFactory interceptorFactory = new ImmediateInterceptorFactory((Interceptor)new ManagedReferenceLifecycleMethodInterceptor(BasicComponentInstance.INSTANCE_KEY, method, changeMethod, lifecycleMethod));
                    interceptors.add((InterceptorFactory)interceptorFactory);
                    if (lifecycleMethod) {
                        configuration2.addLifecycleMethod(method);
                    }
                }
            }
        }.run();
        ModuleClassLoader classLoader = module.getClassLoader();
        ImmediateInterceptorFactory tcclInterceptor = new ImmediateInterceptorFactory((Interceptor)new ContextClassLoaderInterceptor((ClassLoader)classLoader));
        InterceptorFactory privilegedInterceptor = PrivilegedWithCombinerInterceptor.getFactory();
        if (!injectors.isEmpty()) {
            configuration.addPostConstructInterceptors(new ArrayList<InterceptorFactory>(injectors), 2816);
        }
        if (!userPostConstruct.isEmpty()) {
            configuration.addPostConstructInterceptors(userPostConstruct, 4352);
        }
        configuration.addPostConstructInterceptor(Interceptors.getTerminalInterceptorFactory(), 5120);
        configuration.addPostConstructInterceptor((InterceptorFactory)tcclInterceptor, 256);
        configuration.addPostConstructInterceptor(privilegedInterceptor, 0);
        if (!uninjectors.isEmpty()) {
            configuration.addPreDestroyInterceptors(new ArrayList<InterceptorFactory>(uninjectors), 1792);
        }
        if (!destructors.isEmpty()) {
            configuration.addPreDestroyInterceptors(new ArrayList<InterceptorFactory>(destructors), 2304);
        }
        if (!userPreDestroy.isEmpty()) {
            configuration.addPreDestroyInterceptors(userPreDestroy, 3072);
        }
        configuration.addPreDestroyInterceptor(Interceptors.getTerminalInterceptorFactory(), 3328);
        configuration.addPreDestroyInterceptor((InterceptorFactory)tcclInterceptor, 256);
        configuration.addPreDestroyInterceptor(privilegedInterceptor, 0);
        if (description.isPassivationApplicable()) {
            if (!componentUserPrePassivate.isEmpty()) {
                configuration.addPrePassivateInterceptors(componentUserPrePassivate, 1792);
            }
            configuration.addPrePassivateInterceptor(Interceptors.getTerminalInterceptorFactory(), 2048);
            configuration.addPrePassivateInterceptor((InterceptorFactory)tcclInterceptor, 256);
            configuration.addPrePassivateInterceptor(privilegedInterceptor, 0);
            if (!componentUserPostActivate.isEmpty()) {
                configuration.addPostActivateInterceptors(componentUserPostActivate, 1792);
            }
            configuration.addPostActivateInterceptor(Interceptors.getTerminalInterceptorFactory(), 2048);
            configuration.addPostActivateInterceptor((InterceptorFactory)tcclInterceptor, 256);
            configuration.addPostActivateInterceptor(privilegedInterceptor, 0);
        }
        if (description.isIntercepted()) {
            for (Method method : configuration.getDefinedComponentMethods()) {
                boolean requiresTimerChain;
                configuration.addComponentInterceptor(method, Interceptors.getInitialInterceptorFactory(), 256);
                configuration.addComponentInterceptor(method, (InterceptorFactory)new ImmediateInterceptorFactory((Interceptor)new ManagedReferenceMethodInterceptor(BasicComponentInstance.INSTANCE_KEY, method)), 3328);
                MethodIdentifier identifier = MethodIdentifier.getIdentifier(method.getReturnType(), (String)method.getName(), (Class[])method.getParameterTypes());
                boolean bl = requiresTimerChain = description.isTimerServiceRequired() && timeoutMethods.contains(identifier);
                if (requiresTimerChain) {
                    configuration.addComponentInterceptor(method, new UserInterceptorFactory(DefaultComponentConfigurator.weaved(componentUserAroundInvoke), DefaultComponentConfigurator.weaved(componentUserAroundTimeout)), 3072);
                    continue;
                }
                configuration.addComponentInterceptors(method, componentUserAroundInvoke, 3072);
            }
        }
    }
}

