/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.workmanager;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.jca.core.CoreLogger;
import org.jboss.jca.core.workmanager.WorkManagerEvent;
import org.jboss.logging.Logger;

public class WorkManagerEventQueue {
    private static CoreLogger log = (CoreLogger)Logger.getMessageLogger(CoreLogger.class, (String)WorkManagerEventQueue.class.getName());
    private static boolean trace = log.isTraceEnabled();
    private static final WorkManagerEventQueue INSTANCE = new WorkManagerEventQueue();
    private Map<String, List<WorkManagerEvent>> events = new HashMap<String, List<WorkManagerEvent>>();

    private WorkManagerEventQueue() {
    }

    public static WorkManagerEventQueue getInstance() {
        return INSTANCE;
    }

    public synchronized void addEvent(WorkManagerEvent event) {
        List<WorkManagerEvent> e;
        if (trace) {
            log.tracef("addEvent(%s)", event);
        }
        if ((e = this.events.get(event.getAddress().getWorkManagerName())) == null) {
            e = new ArrayList<WorkManagerEvent>();
            this.events.put(event.getAddress().getWorkManagerName(), e);
        }
        e.add(event);
    }

    public synchronized List<WorkManagerEvent> getEvents(String workManagerName) {
        ArrayList<WorkManagerEvent> result = new ArrayList<WorkManagerEvent>();
        List<WorkManagerEvent> e = this.events.get(workManagerName);
        if (e != null) {
            result.addAll(e);
            e.clear();
        }
        if (trace) {
            log.tracef("getEvents(%s): %s", workManagerName, result);
        }
        return result;
    }
}

