/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.common.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

public final class CompressionUtils {
    private CompressionUtils() {
    }

    public static InputStream inflate(byte[] deflatedToken) throws DataFormatException {
        return CompressionUtils.inflate(deflatedToken, true);
    }

    public static InputStream inflate(byte[] deflatedToken, boolean nowrap) throws DataFormatException {
        Inflater inflater = new Inflater(nowrap);
        inflater.setInput(deflatedToken);
        byte[] input = new byte[deflatedToken.length * 2];
        int inflatedLen = 0;
        int inputLen = 0;
        byte[] inflatedToken = input;
        while (!inflater.finished()) {
            inputLen = inflater.inflate(input);
            if (inflater.finished()) continue;
            if (inputLen == 0) {
                if (!inflater.needsInput()) break;
                throw new DataFormatException("Inflater can not inflate all the token bytes");
            }
            inflatedToken = new byte[input.length + inflatedLen];
            System.arraycopy(input, 0, inflatedToken, inflatedLen, inputLen);
            inflatedLen += inputLen;
        }
        InputStream is = new ByteArrayInputStream(input, 0, inputLen);
        if (inflatedToken != input) {
            is = new SequenceInputStream(new ByteArrayInputStream(inflatedToken, 0, inflatedLen), is);
        }
        return is;
    }

    public static byte[] deflate(byte[] tokenBytes) {
        return CompressionUtils.deflate(tokenBytes, true);
    }

    public static byte[] deflate(byte[] tokenBytes, boolean nowrap) {
        Deflater compresser = new Deflater(8, nowrap);
        compresser.setInput(tokenBytes);
        compresser.finish();
        byte[] output = new byte[tokenBytes.length * 2];
        int compressedDataLength = compresser.deflate(output);
        byte[] result = new byte[compressedDataLength];
        System.arraycopy(output, 0, result, 0, compressedDataLength);
        return result;
    }
}

