/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.management.MBeanServer;
import org.hornetq.api.config.HornetQDefaultConfiguration;
import org.hornetq.api.core.BroadcastGroupConfiguration;
import org.hornetq.api.core.SimpleString;
import org.hornetq.core.config.Configuration;
import org.hornetq.core.config.impl.ConfigurationImpl;
import org.hornetq.core.security.Role;
import org.hornetq.core.server.HornetQServer;
import org.hornetq.core.server.JournalType;
import org.hornetq.core.settings.impl.AddressSettings;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.controller.services.path.PathManagerService;
import org.jboss.as.messaging.AddressSettingAdd;
import org.jboss.as.messaging.BridgeAdd;
import org.jboss.as.messaging.BroadcastGroupAdd;
import org.jboss.as.messaging.ClusterConnectionAdd;
import org.jboss.as.messaging.CommonAttributes;
import org.jboss.as.messaging.ConnectorServiceDefinition;
import org.jboss.as.messaging.DiscoveryGroupAdd;
import org.jboss.as.messaging.DivertAdd;
import org.jboss.as.messaging.GroupBindingService;
import org.jboss.as.messaging.GroupingHandlerAdd;
import org.jboss.as.messaging.HTTPAcceptorDefinition;
import org.jboss.as.messaging.HTTPUpgradeService;
import org.jboss.as.messaging.HornetQServerResource;
import org.jboss.as.messaging.HornetQService;
import org.jboss.as.messaging.MessagingServices;
import org.jboss.as.messaging.PathDefinition;
import org.jboss.as.messaging.QueueAdd;
import org.jboss.as.messaging.SecurityRoleDefinition;
import org.jboss.as.messaging.TransportConfigOperationHandlers;
import org.jboss.as.messaging.jms.JMSService;
import org.jboss.as.messaging.logging.MessagingLogger;
import org.jboss.as.network.OutboundSocketBinding;
import org.jboss.as.network.SocketBinding;
import org.jboss.as.security.plugins.SecurityDomainContext;
import org.jboss.as.security.service.SecurityDomainService;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.jgroups.spi.ChannelFactory;
import org.wildfly.clustering.jgroups.spi.service.ProtocolStackServiceName;

class HornetQServerAdd
implements OperationStepHandler {
    static final String PATH_BASE = "paths";
    public static final HornetQServerAdd INSTANCE = new HornetQServerAdd();

    private HornetQServerAdd() {
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        final HornetQServerResource resource = new HornetQServerResource();
        context.addResource(PathAddress.EMPTY_ADDRESS, (Resource)resource);
        ModelNode model = resource.getModel();
        for (AttributeDefinition attributeDefinition : CommonAttributes.SIMPLE_ROOT_RESOURCE_ATTRIBUTES) {
            attributeDefinition.validateAndSet(operation, model);
        }
        ModelNode mceVal = model.get(CommonAttributes.MESSAGE_COUNTER_ENABLED.getName());
        if (mceVal.isDefined()) {
            ModelNode seVal = model.get(CommonAttributes.STATISTICS_ENABLED.getName());
            if (seVal.isDefined() && !seVal.equals(mceVal)) {
                throw MessagingLogger.ROOT_LOGGER.inconsistentStatisticsSettings(CommonAttributes.MESSAGE_COUNTER_ENABLED.getName(), CommonAttributes.STATISTICS_ENABLED.getName());
            }
            seVal.set(mceVal);
            mceVal.set(new ModelNode());
        }
        if (context.isNormalServer()) {
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    ModelNode model = Resource.Tools.readModel((Resource)resource);
                    for (String path : PathDefinition.PATHS.keySet()) {
                        if (model.get("path").hasDefined(path)) continue;
                        PathAddress pathAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"path", (String)path)});
                        context.createResource(pathAddress);
                    }
                    context.stepCompleted();
                }
            }, OperationContext.Stage.MODEL);
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    final ArrayList controllers = new ArrayList();
                    ServiceVerificationHandler verificationHandler = new ServiceVerificationHandler();
                    HornetQServerAdd.this.performRuntime(context, resource, verificationHandler, controllers);
                    context.addStep((OperationStepHandler)verificationHandler, OperationContext.Stage.VERIFY);
                    context.completeStep(new OperationContext.RollbackHandler(){

                        public void handleRollback(OperationContext context, ModelNode operation) {
                            for (ServiceController controller : controllers) {
                                context.removeService(controller.getName());
                            }
                        }
                    });
                }
            }, OperationContext.Stage.RUNTIME);
        }
        context.stepCompleted();
    }

    private void performRuntime(OperationContext context, final HornetQServerResource resource, final ServiceVerificationHandler verificationHandler, final List<ServiceController<?>> newControllers) throws OperationFailedException {
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                ServiceName groupBinding;
                String channelName;
                String jgroupsStack;
                String key;
                String name;
                ServiceTarget serviceTarget = context.getServiceTarget();
                String serverName = PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement().getValue();
                ModelNode model = Resource.Tools.readModel((Resource)resource);
                Configuration configuration = HornetQServerAdd.this.transformConfig(context, serverName, model);
                String bindingsPath = PathDefinition.PATHS.get("bindings-directory").resolveModelAttribute(context, model.get(new String[]{"path", "bindings-directory"})).asString();
                String bindingsRelativeToPath = PathDefinition.RELATIVE_TO.resolveModelAttribute(context, model.get(new String[]{"path", "bindings-directory"})).asString();
                String journalPath = PathDefinition.PATHS.get("journal-directory").resolveModelAttribute(context, model.get(new String[]{"path", "journal-directory"})).asString();
                String journalRelativeToPath = PathDefinition.RELATIVE_TO.resolveModelAttribute(context, model.get(new String[]{"path", "journal-directory"})).asString();
                String largeMessagePath = PathDefinition.PATHS.get("large-messages-directory").resolveModelAttribute(context, model.get(new String[]{"path", "large-messages-directory"})).asString();
                String largeMessageRelativeToPath = PathDefinition.RELATIVE_TO.resolveModelAttribute(context, model.get(new String[]{"path", "large-messages-directory"})).asString();
                String pagingPath = PathDefinition.PATHS.get("paging-directory").resolveModelAttribute(context, model.get(new String[]{"path", "paging-directory"})).asString();
                String pagingRelativeToPath = PathDefinition.RELATIVE_TO.resolveModelAttribute(context, model.get(new String[]{"path", "paging-directory"})).asString();
                HornetQService hqService = new HornetQService(configuration, new HornetQService.PathConfig(bindingsPath, bindingsRelativeToPath, journalPath, journalRelativeToPath, largeMessagePath, largeMessageRelativeToPath, pagingPath, pagingRelativeToPath));
                ServiceName hqServiceName = MessagingServices.getHornetQServiceName(serverName);
                ServiceBuilder serviceBuilder = serviceTarget.addService(hqServiceName, (Service)hqService).addDependency(ServiceBuilder.DependencyType.OPTIONAL, ServiceName.JBOSS.append(new String[]{"mbean", "server"}), MBeanServer.class, hqService.getMBeanServer());
                serviceBuilder.addDependency(PathManagerService.SERVICE_NAME, PathManager.class, hqService.getPathManagerInjector());
                String domain = CommonAttributes.SECURITY_DOMAIN.resolveModelAttribute(context, model).asString();
                serviceBuilder.addDependency(ServiceBuilder.DependencyType.REQUIRED, SecurityDomainService.SERVICE_NAME.append(new String[]{domain}), SecurityDomainContext.class, hqService.getSecurityDomainContextInjector());
                HashSet<String> socketBindings = new HashSet<String>();
                TransportConfigOperationHandlers.processAcceptors(context, configuration, model, socketBindings);
                if (model.hasDefined("http-acceptor")) {
                    for (Property property : model.get("http-acceptor").asPropertyList()) {
                        String httpListener = HTTPAcceptorDefinition.HTTP_LISTENER.resolveModelAttribute(context, property.getValue()).asString();
                        serviceBuilder.addDependency(HTTPUpgradeService.HTTP_UPGRADE_REGISTRY.append(new String[]{httpListener}));
                    }
                }
                for (String socketBinding : socketBindings) {
                    ServiceName socketName = SocketBinding.JBOSS_BINDING_NAME.append(new String[]{socketBinding});
                    serviceBuilder.addDependency(socketName, SocketBinding.class, hqService.getSocketBindingInjector(socketBinding));
                }
                HashSet<String> outboundSocketBindings = new HashSet<String>();
                TransportConfigOperationHandlers.processConnectors(context, configuration, model, outboundSocketBindings);
                for (String outboundSocketBinding : outboundSocketBindings) {
                    ServiceName outboundSocketName = OutboundSocketBinding.OUTBOUND_SOCKET_BINDING_BASE_SERVICE_NAME.append(new String[]{outboundSocketBinding});
                    serviceBuilder.addDependency(ServiceBuilder.DependencyType.OPTIONAL, outboundSocketName, OutboundSocketBinding.class, hqService.getOutboundSocketBindingInjector(outboundSocketBinding));
                    if (socketBindings.contains(outboundSocketBinding)) continue;
                    ServiceName socketName = SocketBinding.JBOSS_BINDING_NAME.append(new String[]{outboundSocketBinding});
                    serviceBuilder.addDependency(ServiceBuilder.DependencyType.OPTIONAL, socketName, SocketBinding.class, hqService.getSocketBindingInjector(outboundSocketBinding));
                }
                BroadcastGroupAdd.addBroadcastGroupConfigs(context, configuration, model);
                List broadcastGroupConfigurations = configuration.getBroadcastGroupConfigurations();
                Map discoveryGroupConfigurations = configuration.getDiscoveryGroupConfigurations();
                if (broadcastGroupConfigurations != null) {
                    for (BroadcastGroupConfiguration config : broadcastGroupConfigurations) {
                        name = config.getName();
                        key = "broadcast" + name;
                        ModelNode broadcastGroupModel = model.get(new String[]{"broadcast-group", name});
                        if (broadcastGroupModel.hasDefined(CommonAttributes.JGROUPS_STACK.getName())) {
                            jgroupsStack = CommonAttributes.JGROUPS_STACK.resolveModelAttribute(context, broadcastGroupModel).asString();
                            channelName = CommonAttributes.JGROUPS_CHANNEL.resolveModelAttribute(context, broadcastGroupModel).asString();
                            serviceBuilder.addDependency(ProtocolStackServiceName.CHANNEL_FACTORY.getServiceName(jgroupsStack), ChannelFactory.class, hqService.getJGroupsInjector(key));
                            hqService.getJGroupsChannels().put(key, channelName);
                            continue;
                        }
                        groupBinding = GroupBindingService.getBroadcastBaseServiceName(hqServiceName).append(new String[]{name});
                        serviceBuilder.addDependency(groupBinding, SocketBinding.class, hqService.getGroupBindingInjector(key));
                    }
                }
                if (discoveryGroupConfigurations != null) {
                    for (BroadcastGroupConfiguration config : discoveryGroupConfigurations.values()) {
                        name = config.getName();
                        key = "discovery" + name;
                        ModelNode discoveryGroupModel = model.get(new String[]{"discovery-group", name});
                        if (discoveryGroupModel.hasDefined(CommonAttributes.JGROUPS_STACK.getName())) {
                            jgroupsStack = CommonAttributes.JGROUPS_STACK.resolveModelAttribute(context, discoveryGroupModel).asString();
                            channelName = CommonAttributes.JGROUPS_CHANNEL.resolveModelAttribute(context, discoveryGroupModel).asString();
                            serviceBuilder.addDependency(ProtocolStackServiceName.CHANNEL_FACTORY.getServiceName(jgroupsStack), ChannelFactory.class, hqService.getJGroupsInjector(key));
                            hqService.getJGroupsChannels().put(key, channelName);
                            continue;
                        }
                        groupBinding = GroupBindingService.getDiscoveryBaseServiceName(hqServiceName).append(new String[]{name});
                        serviceBuilder.addDependency(groupBinding, SocketBinding.class, hqService.getGroupBindingInjector(key));
                    }
                }
                serviceBuilder.addListener((ServiceListener)verificationHandler);
                ServiceController hqServerServiceController = serviceBuilder.install();
                resource.setHornetQServerServiceController((ServiceController<HornetQServer>)hqServerServiceController);
                newControllers.add(hqServerServiceController);
                boolean overrideInVMSecurity = CommonAttributes.OVERRIDE_IN_VM_SECURITY.resolveModelAttribute(context, operation).asBoolean();
                newControllers.add(JMSService.addService(serviceTarget, hqServiceName, overrideInVMSecurity));
                context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
            }
        }, OperationContext.Stage.RUNTIME);
    }

    private Configuration transformConfig(OperationContext context, String serverName, ModelNode model) throws OperationFailedException {
        ModelNode replicationClusterName;
        ConfigurationImpl configuration = new ConfigurationImpl();
        configuration.setName(serverName);
        configuration.setAllowAutoFailBack(CommonAttributes.ALLOW_FAILBACK.resolveModelAttribute(context, model).asBoolean());
        configuration.setEnabledAsyncConnectionExecution(CommonAttributes.ASYNC_CONNECTION_EXECUTION_ENABLED.resolveModelAttribute(context, model).asBoolean());
        ModelNode backupGroupName = CommonAttributes.BACKUP_GROUP_NAME.resolveModelAttribute(context, model);
        if (backupGroupName.isDefined()) {
            configuration.setBackupGroupName(backupGroupName.asString());
        }
        if ((replicationClusterName = CommonAttributes.REPLICATION_CLUSTERNAME.resolveModelAttribute(context, model)).isDefined()) {
            configuration.setReplicationClustername(replicationClusterName.asString());
        }
        configuration.setCheckForLiveServer(CommonAttributes.CHECK_FOR_LIVE_SERVER.resolveModelAttribute(context, model).asBoolean());
        configuration.setBackup(CommonAttributes.BACKUP.resolveModelAttribute(context, model).asBoolean());
        configuration.setClusterPassword(CommonAttributes.CLUSTER_PASSWORD.resolveModelAttribute(context, model).asString());
        configuration.setClusterUser(CommonAttributes.CLUSTER_USER.resolveModelAttribute(context, model).asString());
        configuration.setConnectionTTLOverride((long)CommonAttributes.CONNECTION_TTL_OVERRIDE.resolveModelAttribute(context, model).asInt());
        configuration.setCreateBindingsDir(CommonAttributes.CREATE_BINDINGS_DIR.resolveModelAttribute(context, model).asBoolean());
        configuration.setCreateJournalDir(CommonAttributes.CREATE_JOURNAL_DIR.resolveModelAttribute(context, model).asBoolean());
        configuration.setFailbackDelay(CommonAttributes.FAILBACK_DELAY.resolveModelAttribute(context, model).asLong());
        configuration.setFailoverOnServerShutdown(CommonAttributes.FAILOVER_ON_SHUTDOWN.resolveModelAttribute(context, model).asBoolean());
        configuration.setIDCacheSize(CommonAttributes.ID_CACHE_SIZE.resolveModelAttribute(context, model).asInt());
        configuration.setJMXDomain(CommonAttributes.JMX_DOMAIN.resolveModelAttribute(context, model).asString());
        configuration.setJMXManagementEnabled(CommonAttributes.JMX_MANAGEMENT_ENABLED.resolveModelAttribute(context, model).asBoolean());
        JournalType journalType = JournalType.valueOf((String)CommonAttributes.JOURNAL_TYPE.resolveModelAttribute(context, model).asString());
        configuration.setJournalType(journalType);
        configuration.setJournalBufferSize_AIO(CommonAttributes.JOURNAL_BUFFER_SIZE.resolveModelAttribute(context, model).asInt(HornetQDefaultConfiguration.getDefaultJournalBufferSizeAio()));
        configuration.setJournalBufferTimeout_AIO(CommonAttributes.JOURNAL_BUFFER_TIMEOUT.resolveModelAttribute(context, model).asInt(HornetQDefaultConfiguration.getDefaultJournalBufferTimeoutAio()));
        configuration.setJournalMaxIO_AIO(CommonAttributes.JOURNAL_MAX_IO.resolveModelAttribute(context, model).asInt(HornetQDefaultConfiguration.getDefaultJournalMaxIoAio()));
        configuration.setJournalBufferSize_NIO(CommonAttributes.JOURNAL_BUFFER_SIZE.resolveModelAttribute(context, model).asInt(HornetQDefaultConfiguration.getDefaultJournalBufferSizeNio()));
        configuration.setJournalBufferTimeout_NIO(CommonAttributes.JOURNAL_BUFFER_TIMEOUT.resolveModelAttribute(context, model).asInt(HornetQDefaultConfiguration.getDefaultJournalBufferTimeoutNio()));
        configuration.setJournalMaxIO_NIO(CommonAttributes.JOURNAL_MAX_IO.resolveModelAttribute(context, model).asInt(HornetQDefaultConfiguration.getDefaultJournalMaxIoNio()));
        configuration.setJournalCompactMinFiles(CommonAttributes.JOURNAL_COMPACT_MIN_FILES.resolveModelAttribute(context, model).asInt());
        configuration.setJournalCompactPercentage(CommonAttributes.JOURNAL_COMPACT_PERCENTAGE.resolveModelAttribute(context, model).asInt());
        configuration.setJournalFileSize(CommonAttributes.JOURNAL_FILE_SIZE.resolveModelAttribute(context, model).asInt());
        configuration.setJournalMinFiles(CommonAttributes.JOURNAL_MIN_FILES.resolveModelAttribute(context, model).asInt());
        configuration.setJournalSyncNonTransactional(CommonAttributes.JOURNAL_SYNC_NON_TRANSACTIONAL.resolveModelAttribute(context, model).asBoolean());
        configuration.setJournalSyncTransactional(CommonAttributes.JOURNAL_SYNC_TRANSACTIONAL.resolveModelAttribute(context, model).asBoolean());
        configuration.setLogJournalWriteRate(CommonAttributes.LOG_JOURNAL_WRITE_RATE.resolveModelAttribute(context, model).asBoolean());
        configuration.setMaxSavedReplicatedJournalSize(CommonAttributes.MAX_SAVED_REPLICATED_JOURNAL_SIZE.resolveModelAttribute(context, model).asInt());
        configuration.setManagementAddress(SimpleString.toSimpleString((String)CommonAttributes.MANAGEMENT_ADDRESS.resolveModelAttribute(context, model).asString()));
        configuration.setManagementNotificationAddress(SimpleString.toSimpleString((String)CommonAttributes.MANAGEMENT_NOTIFICATION_ADDRESS.resolveModelAttribute(context, model).asString()));
        configuration.setMemoryMeasureInterval(CommonAttributes.MEMORY_MEASURE_INTERVAL.resolveModelAttribute(context, model).asLong());
        configuration.setMemoryWarningThreshold(CommonAttributes.MEMORY_WARNING_THRESHOLD.resolveModelAttribute(context, model).asInt());
        configuration.setMessageCounterEnabled(CommonAttributes.STATISTICS_ENABLED.resolveModelAttribute(context, model).asBoolean());
        configuration.setMessageCounterSamplePeriod((long)CommonAttributes.MESSAGE_COUNTER_SAMPLE_PERIOD.resolveModelAttribute(context, model).asInt());
        configuration.setMessageCounterMaxDayHistory(CommonAttributes.MESSAGE_COUNTER_MAX_DAY_HISTORY.resolveModelAttribute(context, model).asInt());
        configuration.setMessageExpiryScanPeriod(CommonAttributes.MESSAGE_EXPIRY_SCAN_PERIOD.resolveModelAttribute(context, model).asLong());
        configuration.setMessageExpiryThreadPriority(CommonAttributes.MESSAGE_EXPIRY_THREAD_PRIORITY.resolveModelAttribute(context, model).asInt());
        configuration.setJournalPerfBlastPages(CommonAttributes.PERF_BLAST_PAGES.resolveModelAttribute(context, model).asInt());
        configuration.setPersistDeliveryCountBeforeDelivery(CommonAttributes.PERSIST_DELIVERY_COUNT_BEFORE_DELIVERY.resolveModelAttribute(context, model).asBoolean());
        configuration.setPageMaxConcurrentIO(CommonAttributes.PAGE_MAX_CONCURRENT_IO.resolveModelAttribute(context, model).asInt());
        configuration.setPersistenceEnabled(CommonAttributes.PERSISTENCE_ENABLED.resolveModelAttribute(context, model).asBoolean());
        configuration.setPersistIDCache(CommonAttributes.PERSIST_ID_CACHE.resolveModelAttribute(context, model).asBoolean());
        configuration.setRunSyncSpeedTest(CommonAttributes.RUN_SYNC_SPEED_TEST.resolveModelAttribute(context, model).asBoolean());
        configuration.setScheduledThreadPoolMaxSize(CommonAttributes.SCHEDULED_THREAD_POOL_MAX_SIZE.resolveModelAttribute(context, model).asInt());
        configuration.setSecurityEnabled(CommonAttributes.SECURITY_ENABLED.resolveModelAttribute(context, model).asBoolean());
        configuration.setSecurityInvalidationInterval(CommonAttributes.SECURITY_INVALIDATION_INTERVAL.resolveModelAttribute(context, model).asLong());
        configuration.setServerDumpInterval(CommonAttributes.SERVER_DUMP_INTERVAL.resolveModelAttribute(context, model).asLong());
        configuration.setSharedStore(CommonAttributes.SHARED_STORE.resolveModelAttribute(context, model).asBoolean());
        configuration.setThreadPoolMaxSize(CommonAttributes.THREAD_POOL_MAX_SIZE.resolveModelAttribute(context, model).asInt());
        configuration.setTransactionTimeout(CommonAttributes.TRANSACTION_TIMEOUT.resolveModelAttribute(context, model).asLong());
        configuration.setTransactionTimeoutScanPeriod(CommonAttributes.TRANSACTION_TIMEOUT_SCAN_PERIOD.resolveModelAttribute(context, model).asLong());
        configuration.setWildcardRoutingEnabled(CommonAttributes.WILD_CARD_ROUTING_ENABLED.resolveModelAttribute(context, model).asBoolean());
        HornetQServerAdd.processAddressSettings(context, (Configuration)configuration, model);
        HornetQServerAdd.processSecuritySettings(context, (Configuration)configuration, model);
        HornetQServerAdd.processRemotingInterceptors(context, (Configuration)configuration, model);
        HornetQServerAdd.processRemotingIncomingInterceptors(context, (Configuration)configuration, model);
        HornetQServerAdd.processRemotingOutgoingInterceptors(context, (Configuration)configuration, model);
        GroupingHandlerAdd.addGroupingHandlerConfig(context, (Configuration)configuration, model);
        DiscoveryGroupAdd.addDiscoveryGroupConfigs(context, (Configuration)configuration, model);
        DivertAdd.addDivertConfigs(context, (Configuration)configuration, model);
        QueueAdd.addQueueConfigs(context, (Configuration)configuration, model);
        BridgeAdd.addBridgeConfigs(context, (Configuration)configuration, model);
        ClusterConnectionAdd.addClusterConnectionConfigs(context, (Configuration)configuration, model);
        ConnectorServiceDefinition.addConnectorServiceConfigs(context, (Configuration)configuration, model);
        return configuration;
    }

    static void processAddressSettings(OperationContext context, Configuration configuration, ModelNode params) throws OperationFailedException {
        if (params.hasDefined("address-setting")) {
            for (Property property : params.get("address-setting").asPropertyList()) {
                String match = property.getName();
                ModelNode config = property.getValue();
                AddressSettings settings = AddressSettingAdd.createSettings(context, config);
                configuration.getAddressesSettings().put(match, settings);
            }
        }
    }

    static void processRemotingInterceptors(OperationContext context, Configuration configuration, ModelNode params) {
        ModelNode interceptors = params.get(CommonAttributes.REMOTING_INTERCEPTORS.getName());
        if (interceptors.isDefined()) {
            ArrayList<String> interceptorClassNames = new ArrayList<String>();
            for (ModelNode child : interceptors.asList()) {
                interceptorClassNames.add(child.asString());
            }
            configuration.setIncomingInterceptorClassNames(interceptorClassNames);
        }
    }

    static void processRemotingIncomingInterceptors(OperationContext context, Configuration configuration, ModelNode params) {
        ModelNode interceptors = params.get(CommonAttributes.REMOTING_INCOMING_INTERCEPTORS.getName());
        if (interceptors.isDefined()) {
            ArrayList<String> interceptorClassNames = new ArrayList<String>();
            for (ModelNode child : interceptors.asList()) {
                interceptorClassNames.add(child.asString());
            }
            configuration.setIncomingInterceptorClassNames(interceptorClassNames);
        }
    }

    static void processRemotingOutgoingInterceptors(OperationContext context, Configuration configuration, ModelNode params) {
        ModelNode interceptors = params.get(CommonAttributes.REMOTING_OUTGOING_INTERCEPTORS.getName());
        if (interceptors.isDefined()) {
            ArrayList<String> interceptorClassNames = new ArrayList<String>();
            for (ModelNode child : interceptors.asList()) {
                interceptorClassNames.add(child.asString());
            }
            configuration.setOutgoingInterceptorClassNames(interceptorClassNames);
        }
    }

    static void processSecuritySettings(OperationContext context, Configuration configuration, ModelNode params) throws OperationFailedException {
        if (params.get("security-setting").isDefined()) {
            for (Property property : params.get("security-setting").asPropertyList()) {
                String match = property.getName();
                ModelNode config = property.getValue();
                if (!config.hasDefined("role")) continue;
                HashSet<Role> roles = new HashSet<Role>();
                for (Property role : config.get("role").asPropertyList()) {
                    roles.add(SecurityRoleDefinition.transform(context, role.getName(), role.getValue()));
                }
                configuration.getSecurityRoles().put(match, roles);
            }
        }
    }
}

