/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.deployment;

import io.undertow.server.ExchangeCompletionListener;
import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import org.wildfly.extension.requestcontroller.ControlPoint;
import org.wildfly.extension.requestcontroller.RunResult;

public class GlobalRequestControllerHandler
implements HttpHandler {
    private final HttpHandler next;
    private final ControlPoint entryPoint;
    private final ExchangeCompletionListener listener = new ExchangeCompletionListener(){

        public void exchangeEvent(HttpServerExchange exchange, ExchangeCompletionListener.NextListener nextListener) {
            GlobalRequestControllerHandler.this.entryPoint.requestComplete();
            nextListener.proceed();
        }
    };

    public GlobalRequestControllerHandler(HttpHandler next, ControlPoint entryPoint) {
        this.next = next;
        this.entryPoint = entryPoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        RunResult result = this.entryPoint.beginRequest();
        try {
            if (result == RunResult.RUN) {
                this.next.handleRequest(exchange);
            } else {
                exchange.setResponseCode(503);
                exchange.endExchange();
            }
        }
        finally {
            if (result == RunResult.RUN && (exchange.isComplete() || !exchange.isDispatched())) {
                this.entryPoint.requestComplete();
            } else if (result == RunResult.RUN) {
                exchange.addExchangeCompleteListener(this.listener);
            }
        }
    }

    public static HandlerWrapper wrapper(final ControlPoint entryPoint) {
        return new HandlerWrapper(){

            public HttpHandler wrap(HttpHandler handler) {
                return new GlobalRequestControllerHandler(handler, entryPoint);
            }
        };
    }
}

