/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security;

import java.util.Set;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.access.Authorizer;
import org.jboss.as.controller.access.Caller;
import org.jboss.as.controller.access.rbac.RunAsRoleMapper;
import org.jboss.as.controller.descriptions.common.ControllerResolver;
import org.jboss.as.domain.management.logging.DomainManagementLogger;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class WhoAmIOperation
implements OperationStepHandler {
    private static final SimpleAttributeDefinition VERBOSE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("verbose", ModelType.BOOLEAN).setAllowNull(true)).setDefaultValue(new ModelNode(false))).build();
    public static final SimpleOperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("whoami", ControllerResolver.getResolver((String[])new String[]{"core", "management"})).setParameters(new AttributeDefinition[]{VERBOSE}).setReadOnly().setReplyType(ModelType.STRING).build();
    private final Authorizer authorizer;

    private WhoAmIOperation(Authorizer authorizer) {
        this.authorizer = authorizer;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        boolean verbose = VERBOSE.resolveModelAttribute(context, operation).asBoolean();
        Caller caller = context.getCaller();
        if (caller == null) {
            throw new OperationFailedException(DomainManagementLogger.ROOT_LOGGER.noSecurityContextEstablished());
        }
        ModelNode result = context.getResult();
        ModelNode identity = result.get("identity");
        identity.get("username").set(caller.getName());
        String realm = caller.getRealm();
        if (realm != null) {
            identity.get("realm").set(realm);
        }
        if (verbose) {
            Set mappedRoles;
            Set roleSet;
            Set groupSet = caller.getAssociatedGroups();
            if (groupSet.size() > 0) {
                ModelNode groups = result.get("groups");
                for (String current : groupSet) {
                    groups.add(current);
                }
            }
            if ((roleSet = caller.getAssociatedRoles()).size() > 0) {
                ModelNode roles = result.get("roles");
                for (String current : roleSet) {
                    roles.add(current);
                }
            }
            Set set = mappedRoles = this.authorizer == null ? null : this.authorizer.getCallerRoles(context.getCaller(), context.getCallEnvironment(), RunAsRoleMapper.getOperationHeaderRoles((ModelNode)operation));
            if (mappedRoles != null) {
                ModelNode roles = result.get("mapped-roles");
                for (String current : mappedRoles) {
                    roles.add(current);
                }
            }
        }
        context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
    }

    public static OperationStepHandler createOperation(Authorizer authorizer) {
        return new WhoAmIOperation(authorizer);
    }
}

