/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.picketlink.idm.IDMInternalMessages;
import org.picketlink.idm.config.AbstractIdentityStoreConfiguration;
import org.picketlink.idm.config.FileIdentityStoreConfiguration;
import org.picketlink.idm.config.IdentityConfiguration;
import org.picketlink.idm.config.IdentityStoreConfiguration;
import org.picketlink.idm.config.JDBCIdentityStoreConfiguration;
import org.picketlink.idm.config.JPAIdentityStoreConfiguration;
import org.picketlink.idm.config.LDAPIdentityStoreConfiguration;
import org.picketlink.idm.config.TokenStoreConfiguration;
import org.picketlink.idm.credential.handler.annotations.SupportsCredentials;
import org.picketlink.idm.credential.storage.CredentialStorage;
import org.picketlink.idm.file.internal.FileIdentityStore;
import org.picketlink.idm.internal.PartitionManagerConfiguration;
import org.picketlink.idm.internal.util.RelationshipMetadata;
import org.picketlink.idm.jdbc.internal.JDBCIdentityStore;
import org.picketlink.idm.jpa.internal.JPAIdentityStore;
import org.picketlink.idm.ldap.internal.LDAPIdentityStore;
import org.picketlink.idm.model.AttributedType;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Partition;
import org.picketlink.idm.model.Relationship;
import org.picketlink.idm.model.annotation.IdentityPartition;
import org.picketlink.idm.permission.acl.spi.PermissionStore;
import org.picketlink.idm.spi.AttributeStore;
import org.picketlink.idm.spi.CredentialStore;
import org.picketlink.idm.spi.IdentityContext;
import org.picketlink.idm.spi.IdentityStore;
import org.picketlink.idm.spi.PartitionStore;
import org.picketlink.idm.spi.StoreSelector;
import org.picketlink.idm.token.internal.TokenIdentityStore;
import org.picketlink.idm.util.IDMUtil;

public class DefaultStoreSelector
implements StoreSelector {
    private final PartitionManagerConfiguration configuration;
    private RelationshipMetadata relationshipMetadata = new RelationshipMetadata();
    private final Map<Partition, IdentityConfiguration> partitionConfigurations = new ConcurrentHashMap<Partition, IdentityConfiguration>();
    private final Map<IdentityConfiguration, Map<IdentityStoreConfiguration, IdentityStore<?>>> stores;
    private final Map<String, Map<Class<? extends IdentityType>, Set<IdentityStoreConfiguration>>> identityQueryStoresCache = new ConcurrentHashMap<String, Map<Class<? extends IdentityType>, Set<IdentityStoreConfiguration>>>();
    private final Map<String, Map<Class<?>, IdentityStoreConfiguration>> credentialStoresCache = new ConcurrentHashMap();

    public DefaultStoreSelector(PartitionManagerConfiguration configuration) {
        this.configuration = configuration;
        HashMap configuredStores = new HashMap();
        for (IdentityConfiguration config : this.configuration.getConfigurations()) {
            HashMap storeMap = new HashMap();
            for (IdentityStoreConfiguration storeConfig : config.getStoreConfiguration()) {
                storeMap.put(storeConfig, this.createIdentityStore(storeConfig));
            }
            configuredStores.put(config, Collections.unmodifiableMap(storeMap));
        }
        this.stores = Collections.unmodifiableMap(configuredStores);
    }

    public <T extends IdentityStore<?>> T getStoreForIdentityOperation(IdentityContext context, Class<T> storeType, Class<? extends AttributedType> type, IdentityStoreConfiguration.IdentityOperation operation) {
        this.checkSupportedTypes(context.getPartition(), type);
        IdentityConfiguration identityConfiguration = this.getConfigurationForPartition(context, context.getPartition());
        T identityStore = this.lookupStore(context, identityConfiguration, type, operation);
        if (identityStore == null) {
            throw IDMInternalMessages.MESSAGES.attributedTypeUnsupportedOperation(type, operation, type, operation);
        }
        return identityStore;
    }

    public Set<IdentityStore<?>> getStoresForIdentityQuery(IdentityContext context, Class<? extends IdentityType> identityType) {
        Set<IdentityStoreConfiguration> storeConfigs;
        IdentityConfiguration identityConfiguration = this.getConfigurationForPartition(context, context.getPartition());
        Map<Class<? extends IdentityType>, Set<IdentityStoreConfiguration>> cachedStoresForType = this.identityQueryStoresCache.get(context.getPartition().getName());
        if (cachedStoresForType != null && (storeConfigs = cachedStoresForType.get(identityType)) != null) {
            HashSet identityStores = new HashSet();
            for (IdentityStoreConfiguration storeConfig : storeConfigs) {
                identityStores.add((IdentityStore<?>)this.getIdentityStoreAndInitializeContext(context, identityConfiguration, storeConfig));
            }
            return identityStores;
        }
        HashSet identityStores = new HashSet();
        HashSet<IdentityStoreConfiguration> identityStoresConfig = new HashSet<IdentityStoreConfiguration>();
        cachedStoresForType = new HashMap<Class<? extends IdentityType>, Set<IdentityStoreConfiguration>>();
        cachedStoresForType.put(identityType, identityStoresConfig);
        for (IdentityStoreConfiguration storeConfig : identityConfiguration.getStoreConfiguration()) {
            if (!storeConfig.supportsType(identityType, IdentityStoreConfiguration.IdentityOperation.read)) continue;
            identityStores.add((IdentityStore<?>)this.getIdentityStoreAndInitializeContext(context, identityConfiguration, storeConfig));
            identityStoresConfig.add(storeConfig);
        }
        if (identityStores.isEmpty()) {
            throw IDMInternalMessages.MESSAGES.attributedTypeUnsupportedOperation(identityType, IdentityStoreConfiguration.IdentityOperation.read, identityType, IdentityStoreConfiguration.IdentityOperation.read);
        }
        this.identityQueryStoresCache.put(context.getPartition().getName(), cachedStoresForType);
        return identityStores;
    }

    public <T extends CredentialStore<?>> T getStoreForCredentialOperation(IdentityContext context, Class<?> credentialClass) {
        CredentialStore store = null;
        IdentityConfiguration identityConfiguration = this.getConfigurationForPartition(context, context.getPartition());
        if (identityConfiguration == null) {
            for (IdentityConfiguration configuration : this.configuration.getConfigurations()) {
                for (IdentityStoreConfiguration storeConfig : configuration.getStoreConfiguration()) {
                    if (!storeConfig.supportsCredential()) continue;
                    identityConfiguration = configuration;
                }
            }
        }
        if (identityConfiguration != null) {
            IdentityStoreConfiguration storeConfig;
            Map<Class<?>, IdentityStoreConfiguration> cachedStoresForType = this.credentialStoresCache.get(context.getPartition().getName());
            if (cachedStoresForType != null && (storeConfig = cachedStoresForType.get(credentialClass)) != null) {
                return (T)((CredentialStore)this.getIdentityStoreAndInitializeContext(context, identityConfiguration, storeConfig));
            }
            if (identityConfiguration.supportsCredential()) {
                for (IdentityStoreConfiguration storeConfig2 : identityConfiguration.getStoreConfiguration()) {
                    if (!storeConfig2.supportsCredential()) continue;
                    for (Class handlerClass : storeConfig2.getCredentialHandlers()) {
                        if (!handlerClass.isAnnotationPresent(SupportsCredentials.class)) continue;
                        for (Class cls : handlerClass.getAnnotation(SupportsCredentials.class).credentialClass()) {
                            if (!cls.isAssignableFrom(credentialClass)) continue;
                            T identityStore = this.getIdentityStoreAndInitializeContext(context, identityConfiguration, storeConfig2);
                            try {
                                store = (CredentialStore)identityStore;
                            }
                            catch (ClassCastException cce) {
                                throw IDMInternalMessages.MESSAGES.storeUnexpectedType(CredentialStore.class, identityStore.getClass());
                            }
                            if (!cls.equals(credentialClass)) continue;
                            return (T)store;
                        }
                    }
                }
            }
            cachedStoresForType = new HashMap();
            cachedStoresForType.put(credentialClass, store.getConfig());
            this.credentialStoresCache.put(context.getPartition().getName(), cachedStoresForType);
        }
        if (store == null) {
            throw IDMInternalMessages.MESSAGES.credentialNoStoreForCredentials(credentialClass);
        }
        return (T)store;
    }

    public IdentityStore<?> getStoreForRelationshipOperation(IdentityContext context, Class<? extends Relationship> relationshipClass, Relationship relationship, IdentityStoreConfiguration.IdentityOperation operation) {
        Set<Partition> partitions = this.getRelationshipPartitions(relationship);
        IdentityStore<?> store = null;
        if (partitions.size() == 1) {
            IdentityConfiguration config = this.getConfigurationForPartition(context, partitions.iterator().next());
            if (config.getRelationshipPolicy().isSelfRelationshipSupported(relationshipClass)) {
                for (IdentityStoreConfiguration storeConfig : config.getStoreConfiguration()) {
                    if (!storeConfig.supportsType(relationshipClass, operation)) continue;
                    store = (IdentityStore<?>)this.getIdentityStoreAndInitializeContext(context, config, storeConfig);
                }
            }
        } else {
            for (Partition partition : partitions) {
                IdentityConfiguration config = this.getConfigurationForPartition(context, partition);
                if (!config.getRelationshipPolicy().isGlobalRelationshipSupported(relationshipClass)) continue;
                for (IdentityStoreConfiguration storeConfig : config.getStoreConfiguration()) {
                    if (!storeConfig.supportsType(relationshipClass, operation)) continue;
                    store = (IdentityStore<?>)this.getIdentityStoreAndInitializeContext(context, config, storeConfig);
                }
            }
        }
        if (store == null) {
            for (IdentityConfiguration cfg : this.configuration.getConfigurations()) {
                if (!cfg.getRelationshipPolicy().isGlobalRelationshipSupported(relationshipClass)) continue;
                for (IdentityStoreConfiguration storeConfig : cfg.getStoreConfiguration()) {
                    if (!storeConfig.supportsType(relationshipClass, operation)) continue;
                    store = (IdentityStore<?>)this.getIdentityStoreAndInitializeContext(context, cfg, storeConfig);
                }
            }
        }
        if (store == null) {
            throw IDMInternalMessages.MESSAGES.attributedTypeUnsupportedOperation(relationshipClass, operation, relationshipClass, operation);
        }
        return store;
    }

    public Set<IdentityStore<?>> getStoresForRelationshipQuery(IdentityContext context, Class<? extends Relationship> relationshipClass, Set<Partition> partitions) {
        HashSet identityStores = new HashSet();
        if (partitions.isEmpty()) {
            for (IdentityConfiguration config : this.configuration.getConfigurations()) {
                if (!config.getRelationshipPolicy().isGlobalRelationshipSupported(relationshipClass) && !config.getRelationshipPolicy().isSelfRelationshipSupported(relationshipClass)) continue;
                for (IdentityStoreConfiguration storeConfig : config.getStoreConfiguration()) {
                    if (!storeConfig.supportsType(relationshipClass, IdentityStoreConfiguration.IdentityOperation.create) && !Relationship.class.equals(relationshipClass)) continue;
                    identityStores.add((IdentityStore<?>)this.getIdentityStoreAndInitializeContext(context, config, storeConfig));
                }
            }
        } else {
            for (Partition partition : partitions) {
                IdentityConfiguration config = this.getConfigurationForPartition(context, partition);
                if (!config.getRelationshipPolicy().isGlobalRelationshipSupported(relationshipClass)) continue;
                for (IdentityStoreConfiguration storeConfig : config.getStoreConfiguration()) {
                    if (!storeConfig.supportsType(relationshipClass, IdentityStoreConfiguration.IdentityOperation.create) && !Relationship.class.equals(relationshipClass)) continue;
                    identityStores.add((IdentityStore<?>)this.getIdentityStoreAndInitializeContext(context, config, storeConfig));
                }
            }
        }
        if (identityStores.isEmpty()) {
            throw IDMInternalMessages.MESSAGES.attributedTypeUnsupportedOperation(relationshipClass, IdentityStoreConfiguration.IdentityOperation.read, relationshipClass, IdentityStoreConfiguration.IdentityOperation.read);
        }
        return identityStores;
    }

    public <T extends PartitionStore<?>> T getStoreForPartitionOperation(IdentityContext context, Class<? extends Partition> partitionClass) {
        IdentityConfiguration partitionManagementConfig = this.configuration.getPartitionManagementConfig();
        Map<IdentityStoreConfiguration, IdentityStore<?>> configStores = this.stores.get(partitionManagementConfig);
        for (IdentityStoreConfiguration cfg : configStores.keySet()) {
            if (!cfg.supportsType(partitionClass, IdentityStoreConfiguration.IdentityOperation.create)) continue;
            PartitionStore store = (PartitionStore)this.getIdentityStoreAndInitializeContext(context, partitionManagementConfig, cfg);
            if (!PartitionStore.class.isInstance(store)) {
                throw IDMInternalMessages.MESSAGES.storeUnexpectedType(store.getClass(), PartitionStore.class);
            }
            return (T)store;
        }
        throw IDMInternalMessages.MESSAGES.storeNotFound(PartitionStore.class, partitionClass);
    }

    public <T extends AttributeStore<?>> T getStoreForAttributeOperation(IdentityContext context) {
        IdentityConfiguration attributeManagementConfig = this.configuration.getAttributeManagementConfig();
        if (attributeManagementConfig != null) {
            Map<IdentityStoreConfiguration, IdentityStore<?>> configStores = this.stores.get(attributeManagementConfig);
            for (IdentityStoreConfiguration cfg : configStores.keySet()) {
                if (!cfg.supportsAttribute()) continue;
                AttributeStore store = (AttributeStore)this.getIdentityStoreAndInitializeContext(context, attributeManagementConfig, cfg);
                if (!AttributeStore.class.isInstance(store)) {
                    throw IDMInternalMessages.MESSAGES.storeUnexpectedType(store.getClass(), AttributeStore.class);
                }
                return (T)store;
            }
        }
        return null;
    }

    public Set<CredentialStore<?>> getStoresForCredentialStorage(IdentityContext context, Class<? extends CredentialStorage> storageClass) {
        IdentityConfiguration identityConfiguration = this.getConfigurationForPartition(context, context.getPartition());
        Map<IdentityStoreConfiguration, IdentityStore<?>> storesConfig = this.stores.get(identityConfiguration);
        HashSet credentialStores = new HashSet();
        if (storesConfig != null) {
            for (IdentityStoreConfiguration storeConfig : storesConfig.keySet()) {
                if (!storeConfig.supportsCredential()) continue;
                for (Class credentialHandler : storeConfig.getCredentialHandlers()) {
                    SupportsCredentials supportedCredentials = credentialHandler.getAnnotation(SupportsCredentials.class);
                    if (supportedCredentials == null || !supportedCredentials.credentialStorage().equals(storageClass)) continue;
                    CredentialStore credentialStore = (CredentialStore)this.getIdentityStoreAndInitializeContext(context, identityConfiguration, storeConfig);
                    credentialStores.add(credentialStore);
                }
            }
        }
        return credentialStores;
    }

    public PermissionStore getStoreForPermissionOperation(IdentityContext context) {
        IdentityConfiguration identityConfiguration = this.getConfigurationForPartition(context, context.getPartition());
        if (identityConfiguration == null) {
            for (IdentityConfiguration configuration : this.configuration.getConfigurations()) {
                for (IdentityStoreConfiguration storeConfig : configuration.getStoreConfiguration()) {
                    if (!storeConfig.supportsPermissions()) continue;
                    return (PermissionStore)this.getIdentityStoreAndInitializeContext(context, configuration, storeConfig);
                }
            }
        } else {
            for (IdentityStoreConfiguration storeConfig : identityConfiguration.getStoreConfiguration()) {
                if (!storeConfig.supportsPermissions()) continue;
                return (PermissionStore)this.getIdentityStoreAndInitializeContext(context, identityConfiguration, storeConfig);
            }
        }
        return null;
    }

    private <T extends IdentityStore> T createIdentityStore(IdentityStoreConfiguration storeConfiguration) {
        Class storeClass = storeConfiguration.getIdentityStoreType();
        if (storeClass == null) {
            if (FileIdentityStoreConfiguration.class.isInstance(storeConfiguration)) {
                storeClass = FileIdentityStore.class;
            } else if (JPAIdentityStoreConfiguration.class.isInstance(storeConfiguration)) {
                storeClass = JPAIdentityStore.class;
            } else if (LDAPIdentityStoreConfiguration.class.isInstance(storeConfiguration)) {
                storeClass = LDAPIdentityStore.class;
            } else if (JDBCIdentityStoreConfiguration.class.isInstance(storeConfiguration)) {
                storeClass = JDBCIdentityStore.class;
            } else if (TokenStoreConfiguration.class.isInstance(storeConfiguration)) {
                storeClass = TokenIdentityStore.class;
            }
        }
        if (storeClass == null) {
            throw IDMInternalMessages.MESSAGES.configUnknownStoreForConfiguration(storeConfiguration);
        }
        try {
            if (storeConfiguration instanceof AbstractIdentityStoreConfiguration) {
                ((AbstractIdentityStoreConfiguration)storeConfiguration).setIdentityStoreType(storeClass);
            }
            IdentityStore store = (IdentityStore)storeClass.newInstance();
            store.setup(storeConfiguration);
            return (T)store;
        }
        catch (Exception ex) {
            throw IDMInternalMessages.MESSAGES.configCouldNotCreateStore(storeClass, storeConfiguration, ex);
        }
    }

    public <T extends IdentityStore<?>> T lookupStore(IdentityContext context, IdentityConfiguration configuration, Class<? extends AttributedType> type, IdentityStoreConfiguration.IdentityOperation operation) {
        for (IdentityStoreConfiguration storeConfig : configuration.getStoreConfiguration()) {
            if (!storeConfig.supportsType(type, operation)) continue;
            return this.getIdentityStoreAndInitializeContext(context, configuration, storeConfig);
        }
        return null;
    }

    private <T extends IdentityStore<?>> T getIdentityStoreAndInitializeContext(IdentityContext context, IdentityConfiguration configuration, IdentityStoreConfiguration storeConfig) {
        IdentityStore<?> store = this.stores.get(configuration).get(storeConfig);
        storeConfig.initializeContext(context, store);
        return (T)store;
    }

    private void checkSupportedTypes(Partition partition, Class<? extends AttributedType> type) {
        IdentityPartition identityPartition;
        if (partition != null && IdentityType.class.isAssignableFrom(type) && (identityPartition = partition.getClass().getAnnotation(IdentityPartition.class)) != null && IDMUtil.isTypeSupported(type, (Set)IDMUtil.toSet((Object[])identityPartition.supportedTypes()), (Set)IDMUtil.toSet((Object[])identityPartition.unsupportedTypes())) == -1) {
            throw IDMInternalMessages.MESSAGES.partitionUnsupportedType(partition, type);
        }
    }

    IdentityConfiguration getConfigurationForPartition(IdentityContext identityContext, Partition partition) {
        IdentityConfiguration identityConfiguration;
        Collection<IdentityConfiguration> configurations;
        IdentityConfiguration partitionManagementConfig = this.configuration.getPartitionManagementConfig();
        if (partitionManagementConfig == null && (configurations = this.configuration.getConfigurations()).size() == 1) {
            return configurations.iterator().next();
        }
        if (!this.partitionConfigurations.containsKey(partition)) {
            Object store = this.getStoreForPartitionOperation(identityContext, partition.getClass());
            this.partitionConfigurations.put(partition, this.configuration.getConfigurationByName(store.getConfigurationName(identityContext, partition)));
        }
        if ((identityConfiguration = this.partitionConfigurations.get(partition)) == null) {
            throw IDMInternalMessages.MESSAGES.partitionReferencesInvalidConfiguration(partition);
        }
        return identityConfiguration;
    }

    private Set<Partition> getRelationshipPartitions(Relationship relationship) {
        return this.relationshipMetadata.getRelationshipPartitions(relationship);
    }
}

