/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.protocol;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.annotation.ClientListener;
import org.infinispan.client.hotrod.event.ClientEvent;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.client.hotrod.exceptions.InvalidResponseException;
import org.infinispan.client.hotrod.exceptions.RemoteNodeSuspectException;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.protocol.HeaderParams;
import org.infinispan.client.hotrod.impl.transport.Transport;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.util.Either;
import org.infinispan.commons.util.Util;

public class Codec10
implements Codec {
    private static final Log log = LogFactory.getLog(Codec10.class, Log.class);
    static final AtomicLong MSG_ID = new AtomicLong();

    @Override
    public HeaderParams writeHeader(Transport transport, HeaderParams params) {
        return this.writeHeader(transport, params, (byte)10);
    }

    @Override
    public void writeClientListenerParams(Transport transport, ClientListener clientListener, byte[][] filterFactoryParams, byte[][] converterFactoryParams) {
    }

    protected HeaderParams writeHeader(Transport transport, HeaderParams params, byte version) {
        transport.writeByte((short)160);
        transport.writeVLong(params.messageId((long)Codec10.MSG_ID.incrementAndGet()).messageId);
        transport.writeByte(version);
        transport.writeByte(params.opCode);
        transport.writeArray(params.cacheName);
        int flagInt = 0;
        if (params.flags != null) {
            for (Flag flag : params.flags) {
                if (!flag.equals((Object)Flag.FORCE_RETURN_VALUE)) continue;
                flagInt = flag.getFlagInt();
            }
        }
        transport.writeVInt(flagInt);
        transport.writeByte(params.clientIntel);
        transport.writeVInt(params.topologyId.get());
        transport.writeByte(params.txMarker);
        this.getLog().tracef("Wrote header for message %d. Operation code: %#04x. Flags: %#x", params.messageId, params.opCode, flagInt);
        return params;
    }

    @Override
    public short readHeader(Transport transport, HeaderParams params) {
        short magic = transport.readByte();
        Log localLog = this.getLog();
        boolean isTrace = localLog.isTraceEnabled();
        if (magic != 161) {
            String message = "Invalid magic number. Expected %#x and received %#x";
            localLog.invalidMagicNumber((short)161, magic);
            if (isTrace) {
                localLog.tracef("Socket dump: %s", Util.hexDump((byte[])transport.dumpStream()));
            }
            throw new InvalidResponseException(String.format(message, (short)161, magic));
        }
        long receivedMessageId = transport.readVLong();
        if (receivedMessageId != params.messageId && receivedMessageId != 0L) {
            String message = "Invalid message id. Expected %d and received %d";
            localLog.invalidMessageId(params.messageId, receivedMessageId);
            if (isTrace) {
                localLog.tracef("Socket dump: %s", Util.hexDump((byte[])transport.dumpStream()));
            }
            throw new InvalidResponseException(String.format(message, params.messageId, receivedMessageId));
        }
        localLog.tracef("Received response for message id: %d", receivedMessageId);
        short receivedOpCode = transport.readByte();
        short status = transport.readByte();
        this.readNewTopologyIfPresent(transport, params);
        if (receivedOpCode != params.opRespCode) {
            if (receivedOpCode == 80) {
                this.checkForErrorsInResponseStatus(transport, params, status);
            }
            throw new InvalidResponseException(String.format("Invalid response operation. Expected %#x and received %#x", params.opRespCode, receivedOpCode));
        }
        localLog.tracef("Received operation code is: %#04x", receivedOpCode);
        return status;
    }

    @Override
    public ClientEvent readEvent(Transport transport, byte[] expectedListenerId, Marshaller marshaller) {
        return null;
    }

    @Override
    public Either<Short, ClientEvent> readHeaderOrEvent(Transport transport, HeaderParams params, byte[] expectedListenerId, Marshaller marshaller) {
        return null;
    }

    @Override
    public byte[] returnPossiblePrevValue(Transport transport, short status, Flag[] flags) {
        if (this.hasForceReturn(flags)) {
            byte[] bytes = transport.readArray();
            if (log.isTraceEnabled()) {
                log.tracef("Previous value bytes is: %s", Util.printArray((byte[])bytes, (boolean)false));
            }
            return bytes.length == 0 ? null : bytes;
        }
        return null;
    }

    private boolean hasForceReturn(Flag[] flags) {
        if (flags == null) {
            return false;
        }
        for (Flag flag : flags) {
            if (flag != Flag.FORCE_RETURN_VALUE) continue;
            return true;
        }
        return false;
    }

    @Override
    public Log getLog() {
        return log;
    }

    protected void checkForErrorsInResponseStatus(Transport transport, HeaderParams params, short status) {
        Log localLog = this.getLog();
        boolean isTrace = localLog.isTraceEnabled();
        if (isTrace) {
            localLog.tracef("Received operation status: %#x", status);
        }
        try {
            switch (status) {
                case 129: 
                case 130: 
                case 131: 
                case 132: 
                case 133: 
                case 134: {
                    String msgFromServer = transport.readString();
                    if (status == 134 && isTrace) {
                        localLog.tracef("Server-side timeout performing operation: %s", msgFromServer);
                    }
                    if (msgFromServer.contains("SuspectException") || msgFromServer.contains("SuspectedException")) {
                        if (isTrace) {
                            localLog.tracef("A remote node was suspected while executing messageId=%d. Check if retry possible. Message from server: %s", params.messageId, msgFromServer);
                        }
                        throw new RemoteNodeSuspectException(msgFromServer, params.messageId, status);
                    }
                    localLog.errorFromServer(msgFromServer);
                    throw new HotRodClientException(msgFromServer, params.messageId, status);
                }
            }
            throw new IllegalStateException(String.format("Unknown status: %#04x", status));
        }
        catch (Throwable throwable) {
            switch (status) {
                case 129: 
                case 130: 
                case 131: 
                case 132: {
                    transport.invalidate();
                }
            }
            throw throwable;
        }
    }

    protected void readNewTopologyIfPresent(Transport transport, HeaderParams params) {
        short topologyChangeByte = transport.readByte();
        if (topologyChangeByte == 1) {
            this.readNewTopologyAndHash(transport, params.topologyId, params.cacheName);
        }
    }

    protected void readNewTopologyAndHash(Transport transport, AtomicInteger topologyId, byte[] cacheName) {
        Log localLog = this.getLog();
        int newTopologyId = transport.readVInt();
        topologyId.set(newTopologyId);
        int numKeyOwners = transport.readUnsignedShort();
        short hashFunctionVersion = transport.readByte();
        int hashSpace = transport.readVInt();
        int clusterSize = transport.readVInt();
        Map<SocketAddress, Set<Integer>> servers2Hash = this.computeNewHashes(transport, localLog, newTopologyId, numKeyOwners, hashFunctionVersion, hashSpace, clusterSize);
        Set<SocketAddress> socketAddresses = servers2Hash.keySet();
        if (localLog.isInfoEnabled()) {
            localLog.newTopology(transport.getRemoteSocketAddress(), newTopologyId, socketAddresses.size(), socketAddresses);
        }
        transport.getTransportFactory().updateServers(socketAddresses, cacheName);
        if (hashFunctionVersion == 0) {
            localLog.trace("Not using a consistent hash function (hash function version == 0).");
        } else {
            transport.getTransportFactory().updateHashFunction(servers2Hash, numKeyOwners, hashFunctionVersion, hashSpace, cacheName);
        }
    }

    protected Map<SocketAddress, Set<Integer>> computeNewHashes(Transport transport, Log localLog, int newTopologyId, int numKeyOwners, short hashFunctionVersion, int hashSpace, int clusterSize) {
        if (localLog.isTraceEnabled()) {
            localLog.tracef("Topology change request: newTopologyId=%d, numKeyOwners=%d, hashFunctionVersion=%d, hashSpaceSize=%d, clusterSize=%d", new Object[]{newTopologyId, numKeyOwners, hashFunctionVersion, hashSpace, clusterSize});
        }
        LinkedHashMap<SocketAddress, Set<Integer>> servers2Hash = new LinkedHashMap<SocketAddress, Set<Integer>>();
        for (int i = 0; i < clusterSize; ++i) {
            String host = transport.readString();
            int port = transport.readUnsignedShort();
            int hashCode = transport.read4ByteInt();
            localLog.tracef("Server read: %s:%d - hash code is %d", host, port, hashCode);
            InetSocketAddress address = new InetSocketAddress(host, port);
            HashSet<Integer> hashes = (HashSet<Integer>)servers2Hash.get(address);
            if (hashes == null) {
                hashes = new HashSet<Integer>();
                servers2Hash.put(address, hashes);
            }
            hashes.add(hashCode);
            localLog.tracef("Hash code is: %d", hashCode);
        }
        return servers2Hash;
    }
}

