/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.logging;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.infinispan.client.hotrod.event.ClientEvent;
import org.infinispan.client.hotrod.event.IncorrectClientListenerException;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.client.hotrod.impl.transport.tcp.TcpTransport;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.CacheListenerException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;

@MessageLogger(projectCode="ISPN")
public interface Log
extends BasicLogger {
    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Could not find '%s' file in classpath, using defaults.", id=4001)
    public void couldNotFindPropertiesFile(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Cannot perform operations on a cache associated with an unstarted RemoteCacheManager. Use RemoteCacheManager.start before using the remote cache.", id=4002)
    public void unstartedRemoteCacheManager();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Invalid magic number. Expected %#x and received %#x", id=4003)
    public void invalidMagicNumber(short var1, short var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Invalid message id. Expected %d and received %d", id=4004)
    public void invalidMessageId(long var1, long var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Error received from the server: %s", id=4005)
    public void errorFromServer(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="%s sent new topology view (id=%d) containing %d addresses: %s", id=4006)
    public void newTopology(SocketAddress var1, int var2, int var3, Set<SocketAddress> var4);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Exception encountered. Retry %d out of %d", id=4007)
    public void exceptionAndNoRetriesLeft(int var1, int var2, @Cause HotRodClientException var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Issues closing socket for %s: %s", id=4009)
    public void errorClosingSocket(TcpTransport var1, IOException var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Exception while shutting down the connection pool.", id=4010)
    public void errorClosingConnectionPool(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="No hash function configured for version: %d", id=4011)
    public void noHasHFunctionConfigured(int var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Could not invalidate connection: %s", id=4012)
    public void couldNoInvalidateConnection(TcpTransport var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Could not release connection: %s", id=4013)
    public void couldNotReleaseConnection(TcpTransport var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="New server added(%s), adding to the pool.", id=4014)
    public void newServerAdded(SocketAddress var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Failed adding new server %s", id=4015)
    public void failedAddingNewServer(SocketAddress var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Server not in cluster anymore(%s), removing from the pool.", id=4016)
    public void removingServer(SocketAddress var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Unable to convert string property [%s] to an int! Using default value of %d", id=4018)
    public void unableToConvertStringPropertyToInt(String var1, int var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Unable to convert string property [%s] to a long! Using default value of %d", id=4019)
    public void unableToConvertStringPropertyToLong(String var1, long var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Unable to convert string property [%s] to a boolean! Using default value of %b", id=4020)
    public void unableToConvertStringPropertyToBoolean(String var1, boolean var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Infinispan version: %s", id=4021)
    public void version(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Unable to invalidate transport for server: %s", id=4022)
    public void unableToInvalidateTransport(SocketAddress var1);

    @Message(value="SSL Enabled but no KeyStore specified", id=4023)
    public CacheConfigurationException noSSLKeyManagerConfiguration();

    @Message(value="SSL Enabled but no TrustStore specified", id=4024)
    public CacheConfigurationException noSSLTrustManagerConfiguration();

    @Message(value="A password is required to open the KeyStore '%s'", id=4025)
    public CacheConfigurationException missingKeyStorePassword(String var1);

    @Message(value="A password is required to open the TrustStore '%s'", id=4026)
    public CacheConfigurationException missingTrustStorePassword(String var1);

    @Message(value="Cannot configure custom KeyStore and/or TrustStore when specifying a SSLContext", id=4027)
    public CacheConfigurationException xorSSLContext();

    @Message(value="Unable to parse server IP address %s", id=4028)
    public CacheConfigurationException parseErrorServerAddress(String var1);

    @Message(value="Invalid max_retries (value=%s). Value should be greater or equal than zero.", id=4029)
    public CacheConfigurationException invalidMaxRetries(int var1);

    @Message(value="Cannot enable authentication without specifying a Callback Handler or a client Subject", id=4030)
    public CacheConfigurationException invalidCallbackHandler();

    @Message(value="The selected authentication mechanism '%s' is not among the supported server mechanisms: %s", id=4031)
    public SecurityException unsupportedMech(String var1, List<String> var2);

    @Message(value="'%s' is an invalid SASL mechanism", id=4032)
    public CacheConfigurationException invalidSaslMechanism(String var1);

    @Message(value="Connection dedicated to listener with id=%s but received event for listener with id=%s", id=4033)
    public IllegalStateException unexpectedListenerId(String var1, String var2);

    @Message(value="Unable to unmarshall bytes %s", id=4034)
    public HotRodClientException unableToUnmarshallBytes(String var1, @Cause Exception var2);

    @Message(value="Caught exception [%s] while invoking method [%s] on listener instance: %s", id=4035)
    public CacheListenerException exceptionInvokingListener(String var1, Method var2, Object var3, @Cause Throwable var4);

    @Message(value="Methods annotated with %s must accept exactly one parameter, of assignable from type %s", id=4036)
    public IncorrectClientListenerException incorrectClientListener(String var1, Collection<?> var2);

    @Message(value="Methods annotated with %s should have a return type of void.", id=4037)
    public IncorrectClientListenerException incorrectClientListener(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Unexpected error consuming event %s", id=4038)
    public void unexpectedErrorConsumingEvent(ClientEvent var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Unable to complete reading event from server %s", id=4039)
    public void unableToReadEventFromServer(@Cause Throwable var1, SocketAddress var2);

    @Message(value="Cache listener class %s must be annotated with org.infinispan.client.hotrod.annotation.ClientListener", id=4040)
    public IncorrectClientListenerException missingClientListenerAnnotation(String var1);

    @Message(value="Unknown event type %s received", id=4041)
    public HotRodClientException unknownEvent(short var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Unable to set method %s accessible", id=4042)
    public void unableToSetAccesible(Method var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Unrecoverable error reading event from server %s, exiting event reader thread", id=4043)
    public void unrecoverableErrorReadingEvent(@Cause Throwable var1, SocketAddress var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Unable to read %s bytes %s", id=4044)
    public void unableToUnmarshallBytesError(String var1, String var2, @Cause Exception var3);
}

