/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import org.infinispan.configuration.cache.BackupConfiguration;
import org.infinispan.configuration.cache.BackupFailurePolicy;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.jboss.as.clustering.dmr.ModelNodes;
import org.jboss.as.clustering.infinispan.subsystem.AdvancedCacheConfigurationBuilder;
import org.jboss.as.clustering.infinispan.subsystem.BackupForResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.BackupSiteResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.ClusteredCacheAddHandler;
import org.jboss.as.clustering.infinispan.subsystem.StateTransferResourceDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public abstract class SharedStateCacheAddHandler
extends ClusteredCacheAddHandler {
    SharedStateCacheAddHandler(CacheMode mode) {
        super(mode);
    }

    @Override
    void processModelNode(OperationContext context, String containerName, ModelNode containerModel, ModelNode cache, AdvancedCacheConfigurationBuilder configBuilder) throws OperationFailedException {
        ModelNode backupFor;
        ModelNode stateTransfer;
        super.processModelNode(context, containerName, containerModel, cache, configBuilder);
        ConfigurationBuilder builder = configBuilder.getConfigurationBuilder();
        if (cache.hasDefined(StateTransferResourceDefinition.PATH.getKey()) && (stateTransfer = cache.get(StateTransferResourceDefinition.PATH.getKeyValuePair())).isDefined()) {
            builder.clustering().stateTransfer().fetchInMemoryState(StateTransferResourceDefinition.ENABLED.resolveModelAttribute(context, stateTransfer).asBoolean()).timeout(StateTransferResourceDefinition.TIMEOUT.resolveModelAttribute(context, stateTransfer).asLong()).chunkSize(StateTransferResourceDefinition.CHUNK_SIZE.resolveModelAttribute(context, stateTransfer).asInt());
        }
        if (cache.hasDefined(BackupSiteResourceDefinition.WILDCARD_PATH.getKey())) {
            for (Property property : cache.get(BackupSiteResourceDefinition.WILDCARD_PATH.getKey()).asPropertyList()) {
                String siteName = property.getName();
                ModelNode site = property.getValue();
                builder.sites().addBackup().site(siteName).backupFailurePolicy(BackupFailurePolicy.valueOf((String)BackupSiteResourceDefinition.FAILURE_POLICY.resolveModelAttribute(context, site).asString())).strategy(BackupConfiguration.BackupStrategy.valueOf((String)BackupSiteResourceDefinition.STRATEGY.resolveModelAttribute(context, site).asString())).replicationTimeout(BackupSiteResourceDefinition.REPLICATION_TIMEOUT.resolveModelAttribute(context, site).asLong());
                if (!BackupSiteResourceDefinition.ENABLED.resolveModelAttribute(context, site).asBoolean()) continue;
                builder.sites().addInUseBackupSite(siteName);
            }
        }
        if (cache.hasDefined(BackupForResourceDefinition.PATH.getKey()) && (backupFor = cache.get(BackupForResourceDefinition.PATH.getKeyValuePair())).isDefined()) {
            builder.sites().backupFor().remoteCache(ModelNodes.asString((ModelNode)BackupForResourceDefinition.REMOTE_CACHE.resolveModelAttribute(context, backupFor))).remoteSite(ModelNodes.asString((ModelNode)BackupForResourceDefinition.REMOTE_SITE.resolveModelAttribute(context, backupFor)));
        }
    }
}

