/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.sso;

import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.context.Flag;
import org.infinispan.transaction.LockingMode;
import org.infinispan.util.concurrent.IsolationLevel;
import org.jboss.msc.service.AbstractService;
import org.wildfly.clustering.ee.Batcher;
import org.wildfly.clustering.ee.infinispan.InfinispanBatcher;
import org.wildfly.clustering.ee.infinispan.TransactionBatch;
import org.wildfly.clustering.marshalling.MarshalledValueFactory;
import org.wildfly.clustering.marshalling.MarshalledValueMarshaller;
import org.wildfly.clustering.marshalling.MarshallingContext;
import org.wildfly.clustering.marshalling.SimpleMarshalledValueFactory;
import org.wildfly.clustering.marshalling.SimpleMarshallingContext;
import org.wildfly.clustering.marshalling.SimpleMarshallingContextFactory;
import org.wildfly.clustering.marshalling.VersionedMarshallingConfiguration;
import org.wildfly.clustering.web.IdentifierFactory;
import org.wildfly.clustering.web.LocalContextFactory;
import org.wildfly.clustering.web.infinispan.AffinityIdentifierFactory;
import org.wildfly.clustering.web.infinispan.sso.AuthenticationMarshallingContext;
import org.wildfly.clustering.web.infinispan.sso.InfinispanSSOManager;
import org.wildfly.clustering.web.infinispan.sso.InfinispanSSOManagerFactoryConfiguration;
import org.wildfly.clustering.web.infinispan.sso.coarse.CoarseSSOFactory;
import org.wildfly.clustering.web.sso.SSOManager;
import org.wildfly.clustering.web.sso.SSOManagerFactory;

public class InfinispanSSOManagerFactory<A, D>
extends AbstractService<SSOManagerFactory<A, D, TransactionBatch>>
implements SSOManagerFactory<A, D, TransactionBatch> {
    private final InfinispanSSOManagerFactoryConfiguration configuration;

    public InfinispanSSOManagerFactory(InfinispanSSOManagerFactoryConfiguration configuration) {
        this.configuration = configuration;
    }

    public <L> SSOManager<A, D, L, TransactionBatch> createSSOManager(IdentifierFactory<String> identifierFactory, LocalContextFactory<L> localContextFactory) {
        SimpleMarshallingContext marshallingContext = new SimpleMarshallingContextFactory().createMarshallingContext((VersionedMarshallingConfiguration)new AuthenticationMarshallingContext(this.configuration.getModuleLoader()), null);
        SimpleMarshalledValueFactory marshalledValueFactory = new SimpleMarshalledValueFactory((MarshallingContext)marshallingContext);
        MarshalledValueMarshaller marshaller = new MarshalledValueMarshaller((MarshalledValueFactory)marshalledValueFactory, (Object)marshallingContext);
        AdvancedCache authenticationCache = this.configuration.getCache();
        Configuration config = authenticationCache.getCacheConfiguration();
        boolean lockOnRead = config.transaction().transactionMode().isTransactional() && config.transaction().lockingMode() == LockingMode.PESSIMISTIC && config.locking().isolationLevel() == IsolationLevel.REPEATABLE_READ;
        Cache sessionsCache = this.configuration.getCache();
        CoarseSSOFactory factory = new CoarseSSOFactory(lockOnRead ? authenticationCache.getAdvancedCache().withFlags(new Flag[]{Flag.FORCE_WRITE_LOCK}) : authenticationCache, sessionsCache, marshaller, localContextFactory);
        AffinityIdentifierFactory<String> idFactory = new AffinityIdentifierFactory<String>(identifierFactory, (Cache<String, ?>)authenticationCache, this.configuration.getKeyAffinityServiceFactory());
        InfinispanBatcher batcher = new InfinispanBatcher((Cache)authenticationCache);
        return new InfinispanSSOManager(factory, idFactory, (Batcher<TransactionBatch>)batcher);
    }
}

