/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.jboss.as.clustering.dmr.ModelNodes;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerBuilder;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerConfigurationBuilder;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanBindingFactory;
import org.jboss.as.clustering.infinispan.subsystem.KeyAffinityServiceFactoryBuilder;
import org.jboss.as.clustering.infinispan.subsystem.TransportConfigurationBuilder;
import org.jboss.as.clustering.infinispan.subsystem.TransportResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsBindingFactory;
import org.jboss.as.clustering.naming.BinderServiceBuilder;
import org.jboss.as.clustering.naming.JndiNameFactory;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.dmr.ModelNode;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.msc.service.ServiceTarget;
import org.jgroups.Channel;
import org.wildfly.clustering.infinispan.spi.CacheContainer;
import org.wildfly.clustering.infinispan.spi.service.CacheContainerServiceName;
import org.wildfly.clustering.infinispan.spi.service.CacheServiceName;
import org.wildfly.clustering.jgroups.spi.ChannelFactory;
import org.wildfly.clustering.jgroups.spi.service.ChannelBuilder;
import org.wildfly.clustering.jgroups.spi.service.ChannelConnectorBuilder;
import org.wildfly.clustering.jgroups.spi.service.ChannelServiceName;
import org.wildfly.clustering.jgroups.spi.service.ProtocolStackServiceName;
import org.wildfly.clustering.service.AliasServiceBuilder;
import org.wildfly.clustering.service.Builder;
import org.wildfly.clustering.spi.CacheGroupBuilderProvider;
import org.wildfly.clustering.spi.ClusteredCacheGroupBuilderProvider;
import org.wildfly.clustering.spi.ClusteredGroupBuilderProvider;
import org.wildfly.clustering.spi.GroupBuilderProvider;
import org.wildfly.clustering.spi.LocalCacheGroupBuilderProvider;
import org.wildfly.clustering.spi.LocalGroupBuilderProvider;

public class CacheContainerAddHandler
extends AbstractAddStepHandler {
    CacheContainerAddHandler() {
        super(CacheContainerResourceDefinition.ATTRIBUTES);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        CacheContainerAddHandler.installRuntimeServices(context, operation, Resource.Tools.readModel((Resource)context.readResource(PathAddress.EMPTY_ADDRESS)));
    }

    /*
     * WARNING - void declaration
     */
    static void installRuntimeServices(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        PathElement ejbPath;
        Resource rootResource;
        String name = context.getCurrentAddressValue();
        if (context.getProcessType().isServer() && !context.isBooting() && name.equals("ejb") && (rootResource = context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS)).hasChild(ejbPath = PathElement.pathElement((String)"subsystem", (String)"ejb3")) && rootResource.getChild(ejbPath).hasChild(PathElement.pathElement((String)"service", (String)"remote"))) {
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    context.reloadRequired();
                    context.completeStep(OperationContext.RollbackHandler.REVERT_RELOAD_REQUIRED_ROLLBACK_HANDLER);
                }
            }, OperationContext.Stage.RUNTIME);
            return;
        }
        ServiceTarget target = context.getServiceTarget();
        String defaultCache = ModelNodes.asString((ModelNode)CacheContainerResourceDefinition.DEFAULT_CACHE.resolveModelAttribute(context, model));
        String jndiName = ModelNodes.asString((ModelNode)CacheContainerResourceDefinition.JNDI_NAME.resolveModelAttribute(context, model));
        ModuleIdentifier module = ModelNodes.asModuleIdentifier((ModelNode)CacheContainerResourceDefinition.MODULE.resolveModelAttribute(context, model));
        CacheContainerConfigurationBuilder configBuilder = new CacheContainerConfigurationBuilder(name).setModule(module).setStatisticsEnabled(CacheContainerResourceDefinition.STATISTICS_ENABLED.resolveModelAttribute(context, model).asBoolean()).setListenerExecutor(ModelNodes.asString((ModelNode)CacheContainerResourceDefinition.LISTENER_EXECUTOR.resolveModelAttribute(context, model))).setEvictionExecutor(ModelNodes.asString((ModelNode)CacheContainerResourceDefinition.EVICTION_EXECUTOR.resolveModelAttribute(context, model))).setReplicationQueueExecutor(ModelNodes.asString((ModelNode)CacheContainerResourceDefinition.REPLICATION_QUEUE_EXECUTOR.resolveModelAttribute(context, model)));
        if (model.hasDefined(TransportResourceDefinition.PATH.getKey())) {
            ModelNode transport = model.get(TransportResourceDefinition.PATH.getKeyValuePair());
            String string = ModelNodes.asString((ModelNode)TransportResourceDefinition.CHANNEL.resolveModelAttribute(context, transport), (String)"default");
            configBuilder.setTransport().setLockTimeout(TransportResourceDefinition.LOCK_TIMEOUT.resolveModelAttribute(context, transport).asLong(), TimeUnit.MILLISECONDS).setExecutor(ModelNodes.asString((ModelNode)TransportResourceDefinition.EXECUTOR.resolveModelAttribute(context, transport))).build(target).install();
            if (!name.equals(string)) {
                new BinderServiceBuilder(JGroupsBindingFactory.createChannelBinding((String)name), ChannelServiceName.CHANNEL.getServiceName(name), Channel.class).build(target).install();
                new ChannelBuilder(name).build(target).install();
                new ChannelConnectorBuilder(name).build(target).install();
                new AliasServiceBuilder(ChannelServiceName.FACTORY.getServiceName(name), ProtocolStackServiceName.CHANNEL_FACTORY.getServiceName(string), ChannelFactory.class).build(target).install();
                for (GroupBuilderProvider groupBuilderProvider : ServiceLoader.load(ClusteredGroupBuilderProvider.class, ClusteredGroupBuilderProvider.class.getClassLoader())) {
                    Iterator builders = groupBuilderProvider.getBuilders(string, module).iterator();
                    for (Builder builder : groupBuilderProvider.getBuilders(name, module)) {
                        new AliasServiceBuilder(builder.getServiceName(), ((Builder)builders.next()).getServiceName(), Object.class).build(target).install();
                    }
                }
            }
        } else {
            for (GroupBuilderProvider groupBuilderProvider : ServiceLoader.load(LocalGroupBuilderProvider.class, LocalGroupBuilderProvider.class.getClassLoader())) {
                Iterator builders = groupBuilderProvider.getBuilders("local", module).iterator();
                for (Builder builder : groupBuilderProvider.getBuilders(name, module)) {
                    new AliasServiceBuilder(builder.getServiceName(), ((Builder)builders.next()).getServiceName(), Object.class).build(target).install();
                }
            }
        }
        configBuilder.build(target).install();
        CacheContainerBuilder containerBuilder = new CacheContainerBuilder(name, defaultCache);
        if (model.hasDefined(CacheContainerResourceDefinition.ALIASES.getName())) {
            for (ModelNode alias : operation.get(CacheContainerResourceDefinition.ALIASES.getName()).asList()) {
                containerBuilder.addAlias(alias.asString());
            }
        }
        containerBuilder.build(target).install();
        ContextNames.BindInfo bindInfo = InfinispanBindingFactory.createCacheContainerBinding(name);
        BinderServiceBuilder bindingBuilder = new BinderServiceBuilder(bindInfo, CacheContainerServiceName.CACHE_CONTAINER.getServiceName(name), CacheContainer.class);
        if (jndiName != null) {
            bindingBuilder.alias(ContextNames.bindInfoFor((String)JndiNameFactory.parse((String)jndiName).getAbsoluteName()));
        }
        bindingBuilder.build(target).install();
        new KeyAffinityServiceFactoryBuilder(name).build(target).install();
        if (defaultCache != null && !defaultCache.equals("default")) {
            void var14_27;
            CacheServiceName[] cacheServiceNameArray = CacheServiceName.values();
            int len$ = cacheServiceNameArray.length;
            boolean bl = false;
            while (var14_27 < len$) {
                CacheServiceName nameFactory = cacheServiceNameArray[var14_27];
                new AliasServiceBuilder(nameFactory.getServiceName(name), nameFactory.getServiceName(name, defaultCache), Object.class).build(target).install();
                ++var14_27;
            }
            new BinderServiceBuilder(InfinispanBindingFactory.createCacheBinding(name, "default"), CacheServiceName.CACHE.getServiceName(name), Cache.class).build(target).install();
            Class clazz = model.hasDefined(TransportResourceDefinition.PATH.getKey()) ? ClusteredCacheGroupBuilderProvider.class : LocalCacheGroupBuilderProvider.class;
            for (CacheGroupBuilderProvider cacheGroupBuilderProvider : ServiceLoader.load(clazz, clazz.getClassLoader())) {
                for (Builder builder : cacheGroupBuilderProvider.getBuilders(name, "default")) {
                    builder.build(target).install();
                }
            }
        }
    }

    static void removeRuntimeServices(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        String name = context.getCurrentAddressValue();
        context.removeService(InfinispanBindingFactory.createCacheContainerBinding(name).getBinderServiceName());
        for (CacheContainerServiceName cacheContainerServiceName : CacheContainerServiceName.values()) {
            context.removeService(cacheContainerServiceName.getServiceName(name));
        }
        if (model.hasDefined(TransportResourceDefinition.PATH.getKey())) {
            CacheContainerAddHandler.removeServices(context, ClusteredGroupBuilderProvider.class, name);
            context.removeService(new TransportConfigurationBuilder(name).getServiceName());
            context.removeService(JGroupsBindingFactory.createChannelBinding((String)name).getBinderServiceName());
            for (CacheContainerServiceName cacheContainerServiceName : ChannelServiceName.values()) {
                context.removeService(cacheContainerServiceName.getServiceName(name));
            }
        } else {
            CacheContainerAddHandler.removeServices(context, LocalGroupBuilderProvider.class, name);
        }
        String defaultCache = ModelNodes.asString((ModelNode)CacheContainerResourceDefinition.DEFAULT_CACHE.resolveModelAttribute(context, model));
        if (defaultCache != null && !defaultCache.equals("default")) {
            Class providerClass = model.hasDefined(TransportResourceDefinition.PATH.getKey()) ? ClusteredCacheGroupBuilderProvider.class : LocalCacheGroupBuilderProvider.class;
            for (CacheGroupBuilderProvider cacheGroupBuilderProvider : ServiceLoader.load(providerClass, providerClass.getClassLoader())) {
                for (Builder builder : cacheGroupBuilderProvider.getBuilders(name, "default")) {
                    context.removeService(builder.getServiceName());
                }
            }
        }
    }

    private static <I extends GroupBuilderProvider> void removeServices(OperationContext context, Class<I> providerClass, String group) {
        for (GroupBuilderProvider provider : ServiceLoader.load(providerClass, providerClass.getClassLoader())) {
            for (Builder builder : provider.getBuilders(group, null)) {
                context.removeService(builder.getServiceName());
            }
        }
    }
}

