/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jaxrs;

import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.api.ThreadSetupHandler;
import io.undertow.servlet.handlers.ServletHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.ws.rs.CookieParam;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.MatrixParam;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.MediaType;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ObjectListAttributeDefinition;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleListAttributeDefinition;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.jaxrs.JaxrsExtension;
import org.jboss.as.jaxrs.logging.JaxrsLogger;
import org.jboss.as.server.Services;
import org.jboss.as.server.moduleservice.ServiceModuleLoader;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.modules.Module;
import org.jboss.msc.service.ServiceController;
import org.jboss.resteasy.core.ResourceInvoker;
import org.jboss.resteasy.core.ResourceLocatorInvoker;
import org.jboss.resteasy.core.ResourceMethodInvoker;
import org.jboss.resteasy.core.ResourceMethodRegistry;
import org.jboss.resteasy.plugins.server.servlet.HttpServletDispatcher;
import org.jboss.resteasy.spi.metadata.ResourceBuilder;
import org.jboss.resteasy.spi.metadata.ResourceClass;
import org.jboss.resteasy.spi.metadata.ResourceMethod;
import org.wildfly.extension.undertow.DeploymentDefinition;
import org.wildfly.extension.undertow.UndertowService;
import org.wildfly.extension.undertow.deployment.UndertowDeploymentService;

public class DeploymentRestResourcesDefintion
extends SimpleResourceDefinition {
    public static DeploymentRestResourcesDefintion INSTANCE = new DeploymentRestResourcesDefintion();
    public static final String REST_RESOURCE_NAME = "rest-resource";
    public static final AttributeDefinition RESOURCE_CLASS = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("resource-class", ModelType.STRING, true).setStorageRuntime()).build();
    public static final AttributeDefinition RESOURCE_PATH = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("resource-path", ModelType.STRING, true).setStorageRuntime()).build();
    public static final AttributeDefinition RESOURCE_METHOD = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("resource-method", ModelType.STRING, false).setStorageRuntime()).build();
    public static final AttributeDefinition RESOURCE_METHODS = ((SimpleListAttributeDefinition.Builder)new SimpleListAttributeDefinition.Builder("resource-methods", RESOURCE_METHOD).setStorageRuntime()).build();
    public static final AttributeDefinition CONSUME = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("consume", ModelType.STRING, true).setStorageRuntime()).build();
    public static final AttributeDefinition CONSUMES = ((SimpleListAttributeDefinition.Builder)new SimpleListAttributeDefinition.Builder("consumes", CONSUME).setStorageRuntime()).build();
    public static final AttributeDefinition PRODUCE = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("produce", ModelType.STRING, true).setStorageRuntime()).build();
    public static final AttributeDefinition PRODUCES = ((SimpleListAttributeDefinition.Builder)new SimpleListAttributeDefinition.Builder("produces", PRODUCE).setStorageRuntime()).build();
    public static final AttributeDefinition JAVA_METHOD = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("java-method", ModelType.STRING, true).setStorageRuntime()).build();
    public static final ObjectTypeAttributeDefinition RESOURCE_PATH_GRP = new ObjectTypeAttributeDefinition.Builder("rest-resource-path-group", new AttributeDefinition[]{RESOURCE_PATH, CONSUMES, PRODUCES, JAVA_METHOD, RESOURCE_METHODS}).build();
    public static final ObjectListAttributeDefinition RESOURCE_PATHS = new ObjectListAttributeDefinition.Builder("rest-resource-paths", RESOURCE_PATH_GRP).build();
    public static final ObjectTypeAttributeDefinition SUB_RESOURCE_LOCATOR = new ObjectTypeAttributeDefinition.Builder("sub-resource-locator-group", new AttributeDefinition[]{RESOURCE_CLASS, RESOURCE_PATH, CONSUMES, PRODUCES, JAVA_METHOD, RESOURCE_METHODS}).build();
    public static final ObjectListAttributeDefinition SUB_RESOURCE_LOCATORS = new ObjectListAttributeDefinition.Builder("sub-resource-locators", SUB_RESOURCE_LOCATOR).build();
    private OperationContext.AttachmentKey<Map<PathAddress, UndertowDeploymentService>> undertowDeployServiceKey = OperationContext.AttachmentKey.create(Map.class);
    private OperationContext.AttachmentKey<Map<PathAddress, Module>> deploymentModuleKey = OperationContext.AttachmentKey.create(Map.class);
    private OperationContext.AttachmentKey<Map<String, ResourceMeta>> resourceMetaKey = OperationContext.AttachmentKey.create(Map.class);

    private DeploymentRestResourcesDefintion() {
        super(PathElement.pathElement((String)REST_RESOURCE_NAME), JaxrsExtension.getResolver("deployment"));
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerMetric(RESOURCE_CLASS, (OperationStepHandler)new AbstractRestResReadHandler(){

            @Override
            void handleAttribute(String className, List<JaxrsResourceMethodDescription> methodInvokers, List<JaxrsResourceLocatorDescription> locatorIncokers, Collection<String> servletMappings, ModelNode response) {
                response.set(className);
            }
        });
        resourceRegistration.registerMetric((AttributeDefinition)RESOURCE_PATHS, (OperationStepHandler)new AbstractRestResReadHandler(){

            @Override
            void handleAttribute(String className, List<JaxrsResourceMethodDescription> methodInvokers, List<JaxrsResourceLocatorDescription> locatorIncokers, Collection<String> servletMappings, ModelNode response) {
                for (JaxrsResourceMethodDescription methodDesc : methodInvokers) {
                    response.add(methodDesc.toModelNode());
                }
            }
        });
        resourceRegistration.registerMetric((AttributeDefinition)SUB_RESOURCE_LOCATORS, (OperationStepHandler)new AbstractRestResReadHandler(){

            @Override
            void handleAttribute(String className, List<JaxrsResourceMethodDescription> methodInvokers, List<JaxrsResourceLocatorDescription> locatorIncokers, Collection<String> servletMappings, ModelNode response) {
                for (JaxrsResourceLocatorDescription methodDesc : locatorIncokers) {
                    response.add(methodDesc.toModelNode());
                }
            }
        });
    }

    private JaxrsResourceLocatorDescription resLocatorDescription(ResourceClass resClass, String contextPath, String mapping, Collection<String> servletMappings, List<Class<?>> resolvedCls) {
        ResourceMethod resLocator;
        Class clz;
        JaxrsResourceLocatorDescription locatorRes = new JaxrsResourceLocatorDescription();
        locatorRes.resourceClass = resClass.getClazz();
        resolvedCls.add(resClass.getClazz());
        for (ResourceMethod resMethod : resClass.getResourceMethods()) {
            JaxrsResourceMethodDescription jaxrsRes = new JaxrsResourceMethodDescription();
            JaxrsResourceMethodDescription.access$1202(jaxrsRes, resMethod.getConsumes());
            jaxrsRes.contextPath = contextPath;
            jaxrsRes.httpMethods = resMethod.getHttpMethods();
            jaxrsRes.method = resMethod.getMethod();
            JaxrsResourceMethodDescription.access$1602(jaxrsRes, resMethod.getProduces());
            jaxrsRes.resourceClass = resClass.getClazz().getCanonicalName();
            String resPath = (mapping + "/" + resMethod.getFullpath()).replace("//", "/");
            jaxrsRes.resourcePath = resPath;
            jaxrsRes.servletMappings = servletMappings;
            this.addMethodParameters(jaxrsRes, resMethod.getMethod());
            locatorRes.methodsDescriptions.add(jaxrsRes);
        }
        ResourceMethod[] resourceMethodArray = resClass.getResourceLocators();
        int n = resourceMethodArray.length;
        for (int i = 0; i < n && !(clz = (resLocator = resourceMethodArray[i]).getReturnType()).equals(resClass.getClazz()) && !resolvedCls.contains(clz); ++i) {
            resolvedCls.add(clz);
            ResourceClass subResClass = ResourceBuilder.locatorFromAnnotations((Class)clz);
            String subMapping = (mapping + "/" + resLocator.getFullpath()).replace("//", "/");
            JaxrsResourceLocatorDescription inner = this.resLocatorDescription(subResClass, contextPath, subMapping, servletMappings, resolvedCls);
            if (!inner.containsMethodResources()) continue;
            locatorRes.subLocatorDescriptions.add(inner);
        }
        return locatorRes;
    }

    private JaxrsResourceMethodDescription resMethodDescription(ResourceMethodInvoker methodInvoker, String contextPath, String mapping, Collection<String> servletMappings, String clsName) {
        JaxrsResourceMethodDescription jaxrsRes = new JaxrsResourceMethodDescription();
        JaxrsResourceMethodDescription.access$1202(jaxrsRes, methodInvoker.getConsumes());
        jaxrsRes.contextPath = contextPath;
        jaxrsRes.httpMethods = methodInvoker.getHttpMethods();
        jaxrsRes.method = methodInvoker.getMethod();
        JaxrsResourceMethodDescription.access$1602(jaxrsRes, methodInvoker.getProduces());
        jaxrsRes.resourceClass = clsName;
        jaxrsRes.resourcePath = mapping;
        jaxrsRes.servletMappings = servletMappings;
        this.addMethodParameters(jaxrsRes, methodInvoker.getMethod());
        return jaxrsRes;
    }

    private void addMethodParameters(JaxrsResourceMethodDescription jaxrsRes, Method method) {
        for (Parameter param : method.getParameters()) {
            ParamInfo paramInfo = new ParamInfo();
            paramInfo.cls = param.getType();
            paramInfo.defaultValue = null;
            paramInfo.name = null;
            paramInfo.type = null;
            PathParam annotation = param.getAnnotation(PathParam.class);
            if (annotation != null) {
                PathParam pathParam = annotation;
                paramInfo.name = pathParam.value();
                paramInfo.type = "@" + PathParam.class.getSimpleName();
            } else {
                annotation = param.getAnnotation(QueryParam.class);
                if (annotation != null) {
                    QueryParam queryParam = (QueryParam)annotation;
                    paramInfo.name = queryParam.value();
                    paramInfo.type = "@" + QueryParam.class.getSimpleName();
                } else {
                    annotation = param.getAnnotation(HeaderParam.class);
                    if (annotation != null) {
                        HeaderParam headerParam = (HeaderParam)annotation;
                        paramInfo.name = headerParam.value();
                        paramInfo.type = "@" + HeaderParam.class.getSimpleName();
                    } else {
                        annotation = param.getAnnotation(CookieParam.class);
                        if (annotation != null) {
                            CookieParam cookieParam = (CookieParam)annotation;
                            paramInfo.name = cookieParam.value();
                            paramInfo.type = "@" + CookieParam.class.getSimpleName();
                        } else {
                            annotation = param.getAnnotation(MatrixParam.class);
                            if (annotation != null) {
                                MatrixParam matrixParam = (MatrixParam)annotation;
                                paramInfo.name = matrixParam.value();
                                paramInfo.type = "@" + MatrixParam.class.getSimpleName();
                            } else {
                                annotation = param.getAnnotation(FormParam.class);
                                if (annotation != null) {
                                    FormParam formParam = (FormParam)annotation;
                                    paramInfo.name = formParam.value();
                                    paramInfo.type = "@" + FormParam.class.getSimpleName();
                                }
                            }
                        }
                    }
                }
            }
            if (paramInfo.name == null) {
                paramInfo.name = param.getName();
            }
            if ((annotation = param.getAnnotation(DefaultValue.class)) != null) {
                DefaultValue defaultValue = (DefaultValue)annotation;
                paramInfo.defaultValue = defaultValue.value();
            }
            jaxrsRes.parameters.add(paramInfo);
        }
    }

    private static class ParamInfo {
        private String name;
        private Class<?> cls;
        private String type;
        private String defaultValue;

        private ParamInfo() {
        }
    }

    private static class JaxrsResourceMethodDescription
    implements Comparable<JaxrsResourceMethodDescription> {
        private String resourceClass;
        private String resourcePath;
        private Method method;
        private List<ParamInfo> parameters = new ArrayList<ParamInfo>();
        private Set<String> httpMethods = Collections.emptySet();
        private MediaType[] consumeTypes;
        private MediaType[] produceTypes;
        private Collection<String> servletMappings = Collections.emptyList();
        private String contextPath;

        private JaxrsResourceMethodDescription() {
        }

        @Override
        public int compareTo(JaxrsResourceMethodDescription other) {
            int result = this.resourcePath.compareTo(other.resourcePath);
            if (result == 0) {
                result = this.resourceClass.compareTo(other.resourceClass);
            }
            if (result == 0) {
                result = this.method.getName().compareTo(other.method.getName());
            }
            return result;
        }

        ModelNode toModelNode() {
            ModelNode node = new ModelNode();
            node.get(RESOURCE_PATH.getName()).set(this.resourcePath);
            ModelNode consumeNode = node.get(CONSUMES.getName());
            if (this.consumeTypes != null && this.consumeTypes.length > 0) {
                for (MediaType consume : this.consumeTypes) {
                    consumeNode.add(consume.toString());
                }
            }
            ModelNode produceNode = node.get(PRODUCES.getName());
            if (this.produceTypes != null && this.produceTypes.length > 0) {
                for (MediaType produce : this.produceTypes) {
                    produceNode.add(produce.toString());
                }
            }
            node.get(JAVA_METHOD.getName()).set(this.formatJavaMethod());
            for (String servletMapping : this.servletMappings) {
                for (String httpMethod : this.httpMethods) {
                    node.get(RESOURCE_METHODS.getName()).add(httpMethod + " " + this.formatPath(servletMapping, this.contextPath, this.resourcePath));
                }
            }
            return node;
        }

        private String formatPath(String servletMapping, String ctxPath, String resPath) {
            StringBuilder sb = new StringBuilder();
            String servletPath = servletMapping.replaceAll("\\*", "");
            if (servletPath.charAt(0) == '/') {
                servletPath = servletPath.substring(1);
            }
            sb.append(ctxPath).append('/').append(servletPath).append(resPath);
            return sb.toString().replace("//", "/");
        }

        private String formatJavaMethod() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.method.getReturnType().getCanonicalName()).append(" ").append(this.resourceClass).append(".").append(this.method.getName()).append('(');
            int i = 0;
            for (ParamInfo param : this.parameters) {
                if (param.type != null) {
                    sb.append(param.type).append(" ");
                }
                sb.append(param.cls.getCanonicalName()).append(" ").append(param.name);
                if (param.defaultValue != null) {
                    sb.append(" = '");
                    sb.append(param.defaultValue);
                    sb.append("'");
                }
                if (++i >= this.parameters.size()) continue;
                sb.append(", ");
            }
            sb.append(")");
            return sb.toString();
        }

        static /* synthetic */ MediaType[] access$1202(JaxrsResourceMethodDescription x0, MediaType[] x1) {
            x0.consumeTypes = x1;
            return x1;
        }

        static /* synthetic */ MediaType[] access$1602(JaxrsResourceMethodDescription x0, MediaType[] x1) {
            x0.produceTypes = x1;
            return x1;
        }
    }

    private static class JaxrsResourceLocatorDescription
    implements Comparable<JaxrsResourceLocatorDescription> {
        private Class<?> resourceClass;
        private List<JaxrsResourceMethodDescription> methodsDescriptions = new ArrayList<JaxrsResourceMethodDescription>();
        private List<JaxrsResourceLocatorDescription> subLocatorDescriptions = new ArrayList<JaxrsResourceLocatorDescription>();

        private JaxrsResourceLocatorDescription() {
        }

        @Override
        public int compareTo(JaxrsResourceLocatorDescription o) {
            return this.resourceClass.getCanonicalName().compareTo(o.resourceClass.getCanonicalName());
        }

        public ModelNode toModelNode() {
            ModelNode node = new ModelNode();
            node.get(RESOURCE_CLASS.getName()).set(this.resourceClass.getCanonicalName());
            ModelNode resPathNode = node.get(RESOURCE_PATHS.getName());
            Collections.sort(this.methodsDescriptions);
            for (JaxrsResourceMethodDescription methodRes : this.methodsDescriptions) {
                resPathNode.add(methodRes.toModelNode());
            }
            ModelNode subResNode = node.get(SUB_RESOURCE_LOCATORS.getName());
            Collections.sort(this.subLocatorDescriptions);
            for (JaxrsResourceLocatorDescription subLocator : this.subLocatorDescriptions) {
                subResNode.add(subLocator.toModelNode());
            }
            return node;
        }

        private boolean containsMethodResources() {
            if (this.methodsDescriptions.size() > 0) {
                return true;
            }
            for (JaxrsResourceLocatorDescription p : this.subLocatorDescriptions) {
                if (!p.containsMethodResources()) continue;
                return true;
            }
            return false;
        }
    }

    private class ResourceMeta {
        private List<JaxrsResourceMethodDescription> methodInvokers = new ArrayList<JaxrsResourceMethodDescription>();
        private List<JaxrsResourceLocatorDescription> resLocatorInvokers = new ArrayList<JaxrsResourceLocatorDescription>();
        private boolean metaComplete = false;

        private ResourceMeta() {
        }
    }

    abstract class AbstractRestResReadHandler
    implements OperationStepHandler {
        AbstractRestResReadHandler() {
        }

        public void execute(final OperationContext context, ModelNode operation) throws OperationFailedException {
            ResourceMeta resMeta;
            UndertowDeploymentService undertowDeploymentService;
            final PathAddress address = context.getCurrentAddress();
            final String clsName = address.getLastElement().getValue();
            final PathAddress parentAddress = address.getParent();
            ModelNode subModel = context.readResourceFromRoot(parentAddress.subAddress(0, parentAddress.size() - 1).append("subsystem", "undertow"), false).getModel();
            String host = DeploymentDefinition.VIRTUAL_HOST.resolveModelAttribute(context, subModel).asString();
            final String contextPath = DeploymentDefinition.CONTEXT_ROOT.resolveModelAttribute(context, subModel).asString();
            String server = DeploymentDefinition.SERVER.resolveModelAttribute(context, subModel).asString();
            Map<PathAddress, UndertowDeploymentService> deploymentServiceMap = (Map<PathAddress, UndertowDeploymentService>)context.getAttachment(DeploymentRestResourcesDefintion.this.undertowDeployServiceKey);
            if (deploymentServiceMap == null) {
                deploymentServiceMap = Collections.synchronizedMap(new HashMap());
                context.attach(DeploymentRestResourcesDefintion.this.undertowDeployServiceKey, deploymentServiceMap);
            }
            if ((undertowDeploymentService = (UndertowDeploymentService)deploymentServiceMap.get(parentAddress)) == null) {
                ServiceController controller = context.getServiceRegistry(false).getService(UndertowService.deploymentServiceName((String)server, (String)host, (String)contextPath));
                undertowDeploymentService = (UndertowDeploymentService)controller.getService();
                deploymentServiceMap.put(parentAddress, undertowDeploymentService);
            }
            final UndertowDeploymentService deploymentService = undertowDeploymentService;
            Map<String, ResourceMeta> resourceMetaMap = (Map<String, ResourceMeta>)context.getAttachment(DeploymentRestResourcesDefintion.this.resourceMetaKey);
            if (resourceMetaMap == null) {
                resourceMetaMap = Collections.synchronizedMap(new HashMap());
                context.attach(DeploymentRestResourcesDefintion.this.resourceMetaKey, resourceMetaMap);
            }
            if ((resMeta = (ResourceMeta)resourceMetaMap.get(clsName)) == null) {
                resMeta = new ResourceMeta();
                resourceMetaMap.put(clsName, resMeta);
            }
            final ResourceMeta resourceMeta = resMeta;
            try {
                deploymentService.getDeployment().createThreadSetupAction((ThreadSetupHandler.Action)new ThreadSetupHandler.Action<Object, Object>(){

                    public Object call(HttpServerExchange exchange, Object ctxObject) throws Exception {
                        final ArrayList<HttpServletDispatcher> resteasyServlets = new ArrayList<HttpServletDispatcher>();
                        for (Map.Entry servletHandler : deploymentService.getDeployment().getServlets().getServletHandlers().entrySet()) {
                            if (!HttpServletDispatcher.class.isAssignableFrom(((ServletHandler)servletHandler.getValue()).getManagedServlet().getServletInfo().getServletClass())) continue;
                            resteasyServlets.add((HttpServletDispatcher)((ServletHandler)servletHandler.getValue()).getManagedServlet().getServlet().getInstance());
                        }
                        if (resteasyServlets.size() > 0) {
                            context.addStep(new OperationStepHandler(){

                                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                                    ModelNode response = new ModelNode();
                                    List resMethodInvokers = resourceMeta.methodInvokers;
                                    List resLocatorInvokers = resourceMeta.resLocatorInvokers;
                                    for (HttpServletDispatcher resteasyServlet : resteasyServlets) {
                                        Collection servletMappings = resteasyServlet.getServletConfig().getServletContext().getServletRegistration(resteasyServlet.getServletConfig().getServletName()).getMappings();
                                        if (!resourceMeta.metaComplete) {
                                            resourceMeta.metaComplete = true;
                                            ResourceMethodRegistry registry = (ResourceMethodRegistry)resteasyServlet.getDispatcher().getRegistry();
                                            for (Map.Entry resource : registry.getBounded().entrySet()) {
                                                String mapping = (String)resource.getKey();
                                                List resouceInvokers = (List)resource.getValue();
                                                for (ResourceInvoker resourceInvoker : resouceInvokers) {
                                                    Class<?> resClsInModel;
                                                    if (ResourceMethodInvoker.class.isAssignableFrom(resourceInvoker.getClass())) {
                                                        ResourceMethodInvoker methodInvoker = (ResourceMethodInvoker)resourceInvoker;
                                                        Class resClass = methodInvoker.getResourceClass();
                                                        if (resClass.getCanonicalName().equals(clsName)) {
                                                            JaxrsResourceMethodDescription resMethodDesc = DeploymentRestResourcesDefintion.this.resMethodDescription(methodInvoker, contextPath, mapping, servletMappings, clsName);
                                                            resMethodInvokers.add(resMethodDesc);
                                                            continue;
                                                        }
                                                        if (!resClass.isInterface() || !resClass.isAssignableFrom(resClsInModel = this.getResourceClassInModel(clsName, context))) continue;
                                                        JaxrsResourceMethodDescription resMethodDesc = DeploymentRestResourcesDefintion.this.resMethodDescription(methodInvoker, contextPath, mapping, servletMappings, clsName);
                                                        resMethodInvokers.add(resMethodDesc);
                                                        continue;
                                                    }
                                                    if (!ResourceLocatorInvoker.class.isAssignableFrom(resourceInvoker.getClass())) continue;
                                                    ResourceLocatorInvoker locatorInvoker = (ResourceLocatorInvoker)resourceInvoker;
                                                    Class<?> resLocatorClass = locatorInvoker.getMethod().getDeclaringClass();
                                                    if (clsName.equals(resLocatorClass.getCanonicalName())) {
                                                        ResourceClass resClass = ResourceBuilder.locatorFromAnnotations(locatorInvoker.getMethod().getReturnType());
                                                        JaxrsResourceLocatorDescription resLocatorDesc = DeploymentRestResourcesDefintion.this.resLocatorDescription(resClass, contextPath, mapping, servletMappings, new ArrayList());
                                                        resLocatorInvokers.add(resLocatorDesc);
                                                        continue;
                                                    }
                                                    if (!resLocatorClass.isInterface() || !resLocatorClass.isAssignableFrom(resClsInModel = this.getResourceClassInModel(clsName, context))) continue;
                                                    ResourceClass resClass = ResourceBuilder.locatorFromAnnotations(locatorInvoker.getMethod().getReturnType());
                                                    JaxrsResourceLocatorDescription resLocatorDesc = DeploymentRestResourcesDefintion.this.resLocatorDescription(resClass, contextPath, mapping, servletMappings, new ArrayList());
                                                    resLocatorInvokers.add(resLocatorDesc);
                                                }
                                            }
                                            Collections.sort(resMethodInvokers);
                                            Collections.sort(resLocatorInvokers);
                                        }
                                        AbstractRestResReadHandler.this.handleAttribute(clsName, resMethodInvokers, resLocatorInvokers, servletMappings, response);
                                    }
                                    context.getResult().set(response);
                                }

                                private Class<?> getResourceClassInModel(String clsName, OperationContext context) throws OperationFailedException {
                                    try {
                                        Module deployModule;
                                        Map<PathAddress, Module> deploymentModuleMap = (Map<PathAddress, Module>)context.getAttachment(DeploymentRestResourcesDefintion.this.deploymentModuleKey);
                                        if (deploymentModuleMap == null) {
                                            deploymentModuleMap = Collections.synchronizedMap(new HashMap());
                                            context.attach(DeploymentRestResourcesDefintion.this.deploymentModuleKey, deploymentModuleMap);
                                        }
                                        if ((deployModule = (Module)deploymentModuleMap.get(parentAddress)) == null) {
                                            StringBuilder sb = new StringBuilder("deployment");
                                            sb.append(".");
                                            String deployRuntimeName = address.getElement(0).getValue();
                                            ModelNode deployModel = context.readResourceFromRoot(address.subAddress(0, 1)).getModel();
                                            if (deployModel.isDefined() && deployModel.hasDefined("runtime-name")) {
                                                deployRuntimeName = deployModel.get("runtime-name").asString();
                                            }
                                            sb.append(deployRuntimeName);
                                            if (address.size() > 1 && address.getElement(1).getKey().equals("subdeployment")) {
                                                sb.append(".");
                                                sb.append(address.getElement(1).getValue());
                                            }
                                            String moduleName = sb.toString();
                                            ServiceModuleLoader srvModuleLoader = (ServiceModuleLoader)context.getServiceRegistry(false).getRequiredService(Services.JBOSS_SERVICE_MODULE_LOADER).getValue();
                                            deployModule = srvModuleLoader.loadModule(moduleName);
                                            deploymentModuleMap.put(parentAddress, deployModule);
                                        }
                                        return Class.forName(clsName, false, (ClassLoader)deployModule.getClassLoader());
                                    }
                                    catch (Exception e) {
                                        throw new OperationFailedException((Throwable)e);
                                    }
                                }
                            }, OperationContext.Stage.RUNTIME);
                        }
                        return null;
                    }
                }).call(null, null);
            }
            catch (Exception ex) {
                JaxrsLogger.JAXRS_LOGGER.failedToReadAttribute(ex, address, operation.get("name"));
                context.addResponseWarning((Level)org.jboss.logmanager.Level.WARN, ex.getMessage());
            }
        }

        abstract void handleAttribute(String var1, List<JaxrsResourceMethodDescription> var2, List<JaxrsResourceLocatorDescription> var3, Collection<String> var4, ModelNode var5);
    }
}

