/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.lra.participant.deployment;

import io.narayana.lra.client.internal.proxy.nonjaxrs.LRACDIExtension;
import jakarta.enterprise.inject.spi.Extension;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.as.weld.WeldCapability;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.filter.PathFilters;
import org.wildfly.extension.microprofile.lra.participant.deployment.LRAAnnotationsUtil;

public class LRAParticipantDeploymentDependencyProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (LRAAnnotationsUtil.isNotLRADeployment(deploymentUnit)) {
            return;
        }
        this.addModuleDependencies(deploymentUnit);
    }

    public void undeploy(DeploymentUnit context) {
    }

    private void addModuleDependencies(DeploymentUnit deploymentUnit) {
        ModuleSpecification moduleSpecification = (ModuleSpecification)deploymentUnit.getAttachment(Attachments.MODULE_SPECIFICATION);
        ModuleLoader moduleLoader = Module.getBootModuleLoader();
        moduleSpecification.addSystemDependency(ModuleDependency.Builder.of((ModuleLoader)moduleLoader, (String)"org.eclipse.microprofile.lra.api").build());
        ModuleDependency lraParticipantDependency = ModuleDependency.Builder.of((ModuleLoader)moduleLoader, (String)"org.jboss.narayana.lra.lra-participant").setImportServices(true).build();
        lraParticipantDependency.addImportFilter(PathFilters.getMetaInfFilter(), true);
        moduleSpecification.addSystemDependency(lraParticipantDependency);
        moduleSpecification.addSystemDependency(ModuleDependency.Builder.of((ModuleLoader)moduleLoader, (String)"io.smallrye.jandex").setImportServices(true).build());
        moduleSpecification.addSystemDependency(ModuleDependency.Builder.of((ModuleLoader)moduleLoader, (String)"io.smallrye.stork").setImportServices(true).build());
        moduleSpecification.addSystemDependency(ModuleDependency.Builder.of((ModuleLoader)moduleLoader, (String)"org.jboss.as.weld.common").setImportServices(true).build());
        moduleSpecification.addSystemDependency(ModuleDependency.Builder.of((ModuleLoader)moduleLoader, (String)"org.jboss.resteasy.resteasy-cdi").setImportServices(true).build());
        CapabilityServiceSupport support = (CapabilityServiceSupport)deploymentUnit.getAttachment(Attachments.CAPABILITY_SERVICE_SUPPORT);
        if (support.hasCapability("org.wildfly.weld")) {
            ((WeldCapability)support.getOptionalCapabilityRuntimeAPI("org.wildfly.weld", WeldCapability.class).get()).registerExtensionInstance((Extension)new LRACDIExtension(), deploymentUnit);
        }
    }
}

