/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.pojo.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.as.pojo.BeanState;
import org.jboss.as.pojo.descriptor.BeanMetaDataConfig;
import org.jboss.as.pojo.logging.PojoLogger;
import org.jboss.as.pojo.service.Callback;
import org.jboss.as.pojo.service.TypeBeanStateKey;
import org.jboss.msc.service.DuplicateServiceException;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

final class InstancesService
implements Service<Set<Object>> {
    private final Class<?> type;
    private final Set<Object> instances = new HashSet<Object>();
    private static Map<TypeBeanStateKey, Set<Object>> beans = new HashMap<TypeBeanStateKey, Set<Object>>();
    private static Map<TypeBeanStateKey, List<Callback>> incallbacks = new HashMap<TypeBeanStateKey, List<Callback>>();
    private static Map<TypeBeanStateKey, List<Callback>> uncallbacks = new HashMap<TypeBeanStateKey, List<Callback>>();

    private InstancesService(Class<?> type) {
        this.type = type;
    }

    static void addInstance(ServiceRegistry registry, ServiceTarget target, BeanState state, Object bean) throws StartException {
        InstancesService.addInstance(registry, target, state, bean.getClass(), bean);
    }

    static void removeInstance(ServiceRegistry registry, BeanState state, Object bean) {
        InstancesService.removeInstance(registry, state, bean.getClass(), bean);
    }

    static void addIncallback(Callback callback) {
        InstancesService.addCallback(incallbacks, callback);
    }

    static void addUncallback(Callback callback) {
        InstancesService.addCallback(uncallbacks, callback);
    }

    static void removeIncallback(Callback callback) {
        InstancesService.removeCallback(incallbacks, callback);
    }

    static void removeUncallback(Callback callback) {
        InstancesService.removeCallback(uncallbacks, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addCallback(Map<TypeBeanStateKey, List<Callback>> map, Callback callback) {
        Class<?> type;
        Class<?> clazz = type = callback.getType();
        synchronized (clazz) {
            TypeBeanStateKey key;
            List<Callback> callbacks;
            if (map == incallbacks) {
                try {
                    callback.dispatch();
                }
                catch (Throwable t) {
                    PojoLogger.ROOT_LOGGER.errorAtIncallback(callback, t);
                }
            }
            if ((callbacks = map.get(key = new TypeBeanStateKey(type, callback.getState()))) == null) {
                callbacks = new ArrayList<Callback>();
                map.put(key, callbacks);
            }
            callbacks.add(callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeCallback(Map<TypeBeanStateKey, List<Callback>> map, Callback callback) {
        Class<?> type;
        Class<?> clazz = type = callback.getType();
        synchronized (clazz) {
            TypeBeanStateKey key = new TypeBeanStateKey(type, callback.getState());
            List<Callback> callbacks = map.get(key);
            if (callbacks != null) {
                callbacks.remove(callback);
                if (callbacks.isEmpty()) {
                    map.remove(key);
                }
            }
            if (map == uncallbacks) {
                try {
                    callback.dispatch();
                }
                catch (Throwable t) {
                    PojoLogger.ROOT_LOGGER.errorAtUncallback(callback, t);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void invokeCallbacks(Map<TypeBeanStateKey, List<Callback>> map, BeanState state, Class<?> clazz, Object bean) {
        Class<?> clazz2 = clazz;
        synchronized (clazz2) {
            TypeBeanStateKey key = new TypeBeanStateKey(clazz, state);
            List<Callback> callbacks = map.get(key);
            if (callbacks != null) {
                for (Callback c : callbacks) {
                    try {
                        c.dispatch(bean);
                    }
                    catch (Throwable t) {
                        PojoLogger.ROOT_LOGGER.invokingCallback(c, t);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addInstance(ServiceRegistry registry, ServiceTarget target, BeanState state, Class<?> clazz, Object bean) throws StartException {
        Class<?>[] ifaces;
        if (clazz == null) {
            return;
        }
        ServiceName name = BeanMetaDataConfig.toInstancesName(clazz, state);
        ServiceBuilder builder = target.addService(name, (Service)new InstancesService(clazz));
        InstancesService service = InstancesService.putIfAbsent(registry, name, builder);
        Class<?> clazz2 = clazz;
        synchronized (clazz2) {
            service.instances.add(bean);
            TypeBeanStateKey key = new TypeBeanStateKey(clazz, state);
            if (!beans.containsKey(key)) {
                beans.put(key, service.instances);
            }
            InstancesService.invokeCallbacks(incallbacks, state, clazz, bean);
        }
        InstancesService.addInstance(registry, target, state, clazz.getSuperclass(), bean);
        for (Class<?> iface : ifaces = clazz.getInterfaces()) {
            InstancesService.addInstance(registry, target, state, iface, bean);
        }
    }

    /*
     * Loose catch block
     */
    private static InstancesService putIfAbsent(ServiceRegistry registry, ServiceName name, ServiceBuilder builder) throws StartException {
        while (true) {
            try {
                ServiceController sc = registry.getService(name);
                if (sc == null) {
                    sc = builder.install();
                }
                return (InstancesService)sc.getService();
            }
            catch (DuplicateServiceException ignored) {
                continue;
            }
            break;
        }
        catch (Exception e) {
            throw new StartException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeInstance(ServiceRegistry registry, BeanState state, Class<?> clazz, Object bean) {
        Class<?>[] ifaces;
        if (clazz == null) {
            return;
        }
        ServiceController controller = registry.getService(BeanMetaDataConfig.toInstancesName(clazz, state));
        if (controller != null) {
            InstancesService service = (InstancesService)controller.getService();
            Class<?> clazz2 = clazz;
            synchronized (clazz2) {
                service.instances.remove(bean);
                InstancesService.invokeCallbacks(uncallbacks, state, clazz, bean);
                if (service.instances.isEmpty()) {
                    beans.remove(new TypeBeanStateKey(clazz, state));
                    controller.setMode(ServiceController.Mode.REMOVE);
                }
            }
        }
        InstancesService.removeInstance(registry, state, clazz.getSuperclass(), bean);
        for (Class<?> iface : ifaces = clazz.getInterfaces()) {
            InstancesService.removeInstance(registry, state, iface, bean);
        }
    }

    public void start(StartContext context) throws StartException {
    }

    public void stop(StopContext context) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Object> getValue() throws IllegalStateException, IllegalArgumentException {
        Class<?> clazz = this.type;
        synchronized (clazz) {
            return Collections.unmodifiableSet(this.instances);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Set<Object> getBeans(Class<?> type, BeanState state) {
        Class<?> clazz = type;
        synchronized (clazz) {
            TypeBeanStateKey key = new TypeBeanStateKey(type, state);
            Set<Object> objects = beans.get(key);
            return objects != null ? Collections.unmodifiableSet(objects) : Collections.emptySet();
        }
    }
}

