/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.undertow.session;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.metadata.web.jboss.ReplicationConfig;
import org.jboss.modules.Module;
import org.wildfly.clustering.ee.Immutability;
import org.wildfly.clustering.ee.immutable.SimpleImmutability;
import org.wildfly.clustering.web.container.SessionManagementProvider;
import org.wildfly.clustering.web.session.DistributableSessionManagementProvider;
import org.wildfly.clustering.web.session.LegacySessionManagementProviderFactory;
import org.wildfly.clustering.web.undertow.logging.UndertowClusteringLogger;
import org.wildfly.clustering.web.undertow.session.UndertowDistributableSessionManagementProvider;
import org.wildfly.extension.undertow.session.SessionManagementProviderFactory;

public class UndertowSessionManagementProviderFactory
implements SessionManagementProviderFactory {
    private final LegacySessionManagementProviderFactory legacyFactory;

    public UndertowSessionManagementProviderFactory() {
        Iterator<LegacySessionManagementProviderFactory> factories = ServiceLoader.load(LegacySessionManagementProviderFactory.class, LegacySessionManagementProviderFactory.class.getClassLoader()).iterator();
        if (!factories.hasNext()) {
            throw new ServiceConfigurationError(LegacySessionManagementProviderFactory.class.getName());
        }
        this.legacyFactory = factories.next();
    }

    public SessionManagementProvider createSessionManagementProvider(DeploymentUnit unit, ReplicationConfig config) {
        DistributableSessionManagementProvider provider = (DistributableSessionManagementProvider)unit.getAttachment(DistributableSessionManagementProvider.ATTACHMENT_KEY);
        if (config != null || provider == null) {
            if (provider != null) {
                UndertowClusteringLogger.ROOT_LOGGER.legacySessionManagementProviderOverride(unit.getName());
            } else {
                UndertowClusteringLogger.ROOT_LOGGER.legacySessionManagementProviderInUse(unit.getName());
            }
            provider = this.legacyFactory.createSessionManagerProvider(config);
        }
        Module module = (Module)unit.getAttachment(Attachments.MODULE);
        List immutableClasses = unit.getAttachmentList(DistributableSessionManagementProvider.IMMUTABILITY_ATTACHMENT_KEY);
        return new UndertowDistributableSessionManagementProvider(provider, (Immutability)new SimpleImmutability((ClassLoader)module.getClassLoader(), (Collection)immutableClasses));
    }
}

