/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.OptionalInt;
import org.infinispan.protostream.BaseMarshaller;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.RawProtoStreamReader;
import org.infinispan.protostream.RawProtoStreamWriter;
import org.wildfly.clustering.marshalling.protostream.AnyField;
import org.wildfly.clustering.marshalling.protostream.Field;
import org.wildfly.clustering.marshalling.protostream.Predictable;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;

public enum ClassField implements Field<Class<?>>
{
    ANY{

        public Class<?> readFrom(ImmutableSerializationContext context, RawProtoStreamReader reader) throws IOException {
            return (Class)this.getMarshaller(context).readFrom(context, reader);
        }

        public void writeTo(ImmutableSerializationContext context, RawProtoStreamWriter writer, Class<?> targetClass) throws IOException {
            this.getMarshaller(context).writeTo(context, writer, targetClass);
        }

        @Override
        public OptionalInt size(ImmutableSerializationContext context, Class<?> value) {
            return this.getMarshaller(context).size(context, value);
        }

        private ProtoStreamMarshaller<Class<?>> getMarshaller(ImmutableSerializationContext context) {
            return (ProtoStreamMarshaller)context.getMarshaller(Class.class);
        }
    }
    ,
    ARRAY{

        public Class<?> readFrom(ImmutableSerializationContext context, RawProtoStreamReader reader) throws IOException {
            int dimensions = reader.readUInt32();
            Class<?> targetClass = (Class<?>)ANY.readFrom(context, reader);
            for (int i = 0; i < dimensions; ++i) {
                targetClass = Array.newInstance(targetClass, 0).getClass();
            }
            return targetClass;
        }

        public void writeTo(ImmutableSerializationContext context, RawProtoStreamWriter writer, Class<?> targetClass) throws IOException {
            int dimensions = 0;
            Class<?> componentClass = targetClass;
            while (componentClass.isArray() && !componentClass.getComponentType().isPrimitive()) {
                componentClass = componentClass.getComponentType();
                ++dimensions;
            }
            writer.writeUInt32NoTag(dimensions);
            ANY.writeTo(context, writer, componentClass);
        }

        @Override
        public OptionalInt size(ImmutableSerializationContext context, Class<?> targetClass) {
            int dimensions = 0;
            Class<?> componentClass = targetClass;
            while (componentClass.isArray() && !componentClass.getComponentType().isPrimitive()) {
                componentClass = componentClass.getComponentType();
                ++dimensions;
            }
            return OptionalInt.of(Predictable.unsignedIntSize(dimensions) + ANY.size(context, componentClass).getAsInt());
        }
    }
    ,
    FIELD{

        public Class<?> readFrom(ImmutableSerializationContext context, RawProtoStreamReader reader) throws IOException {
            return AnyField.fromIndex(reader.readUInt32()).getJavaClass();
        }

        public void writeTo(ImmutableSerializationContext context, RawProtoStreamWriter writer, Class<?> value) throws IOException {
            writer.writeUInt32NoTag(AnyField.fromJavaType(value).getIndex());
        }

        @Override
        public OptionalInt size(ImmutableSerializationContext context, Class<?> value) {
            return OptionalInt.of(Predictable.unsignedIntSize(AnyField.fromJavaType(value).getIndex()));
        }
    }
    ,
    ID{

        public Class<?> readFrom(ImmutableSerializationContext context, RawProtoStreamReader reader) throws IOException {
            int typeId = reader.readUInt32();
            String typeName = context.getDescriptorByTypeId(Integer.valueOf(typeId)).getFullName();
            BaseMarshaller marshaller = context.getMarshaller(typeName);
            return marshaller.getJavaClass();
        }

        public void writeTo(ImmutableSerializationContext context, RawProtoStreamWriter writer, Class<?> value) throws IOException {
            BaseMarshaller marshaller = context.getMarshaller(value);
            String typeName = marshaller.getTypeName();
            int typeId = context.getDescriptorByName(typeName).getTypeId();
            writer.writeUInt32NoTag(typeId);
        }

        @Override
        public OptionalInt size(ImmutableSerializationContext context, Class<?> value) {
            BaseMarshaller marshaller = context.getMarshaller(value);
            String typeName = marshaller.getTypeName();
            int typeId = context.getDescriptorByName(typeName).getTypeId();
            return OptionalInt.of(Predictable.unsignedIntSize(typeId));
        }
    }
    ,
    NAME{

        public Class<?> readFrom(ImmutableSerializationContext context, RawProtoStreamReader reader) throws IOException {
            String typeName = (String)AnyField.STRING.cast(String.class).readFrom(context, reader);
            BaseMarshaller marshaller = context.getMarshaller(typeName);
            return marshaller.getJavaClass();
        }

        public void writeTo(ImmutableSerializationContext context, RawProtoStreamWriter writer, Class<?> value) throws IOException {
            BaseMarshaller marshaller = context.getMarshaller(value);
            String typeName = marshaller.getTypeName();
            AnyField.STRING.writeTo(context, writer, typeName);
        }

        @Override
        public OptionalInt size(ImmutableSerializationContext context, Class<?> value) {
            BaseMarshaller marshaller = context.getMarshaller(value);
            String typeName = marshaller.getTypeName();
            return AnyField.STRING.size(context, typeName);
        }
    }
    ,
    OBJECT{

        public Class<?> readFrom(ImmutableSerializationContext context, RawProtoStreamReader reader) throws IOException {
            return Object.class;
        }

        public void writeTo(ImmutableSerializationContext context, RawProtoStreamWriter writer, Class<?> value) throws IOException {
        }

        @Override
        public OptionalInt size(ImmutableSerializationContext context, Class<?> value) {
            return OptionalInt.of(0);
        }
    };

    private static final Class<? extends Class<?>> TARGET_CLASS;

    public Class<? extends Class<?>> getJavaClass() {
        return TARGET_CLASS;
    }

    @Override
    public int getIndex() {
        return this.ordinal();
    }

    static {
        TARGET_CLASS = Class.class;
    }
}

