/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.specimpl;

import jakarta.ws.rs.core.Cookie;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import org.jboss.resteasy.specimpl.UnmodifiableMultivaluedMap;
import org.jboss.resteasy.util.CookieParser;
import org.jboss.resteasy.util.DateUtil;
import org.jboss.resteasy.util.MediaTypeHelper;
import org.jboss.resteasy.util.WeightedLanguage;

public class ResteasyHttpHeaders
implements HttpHeaders {
    private MultivaluedMap<String, String> requestHeaders;
    private MultivaluedMap<String, String> unmodifiableRequestHeaders;
    private Map<String, Cookie> cookies;
    private String cachedMediaTypeString;
    private MediaType cachedMediaType;

    public ResteasyHttpHeaders(MultivaluedMap<String, String> requestHeaders) {
        this(requestHeaders, new HashMap<String, Cookie>());
    }

    public ResteasyHttpHeaders(MultivaluedMap<String, String> requestHeaders, Map<String, Cookie> cookies) {
        this.requestHeaders = requestHeaders;
        this.unmodifiableRequestHeaders = new UnmodifiableMultivaluedMap<String, String>(requestHeaders);
        this.cookies = cookies == null ? new HashMap() : cookies;
    }

    public MultivaluedMap<String, String> getRequestHeaders() {
        return this.unmodifiableRequestHeaders;
    }

    public MultivaluedMap<String, String> getMutableHeaders() {
        return this.requestHeaders;
    }

    public void testParsing() {
        this.getAcceptableMediaTypes();
        this.getMediaType();
        this.getLanguage();
        this.getAcceptableLanguages();
    }

    public List<String> getRequestHeader(String name) {
        List vals = (List)this.unmodifiableRequestHeaders.get((Object)name);
        return vals == null ? Collections.emptyList() : vals;
    }

    public Map<String, Cookie> getCookies() {
        this.mergeCookies();
        return Collections.unmodifiableMap(this.cookies);
    }

    public Map<String, Cookie> getMutableCookies() {
        this.mergeCookies();
        return this.cookies;
    }

    public void setCookies(Map<String, Cookie> cookies) {
        this.cookies = cookies;
    }

    public Date getDate() {
        String date = (String)this.requestHeaders.getFirst((Object)"Date");
        if (date == null) {
            return null;
        }
        return DateUtil.parseDate(date);
    }

    public String getHeaderString(String name) {
        List vals = (List)this.requestHeaders.get((Object)name);
        if (vals == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (String val : vals) {
            if (first) {
                first = false;
            } else {
                builder.append(",");
            }
            builder.append(val);
        }
        return builder.toString();
    }

    public Locale getLanguage() {
        String obj = (String)this.requestHeaders.getFirst((Object)"Content-Language");
        if (obj == null) {
            return null;
        }
        return new Locale(obj);
    }

    public int getLength() {
        String obj = (String)this.requestHeaders.getFirst((Object)"Content-Length");
        if (obj == null) {
            return -1;
        }
        return Integer.parseInt(obj);
    }

    public MediaType getMediaType() {
        String obj = (String)this.requestHeaders.getFirst((Object)"Content-Type");
        if (obj == null) {
            return null;
        }
        if (obj == this.cachedMediaTypeString) {
            return this.cachedMediaType;
        }
        this.cachedMediaTypeString = obj;
        this.cachedMediaType = MediaType.valueOf((String)obj);
        return this.cachedMediaType;
    }

    public List<MediaType> getAcceptableMediaTypes() {
        String accepts = this.getHeaderString("Accept");
        ArrayList<MediaType> list = new ArrayList<MediaType>();
        if (accepts == null) {
            list.add(MediaType.WILDCARD_TYPE);
        } else {
            StringTokenizer tokenizer = new StringTokenizer(accepts, ",");
            while (tokenizer.hasMoreElements()) {
                String item = tokenizer.nextToken().trim();
                list.add(MediaType.valueOf((String)item));
            }
            MediaTypeHelper.sortByWeight(list);
        }
        return Collections.unmodifiableList(list);
    }

    public List<Locale> getAcceptableLanguages() {
        String accepts = this.getHeaderString("Accept-Language");
        if (accepts == null) {
            return Collections.emptyList();
        }
        ArrayList<Locale> list = new ArrayList<Locale>();
        ArrayList<WeightedLanguage> languages = new ArrayList<WeightedLanguage>();
        StringTokenizer tokenizer = new StringTokenizer(accepts, ",");
        while (tokenizer.hasMoreElements()) {
            String item = tokenizer.nextToken().trim();
            languages.add(WeightedLanguage.parse(item));
        }
        Collections.sort(languages);
        for (WeightedLanguage language : languages) {
            list.add(language.getLocale());
        }
        return Collections.unmodifiableList(list);
    }

    private void mergeCookies() {
        List cookieHeader = (List)this.requestHeaders.get((Object)"Cookie");
        if (cookieHeader != null && !cookieHeader.isEmpty()) {
            for (String s : cookieHeader) {
                List<Cookie> list = CookieParser.parseCookies(s);
                for (Cookie cookie : list) {
                    this.cookies.put(cookie.getName(), cookie);
                }
            }
        }
    }
}

