/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.corba.se.idl;

import com.sun.tools.corba.se.idl.Arguments;
import com.sun.tools.corba.se.idl.AttributeEntry;
import com.sun.tools.corba.se.idl.Comment;
import com.sun.tools.corba.se.idl.ConstEntry;
import com.sun.tools.corba.se.idl.EnumEntry;
import com.sun.tools.corba.se.idl.ExceptionEntry;
import com.sun.tools.corba.se.idl.ForwardEntry;
import com.sun.tools.corba.se.idl.ForwardValueEntry;
import com.sun.tools.corba.se.idl.IDLID;
import com.sun.tools.corba.se.idl.IncludeEntry;
import com.sun.tools.corba.se.idl.InterfaceEntry;
import com.sun.tools.corba.se.idl.InterfaceState;
import com.sun.tools.corba.se.idl.InterfaceType;
import com.sun.tools.corba.se.idl.MethodEntry;
import com.sun.tools.corba.se.idl.ModuleEntry;
import com.sun.tools.corba.se.idl.NativeEntry;
import com.sun.tools.corba.se.idl.ParameterEntry;
import com.sun.tools.corba.se.idl.ParseException;
import com.sun.tools.corba.se.idl.Preprocessor;
import com.sun.tools.corba.se.idl.PrimitiveEntry;
import com.sun.tools.corba.se.idl.Scanner;
import com.sun.tools.corba.se.idl.SequenceEntry;
import com.sun.tools.corba.se.idl.StringEntry;
import com.sun.tools.corba.se.idl.StructEntry;
import com.sun.tools.corba.se.idl.SymtabEntry;
import com.sun.tools.corba.se.idl.SymtabFactory;
import com.sun.tools.corba.se.idl.Token;
import com.sun.tools.corba.se.idl.TokenBuffer;
import com.sun.tools.corba.se.idl.TypedefEntry;
import com.sun.tools.corba.se.idl.UnionBranch;
import com.sun.tools.corba.se.idl.UnionEntry;
import com.sun.tools.corba.se.idl.Util;
import com.sun.tools.corba.se.idl.ValueBoxEntry;
import com.sun.tools.corba.se.idl.ValueEntry;
import com.sun.tools.corba.se.idl.constExpr.And;
import com.sun.tools.corba.se.idl.constExpr.BinaryExpr;
import com.sun.tools.corba.se.idl.constExpr.Divide;
import com.sun.tools.corba.se.idl.constExpr.EvaluationException;
import com.sun.tools.corba.se.idl.constExpr.ExprFactory;
import com.sun.tools.corba.se.idl.constExpr.Expression;
import com.sun.tools.corba.se.idl.constExpr.Minus;
import com.sun.tools.corba.se.idl.constExpr.Modulo;
import com.sun.tools.corba.se.idl.constExpr.Negative;
import com.sun.tools.corba.se.idl.constExpr.Not;
import com.sun.tools.corba.se.idl.constExpr.Or;
import com.sun.tools.corba.se.idl.constExpr.Plus;
import com.sun.tools.corba.se.idl.constExpr.Positive;
import com.sun.tools.corba.se.idl.constExpr.ShiftLeft;
import com.sun.tools.corba.se.idl.constExpr.ShiftRight;
import com.sun.tools.corba.se.idl.constExpr.Terminal;
import com.sun.tools.corba.se.idl.constExpr.Times;
import com.sun.tools.corba.se.idl.constExpr.Xor;
import java.io.EOFException;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Stack;
import java.util.Vector;

class Parser {
    private boolean _isModuleLegalType = false;
    private static final int MAX_SHORT = Short.MAX_VALUE;
    private static final int MIN_SHORT = Short.MIN_VALUE;
    private static final int MAX_USHORT = 65535;
    UnionBranch defaultBranch = null;
    public static final String unknownNamePrefix = "uN__";
    static Hashtable symbolTable;
    Hashtable lcSymbolTable = new Hashtable();
    static Hashtable overrideNames;
    Vector emitList = new Vector();
    boolean emitAll;
    boolean cppModule;
    boolean noWarn;
    Scanner scanner;
    Hashtable symbols;
    Vector macros = new Vector();
    Vector paths;
    SymtabEntry currentModule = null;
    static Stack repIDStack;
    private static int ftlKey;
    int sequence = 0;
    Vector includes;
    Vector includeEntries;
    boolean parsingConditionalExpr = false;
    Token token;
    ModuleEntry topLevelModule;
    private Preprocessor prep;
    private boolean verbose;
    SymtabFactory stFactory;
    ExprFactory exprFactory;
    private String[] keywords;
    private TokenBuffer tokenHistory = new TokenBuffer();
    protected float corbaLevel;
    private Arguments arguments;

    Parser(Preprocessor preprocessor, Arguments arguments, Hashtable overrides, Hashtable symtab, SymtabFactory stFac, ExprFactory exprFac, String[] genKeywords) {
        this.arguments = arguments;
        this.noWarn = arguments.noWarn;
        this.corbaLevel = arguments.corbaLevel;
        this.paths = arguments.includePaths;
        this.symbols = arguments.definedSymbols;
        this.verbose = arguments.verbose;
        this.emitAll = arguments.emitAll;
        this.cppModule = arguments.cppModule;
        overrideNames = overrides == null ? new Hashtable() : overrides;
        symbolTable = symtab == null ? new Hashtable() : symtab;
        this.keywords = genKeywords == null ? new String[]{} : genKeywords;
        this.stFactory = stFac;
        this.exprFactory = exprFac;
        this.topLevelModule = new ModuleEntry();
        this.currentModule = this.topLevelModule;
        this.prep = preprocessor;
        repIDStack.push(new IDLID());
        this.addPrimEntries();
    }

    void parse(String file) throws IOException {
        IncludeEntry fileEntry = this.stFactory.includeEntry();
        fileEntry.name('\"' + file + '\"');
        try {
            fileEntry.absFilename(Util.getAbsolutePath(file, this.paths));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.scanner = new Scanner(fileEntry, this.keywords, this.verbose, this.emitAll, this.corbaLevel, this.arguments.scannerDebugFlag);
        this.topLevelModule.sourceFile(fileEntry);
        this.token = new Token(0);
        this.tokenHistory.insert(this.token);
        try {
            this.match(0);
            if (this.token.equals(999)) {
                ParseException.nothing(file);
            } else {
                this.specification(this.topLevelModule);
            }
        }
        catch (ParseException parseException) {
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
    }

    private void addPrimEntries() {
        symbolTable.put("short", this.stFactory.primitiveEntry("short"));
        symbolTable.put("long", this.stFactory.primitiveEntry("long"));
        symbolTable.put("long long", this.stFactory.primitiveEntry("long long"));
        symbolTable.put("unsigned short", this.stFactory.primitiveEntry("unsigned short"));
        symbolTable.put("unsigned long", this.stFactory.primitiveEntry("unsigned long"));
        symbolTable.put("unsigned long long", this.stFactory.primitiveEntry("unsigned long long"));
        symbolTable.put("char", this.stFactory.primitiveEntry("char"));
        symbolTable.put("wchar", this.stFactory.primitiveEntry("wchar"));
        symbolTable.put("float", this.stFactory.primitiveEntry("float"));
        symbolTable.put("double", this.stFactory.primitiveEntry("double"));
        symbolTable.put("boolean", this.stFactory.primitiveEntry("boolean"));
        symbolTable.put("octet", this.stFactory.primitiveEntry("octet"));
        symbolTable.put("any", this.stFactory.primitiveEntry("any"));
        InterfaceEntry object = this.stFactory.interfaceEntry();
        object.name("Object");
        symbolTable.put("Object", object);
        ValueEntry valueBase = this.stFactory.valueEntry();
        valueBase.name("ValueBase");
        symbolTable.put("ValueBase", valueBase);
        this.lcSymbolTable.put("short", this.stFactory.primitiveEntry("short"));
        this.lcSymbolTable.put("long", this.stFactory.primitiveEntry("long"));
        this.lcSymbolTable.put("long long", this.stFactory.primitiveEntry("long long"));
        this.lcSymbolTable.put("unsigned short", this.stFactory.primitiveEntry("unsigned short"));
        this.lcSymbolTable.put("unsigned long", this.stFactory.primitiveEntry("unsigned long"));
        this.lcSymbolTable.put("unsigned long long", this.stFactory.primitiveEntry("unsigned long long"));
        this.lcSymbolTable.put("char", this.stFactory.primitiveEntry("char"));
        this.lcSymbolTable.put("wchar", this.stFactory.primitiveEntry("wchar"));
        this.lcSymbolTable.put("float", this.stFactory.primitiveEntry("float"));
        this.lcSymbolTable.put("double", this.stFactory.primitiveEntry("double"));
        this.lcSymbolTable.put("boolean", this.stFactory.primitiveEntry("boolean"));
        this.lcSymbolTable.put("octet", this.stFactory.primitiveEntry("octet"));
        this.lcSymbolTable.put("any", this.stFactory.primitiveEntry("any"));
        this.lcSymbolTable.put("object", object);
        this.lcSymbolTable.put("valuebase", valueBase);
    }

    private void specification(ModuleEntry entry) throws IOException {
        while (!this.token.equals(999)) {
            this.definition(entry);
            this.addToEmitList(entry);
        }
    }

    private void addToEmitList(ModuleEntry entry) {
        Enumeration e = entry.contained().elements();
        while (e.hasMoreElements()) {
            SymtabEntry emitEntry = (SymtabEntry)e.nextElement();
            if (emitEntry.emit()) {
                this.emitList.addElement(emitEntry);
                if (emitEntry instanceof ModuleEntry) {
                    this.checkContained((ModuleEntry)emitEntry);
                }
                if (!(emitEntry instanceof IncludeEntry)) continue;
                this.includes.addElement(emitEntry.name());
                this.includeEntries.addElement(emitEntry);
                continue;
            }
            if (!(emitEntry instanceof ModuleEntry)) continue;
            this.checkContained((ModuleEntry)emitEntry);
        }
        entry.contained().removeAllElements();
    }

    private void checkContained(ModuleEntry entry) {
        Enumeration e = entry.contained().elements();
        while (e.hasMoreElements()) {
            SymtabEntry contained = (SymtabEntry)e.nextElement();
            if (contained instanceof ModuleEntry) {
                this.checkContained((ModuleEntry)contained);
            }
            if (!contained.emit()) continue;
            if (!this.emitList.contains(entry)) {
                this.emitList.addElement(entry);
            }
            entry.emit(true);
            break;
        }
    }

    private void definition(ModuleEntry entry) throws IOException {
        try {
            switch (this.token.type) {
                case 9: 
                case 29: 
                case 32: 
                case 34: {
                    this.typeDcl(entry);
                    break;
                }
                case 5: {
                    this.constDcl(entry);
                    break;
                }
                case 19: {
                    this.nativeDcl(entry);
                    break;
                }
                case 10: {
                    this.exceptDcl(entry);
                    break;
                }
                case 16: {
                    this.interfaceProd(entry, 0);
                    break;
                }
                case 55: {
                    this.match(55);
                    if (this.token.type == 16) {
                        this.interfaceProd(entry, 2);
                        break;
                    }
                    throw ParseException.syntaxError(this.scanner, new int[]{16}, this.token.type);
                }
                case 18: {
                    this.module(entry);
                    break;
                }
                case 39: {
                    this.match(39);
                    if (this.token.type == 16) {
                        this.interfaceProd(entry, 1);
                        break;
                    }
                    if (this.token.type == 46) {
                        this.valueProd(entry, true);
                        break;
                    }
                    throw ParseException.syntaxError(this.scanner, new int[]{16, 46}, this.token.type);
                }
                case 40: 
                case 46: {
                    this.valueProd(entry, false);
                    break;
                }
                default: {
                    throw ParseException.syntaxError(this.scanner, new int[]{32, 29, 34, 9, 5, 10, 16, 46, 18}, this.token.type);
                }
            }
            this.match(100);
        }
        catch (ParseException e) {
            this.skipToSemicolon();
        }
    }

    private void module(ModuleEntry entry) throws IOException, ParseException {
        this.match(18);
        repIDStack.push(((IDLID)repIDStack.peek()).clone());
        ModuleEntry newEntry = this.newModule(entry);
        ((IDLID)repIDStack.peek()).appendToName(newEntry.name());
        newEntry.comment(this.tokenHistory.lookBack((int)1).comment);
        this.currentModule = newEntry;
        this.match(80);
        this.prep.openScope(newEntry);
        this.match(101);
        this.definition(newEntry);
        while (!this.token.equals(999) && !this.token.equals(102)) {
            this.definition(newEntry);
        }
        this.prep.closeScope(newEntry);
        this.match(102);
        this.currentModule = entry;
        repIDStack.pop();
    }

    private void interfaceProd(ModuleEntry entry, int interfaceType) throws IOException, ParseException {
        this.match(16);
        String name = this.token.name;
        this.match(80);
        this.interface2(entry, name, interfaceType);
    }

    private void interface2(ModuleEntry module, String name, int interfaceType) throws IOException, ParseException {
        if (this.token.type == 103 || this.token.type == 101) {
            repIDStack.push(((IDLID)repIDStack.peek()).clone());
            InterfaceEntry entry = this.stFactory.interfaceEntry(module, (IDLID)repIDStack.peek());
            entry.sourceFile(this.scanner.fileEntry());
            entry.name(name);
            entry.setInterfaceType(interfaceType);
            entry.comment(this.tokenHistory.lookBack((int)(entry.getInterfaceType() == 0 ? 2 : 3)).comment);
            if (!ForwardEntry.replaceForwardDecl(entry)) {
                ParseException.badAbstract(this.scanner, entry.fullName());
            }
            this.pigeonhole(module, entry);
            ((IDLID)repIDStack.peek()).appendToName(name);
            this.currentModule = entry;
            this.interfaceDcl(entry);
            this.currentModule = module;
            repIDStack.pop();
        } else {
            ForwardEntry entry = this.stFactory.forwardEntry(module, (IDLID)repIDStack.peek());
            entry.sourceFile(this.scanner.fileEntry());
            entry.name(name);
            entry.setInterfaceType(interfaceType);
            entry.comment(this.tokenHistory.lookBack((int)(entry.getInterfaceType() == 0 ? 2 : 3)).comment);
            this.pigeonhole(module, entry);
        }
    }

    private void interfaceDcl(InterfaceEntry entry) throws IOException, ParseException {
        if (this.token.type != 101) {
            this.inheritanceSpec(entry);
        } else if (!entry.isAbstract()) {
            SymtabEntry objectEntry = this.qualifiedEntry("Object");
            SymtabEntry realOEntry = Parser.typeOf(objectEntry);
            if (objectEntry != null) {
                if (!this.isInterface(realOEntry)) {
                    ParseException.wrongType(this.scanner, Parser.overrideName("Object"), "interface", objectEntry.typeName());
                } else {
                    entry.derivedFromAddElement(realOEntry, this.scanner);
                }
            }
        }
        this.prep.openScope(entry);
        this.match(101);
        while (this.token.type != 102) {
            this.export(entry);
        }
        this.prep.closeScope(entry);
        this.match(102);
    }

    private void export(InterfaceEntry entry) throws IOException {
        try {
            switch (this.token.type) {
                case 9: 
                case 29: 
                case 32: 
                case 34: {
                    this.typeDcl(entry);
                    break;
                }
                case 5: {
                    this.constDcl(entry);
                    break;
                }
                case 19: {
                    this.nativeDcl(entry);
                    break;
                }
                case 10: {
                    this.exceptDcl(entry);
                    break;
                }
                case 1: 
                case 25: {
                    this.attrDcl(entry);
                    break;
                }
                case 0: 
                case 2: 
                case 4: 
                case 8: 
                case 13: 
                case 17: 
                case 20: 
                case 21: 
                case 22: 
                case 27: 
                case 28: 
                case 33: 
                case 35: 
                case 36: 
                case 37: 
                case 45: 
                case 80: 
                case 124: {
                    this.opDcl(entry);
                    break;
                }
                default: {
                    throw ParseException.syntaxError(this.scanner, new int[]{32, 29, 34, 9, 5, 10, 25, 1, 22, 13, 8, 17, 27, 33, 4, 36, 2, 21, 0, 28, 37, 80, 124, 35, 45}, this.token.type);
                }
            }
            this.match(100);
        }
        catch (ParseException exception) {
            this.skipToSemicolon();
        }
    }

    private void inheritanceSpec(InterfaceEntry entry) throws IOException, ParseException {
        this.match(103);
        while (true) {
            SymtabEntry parent;
            SymtabEntry realParent;
            if (this.isInterfaceOnly(realParent = Parser.typeOf(parent = this.scopedName(entry.container(), this.stFactory.interfaceEntry())))) {
                boolean isInterface = realParent instanceof InterfaceEntry;
                if (entry.derivedFrom().contains(realParent)) {
                    ParseException.alreadyDerived(this.scanner, realParent.fullName(), entry.fullName());
                } else if (!entry.isAbstract() || ((InterfaceType)((Object)realParent)).getInterfaceType() == 1) {
                    entry.derivedFromAddElement(realParent, this.scanner);
                } else {
                    ParseException.nonAbstractParent(this.scanner, entry.fullName(), parent.fullName());
                }
            } else if (this.isForward(realParent)) {
                ParseException.illegalForwardInheritance(this.scanner, entry.fullName(), parent.fullName());
            } else {
                ParseException.wrongType(this.scanner, parent.fullName(), "interface", this.entryName(parent));
            }
            if (parent instanceof InterfaceEntry && ((InterfaceEntry)parent).state() != null) {
                if (entry.state() == null) {
                    entry.initState();
                } else {
                    throw ParseException.badState(this.scanner, entry.fullName());
                }
            }
            if (this.token.type != 104) break;
            this.match(104);
        }
    }

    public boolean isModuleLegalType() {
        return this._isModuleLegalType;
    }

    public void isModuleLegalType(boolean b) {
        this._isModuleLegalType = b;
    }

    SymtabEntry scopedName(SymtabEntry container, SymtabEntry expected) throws IOException, ParseException {
        return this.scopedName(container, expected, true);
    }

    SymtabEntry scopedName(SymtabEntry container, SymtabEntry expected, boolean mustBeReferencable) throws IOException, ParseException {
        boolean globalScope = false;
        boolean partialScope = false;
        String name = null;
        if (this.token.type == 124) {
            globalScope = true;
        } else if (this.token.type == 20) {
            name = "Object";
            this.match(20);
        } else if (this.token.type == 45) {
            name = "ValueBase";
            this.match(45);
        } else {
            name = this.token.name;
            this.match(80);
        }
        while (this.token.type == 124) {
            this.match(124);
            partialScope = true;
            name = name != null ? name + '/' + this.token.name : this.token.name;
            this.match(80);
        }
        SymtabEntry entry = null;
        entry = globalScope ? this.qualifiedEntry(name) : (partialScope ? this.partlyQualifiedEntry(name, container) : this.unqualifiedEntry(name, container));
        if (entry == null) {
            entry = expected;
            entry.name(name);
        } else if (!entry.isReferencable() && mustBeReferencable) {
            throw ParseException.illegalIncompleteTypeReference(this.scanner, name);
        }
        return entry;
    }

    private void valueProd(ModuleEntry entry, boolean isAbstract) throws IOException, ParseException {
        boolean isCustom;
        boolean bl = isCustom = this.token.type == 40;
        if (isCustom) {
            this.match(40);
        }
        this.match(46);
        String name = this.token.name;
        this.match(80);
        switch (this.token.type) {
            case 43: 
            case 101: 
            case 103: {
                this.value2(entry, name, isAbstract, isCustom);
                return;
            }
            case 100: {
                if (isCustom) break;
                this.valueForwardDcl(entry, name, isAbstract);
                return;
            }
        }
        if (isCustom) {
            throw ParseException.badCustom(this.scanner);
        }
        if (isAbstract) {
            throw ParseException.abstractValueBox(this.scanner);
        }
        this.valueBox(entry, name);
    }

    private void value2(ModuleEntry module, String name, boolean isAbstract, boolean isCustom) throws IOException, ParseException {
        repIDStack.push(((IDLID)repIDStack.peek()).clone());
        ValueEntry entry = this.stFactory.valueEntry(module, (IDLID)repIDStack.peek());
        entry.sourceFile(this.scanner.fileEntry());
        entry.name(name);
        entry.setInterfaceType(isAbstract ? 1 : 0);
        entry.setCustom(isCustom);
        entry.comment(this.tokenHistory.lookBack((int)(isAbstract || isCustom ? 3 : 2)).comment);
        if (!ForwardEntry.replaceForwardDecl(entry)) {
            ParseException.badAbstract(this.scanner, entry.fullName());
        }
        this.pigeonhole(module, entry);
        ((IDLID)repIDStack.peek()).appendToName(name);
        this.currentModule = entry;
        this.valueDcl(entry);
        entry.tagMethods();
        this.currentModule = module;
        repIDStack.pop();
    }

    private void valueDcl(ValueEntry entry) throws IOException, ParseException {
        if (this.token.type == 103) {
            this.valueInheritanceSpec(entry);
        } else if (!entry.isAbstract()) {
            SymtabEntry objectEntry = this.qualifiedEntry("ValueBase");
            SymtabEntry realOEntry = Parser.typeOf(objectEntry);
            if (objectEntry != null) {
                if (!this.isValue(realOEntry)) {
                    ParseException.wrongType(this.scanner, Parser.overrideName("ValueBase"), "value", objectEntry.typeName());
                } else {
                    entry.derivedFromAddElement(realOEntry, false, this.scanner);
                }
            }
        }
        if (this.token.type == 43) {
            this.valueSupportsSpec(entry);
        }
        this.prep.openScope(entry);
        this.match(101);
        while (this.token.type != 102) {
            this.valueElement(entry);
        }
        this.prep.closeScope(entry);
        this.match(102);
    }

    private void valueInheritanceSpec(ValueEntry entry) throws IOException, ParseException {
        boolean isTruncatable;
        this.match(103);
        boolean bl = isTruncatable = this.token.type == 44;
        if (isTruncatable) {
            this.match(44);
        }
        while (true) {
            SymtabEntry parent;
            SymtabEntry realParent;
            if (this.isValue(realParent = Parser.typeOf(parent = this.scopedName(entry.container(), this.stFactory.valueEntry()))) && !(realParent instanceof ValueBoxEntry)) {
                entry.derivedFromAddElement(realParent, isTruncatable, this.scanner);
            } else if (this.isForward(realParent)) {
                ParseException.illegalForwardInheritance(this.scanner, entry.fullName(), parent.fullName());
            } else {
                ParseException.wrongType(this.scanner, parent.fullName(), "value", this.entryName(parent));
            }
            if (this.token.type != 104) break;
            this.match(104);
            isTruncatable = false;
        }
    }

    private void valueSupportsSpec(ValueEntry entry) throws IOException, ParseException {
        this.match(43);
        while (true) {
            SymtabEntry parent;
            SymtabEntry realParent;
            if (this.isInterface(realParent = Parser.typeOf(parent = this.scopedName(entry.container(), this.stFactory.interfaceEntry())))) {
                entry.derivedFromAddElement(realParent, this.scanner);
            } else {
                ParseException.wrongType(this.scanner, parent.fullName(), "interface", this.entryName(parent));
            }
            if (this.token.type != 104) break;
            this.match(104);
        }
    }

    private void valueElement(ValueEntry entry) throws IOException, ParseException {
        if (entry.isAbstract()) {
            this.export(entry);
        } else {
            switch (this.token.type) {
                case 41: 
                case 42: {
                    this.valueStateMember(entry);
                    break;
                }
                case 38: 
                case 47: {
                    this.initDcl(entry);
                    break;
                }
                case 0: 
                case 1: 
                case 2: 
                case 4: 
                case 5: 
                case 8: 
                case 9: 
                case 10: 
                case 13: 
                case 17: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 25: 
                case 27: 
                case 28: 
                case 29: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 45: 
                case 80: 
                case 124: {
                    this.export(entry);
                    break;
                }
                default: {
                    throw ParseException.syntaxError(this.scanner, new int[]{41, 42, 38, 45, 32, 29, 34, 9, 5, 10, 25, 1, 22, 13, 8, 17, 27, 33, 4, 36, 2, 21, 0, 28, 37, 80, 124, 35}, this.token.type);
                }
            }
        }
    }

    private void valueStateMember(ValueEntry entry) throws IOException, ParseException {
        boolean isPublic;
        TypedefEntry typedefEntry = this.stFactory.typedefEntry(entry, (IDLID)repIDStack.peek());
        typedefEntry.sourceFile(this.scanner.fileEntry());
        typedefEntry.comment(this.token.comment);
        boolean bl = isPublic = this.token.type == 42;
        if (isPublic) {
            this.match(42);
        } else {
            this.match(41);
        }
        boolean isConstTypeSpec = this.token.type == 29 || this.token.type == 34 || this.token.type == 9;
        typedefEntry.name("");
        typedefEntry.type(this.typeSpec(typedefEntry));
        this.addDeclarators(entry, typedefEntry, isPublic);
        if (isConstTypeSpec) {
            entry.addContained(typedefEntry);
        }
        this.match(100);
    }

    private void addDeclarators(ValueEntry entry, TypedefEntry typedefEntry, boolean isPublic) throws IOException, ParseException {
        int modifier = isPublic ? 2 : 0;
        try {
            Vector typedefList = new Vector();
            this.declarators(typedefEntry, typedefList);
            Enumeration e = typedefList.elements();
            while (e.hasMoreElements()) {
                entry.addStateElement(new InterfaceState(modifier, (TypedefEntry)e.nextElement()), this.scanner);
            }
        }
        catch (ParseException exception) {
            this.skipToSemicolon();
        }
    }

    private void initDcl(ValueEntry entry) throws IOException, ParseException {
        MethodEntry method = this.stFactory.methodEntry(entry, (IDLID)repIDStack.peek());
        method.sourceFile(this.scanner.fileEntry());
        method.comment(this.token.comment);
        repIDStack.push(((IDLID)repIDStack.peek()).clone());
        ((IDLID)repIDStack.peek()).appendToName(this.token.name);
        if (this.token.type == 38) {
            method.name("init");
            this.match(38);
            this.match(108);
        } else {
            this.match(47);
            method.name(this.token.name);
            if (this.token.type == 81) {
                this.match(81);
            } else {
                this.match(80);
                this.match(108);
            }
        }
        if (this.token.type != 109) {
            while (true) {
                this.initParamDcl(method);
                if (this.token.type == 109) break;
                this.match(104);
            }
        }
        entry.initializersAddElement(method, this.scanner);
        this.match(109);
        this.match(100);
        repIDStack.pop();
    }

    private void initParamDcl(MethodEntry entry) throws IOException, ParseException {
        ParameterEntry parmEntry = this.stFactory.parameterEntry(entry, (IDLID)repIDStack.peek());
        parmEntry.sourceFile(this.scanner.fileEntry());
        parmEntry.comment(this.token.comment);
        this.match(14);
        parmEntry.passType(0);
        parmEntry.type(this.paramTypeSpec(entry));
        parmEntry.name(this.token.name);
        this.match(80);
        if (this.isntInList(entry.parameters(), parmEntry.name())) {
            entry.addParameter(parmEntry);
        }
    }

    private void valueBox(ModuleEntry module, String name) throws IOException, ParseException {
        repIDStack.push(((IDLID)repIDStack.peek()).clone());
        ValueBoxEntry entry = this.stFactory.valueBoxEntry(module, (IDLID)repIDStack.peek());
        entry.sourceFile(this.scanner.fileEntry());
        entry.name(name);
        entry.comment(this.tokenHistory.lookBack((int)2).comment);
        SymtabEntry valueForward = (SymtabEntry)symbolTable.get(entry.fullName());
        if (valueForward != null && valueForward instanceof ForwardEntry) {
            ParseException.forwardedValueBox(this.scanner, entry.fullName());
        }
        this.pigeonhole(module, entry);
        ((IDLID)repIDStack.peek()).appendToName(name);
        this.currentModule = entry;
        TypedefEntry typedefEntry = this.stFactory.typedefEntry(entry, (IDLID)repIDStack.peek());
        typedefEntry.sourceFile(this.scanner.fileEntry());
        typedefEntry.comment(this.token.comment);
        boolean isConstTypeSpec = this.token.type == 29 || this.token.type == 34 || this.token.type == 9;
        typedefEntry.name("");
        typedefEntry.type(this.typeSpec(typedefEntry));
        if (typedefEntry.type() instanceof ValueBoxEntry) {
            ParseException.nestedValueBox(this.scanner);
        }
        entry.addStateElement(new InterfaceState(2, typedefEntry), this.scanner);
        if (isConstTypeSpec) {
            entry.addContained(typedefEntry);
        }
        this.currentModule = module;
        repIDStack.pop();
    }

    private void valueForwardDcl(ModuleEntry module, String name, boolean isAbstract) throws IOException, ParseException {
        ForwardValueEntry entry = this.stFactory.forwardValueEntry(module, (IDLID)repIDStack.peek());
        entry.sourceFile(this.scanner.fileEntry());
        entry.name(name);
        entry.setInterfaceType(isAbstract ? 1 : 0);
        entry.comment(this.tokenHistory.lookBack((int)(isAbstract ? 3 : 2)).comment);
        this.pigeonhole(module, entry);
    }

    private void nativeDcl(SymtabEntry entry) throws IOException, ParseException {
        this.match(19);
        NativeEntry nativeEntry = this.stFactory.nativeEntry(entry, (IDLID)repIDStack.peek());
        nativeEntry.sourceFile(this.scanner.fileEntry());
        nativeEntry.comment(this.tokenHistory.lookBack((int)1).comment);
        nativeEntry.name(this.token.name);
        this.match(80);
        this.pigeonhole(entry, nativeEntry);
    }

    private void constDcl(SymtabEntry entry) throws IOException, ParseException {
        this.match(5);
        ConstEntry constEntry = this.stFactory.constEntry(entry, (IDLID)repIDStack.peek());
        constEntry.sourceFile(this.scanner.fileEntry());
        constEntry.comment(this.tokenHistory.lookBack((int)1).comment);
        this.constType(constEntry);
        constEntry.name(this.token.name);
        this.match(80);
        this.match(105);
        constEntry.value(this.constExp(constEntry));
        this.verifyConstType(constEntry.value(), Parser.typeOf(constEntry.type()));
        this.pigeonhole(entry, constEntry);
    }

    private void constType(SymtabEntry entry) throws IOException, ParseException {
        switch (this.token.type) {
            case 21: {
                entry.type(this.octetType());
                break;
            }
            case 17: 
            case 27: 
            case 33: {
                entry.type(this.integerType(entry));
                break;
            }
            case 4: 
            case 36: {
                entry.type(this.charType());
                break;
            }
            case 2: {
                entry.type(this.booleanType());
                break;
            }
            case 8: 
            case 13: {
                entry.type(this.floatingPtType());
                break;
            }
            case 28: 
            case 37: {
                entry.type(this.stringType(entry));
                break;
            }
            case 80: 
            case 124: {
                SymtabEntry entryType;
                entry.type(this.scopedName(entry.container(), this.stFactory.primitiveEntry()));
                if (this.hasArrayInfo(entry.type())) {
                    ParseException.illegalArray(this.scanner, "const");
                }
                if (!((entryType = Parser.typeOf(entry.type())) instanceof PrimitiveEntry) && !(entryType instanceof StringEntry)) {
                    ParseException.wrongType(this.scanner, entry.fullName(), "primitive or string", this.entryName(entry.type()));
                    entry.type(this.qualifiedEntry("long"));
                    break;
                }
                if (!(entryType instanceof PrimitiveEntry)) break;
                String any = Parser.overrideName("any");
                if (!entryType.name().equals(any)) break;
                ParseException.wrongType(this.scanner, entry.fullName(), "primitive or string (except " + any + ')', any);
                entry.type(this.qualifiedEntry("long"));
                break;
            }
            default: {
                throw ParseException.syntaxError(this.scanner, new int[]{17, 27, 33, 4, 36, 2, 13, 8, 28, 37, 80, 124}, this.token.type);
            }
        }
    }

    private boolean hasArrayInfo(SymtabEntry entry) {
        while (entry instanceof TypedefEntry) {
            if (((TypedefEntry)entry).arrayInfo().size() != 0) {
                return true;
            }
            entry = entry.type();
        }
        return false;
    }

    public static String overrideName(String string) {
        String name = (String)overrideNames.get(string);
        return name == null ? string : name;
    }

    private void verifyConstType(Expression e, SymtabEntry t) {
        Object value = e.value();
        if (value instanceof BigInteger) {
            this.verifyIntegral((Number)value, t);
        } else if (value instanceof String) {
            this.verifyString(e, t);
        } else if (value instanceof Boolean) {
            this.verifyBoolean(t);
        } else if (value instanceof Character) {
            this.verifyCharacter(e, t);
        } else if (value instanceof Float || value instanceof Double) {
            this.verifyFloat((Number)value, t);
        } else if (value instanceof ConstEntry) {
            this.verifyConstType(((ConstEntry)value).value(), t);
        } else {
            ParseException.wrongExprType(this.scanner, t.fullName(), value == null ? "" : value.toString());
        }
    }

    private void verifyIntegral(Number n, SymtabEntry t) {
        boolean outOfRange = false;
        if (t == this.qualifiedEntry("octet")) {
            if (n.longValue() > 255L || n.longValue() < 0L) {
                outOfRange = true;
            }
        } else if (t == this.qualifiedEntry("long")) {
            if (n.longValue() > Integer.MAX_VALUE || n.longValue() < Integer.MIN_VALUE) {
                outOfRange = true;
            }
        } else if (t == this.qualifiedEntry("short")) {
            if (n.intValue() > Short.MAX_VALUE || n.intValue() < Short.MIN_VALUE) {
                outOfRange = true;
            }
        } else if (t == this.qualifiedEntry("unsigned long")) {
            if (n.longValue() > 0xFFFFFFFFL || n.longValue() < 0L) {
                outOfRange = true;
            }
        } else if (t == this.qualifiedEntry("unsigned short")) {
            if (n.intValue() > 65535 || n.intValue() < 0) {
                outOfRange = true;
            }
        } else if (t == this.qualifiedEntry("long long")) {
            BigInteger llMax = BigInteger.valueOf(Long.MAX_VALUE);
            BigInteger llMin = BigInteger.valueOf(Long.MIN_VALUE);
            if (((BigInteger)n).compareTo(llMax) > 0 || ((BigInteger)n).compareTo(llMin) < 0) {
                outOfRange = true;
            }
        } else if (t == this.qualifiedEntry("unsigned long long")) {
            BigInteger ullMax = BigInteger.valueOf(Long.MAX_VALUE).multiply(BigInteger.valueOf(2L)).add(BigInteger.valueOf(1L));
            BigInteger ullMin = BigInteger.valueOf(0L);
            if (((BigInteger)n).compareTo(ullMax) > 0 || ((BigInteger)n).compareTo(ullMin) < 0) {
                outOfRange = true;
            }
        } else {
            String got = null;
            got = "long";
            ParseException.wrongExprType(this.scanner, t.fullName(), got);
        }
        if (outOfRange) {
            ParseException.outOfRange(this.scanner, n.toString(), t.fullName());
        }
    }

    private void verifyString(Expression e, SymtabEntry t) {
        String string = (String)e.value();
        if (!(t instanceof StringEntry)) {
            ParseException.wrongExprType(this.scanner, t.fullName(), e.type());
        } else if (((StringEntry)t).maxSize() != null) {
            Expression maxExp = ((StringEntry)t).maxSize();
            try {
                Number max = (Number)maxExp.value();
                if (string.length() > max.intValue()) {
                    ParseException.stringTooLong(this.scanner, string, max.toString());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!e.type().equals(t.name())) {
            ParseException.wrongExprType(this.scanner, t.name(), e.type());
        }
    }

    private void verifyBoolean(SymtabEntry t) {
        if (!t.name().equals(Parser.overrideName("boolean"))) {
            ParseException.wrongExprType(this.scanner, t.name(), "boolean");
        }
    }

    private void verifyCharacter(Expression e, SymtabEntry t) {
        if (!t.name().equals(Parser.overrideName("char")) && !t.name().equals(Parser.overrideName("wchar")) || !t.name().equals(e.type())) {
            ParseException.wrongExprType(this.scanner, t.fullName(), e.type());
        }
    }

    private void verifyFloat(Number f, SymtabEntry t) {
        boolean outOfRange = false;
        if (t.name().equals(Parser.overrideName("float"))) {
            double absVal;
            double d = absVal = f.doubleValue() < 0.0 ? f.doubleValue() * -1.0 : f.doubleValue();
            if (absVal != 0.0 && (absVal > 3.4028234663852886E38 || absVal < (double)1.4E-45f)) {
                outOfRange = true;
            }
        } else if (!t.name().equals(Parser.overrideName("double"))) {
            ParseException.wrongExprType(this.scanner, t.fullName(), f instanceof Float ? "float" : "double");
        }
        if (outOfRange) {
            ParseException.outOfRange(this.scanner, f.toString(), t.fullName());
        }
    }

    Expression constExp(SymtabEntry entry) throws IOException, ParseException {
        Expression expr = this.orExpr(null, entry);
        if (expr.type() == null) {
            expr.type(entry.typeName());
        }
        try {
            expr.evaluate();
            if (expr instanceof Terminal && expr.value() instanceof BigInteger && (Parser.overrideName(expr.type()).equals("float") || Parser.overrideName(expr.type()).indexOf("double") >= 0)) {
                expr.value(new Double(((BigInteger)expr.value()).doubleValue()));
            }
        }
        catch (EvaluationException exception) {
            ParseException.evaluationError(this.scanner, exception.toString());
        }
        return expr;
    }

    private Expression orExpr(Expression e, SymtabEntry entry) throws IOException, ParseException {
        if (e == null) {
            e = this.xorExpr(null, entry);
        } else {
            BinaryExpr b = (BinaryExpr)e;
            b.right(this.xorExpr(null, entry));
            e.rep(e.rep() + b.right().rep());
        }
        if (this.token.equals(117)) {
            this.match(this.token.type);
            Or or = this.exprFactory.or(e, null);
            or.type(entry.typeName());
            or.rep(e.rep() + " | ");
            return this.orExpr(or, entry);
        }
        return e;
    }

    private Expression xorExpr(Expression e, SymtabEntry entry) throws IOException, ParseException {
        if (e == null) {
            e = this.andExpr(null, entry);
        } else {
            BinaryExpr b = (BinaryExpr)e;
            b.right(this.andExpr(null, entry));
            e.rep(e.rep() + b.right().rep());
        }
        if (this.token.equals(118)) {
            this.match(this.token.type);
            Xor xor = this.exprFactory.xor(e, null);
            xor.rep(e.rep() + " ^ ");
            xor.type(entry.typeName());
            return this.xorExpr(xor, entry);
        }
        return e;
    }

    private Expression andExpr(Expression e, SymtabEntry entry) throws IOException, ParseException {
        if (e == null) {
            e = this.shiftExpr(null, entry);
        } else {
            BinaryExpr b = (BinaryExpr)e;
            b.right(this.shiftExpr(null, entry));
            e.rep(e.rep() + b.right().rep());
        }
        if (this.token.equals(119)) {
            this.match(this.token.type);
            And and = this.exprFactory.and(e, null);
            and.rep(e.rep() + " & ");
            and.type(entry.typeName());
            return this.andExpr(and, entry);
        }
        return e;
    }

    private Expression shiftExpr(Expression e, SymtabEntry entry) throws IOException, ParseException {
        if (e == null) {
            e = this.addExpr(null, entry);
        } else {
            BinaryExpr b = (BinaryExpr)e;
            b.right(this.addExpr(null, entry));
            e.rep(e.rep() + b.right().rep());
        }
        if (this.token.equals(125)) {
            this.match(this.token.type);
            ShiftLeft sl = this.exprFactory.shiftLeft(e, null);
            sl.type(entry.typeName());
            sl.rep(e.rep() + " << ");
            return this.shiftExpr(sl, entry);
        }
        if (this.token.equals(126)) {
            this.match(this.token.type);
            ShiftRight sr = this.exprFactory.shiftRight(e, null);
            sr.type(entry.typeName());
            sr.rep(e.rep() + " >> ");
            return this.shiftExpr(sr, entry);
        }
        return e;
    }

    private Expression addExpr(Expression e, SymtabEntry entry) throws IOException, ParseException {
        if (e == null) {
            e = this.multExpr(null, entry);
        } else {
            BinaryExpr b = (BinaryExpr)e;
            b.right(this.multExpr(null, entry));
            e.rep(e.rep() + b.right().rep());
        }
        if (this.token.equals(106)) {
            this.match(this.token.type);
            Plus p = this.exprFactory.plus(e, null);
            p.type(entry.typeName());
            p.rep(e.rep() + " + ");
            return this.addExpr(p, entry);
        }
        if (this.token.equals(107)) {
            this.match(this.token.type);
            Minus m = this.exprFactory.minus(e, null);
            m.type(entry.typeName());
            m.rep(e.rep() + " - ");
            return this.addExpr(m, entry);
        }
        return e;
    }

    private Expression multExpr(Expression e, SymtabEntry entry) throws IOException, ParseException {
        if (e == null) {
            e = this.unaryExpr(entry);
        } else {
            BinaryExpr b = (BinaryExpr)e;
            b.right(this.unaryExpr(entry));
            e.rep(e.rep() + b.right().rep());
        }
        if (this.token.equals(120)) {
            this.match(this.token.type);
            Times t = this.exprFactory.times(e, null);
            t.type(entry.typeName());
            t.rep(e.rep() + " * ");
            return this.multExpr(t, entry);
        }
        if (this.token.equals(121)) {
            this.match(this.token.type);
            Divide d = this.exprFactory.divide(e, null);
            d.type(entry.typeName());
            d.rep(e.rep() + " / ");
            return this.multExpr(d, entry);
        }
        if (this.token.equals(122)) {
            this.match(this.token.type);
            Modulo m = this.exprFactory.modulo(e, null);
            m.type(entry.typeName());
            m.rep(e.rep() + " % ");
            return this.multExpr(m, entry);
        }
        return e;
    }

    private Expression unaryExpr(SymtabEntry entry) throws IOException, ParseException {
        if (this.token.equals(106)) {
            this.match(this.token.type);
            Expression e = this.primaryExpr(entry);
            Positive pos = this.exprFactory.positive(e);
            pos.type(entry.typeName());
            pos.rep('+' + e.rep());
            return pos;
        }
        if (this.token.equals(107)) {
            this.match(this.token.type);
            Expression e = this.primaryExpr(entry);
            Negative neg = this.exprFactory.negative(e);
            neg.type(entry.typeName());
            neg.rep('-' + e.rep());
            return neg;
        }
        if (this.token.equals(123)) {
            this.match(this.token.type);
            Expression e = this.primaryExpr(entry);
            Not not = this.exprFactory.not(e);
            not.type(entry.typeName());
            not.rep('~' + e.rep());
            return not;
        }
        return this.primaryExpr(entry);
    }

    private Expression primaryExpr(SymtabEntry entry) throws IOException, ParseException {
        Expression primary = null;
        if (this.parsingConditionalExpr) {
            this.prep.token = this.token;
            primary = this.prep.primaryExpr(entry);
            this.token = this.prep.token;
        } else {
            switch (this.token.type) {
                case 80: 
                case 124: {
                    ConstEntry expectedC = this.stFactory.constEntry();
                    expectedC.value(this.exprFactory.terminal("1", BigInteger.valueOf(1L)));
                    SymtabEntry ref = this.scopedName(entry.container(), expectedC);
                    if (!(ref instanceof ConstEntry)) {
                        ParseException.invalidConst(this.scanner, ref.fullName());
                        primary = this.exprFactory.terminal("1", BigInteger.valueOf(1L));
                        break;
                    }
                    primary = this.exprFactory.terminal((ConstEntry)ref);
                    break;
                }
                case 200: 
                case 201: 
                case 202: 
                case 203: 
                case 204: {
                    primary = this.literal(entry);
                    break;
                }
                case 108: {
                    this.match(108);
                    primary = this.constExp(entry);
                    this.match(109);
                    primary.rep('(' + primary.rep() + ')');
                    break;
                }
                default: {
                    throw ParseException.syntaxError(this.scanner, new int[]{80, 124, 205, 108}, this.token.type);
                }
            }
        }
        return primary;
    }

    Expression literal(SymtabEntry entry) throws IOException, ParseException {
        String string = this.token.name;
        Expression literal = null;
        switch (this.token.type) {
            case 202: {
                this.match(202);
                try {
                    literal = this.exprFactory.terminal(string, this.parseString(string));
                    literal.type(entry.typeName());
                }
                catch (NumberFormatException exception) {
                    ParseException.notANumber(this.scanner, string);
                    literal = this.exprFactory.terminal("0", BigInteger.valueOf(0L));
                }
                break;
            }
            case 201: {
                boolean isWide = this.token.isWide();
                this.match(201);
                literal = this.exprFactory.terminal("'" + string.substring(1) + "'", new Character(string.charAt(0)), isWide);
                break;
            }
            case 203: {
                this.match(203);
                try {
                    literal = this.exprFactory.terminal(string, new Double(string));
                    literal.type(entry.typeName());
                }
                catch (NumberFormatException e) {
                    ParseException.notANumber(this.scanner, string);
                }
                break;
            }
            case 200: {
                literal = this.booleanLiteral();
                break;
            }
            case 204: {
                literal = this.stringLiteral();
                break;
            }
            default: {
                throw ParseException.syntaxError(this.scanner, 205, this.token.type);
            }
        }
        return literal;
    }

    private BigInteger parseString(String string) throws NumberFormatException {
        int radix = 10;
        if (string.length() > 1 && string.charAt(0) == '0') {
            if (string.charAt(1) == 'x' || string.charAt(1) == 'X') {
                string = string.substring(2);
                radix = 16;
            } else {
                radix = 8;
            }
        }
        return new BigInteger(string, radix);
    }

    private Terminal booleanLiteral() throws IOException, ParseException {
        Boolean bool = null;
        if (this.token.name.equals("TRUE")) {
            bool = new Boolean(true);
        } else if (this.token.name.equals("FALSE")) {
            bool = new Boolean(false);
        } else {
            ParseException.invalidConst(this.scanner, this.token.name);
            bool = new Boolean(false);
        }
        String name = this.token.name;
        this.match(200);
        return this.exprFactory.terminal(name, bool);
    }

    private Expression stringLiteral() throws IOException, ParseException {
        boolean isWide = this.token.isWide();
        String literal = "";
        do {
            literal = literal + this.token.name;
            this.match(204);
        } while (this.token.equals(204));
        Terminal stringExpr = this.exprFactory.terminal(literal, isWide);
        stringExpr.rep('\"' + literal + '\"');
        return stringExpr;
    }

    private Expression positiveIntConst(SymtabEntry entry) throws IOException, ParseException {
        Expression e = this.constExp(entry);
        Object value = e.value();
        while (value instanceof ConstEntry) {
            value = ((ConstEntry)value).value().value();
        }
        if (!(value instanceof Number) || value instanceof Float || value instanceof Double) {
            ParseException.notPositiveInt(this.scanner, e.rep());
            e = this.exprFactory.terminal("1", BigInteger.valueOf(1L));
        } else if (((BigInteger)value).compareTo(BigInteger.valueOf(0L)) <= 0) {
            ParseException.notPositiveInt(this.scanner, value.toString());
            e = this.exprFactory.terminal("1", BigInteger.valueOf(1L));
        }
        return e;
    }

    private SymtabEntry typeDcl(SymtabEntry entry) throws IOException, ParseException {
        switch (this.token.type) {
            case 32: {
                this.match(32);
                return this.typeDeclarator(entry);
            }
            case 29: {
                return this.structType(entry);
            }
            case 34: {
                return this.unionType(entry);
            }
            case 9: {
                return this.enumType(entry);
            }
        }
        throw ParseException.syntaxError(this.scanner, new int[]{32, 29, 34, 9}, this.token.type);
    }

    private TypedefEntry typeDeclarator(SymtabEntry entry) throws IOException, ParseException {
        TypedefEntry typedefEntry = this.stFactory.typedefEntry(entry, (IDLID)repIDStack.peek());
        typedefEntry.sourceFile(this.scanner.fileEntry());
        typedefEntry.comment(this.tokenHistory.lookBack((int)1).comment);
        typedefEntry.type(this.typeSpec(entry));
        Vector typedefList = new Vector();
        this.declarators(typedefEntry, typedefList);
        Enumeration e = typedefList.elements();
        while (e.hasMoreElements()) {
            this.pigeonhole(entry, (SymtabEntry)e.nextElement());
        }
        return typedefEntry;
    }

    private SymtabEntry typeSpec(SymtabEntry entry) throws IOException, ParseException {
        return this.token.type == 29 || this.token.type == 34 || this.token.type == 9 ? this.constrTypeSpec(entry) : this.simpleTypeSpec(entry, true);
    }

    private SymtabEntry simpleTypeSpec(SymtabEntry entry, boolean mustBeReferencable) throws IOException, ParseException {
        if (this.token.type == 80 || this.token.type == 124 || this.token.type == 20 || this.token.type == 45) {
            SymtabEntry container = entry instanceof InterfaceEntry || entry instanceof ModuleEntry || entry instanceof StructEntry || entry instanceof UnionEntry ? entry : entry.container();
            return this.scopedName(container, this.stFactory.primitiveEntry(), mustBeReferencable);
        }
        return this.token.type == 26 || this.token.type == 28 || this.token.type == 37 ? this.templateTypeSpec(entry) : this.baseTypeSpec(entry);
    }

    private SymtabEntry baseTypeSpec(SymtabEntry entry) throws IOException, ParseException {
        switch (this.token.type) {
            case 8: 
            case 13: {
                return this.floatingPtType();
            }
            case 17: 
            case 27: 
            case 33: {
                return this.integerType(entry);
            }
            case 4: 
            case 36: {
                return this.charType();
            }
            case 2: {
                return this.booleanType();
            }
            case 21: {
                return this.octetType();
            }
            case 0: {
                return this.anyType();
            }
        }
        throw ParseException.syntaxError(this.scanner, new int[]{13, 8, 17, 27, 33, 4, 36, 2, 21, 0}, this.token.type);
    }

    private SymtabEntry templateTypeSpec(SymtabEntry entry) throws IOException, ParseException {
        switch (this.token.type) {
            case 26: {
                return this.sequenceType(entry);
            }
            case 28: 
            case 37: {
                return this.stringType(entry);
            }
        }
        throw ParseException.syntaxError(this.scanner, new int[]{26, 28, 37}, this.token.type);
    }

    private SymtabEntry constrTypeSpec(SymtabEntry entry) throws IOException, ParseException {
        switch (this.token.type) {
            case 29: {
                return this.structType(entry);
            }
            case 34: {
                return this.unionType(entry);
            }
            case 9: {
                return this.enumType(entry);
            }
        }
        throw ParseException.syntaxError(this.scanner, new int[]{29, 34, 9}, this.token.type);
    }

    private void declarators(TypedefEntry entry, Vector list) throws IOException, ParseException {
        while (true) {
            TypedefEntry newEntry = (TypedefEntry)entry.clone();
            this.declarator(newEntry);
            if (this.isntInList(list, newEntry.name())) {
                list.addElement(newEntry);
            }
            if (this.token.type != 104) break;
            this.match(104);
        }
    }

    private void declarator(TypedefEntry entry) throws IOException, ParseException {
        entry.name(this.token.name);
        if (!this.token.comment.text().equals("")) {
            entry.comment(this.token.comment);
        }
        this.match(80);
        while (this.token.type == 112) {
            this.fixedArraySize(entry);
        }
    }

    private PrimitiveEntry floatingPtType() throws IOException, ParseException {
        String name = "double";
        if (this.token.type == 13) {
            this.match(13);
            name = "float";
        } else if (this.token.type == 8) {
            this.match(8);
        } else {
            int[] expected = new int[]{13, 8};
            ParseException.syntaxError(this.scanner, new int[]{13, 8}, this.token.type);
        }
        PrimitiveEntry ret = null;
        try {
            ret = (PrimitiveEntry)this.qualifiedEntry(name);
        }
        catch (ClassCastException exception) {
            ParseException.undeclaredType(this.scanner, name);
        }
        return ret;
    }

    private PrimitiveEntry integerType(SymtabEntry entry) throws IOException, ParseException {
        String name = "";
        if (this.token.type == 33) {
            this.match(33);
            name = "unsigned ";
        }
        name = name + this.signedInt();
        PrimitiveEntry ret = null;
        try {
            ret = (PrimitiveEntry)this.qualifiedEntry(name);
        }
        catch (ClassCastException exception) {
            ParseException.undeclaredType(this.scanner, name);
        }
        return ret;
    }

    private String signedInt() throws IOException, ParseException {
        String ret = "long";
        if (this.token.type == 17) {
            this.match(17);
            if (this.token.type == 17) {
                ret = "long long";
                this.match(17);
            }
        } else if (this.token.type == 27) {
            ret = "short";
            this.match(27);
        } else {
            ParseException.syntaxError(this.scanner, new int[]{17, 27}, this.token.type);
        }
        return ret;
    }

    private PrimitiveEntry charType() throws IOException, ParseException {
        String tokenName;
        if (this.token.type == 4) {
            this.match(4);
            tokenName = "char";
        } else {
            this.match(36);
            tokenName = "wchar";
        }
        PrimitiveEntry ret = null;
        try {
            ret = (PrimitiveEntry)this.qualifiedEntry(tokenName);
        }
        catch (ClassCastException exception) {
            ParseException.undeclaredType(this.scanner, Parser.overrideName(tokenName));
        }
        return ret;
    }

    private PrimitiveEntry booleanType() throws IOException, ParseException {
        PrimitiveEntry ret = null;
        this.match(2);
        try {
            ret = (PrimitiveEntry)this.qualifiedEntry("boolean");
        }
        catch (ClassCastException exception) {
            ParseException.undeclaredType(this.scanner, Parser.overrideName("boolean"));
        }
        return ret;
    }

    private PrimitiveEntry octetType() throws IOException, ParseException {
        PrimitiveEntry ret = null;
        this.match(21);
        try {
            ret = (PrimitiveEntry)this.qualifiedEntry("octet");
        }
        catch (ClassCastException exception) {
            ParseException.undeclaredType(this.scanner, Parser.overrideName("octet"));
        }
        return ret;
    }

    private SymtabEntry anyType() throws IOException, ParseException {
        this.match(0);
        try {
            return this.qualifiedEntry("any");
        }
        catch (ClassCastException exception) {
            ParseException.undeclaredType(this.scanner, Parser.overrideName("any"));
            return null;
        }
    }

    private StructEntry structType(SymtabEntry entry) throws IOException, ParseException {
        this.match(29);
        String name = this.token.name;
        this.match(80);
        StructEntry structEntry = null;
        if (this.token.type == 101) {
            repIDStack.push(((IDLID)repIDStack.peek()).clone());
            structEntry = this.makeStructEntry(name, entry, false);
            ((IDLID)repIDStack.peek()).appendToName(name);
            this.prep.openScope(structEntry);
            this.match(101);
            this.member(structEntry);
            this.memberList2(structEntry);
            this.prep.closeScope(structEntry);
            this.match(102);
            repIDStack.pop();
        } else if (this.token.equals(100)) {
            structEntry = this.makeStructEntry(name, entry, true);
        } else {
            throw ParseException.syntaxError(this.scanner, new int[]{100, 101}, this.token.type);
        }
        return structEntry;
    }

    private StructEntry makeStructEntry(String name, SymtabEntry entry, boolean isForward) {
        StructEntry structEntry = this.stFactory.structEntry(entry, (IDLID)repIDStack.peek());
        structEntry.isReferencable(!isForward);
        structEntry.sourceFile(this.scanner.fileEntry());
        structEntry.name(name);
        structEntry.comment(this.tokenHistory.lookBack((int)1).comment);
        this.pigeonhole(entry, structEntry);
        return structEntry;
    }

    private void memberList2(StructEntry entry) throws IOException {
        while (this.token.type != 102) {
            this.member(entry);
        }
    }

    private void member(StructEntry entry) throws IOException {
        TypedefEntry newEntry = this.stFactory.typedefEntry(entry, (IDLID)repIDStack.peek());
        newEntry.sourceFile(this.scanner.fileEntry());
        newEntry.comment(this.token.comment);
        try {
            newEntry.type(this.typeSpec(entry));
            if (newEntry.type() == entry) {
                throw ParseException.recursive(this.scanner, entry.fullName(), this.token.name == null ? "" : this.token.name);
            }
            if (Parser.typeOf(newEntry) instanceof ExceptionEntry) {
                throw ParseException.illegalException(this.scanner, this.entryName(entry));
            }
            this.declarators(newEntry, entry.members());
            this.match(100);
        }
        catch (ParseException exception) {
            this.skipToSemicolon();
        }
    }

    private final boolean isConstTypeSpec(Token t) {
        return t.type == 29 || t.type == 34 || t.type == 9;
    }

    private UnionEntry unionType(SymtabEntry entry) throws IOException, ParseException {
        this.match(34);
        String name = this.token.name;
        this.match(80);
        UnionEntry unionEntry = null;
        if (this.token.type == 30) {
            repIDStack.push(((IDLID)repIDStack.peek()).clone());
            unionEntry = this.makeUnionEntry(name, entry, false);
            ((IDLID)repIDStack.peek()).appendToName(name);
            this.match(30);
            this.match(108);
            unionEntry.type(this.switchTypeSpec(unionEntry));
            this.match(109);
            this.prep.openScope(unionEntry);
            this.match(101);
            this.switchBody(unionEntry);
            this.verifyUnion(unionEntry);
            this.prep.closeScope(unionEntry);
            this.match(102);
            repIDStack.pop();
        } else if (this.token.equals(100)) {
            unionEntry = this.makeUnionEntry(name, entry, true);
        } else {
            throw ParseException.syntaxError(this.scanner, new int[]{100, 30}, this.token.type);
        }
        return unionEntry;
    }

    private UnionEntry makeUnionEntry(String name, SymtabEntry entry, boolean isForward) {
        UnionEntry unionEntry = this.stFactory.unionEntry(entry, (IDLID)repIDStack.peek());
        unionEntry.isReferencable(!isForward);
        unionEntry.sourceFile(this.scanner.fileEntry());
        unionEntry.name(name);
        unionEntry.comment(this.tokenHistory.lookBack((int)1).comment);
        this.pigeonhole(entry, unionEntry);
        return unionEntry;
    }

    private void verifyUnion(UnionEntry u) {
        if (u.typeName().equals(Parser.overrideName("boolean"))) {
            if (this.caseCount(u) > 2L) {
                ParseException.noDefault(this.scanner);
            }
        } else if (u.type() instanceof EnumEntry && this.caseCount(u) > (long)((EnumEntry)u.type()).elements().size()) {
            ParseException.noDefault(this.scanner);
        }
    }

    private long caseCount(UnionEntry u) {
        long cases = 0L;
        Enumeration branches = u.branches().elements();
        while (branches.hasMoreElements()) {
            UnionBranch branch = (UnionBranch)branches.nextElement();
            cases += (long)branch.labels.size();
            if (!branch.isDefault) continue;
            ++cases;
        }
        return cases;
    }

    private SymtabEntry switchTypeSpec(UnionEntry entry) throws IOException, ParseException {
        SymtabEntry ret = null;
        switch (this.token.type) {
            case 17: 
            case 27: 
            case 33: {
                return this.integerType(entry);
            }
            case 4: 
            case 36: {
                return this.charType();
            }
            case 2: {
                return this.booleanType();
            }
            case 9: {
                return this.enumType(entry);
            }
            case 80: 
            case 124: {
                SymtabEntry retType;
                ret = this.scopedName(entry, this.stFactory.primitiveEntry());
                if (this.hasArrayInfo(entry.type())) {
                    ParseException.illegalArray(this.scanner, "switch");
                }
                if (!((retType = Parser.typeOf(ret)) instanceof EnumEntry) && !(retType instanceof PrimitiveEntry)) {
                    ParseException.wrongType(this.scanner, ret.fullName(), "long, unsigned long, short, unsigned short, char, boolean, enum", this.entryName(ret.type()));
                    break;
                }
                if (!(ret instanceof PrimitiveEntry)) break;
                SymtabEntry octet = this.qualifiedEntry("octet");
                SymtabEntry flt = this.qualifiedEntry("float");
                SymtabEntry dbl = this.qualifiedEntry("double");
                if (retType != octet && retType != flt && retType != dbl) break;
                ParseException.wrongType(this.scanner, ret.fullName(), "long, unsigned long, short, unsigned short, char, boolean, enum", this.entryName(ret.type()));
                break;
            }
            default: {
                throw ParseException.syntaxError(this.scanner, new int[]{17, 27, 33, 4, 2, 9, 80, 124}, this.token.type);
            }
        }
        return ret;
    }

    private void switchBody(UnionEntry entry) throws IOException, ParseException {
        this.caseProd(entry);
        while (!this.token.equals(102)) {
            this.caseProd(entry);
        }
        entry.defaultBranch(this.defaultBranch == null ? null : this.defaultBranch.typedef);
        this.defaultBranch = null;
    }

    private void caseProd(UnionEntry entry) throws IOException, ParseException {
        UnionBranch branch = new UnionBranch();
        entry.addBranch(branch);
        this.caseLabel(entry, branch);
        while (this.token.equals(3) || this.token.equals(7)) {
            this.caseLabel(entry, branch);
        }
        this.elementSpec(entry, branch);
        this.match(100);
    }

    private void caseLabel(UnionEntry entry, UnionBranch branch) throws IOException, ParseException {
        if (this.token.type == 3) {
            Expression label;
            this.match(3);
            ConstEntry tmpEntry = this.stFactory.constEntry(entry, (IDLID)repIDStack.peek());
            tmpEntry.sourceFile(this.scanner.fileEntry());
            tmpEntry.type(entry);
            SymtabEntry type = Parser.typeOf(entry.type());
            if (type instanceof EnumEntry) {
                label = this.matchEnum((EnumEntry)type);
            } else {
                label = this.constExp(tmpEntry);
                this.verifyConstType(label, type);
            }
            if (entry.has(label)) {
                ParseException.branchLabel(this.scanner, label.rep());
            }
            branch.labels.addElement(label);
            this.match(103);
        } else if (this.token.type == 7) {
            this.match(7);
            this.match(103);
            if (entry.defaultBranch() != null) {
                ParseException.alreadyDefaulted(this.scanner);
            }
            branch.isDefault = true;
            this.defaultBranch = branch;
        } else {
            throw ParseException.syntaxError(this.scanner, new int[]{3, 7}, this.token.type);
        }
    }

    private Expression matchEnum(EnumEntry entry) throws IOException, ParseException {
        SymtabEntry label = this.scopedName(entry.container(), new SymtabEntry());
        return this.exprFactory.terminal(label.name(), false);
    }

    private void elementSpec(UnionEntry entry, UnionBranch branch) throws IOException, ParseException {
        TypedefEntry typedef = this.stFactory.typedefEntry(entry, (IDLID)repIDStack.peek());
        typedef.sourceFile(this.scanner.fileEntry());
        typedef.comment(this.token.comment);
        typedef.type(this.typeSpec(entry));
        if (typedef.type() == entry) {
            throw ParseException.recursive(this.scanner, entry.fullName(), this.token.name == null ? "" : this.token.name);
        }
        if (Parser.typeOf(typedef) instanceof ExceptionEntry) {
            throw ParseException.illegalException(this.scanner, this.entryName(entry));
        }
        this.declarator(typedef);
        branch.typedef = typedef;
        if (entry.has(typedef)) {
            ParseException.branchName(this.scanner, typedef.name());
        }
    }

    private EnumEntry enumType(SymtabEntry entry) throws IOException, ParseException {
        this.match(9);
        EnumEntry enumEntry = this.newEnumEntry(entry);
        enumEntry.comment(this.tokenHistory.lookBack((int)1).comment);
        enumEntry.name(this.token.name);
        this.match(80);
        this.prep.openScope(enumEntry);
        this.match(101);
        if (this.isntInStringList(enumEntry.elements(), this.token.name)) {
            enumEntry.addElement(this.token.name);
            SymtabEntry element = new SymtabEntry(entry, (IDLID)repIDStack.peek());
            if (element.module().equals("")) {
                element.module(element.name());
            } else if (!element.name().equals("")) {
                element.module(element.module() + "/" + element.name());
            }
            element.name(this.token.name);
            this.pigeonhole(enumEntry.container(), element);
        }
        this.match(80);
        this.enumType2(enumEntry);
        this.prep.closeScope(enumEntry);
        this.match(102);
        return enumEntry;
    }

    private void enumType2(EnumEntry entry) throws IOException, ParseException {
        while (this.token.type == 104) {
            this.match(104);
            String name = this.token.name;
            this.match(80);
            if (!this.isntInStringList(entry.elements(), name)) continue;
            entry.addElement(name);
            SymtabEntry element = new SymtabEntry(entry.container(), (IDLID)repIDStack.peek());
            if (element.module().equals("")) {
                element.module(element.name());
            } else if (!element.name().equals("")) {
                element.module(element.module() + "/" + element.name());
            }
            element.name(name);
            this.pigeonhole(entry.container(), element);
        }
    }

    private SequenceEntry sequenceType(SymtabEntry entry) throws IOException, ParseException {
        this.match(26);
        this.match(110);
        SequenceEntry newEntry = this.newSequenceEntry(entry);
        SymtabEntry tsentry = this.simpleTypeSpec(newEntry, false);
        newEntry.type(tsentry);
        if (!tsentry.isReferencable()) {
            try {
                ArrayList<SequenceEntry> fwdTypes = (ArrayList<SequenceEntry>)tsentry.dynamicVariable(ftlKey);
                if (fwdTypes == null) {
                    fwdTypes = new ArrayList<SequenceEntry>();
                    tsentry.dynamicVariable(ftlKey, fwdTypes);
                }
                fwdTypes.add(newEntry);
            }
            catch (NoSuchFieldException exc) {
                throw new IllegalStateException();
            }
        }
        if (this.token.type == 104) {
            this.match(104);
            ConstEntry tmpEntry = this.stFactory.constEntry(newEntry, (IDLID)repIDStack.peek());
            tmpEntry.sourceFile(this.scanner.fileEntry());
            tmpEntry.type(this.qualifiedEntry("long"));
            newEntry.maxSize(this.positiveIntConst(tmpEntry));
            this.verifyConstType(newEntry.maxSize(), this.qualifiedEntry("long"));
        }
        this.match(111);
        return newEntry;
    }

    private StringEntry stringType(SymtabEntry entry) throws IOException, ParseException {
        StringEntry string = this.stFactory.stringEntry();
        if (this.token.type == 28) {
            string.name(Parser.overrideName("string"));
            this.match(28);
        } else {
            string.name(Parser.overrideName("wstring"));
            this.match(37);
        }
        string.maxSize(this.stringType2(entry));
        return string;
    }

    private Expression stringType2(SymtabEntry entry) throws IOException, ParseException {
        if (this.token.type == 110) {
            this.match(110);
            ConstEntry tmpEntry = this.stFactory.constEntry(entry, (IDLID)repIDStack.peek());
            tmpEntry.sourceFile(this.scanner.fileEntry());
            tmpEntry.type(this.qualifiedEntry("long"));
            Expression maxSize = this.positiveIntConst(tmpEntry);
            this.verifyConstType(maxSize, this.qualifiedEntry("long"));
            this.match(111);
            return maxSize;
        }
        return null;
    }

    private void fixedArraySize(TypedefEntry entry) throws IOException, ParseException {
        this.match(112);
        ConstEntry tmpEntry = this.stFactory.constEntry(entry, (IDLID)repIDStack.peek());
        tmpEntry.sourceFile(this.scanner.fileEntry());
        tmpEntry.type(this.qualifiedEntry("long"));
        Expression expr = this.positiveIntConst(tmpEntry);
        entry.addArrayInfo(expr);
        this.verifyConstType(expr, this.qualifiedEntry("long"));
        this.match(113);
    }

    private void attrDcl(InterfaceEntry entry) throws IOException, ParseException {
        AttributeEntry attribute = this.stFactory.attributeEntry(entry, (IDLID)repIDStack.peek());
        attribute.sourceFile(this.scanner.fileEntry());
        attribute.comment(this.token.comment);
        Comment dclComment = attribute.comment();
        if (this.token.type == 25) {
            this.match(25);
            attribute.readOnly(true);
        }
        this.match(1);
        attribute.type(this.paramTypeSpec(attribute));
        attribute.name(this.token.name);
        if (!this.token.comment.text().equals("")) {
            attribute.comment(this.token.comment);
        }
        entry.methodsAddElement(attribute, this.scanner);
        this.pigeonholeMethod(entry, attribute);
        if (!this.token.comment.text().equals("")) {
            AttributeEntry attributeClone = (AttributeEntry)attribute.clone();
            attributeClone.comment(dclComment);
            this.match(80);
            this.attrDcl2(entry, attributeClone);
        } else {
            this.match(80);
            this.attrDcl2(entry, attribute);
        }
    }

    private void attrDcl2(InterfaceEntry entry, AttributeEntry clone) throws IOException, ParseException {
        while (this.token.type == 104) {
            this.match(104);
            AttributeEntry attribute = (AttributeEntry)clone.clone();
            attribute.name(this.token.name);
            if (!this.token.comment.text().equals("")) {
                attribute.comment(this.token.comment);
            }
            entry.methodsAddElement(attribute, this.scanner);
            this.pigeonholeMethod(entry, attribute);
            this.match(80);
        }
    }

    private void exceptDcl(SymtabEntry entry) throws IOException, ParseException {
        this.match(10);
        repIDStack.push(((IDLID)repIDStack.peek()).clone());
        ExceptionEntry exceptEntry = this.stFactory.exceptionEntry(entry, (IDLID)repIDStack.peek());
        ((IDLID)repIDStack.peek()).appendToName(this.token.name);
        exceptEntry.sourceFile(this.scanner.fileEntry());
        exceptEntry.comment(this.tokenHistory.lookBack((int)1).comment);
        exceptEntry.name(this.token.name);
        this.match(80);
        this.pigeonhole(entry, exceptEntry);
        if (!this.token.equals(101)) {
            throw ParseException.syntaxError(this.scanner, 101, this.token.type);
        }
        this.prep.openScope(exceptEntry);
        this.match(101);
        this.memberList2(exceptEntry);
        this.prep.closeScope(exceptEntry);
        this.match(102);
        repIDStack.pop();
    }

    private void opDcl(InterfaceEntry entry) throws IOException, ParseException {
        MethodEntry method = this.stFactory.methodEntry(entry, (IDLID)repIDStack.peek());
        method.sourceFile(this.scanner.fileEntry());
        method.comment(this.token.comment);
        if (this.token.type == 22) {
            this.match(22);
            method.oneway(true);
        }
        method.type(this.opTypeSpec(method));
        repIDStack.push(((IDLID)repIDStack.peek()).clone());
        ((IDLID)repIDStack.peek()).appendToName(this.token.name);
        method.name(this.token.name);
        entry.methodsAddElement(method, this.scanner);
        this.pigeonholeMethod(entry, method);
        this.opDcl2(method);
        if (method.oneway()) {
            this.checkIfOpLegalForOneway(method);
        }
        repIDStack.pop();
    }

    private void checkIfOpLegalForOneway(MethodEntry method) {
        boolean notLegal = false;
        if (method.type() != null || method.exceptions().size() != 0) {
            notLegal = true;
        } else {
            Enumeration e = method.parameters().elements();
            while (e.hasMoreElements()) {
                if (((ParameterEntry)e.nextElement()).passType() == 0) continue;
                notLegal = true;
                break;
            }
        }
        if (notLegal) {
            ParseException.oneway(this.scanner, method.name());
        }
    }

    private void opDcl2(MethodEntry method) throws IOException, ParseException {
        if (this.token.equals(81)) {
            this.match(81);
            this.parameterDcls2(method);
        } else {
            this.match(80);
            this.parameterDcls(method);
        }
        this.opDcl3(method);
    }

    private void opDcl3(MethodEntry entry) throws IOException, ParseException {
        if (this.token.type != 100) {
            if (!this.token.equals(24) && !this.token.equals(6)) {
                throw ParseException.syntaxError(this.scanner, new int[]{24, 6, 100}, this.token.type);
            }
            if (this.token.type == 24) {
                this.raisesExpr(entry);
            }
            if (this.token.type == 6) {
                this.contextExpr(entry);
            }
        }
    }

    private SymtabEntry opTypeSpec(SymtabEntry entry) throws IOException, ParseException {
        SymtabEntry ret = null;
        if (this.token.type == 35) {
            this.match(35);
        } else {
            ret = this.paramTypeSpec(entry);
        }
        return ret;
    }

    private void parameterDcls(MethodEntry entry) throws IOException, ParseException {
        this.match(108);
        this.parameterDcls2(entry);
    }

    private void parameterDcls2(MethodEntry entry) throws IOException, ParseException {
        if (this.token.type == 109) {
            this.match(109);
        } else {
            this.paramDcl(entry);
            while (this.token.type == 104) {
                this.match(104);
                this.paramDcl(entry);
            }
            this.match(109);
        }
    }

    private void paramDcl(MethodEntry entry) throws IOException, ParseException {
        ParameterEntry parmEntry = this.stFactory.parameterEntry(entry, (IDLID)repIDStack.peek());
        parmEntry.sourceFile(this.scanner.fileEntry());
        parmEntry.comment(this.token.comment);
        this.paramAttribute(parmEntry);
        parmEntry.type(this.paramTypeSpec(entry));
        parmEntry.name(this.token.name);
        this.match(80);
        if (this.isntInList(entry.parameters(), parmEntry.name())) {
            entry.addParameter(parmEntry);
        }
    }

    private void paramAttribute(ParameterEntry entry) throws IOException, ParseException {
        if (this.token.type == 14) {
            entry.passType(0);
            this.match(14);
        } else if (this.token.type == 23) {
            entry.passType(2);
            this.match(23);
        } else if (this.token.type == 15) {
            entry.passType(1);
            this.match(15);
        } else {
            throw ParseException.syntaxError(this.scanner, new int[]{14, 23, 15}, this.token.type);
        }
    }

    private void raisesExpr(MethodEntry entry) throws IOException, ParseException {
        this.match(24);
        this.match(108);
        Comment tempComment = this.token.comment;
        SymtabEntry exception = this.scopedName(entry.container(), this.stFactory.exceptionEntry());
        if (Parser.typeOf(exception) instanceof ExceptionEntry) {
            exception.comment(tempComment);
            if (this.isntInList(entry.exceptions(), exception)) {
                entry.exceptionsAddElement((ExceptionEntry)exception);
            }
        } else {
            ParseException.wrongType(this.scanner, exception.fullName(), "exception", this.entryName(exception.type()));
        }
        this.raisesExpr2(entry);
        this.match(109);
    }

    private void raisesExpr2(MethodEntry entry) throws IOException, ParseException {
        while (this.token.type == 104) {
            this.match(104);
            Comment tempComment = this.token.comment;
            SymtabEntry exception = this.scopedName(entry.container(), this.stFactory.exceptionEntry());
            if (Parser.typeOf(exception) instanceof ExceptionEntry) {
                exception.comment(tempComment);
                if (!this.isntInList(entry.exceptions(), exception)) continue;
                entry.addException((ExceptionEntry)exception);
                continue;
            }
            ParseException.wrongType(this.scanner, exception.fullName(), "exception", this.entryName(exception.type()));
        }
    }

    private void contextExpr(MethodEntry entry) throws IOException, ParseException {
        this.match(6);
        this.match(108);
        String stringLit = (String)this.stringLiteral().value();
        if (this.isntInStringList(entry.contexts(), stringLit)) {
            entry.addContext(stringLit);
        }
        this.contextExpr2(entry);
        this.match(109);
    }

    private void contextExpr2(MethodEntry entry) throws IOException, ParseException {
        while (this.token.type == 104) {
            this.match(104);
            String stringLit = (String)this.stringLiteral().value();
            if (!this.isntInStringList(entry.contexts(), stringLit)) continue;
            entry.addContext(stringLit);
        }
    }

    private SymtabEntry paramTypeSpec(SymtabEntry entry) throws IOException, ParseException {
        SymtabEntry ret = null;
        switch (this.token.type) {
            case 0: 
            case 2: 
            case 4: 
            case 8: 
            case 13: 
            case 17: 
            case 21: 
            case 27: 
            case 33: 
            case 36: {
                return this.baseTypeSpec(entry);
            }
            case 28: 
            case 37: {
                return this.stringType(entry);
            }
            case 20: 
            case 45: 
            case 80: 
            case 124: {
                ret = this.scopedName(entry.container(), this.stFactory.primitiveEntry());
                if (Parser.typeOf(ret) instanceof AttributeEntry) {
                    ParseException.attributeNotType(this.scanner, ret.name());
                    break;
                }
                if (!(Parser.typeOf(ret) instanceof MethodEntry)) break;
                ParseException.operationNotType(this.scanner, ret.name());
                break;
            }
            default: {
                throw ParseException.syntaxError(this.scanner, new int[]{13, 8, 17, 27, 33, 4, 36, 2, 21, 0, 28, 37, 80, 124, 45}, this.token.type);
            }
        }
        return ret;
    }

    private void match(int type) throws IOException, ParseException {
        String string;
        ParseException exception = null;
        if (!this.token.equals(type)) {
            exception = ParseException.syntaxError(this.scanner, type, this.token.type);
            if (type == 100) {
                return;
            }
        }
        this.token = this.scanner.getToken();
        this.issueTokenWarnings();
        this.tokenHistory.insert(this.token);
        while (this.token.isDirective()) {
            this.token = this.prep.process(this.token);
        }
        if ((this.token.equals(80) || this.token.equals(81)) && (string = (String)this.symbols.get(this.token.name)) != null && !string.equals("")) {
            if (this.macros.contains(this.token.name)) {
                this.scanner.scanString(this.prep.expandMacro(string, this.token));
                this.match(this.token.type);
            } else {
                this.scanner.scanString(string);
                this.match(this.token.type);
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    private void issueTokenWarnings() {
        if (this.noWarn) {
            return;
        }
        if ((this.token.equals(80) || this.token.equals(81)) && !this.token.isEscaped() && this.token.collidesWithKeyword()) {
            ParseException.warning(this.scanner, Util.getMessage("Migration.keywordCollision", this.token.name));
        }
        if (this.token.isKeyword() && this.token.isDeprecated()) {
            ParseException.warning(this.scanner, Util.getMessage("Deprecated.keyword", this.token.toString()));
        }
    }

    private ModuleEntry newModule(ModuleEntry oldEntry) {
        ModuleEntry entry = this.stFactory.moduleEntry(oldEntry, (IDLID)repIDStack.peek());
        entry.sourceFile(this.scanner.fileEntry());
        entry.name(this.token.name);
        SymtabEntry prevEntry = (SymtabEntry)symbolTable.get(entry.fullName());
        if (!this.cppModule && prevEntry != null && prevEntry instanceof ModuleEntry) {
            entry = (ModuleEntry)prevEntry;
            if (oldEntry == this.topLevelModule) {
                if (!entry.emit()) {
                    this.addToContainer(oldEntry, entry);
                } else if (!oldEntry.contained().contains(entry)) {
                    this.addToContainer(oldEntry, entry);
                }
            }
        } else {
            this.pigeonhole(oldEntry, entry);
        }
        return entry;
    }

    private EnumEntry newEnumEntry(SymtabEntry oldEntry) {
        EnumEntry entry = this.stFactory.enumEntry(oldEntry, (IDLID)repIDStack.peek());
        entry.sourceFile(this.scanner.fileEntry());
        entry.name(this.token.name);
        this.pigeonhole(oldEntry, entry);
        return entry;
    }

    private SequenceEntry newSequenceEntry(SymtabEntry oldEntry) {
        SequenceEntry entry = this.stFactory.sequenceEntry(oldEntry, (IDLID)repIDStack.peek());
        entry.sourceFile(this.scanner.fileEntry());
        entry.name("");
        this.pigeonhole(oldEntry, entry);
        return entry;
    }

    private void updateSymbolTable(String fullName, SymtabEntry entry, boolean lcCheck) {
        String lcFullName = fullName.toLowerCase();
        if (lcCheck && this.lcSymbolTable.get(lcFullName) != null) {
            ParseException.alreadyDeclared(this.scanner, fullName);
        }
        symbolTable.put(fullName, entry);
        this.lcSymbolTable.put(lcFullName, entry);
        String omgPrefix = "org/omg/CORBA";
        if (fullName.startsWith(omgPrefix)) {
            overrideNames.put("CORBA" + fullName.substring(omgPrefix.length()), fullName);
        }
    }

    private void pigeonhole(SymtabEntry container, SymtabEntry entry) {
        String fullName;
        if (entry.name().equals("")) {
            entry.name(unknownNamePrefix + ++this.sequence);
        }
        if (overrideNames.get(fullName = entry.fullName()) == null) {
            this.addToContainer(container, entry);
            SymtabEntry oldEntry = (SymtabEntry)symbolTable.get(fullName);
            if (oldEntry == null) {
                this.updateSymbolTable(fullName, entry, true);
            } else if (oldEntry instanceof ForwardEntry && entry instanceof InterfaceEntry) {
                String oldRepIDPrefix;
                String repIDPrefix = ((IDLID)entry.repositoryID()).prefix();
                if (repIDPrefix.equals(oldRepIDPrefix = ((IDLID)oldEntry.repositoryID()).prefix())) {
                    this.updateSymbolTable(fullName, entry, false);
                } else {
                    ParseException.badRepIDPrefix(this.scanner, fullName, oldRepIDPrefix, repIDPrefix);
                }
            } else if (entry instanceof ForwardEntry && (oldEntry instanceof InterfaceEntry || oldEntry instanceof ForwardEntry)) {
                String oldRepIDPrefix;
                String repIDPrefix;
                if (oldEntry instanceof ForwardEntry && entry.repositoryID() instanceof IDLID && oldEntry.repositoryID() instanceof IDLID && !(repIDPrefix = ((IDLID)entry.repositoryID()).prefix()).equals(oldRepIDPrefix = ((IDLID)oldEntry.repositoryID()).prefix())) {
                    ParseException.badRepIDPrefix(this.scanner, fullName, oldRepIDPrefix, repIDPrefix);
                }
            } else if (!(this.cppModule && entry instanceof ModuleEntry && oldEntry instanceof ModuleEntry || fullName.startsWith("org/omg/CORBA") || fullName.startsWith("CORBA"))) {
                if (this.isForwardable(oldEntry, entry)) {
                    if (oldEntry.isReferencable() && entry.isReferencable()) {
                        ParseException.alreadyDeclared(this.scanner, fullName);
                    }
                    if (entry.isReferencable()) {
                        String defFile;
                        String firstFile = oldEntry.sourceFile().absFilename();
                        if (!firstFile.equals(defFile = entry.sourceFile().absFilename())) {
                            ParseException.declNotInSameFile(this.scanner, fullName, firstFile);
                        } else {
                            List oldRefList;
                            this.updateSymbolTable(fullName, entry, false);
                            try {
                                oldRefList = (List)oldEntry.dynamicVariable(ftlKey);
                            }
                            catch (NoSuchFieldException exc) {
                                throw new IllegalStateException();
                            }
                            if (oldRefList != null) {
                                for (SymtabEntry elem : oldRefList) {
                                    elem.type(entry);
                                }
                            }
                        }
                    }
                } else {
                    ParseException.alreadyDeclared(this.scanner, fullName);
                }
            }
        }
    }

    private boolean isForwardable(SymtabEntry oldEntry, SymtabEntry entry) {
        return oldEntry instanceof StructEntry && entry instanceof StructEntry || oldEntry instanceof UnionEntry && entry instanceof UnionEntry;
    }

    private void pigeonholeMethod(InterfaceEntry container, MethodEntry entry) {
        String fullName;
        if (entry.name().equals("")) {
            entry.name(unknownNamePrefix + ++this.sequence);
        }
        if (overrideNames.get(fullName = entry.fullName()) == null) {
            this.addToContainer(container, entry);
            String lcFullName = fullName.toLowerCase();
            symbolTable.put(fullName, entry);
            this.lcSymbolTable.put(lcFullName, entry);
            if (fullName.startsWith("org/omg/CORBA")) {
                overrideNames.put("CORBA" + fullName.substring(13), fullName);
            }
        }
    }

    private void addToContainer(SymtabEntry container, SymtabEntry contained) {
        if (container instanceof ModuleEntry) {
            ((ModuleEntry)container).addContained(contained);
        } else if (container instanceof InterfaceEntry) {
            ((InterfaceEntry)container).addContained(contained);
        } else if (container instanceof StructEntry) {
            ((StructEntry)container).addContained(contained);
        } else if (container instanceof UnionEntry) {
            ((UnionEntry)container).addContained(contained);
        } else if (container instanceof SequenceEntry) {
            ((SequenceEntry)container).addContained(contained);
        }
    }

    SymtabEntry qualifiedEntry(String typeName) {
        SymtabEntry type = this.recursiveQualifiedEntry(typeName);
        if (type == null) {
            ParseException.undeclaredType(this.scanner, typeName);
        } else if (type instanceof ModuleEntry && !this._isModuleLegalType) {
            ParseException.moduleNotType(this.scanner, typeName);
            type = null;
        }
        return type;
    }

    SymtabEntry recursiveQualifiedEntry(String typeName) {
        SymtabEntry type = null;
        if (typeName != null && !typeName.equals("void")) {
            int index = typeName.lastIndexOf(47);
            if (index >= 0) {
                type = this.recursiveQualifiedEntry(typeName.substring(0, index));
                if (type == null) {
                    return null;
                }
                if (type instanceof TypedefEntry) {
                    typeName = Parser.typeOf(type).fullName() + typeName.substring(index);
                }
            }
            if ((type = this.searchOverrideNames(typeName)) == null) {
                type = (SymtabEntry)symbolTable.get(typeName);
            }
            if (type == null) {
                type = this.searchGlobalInheritanceScope(typeName);
            }
        }
        return type;
    }

    SymtabEntry partlyQualifiedEntry(String typeName, SymtabEntry container) {
        SymtabEntry type = null;
        if (typeName != null) {
            int index = typeName.lastIndexOf(47);
            type = this.recursivePQEntry(typeName.substring(0, index), container);
            if (type instanceof TypedefEntry) {
                typeName = Parser.typeOf(type).fullName() + typeName.substring(index);
            }
            if (container != null) {
                type = this.searchModuleScope(typeName.substring(0, typeName.lastIndexOf(47)), container);
            }
            type = type == null ? this.qualifiedEntry(typeName) : this.qualifiedEntry(type.fullName() + typeName.substring(typeName.lastIndexOf(47)));
        }
        return type;
    }

    SymtabEntry recursivePQEntry(String typeName, SymtabEntry container) {
        SymtabEntry type = null;
        if (typeName != null) {
            int index = typeName.lastIndexOf(47);
            if (index < 0) {
                type = this.searchModuleScope(typeName, container);
            } else {
                type = this.recursivePQEntry(typeName.substring(0, index), container);
                if (type == null) {
                    return null;
                }
                if (type instanceof TypedefEntry) {
                    typeName = Parser.typeOf(type).fullName() + typeName.substring(index);
                }
                if (container != null) {
                    type = this.searchModuleScope(typeName.substring(0, typeName.lastIndexOf(47)), container);
                }
                if (type == null) {
                    this.recursiveQualifiedEntry(typeName);
                } else {
                    type = this.recursiveQualifiedEntry(type.fullName() + typeName.substring(typeName.lastIndexOf(47)));
                }
            }
        }
        return type;
    }

    SymtabEntry unqualifiedEntry(String typeName, SymtabEntry container) {
        SymtabEntry type = this.unqualifiedEntryWMod(typeName, container);
        if (type instanceof ModuleEntry && !this._isModuleLegalType) {
            ParseException.moduleNotType(this.scanner, typeName);
            type = null;
        }
        return type;
    }

    SymtabEntry unqualifiedEntryWMod(String typeName, SymtabEntry container) {
        SymtabEntry type = null;
        if (typeName != null && !typeName.equals("void")) {
            type = (SymtabEntry)symbolTable.get(container.fullName() + '/' + typeName);
            if (type == null) {
                type = this.searchLocalInheritanceScope(typeName, container);
            }
            if (type == null) {
                type = this.searchOverrideNames(typeName);
            }
            if (type == null && container != null) {
                type = this.searchModuleScope(typeName, container);
            }
            if (type == null) {
                type = this.searchParentInheritanceScope(typeName, container);
            }
        }
        if (type == null) {
            ParseException.undeclaredType(this.scanner, typeName);
        }
        return type;
    }

    SymtabEntry searchParentInheritanceScope(String name, SymtabEntry ptype) {
        String cname = ptype.fullName();
        while (ptype != null && !cname.equals("") && !(ptype instanceof InterfaceEntry)) {
            int index = cname.lastIndexOf(47);
            if (index < 0) {
                cname = "";
                continue;
            }
            cname = cname.substring(0, index);
            ptype = (SymtabEntry)symbolTable.get(cname);
        }
        if (ptype == null || !(ptype instanceof InterfaceEntry)) {
            return null;
        }
        String fullName = ptype.fullName() + '/' + name;
        SymtabEntry type = (SymtabEntry)symbolTable.get(fullName);
        if (type != null) {
            return type;
        }
        return this.searchLocalInheritanceScope(name, ptype);
    }

    SymtabEntry searchGlobalInheritanceScope(String name) {
        int index = name.lastIndexOf(47);
        SymtabEntry entry = null;
        if (index >= 0) {
            String containerName = name.substring(0, index);
            entry = (SymtabEntry)symbolTable.get(containerName);
            entry = entry instanceof InterfaceEntry ? this.searchLocalInheritanceScope(name.substring(index + 1), entry) : null;
        }
        return entry;
    }

    SymtabEntry searchLocalInheritanceScope(String name, SymtabEntry container) {
        return container instanceof InterfaceEntry ? this.searchDerivedFrom(name, (InterfaceEntry)container) : null;
    }

    SymtabEntry searchOverrideNames(String name) {
        String overrideName = (String)overrideNames.get(name);
        return overrideName != null ? (SymtabEntry)symbolTable.get(overrideName) : null;
    }

    SymtabEntry searchModuleScope(String name, SymtabEntry container) {
        String module = container.fullName();
        String fullName = module + '/' + name;
        SymtabEntry type = (SymtabEntry)symbolTable.get(fullName);
        while (type == null && !module.equals("")) {
            int index = module.lastIndexOf(47);
            if (index < 0) {
                module = "";
                continue;
            }
            module = module.substring(0, index);
            fullName = module + '/' + name;
            type = (SymtabEntry)symbolTable.get(fullName);
        }
        return type == null ? (SymtabEntry)symbolTable.get(name) : type;
    }

    SymtabEntry searchDerivedFrom(String name, InterfaceEntry i) {
        Enumeration e = i.derivedFrom().elements();
        while (e.hasMoreElements()) {
            SymtabEntry tmp = (SymtabEntry)e.nextElement();
            if (!(tmp instanceof InterfaceEntry)) continue;
            InterfaceEntry parent = (InterfaceEntry)tmp;
            String fullName = parent.fullName() + '/' + name;
            SymtabEntry type = (SymtabEntry)symbolTable.get(fullName);
            if (type != null) {
                return type;
            }
            type = this.searchDerivedFrom(name, parent);
            if (type == null) continue;
            return type;
        }
        return null;
    }

    String entryName(SymtabEntry entry) {
        if (entry instanceof AttributeEntry) {
            return "attribute";
        }
        if (entry instanceof ConstEntry) {
            return "constant";
        }
        if (entry instanceof EnumEntry) {
            return "enumeration";
        }
        if (entry instanceof ExceptionEntry) {
            return "exception";
        }
        if (entry instanceof ValueBoxEntry) {
            return "value box";
        }
        if (entry instanceof ForwardValueEntry || entry instanceof ValueEntry) {
            return "value";
        }
        if (entry instanceof ForwardEntry || entry instanceof InterfaceEntry) {
            return "interface";
        }
        if (entry instanceof MethodEntry) {
            return "method";
        }
        if (entry instanceof ModuleEntry) {
            return "module";
        }
        if (entry instanceof ParameterEntry) {
            return "parameter";
        }
        if (entry instanceof PrimitiveEntry) {
            return "primitive";
        }
        if (entry instanceof SequenceEntry) {
            return "sequence";
        }
        if (entry instanceof StringEntry) {
            return "string";
        }
        if (entry instanceof StructEntry) {
            return "struct";
        }
        if (entry instanceof TypedefEntry) {
            return "typedef";
        }
        if (entry instanceof UnionEntry) {
            return "union";
        }
        return "void";
    }

    private boolean isInterface(SymtabEntry entry) {
        return entry instanceof InterfaceEntry || entry instanceof ForwardEntry && !(entry instanceof ForwardValueEntry);
    }

    private boolean isValue(SymtabEntry entry) {
        return entry instanceof ValueEntry;
    }

    private boolean isInterfaceOnly(SymtabEntry entry) {
        return entry instanceof InterfaceEntry;
    }

    private boolean isForward(SymtabEntry entry) {
        return entry instanceof ForwardEntry;
    }

    private boolean isntInStringList(Vector list, String name) {
        boolean isnt = true;
        Enumeration e = list.elements();
        while (e.hasMoreElements()) {
            if (!name.equals((String)e.nextElement())) continue;
            ParseException.alreadyDeclared(this.scanner, name);
            isnt = false;
            break;
        }
        return isnt;
    }

    private boolean isntInList(Vector list, String name) {
        boolean isnt = true;
        Enumeration e = list.elements();
        while (e.hasMoreElements()) {
            if (!name.equals(((SymtabEntry)e.nextElement()).name())) continue;
            ParseException.alreadyDeclared(this.scanner, name);
            isnt = false;
            break;
        }
        return isnt;
    }

    private boolean isntInList(Vector list, SymtabEntry entry) {
        boolean isnt = true;
        Enumeration e = list.elements();
        while (e.hasMoreElements()) {
            SymtabEntry eEntry = (SymtabEntry)e.nextElement();
            if (entry != eEntry) continue;
            ParseException.alreadyDeclared(this.scanner, entry.fullName());
            isnt = false;
            break;
        }
        return isnt;
    }

    public static SymtabEntry typeOf(SymtabEntry entry) {
        while (entry instanceof TypedefEntry) {
            entry = entry.type();
        }
        return entry;
    }

    void forwardEntryCheck() {
        Enumeration e = symbolTable.elements();
        while (e.hasMoreElements()) {
            SymtabEntry entry = (SymtabEntry)e.nextElement();
            if (!(entry instanceof ForwardEntry)) continue;
            ParseException.forwardEntry(this.scanner, entry.fullName());
        }
    }

    private void skipToSemicolon() throws IOException {
        while (!this.token.equals(999) && !this.token.equals(100)) {
            if (this.token.equals(101)) {
                this.skipToRightBrace();
            }
            try {
                this.match(this.token.type);
            }
            catch (ParseException parseException) {}
        }
        if (this.token.equals(999)) {
            throw new EOFException();
        }
        try {
            this.match(100);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void skipToRightBrace() throws IOException {
        boolean firstTime = true;
        while (!this.token.equals(999) && !this.token.equals(102)) {
            if (firstTime) {
                firstTime = false;
            } else if (this.token.equals(101)) {
                this.skipToRightBrace();
            }
            try {
                this.match(this.token.type);
            }
            catch (ParseException parseException) {}
        }
        if (this.token.equals(999)) {
            throw new EOFException();
        }
    }

    public static void enteringInclude() {
        repIDStack.push(new IDLID());
    }

    public static void exitingInclude() {
        repIDStack.pop();
    }

    static {
        repIDStack = new Stack();
        ftlKey = SymtabEntry.getVariableKey();
    }
}

