/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.jta.cdi;

import com.arjuna.ats.jta.cdi.TransactionScopeCleanup;
import com.arjuna.ats.jta.common.jtaPropertyManager;
import com.arjuna.ats.jta.logging.jtaLogger;
import jakarta.enterprise.context.ContextNotActiveException;
import jakarta.enterprise.context.spi.Context;
import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.PassivationCapable;
import jakarta.transaction.SystemException;
import jakarta.transaction.Transaction;
import jakarta.transaction.TransactionManager;
import jakarta.transaction.TransactionScoped;
import jakarta.transaction.TransactionSynchronizationRegistry;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;

public class TransactionContext
implements Context {
    private final Supplier<TransactionManager> transactionManagerSupplier;
    private final Supplier<TransactionSynchronizationRegistry> transactionSynchronizationRegistrySupplier;
    private final Map<Transaction, TransactionScopeCleanup<?>> transactions = new HashMap();

    @Deprecated
    public TransactionContext() {
        this(() -> jtaPropertyManager.getJTAEnvironmentBean().getTransactionManager(), () -> jtaPropertyManager.getJTAEnvironmentBean().getTransactionSynchronizationRegistry());
    }

    public TransactionContext(Supplier<TransactionManager> transactionManagerSupplier, Supplier<TransactionSynchronizationRegistry> transactionSynchronizationRegistrySupplier) {
        this.transactionManagerSupplier = Objects.requireNonNull(transactionManagerSupplier);
        this.transactionSynchronizationRegistrySupplier = Objects.requireNonNull(transactionSynchronizationRegistrySupplier);
    }

    public Class<? extends Annotation> getScope() {
        return TransactionScoped.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T get(Contextual<T> contextual, CreationalContext<T> creationalContext) {
        if (!this.isActive()) {
            throw new ContextNotActiveException();
        }
        if (contextual == null) {
            throw new RuntimeException(jtaLogger.i18NLogger.get_contextual_is_null());
        }
        PassivationCapable bean = (PassivationCapable)contextual;
        TransactionSynchronizationRegistry tsr = this.transactionSynchronizationRegistrySupplier.get();
        Object resource = tsr.getResource((Object)bean.getId());
        if (resource != null) {
            return (T)resource;
        }
        if (creationalContext != null) {
            Transaction currentTransaction = this.getCurrentTransaction();
            Object t = contextual.create(creationalContext);
            tsr.putResource((Object)bean.getId(), t);
            Map<Transaction, TransactionScopeCleanup<?>> map = this.transactions;
            synchronized (map) {
                TransactionScopeCleanup<Object> synch = this.transactions.get(currentTransaction);
                if (synch == null) {
                    synch = new TransactionScopeCleanup(this, currentTransaction);
                    this.transactions.put(currentTransaction, synch);
                }
                synch.registerBean(contextual, creationalContext, t);
            }
            return (T)t;
        }
        return null;
    }

    public <T> T get(Contextual<T> contextual) {
        return this.get(contextual, null);
    }

    public boolean isActive() {
        Transaction transaction = this.getCurrentTransaction();
        if (transaction == null) {
            return false;
        }
        try {
            int currentStatus = transaction.getStatus();
            return currentStatus == 0 || currentStatus == 1 || currentStatus == 2 || currentStatus == 5 || currentStatus == 7 || currentStatus == 8 || currentStatus == 9;
        }
        catch (SystemException e) {
            throw new RuntimeException(jtaLogger.i18NLogger.get_error_getting_tx_status(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanupScope(Transaction transaction) {
        Map<Transaction, TransactionScopeCleanup<?>> map = this.transactions;
        synchronized (map) {
            this.transactions.remove(transaction);
        }
    }

    private Transaction getCurrentTransaction() {
        try {
            return this.transactionManagerSupplier.get().getTransaction();
        }
        catch (SystemException e) {
            throw new RuntimeException(jtaLogger.i18NLogger.get_error_getting_current_tx(), e);
        }
    }
}

