/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.service;

import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.persistence.spi.PersistenceUnitInfo;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import javax.sql.DataSource;
import org.jboss.as.jpa.beanmanager.ProxyBeanManager;
import org.jboss.as.jpa.classloader.TempClassLoaderFactoryImpl;
import org.jboss.as.jpa.messages.JpaLogger;
import org.jboss.as.naming.WritableServiceBasedNamingStore;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jipijapa.plugin.spi.EntityManagerFactoryBuilder;
import org.jipijapa.plugin.spi.PersistenceProviderAdaptor;
import org.jipijapa.plugin.spi.PersistenceUnitMetadata;
import org.jipijapa.plugin.spi.TempClassLoaderFactory;
import org.jipijapa.plugin.spi.TwoPhaseBootstrapCapable;
import org.wildfly.security.manager.WildFlySecurityManager;
import org.wildfly.security.manager.action.GetAccessControlContextAction;

public class PhaseOnePersistenceUnitServiceImpl
implements Service<PhaseOnePersistenceUnitServiceImpl> {
    private final InjectedValue<Map> properties = new InjectedValue();
    private final InjectedValue<DataSource> jtaDataSource = new InjectedValue();
    private final InjectedValue<DataSource> nonJtaDataSource = new InjectedValue();
    private final InjectedValue<ExecutorService> executorInjector = new InjectedValue();
    private static final String CDI_BEAN_MANAGER = "jakarta.persistence.bean.manager";
    private final PersistenceProviderAdaptor persistenceProviderAdaptor;
    private final PersistenceUnitMetadata pu;
    private final ClassLoader classLoader;
    private final ServiceName deploymentUnitServiceName;
    private final ProxyBeanManager proxyBeanManager;
    private final Object wrapperBeanManagerLifeCycle;
    private volatile EntityManagerFactoryBuilder entityManagerFactoryBuilder;
    private volatile boolean secondPhaseStarted = false;

    public PhaseOnePersistenceUnitServiceImpl(ClassLoader classLoader, PersistenceUnitMetadata pu, PersistenceProviderAdaptor persistenceProviderAdaptor, ServiceName deploymentUnitServiceName, ProxyBeanManager proxyBeanManager) {
        this.pu = pu;
        this.persistenceProviderAdaptor = persistenceProviderAdaptor;
        this.classLoader = classLoader;
        this.deploymentUnitServiceName = deploymentUnitServiceName;
        this.proxyBeanManager = proxyBeanManager;
        this.wrapperBeanManagerLifeCycle = proxyBeanManager != null ? persistenceProviderAdaptor.beanManagerLifeCycle((BeanManager)proxyBeanManager) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(final StartContext context) throws StartException {
        ExecutorService executor = (ExecutorService)this.executorInjector.getValue();
        final AccessControlContext accessControlContext = (AccessControlContext)AccessController.doPrivileged(GetAccessControlContextAction.getInstance());
        Runnable task = new Runnable(){

            @Override
            public void run() {
                PrivilegedAction<Void> privilegedAction = new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        try {
                            JpaLogger.ROOT_LOGGER.startingPersistenceUnitService(1, PhaseOnePersistenceUnitServiceImpl.this.pu.getScopedPersistenceUnitName());
                            PhaseOnePersistenceUnitServiceImpl.this.pu.setTempClassLoaderFactory((TempClassLoaderFactory)new TempClassLoaderFactoryImpl(PhaseOnePersistenceUnitServiceImpl.this.classLoader));
                            PhaseOnePersistenceUnitServiceImpl.this.pu.setJtaDataSource((DataSource)PhaseOnePersistenceUnitServiceImpl.this.jtaDataSource.getOptionalValue());
                            PhaseOnePersistenceUnitServiceImpl.this.pu.setNonJtaDataSource((DataSource)PhaseOnePersistenceUnitServiceImpl.this.nonJtaDataSource.getOptionalValue());
                            if (PhaseOnePersistenceUnitServiceImpl.this.proxyBeanManager != null) {
                                if (PhaseOnePersistenceUnitServiceImpl.this.wrapperBeanManagerLifeCycle != null) {
                                    ((Map)PhaseOnePersistenceUnitServiceImpl.this.properties.getValue()).put(PhaseOnePersistenceUnitServiceImpl.CDI_BEAN_MANAGER, PhaseOnePersistenceUnitServiceImpl.this.wrapperBeanManagerLifeCycle);
                                } else {
                                    ((Map)PhaseOnePersistenceUnitServiceImpl.this.properties.getValue()).put(PhaseOnePersistenceUnitServiceImpl.CDI_BEAN_MANAGER, PhaseOnePersistenceUnitServiceImpl.this.proxyBeanManager);
                                }
                            }
                            WritableServiceBasedNamingStore.pushOwner((ServiceName)PhaseOnePersistenceUnitServiceImpl.this.deploymentUnitServiceName);
                            PhaseOnePersistenceUnitServiceImpl.this.entityManagerFactoryBuilder = PhaseOnePersistenceUnitServiceImpl.this.createContainerEntityManagerFactoryBuilder();
                            context.complete();
                        }
                        catch (Throwable t) {
                            context.failed(new StartException(t));
                        }
                        finally {
                            PhaseOnePersistenceUnitServiceImpl.this.pu.setTempClassLoaderFactory(null);
                            WritableServiceBasedNamingStore.popOwner();
                        }
                        return null;
                    }
                };
                WildFlySecurityManager.doChecked((PrivilegedAction)privilegedAction, (AccessControlContext)accessControlContext);
            }
        };
        try {
            executor.execute(task);
        }
        catch (RejectedExecutionException e) {
            task.run();
        }
        finally {
            context.asynchronous();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(final StopContext context) {
        ExecutorService executor = (ExecutorService)this.executorInjector.getValue();
        final AccessControlContext accessControlContext = (AccessControlContext)AccessController.doPrivileged(GetAccessControlContextAction.getInstance());
        Runnable task = new Runnable(){

            @Override
            public void run() {
                PrivilegedAction<Void> privilegedAction = new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        JpaLogger.ROOT_LOGGER.stoppingPersistenceUnitService(1, PhaseOnePersistenceUnitServiceImpl.this.pu.getScopedPersistenceUnitName());
                        if (PhaseOnePersistenceUnitServiceImpl.this.entityManagerFactoryBuilder != null) {
                            WritableServiceBasedNamingStore.pushOwner((ServiceName)PhaseOnePersistenceUnitServiceImpl.this.deploymentUnitServiceName);
                            try {
                                if (!PhaseOnePersistenceUnitServiceImpl.this.secondPhaseStarted) {
                                    JpaLogger.ROOT_LOGGER.tracef("PhaseOnePersistenceUnitServiceImpl cancelling %s which didn't start (phase 2 not reached)", PhaseOnePersistenceUnitServiceImpl.this.pu.getScopedPersistenceUnitName());
                                    PhaseOnePersistenceUnitServiceImpl.this.entityManagerFactoryBuilder.cancel();
                                }
                            }
                            catch (Throwable t) {
                                JpaLogger.ROOT_LOGGER.failedToStopPUService(t, PhaseOnePersistenceUnitServiceImpl.this.pu.getScopedPersistenceUnitName());
                            }
                            finally {
                                PhaseOnePersistenceUnitServiceImpl.this.entityManagerFactoryBuilder = null;
                                PhaseOnePersistenceUnitServiceImpl.this.pu.setTempClassLoaderFactory(null);
                                WritableServiceBasedNamingStore.popOwner();
                            }
                        }
                        ((Map)PhaseOnePersistenceUnitServiceImpl.this.properties.getValue()).remove(PhaseOnePersistenceUnitServiceImpl.CDI_BEAN_MANAGER);
                        context.complete();
                        return null;
                    }
                };
                WildFlySecurityManager.doChecked((PrivilegedAction)privilegedAction, (AccessControlContext)accessControlContext);
            }
        };
        try {
            executor.execute(task);
        }
        catch (RejectedExecutionException e) {
            task.run();
        }
        finally {
            context.asynchronous();
        }
    }

    public InjectedValue<ExecutorService> getExecutorInjector() {
        return this.executorInjector;
    }

    public PhaseOnePersistenceUnitServiceImpl getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public EntityManagerFactoryBuilder getEntityManagerFactoryBuilder() {
        return this.entityManagerFactoryBuilder;
    }

    public void setSecondPhaseStarted(boolean secondPhaseStarted) {
        this.secondPhaseStarted = secondPhaseStarted;
    }

    public Injector<Map> getPropertiesInjector() {
        return this.properties;
    }

    public Injector<DataSource> getJtaDataSourceInjector() {
        return this.jtaDataSource;
    }

    public Injector<DataSource> getNonJtaDataSourceInjector() {
        return this.nonJtaDataSource;
    }

    public ProxyBeanManager getBeanManager() {
        return this.proxyBeanManager;
    }

    public Object getBeanManagerLifeCycle() {
        return this.wrapperBeanManagerLifeCycle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EntityManagerFactoryBuilder createContainerEntityManagerFactoryBuilder() {
        this.persistenceProviderAdaptor.beforeCreateContainerEntityManagerFactory(this.pu);
        try {
            TwoPhaseBootstrapCapable twoPhaseBootstrapCapable = (TwoPhaseBootstrapCapable)this.persistenceProviderAdaptor;
            EntityManagerFactoryBuilder entityManagerFactoryBuilder = twoPhaseBootstrapCapable.getBootstrap((PersistenceUnitInfo)this.pu, (Map)this.properties.getValue());
            return entityManagerFactoryBuilder;
        }
        finally {
            try {
                this.persistenceProviderAdaptor.afterCreateContainerEntityManagerFactory(this.pu);
            }
            finally {
                this.pu.setAnnotationIndex(null);
            }
        }
    }
}

