/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.narayana.jta.jms;

import com.arjuna.ats.jta.logging.jtaLogger;
import jakarta.jms.Connection;
import jakarta.jms.ConnectionConsumer;
import jakarta.jms.ConnectionMetaData;
import jakarta.jms.Destination;
import jakarta.jms.ExceptionListener;
import jakarta.jms.JMSException;
import jakarta.jms.ServerSessionPool;
import jakarta.jms.Session;
import jakarta.jms.Topic;
import jakarta.jms.XAConnection;
import jakarta.jms.XASession;
import org.jboss.narayana.jta.jms.ConnectionClosingSynchronization;
import org.jboss.narayana.jta.jms.SessionProxy;
import org.jboss.narayana.jta.jms.TransactionHelper;

public class ConnectionProxy
implements Connection {
    private final XAConnection xaConnection;
    private final TransactionHelper transactionHelper;

    public ConnectionProxy(XAConnection xaConnection, TransactionHelper transactionHelper) {
        this.xaConnection = xaConnection;
        this.transactionHelper = transactionHelper;
    }

    public Session createSession(boolean transacted, int acknowledgeMode) throws JMSException {
        if (this.transactionHelper.isTransactionAvailable()) {
            return this.createAndRegisterSession();
        }
        return this.xaConnection.createSession(transacted, acknowledgeMode);
    }

    public void close() throws JMSException {
        if (this.transactionHelper.isTransactionAvailable()) {
            ConnectionClosingSynchronization synchronization = new ConnectionClosingSynchronization((Connection)this.xaConnection);
            this.transactionHelper.registerSynchronization(synchronization);
            if (jtaLogger.logger.isTraceEnabled()) {
                jtaLogger.logger.trace((Object)("Registered synchronization to close the connection: " + synchronization));
            }
        } else {
            this.xaConnection.close();
        }
    }

    public String getClientID() throws JMSException {
        return this.xaConnection.getClientID();
    }

    public void setClientID(String clientID) throws JMSException {
        this.xaConnection.setClientID(clientID);
    }

    public ConnectionMetaData getMetaData() throws JMSException {
        return this.xaConnection.getMetaData();
    }

    public ExceptionListener getExceptionListener() throws JMSException {
        return this.xaConnection.getExceptionListener();
    }

    public void setExceptionListener(ExceptionListener listener) throws JMSException {
        this.xaConnection.setExceptionListener(listener);
    }

    public void start() throws JMSException {
        this.xaConnection.start();
    }

    public void stop() throws JMSException {
        this.xaConnection.stop();
    }

    public ConnectionConsumer createConnectionConsumer(Destination destination, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        return this.xaConnection.createConnectionConsumer(destination, messageSelector, sessionPool, maxMessages);
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        return this.xaConnection.createDurableConnectionConsumer(topic, subscriptionName, messageSelector, sessionPool, maxMessages);
    }

    private Session createAndRegisterSession() throws JMSException {
        XASession xaSession = this.xaConnection.createXASession();
        SessionProxy session = new SessionProxy(xaSession, this.transactionHelper);
        try {
            this.transactionHelper.registerXAResource(xaSession.getXAResource());
        }
        catch (JMSException e) {
            xaSession.close();
            throw e;
        }
        if (jtaLogger.logger.isTraceEnabled()) {
            jtaLogger.logger.trace((Object)("Created new proxied session: " + session));
        }
        return session;
    }
}

