/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.api.core;

import org.apache.activemq.artemis.api.core.BroadcastEndpoint;
import org.apache.activemq.artemis.api.core.BroadcastEndpointFactory;
import org.apache.activemq.artemis.api.core.JGroupsChannelBroadcastEndpoint;
import org.apache.activemq.artemis.api.core.jgroups.JChannelManager;
import org.jboss.logging.Logger;
import org.jgroups.JChannel;

public class ChannelBroadcastEndpointFactory
implements BroadcastEndpointFactory {
    private static final Logger logger = Logger.getLogger(ChannelBroadcastEndpointFactory.class);
    private final JChannel channel;
    private final String channelName;
    private final JChannelManager manager;
    private static final JChannelManager singletonManager = JChannelManager.getInstance();

    public ChannelBroadcastEndpointFactory(JChannel channel, String channelName) {
        this(singletonManager, channel, channelName);
    }

    private ChannelBroadcastEndpointFactory(JChannelManager manager, JChannel channel, String channelName) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("new ChannelBroadcastEndpointFactory(" + manager + ", " + channel + ", " + channelName), new Exception("trace"));
        }
        this.manager = manager;
        this.channel = channel;
        this.channelName = channelName;
    }

    public JChannel getChannel() {
        return this.channel;
    }

    public String getChannelName() {
        return this.channelName;
    }

    public String toString() {
        return "ChannelBroadcastEndpointFactory{channel=" + this.channel + ", channelName='" + this.channelName + '\'' + ", manager=" + this.manager + '}';
    }

    @Override
    public BroadcastEndpoint createBroadcastEndpoint() throws Exception {
        return new JGroupsChannelBroadcastEndpoint(this.manager, this.channel, this.channelName).initChannel();
    }
}

