/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.jgroups.util.TimeScheduler;

public class TimeService
implements Runnable {
    protected TimeScheduler timer;
    protected volatile Future<?> task;
    protected long interval = 500L;
    protected volatile long timestamp;

    public TimeService(TimeScheduler timer) {
        this(timer, 500L);
    }

    public TimeService(TimeScheduler timer, long interval) {
        this.timer = timer;
        this.interval = interval;
        if (timer == null) {
            throw new IllegalArgumentException("timer must not be null");
        }
    }

    public long timestamp() {
        return this.timestamp > 0L ? this.timestamp : (this.timestamp = System.nanoTime());
    }

    public long interval() {
        return this.interval;
    }

    public TimeService interval(long interval) {
        if (interval != this.interval) {
            this.interval = interval;
        }
        return this;
    }

    public boolean running() {
        return this.task != null && !this.task.isDone();
    }

    public synchronized TimeService start() {
        if (this.task == null || this.task.isDone()) {
            this.task = this.timer.scheduleWithFixedDelay(this, this.interval, this.interval, TimeUnit.MILLISECONDS, false);
        }
        return this;
    }

    public synchronized TimeService stop() {
        if (this.task != null) {
            this.task.cancel(false);
            this.task = null;
        }
        return this;
    }

    @Override
    public void run() {
        this.timestamp = System.nanoTime();
    }

    public String toString() {
        return this.getClass().getSimpleName() + " (interval=" + this.interval + "ms)";
    }
}

